/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.bytecode.generator.BytecodeDSLCodeGenerator;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLBuiltins;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModels;
import com.oracle.truffle.dsl.processor.bytecode.model.CustomOperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.InstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OptimizationDecisionsModel;
import com.oracle.truffle.dsl.processor.bytecode.model.ShortCircuitInstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.Signature;
import com.oracle.truffle.dsl.processor.bytecode.parser.CustomOperationParser;
import com.oracle.truffle.dsl.processor.bytecode.parser.SpecializationSignatureParser;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.expression.DSLExpressionResolver;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.ExportsParser;
import com.oracle.truffle.dsl.processor.model.ImplicitCastData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.TypeSystemParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class BytecodeDSLParser
extends AbstractParser<BytecodeDSLModels> {
    public static final String SYMBOL_ROOT_NODE = "$rootNode";
    public static final String SYMBOL_BYTECODE_NODE = "$bytecodeNode";
    public static final String SYMBOL_BYTECODE_INDEX = "$bytecodeIndex";
    private static final int MAX_TAGS = 32;
    private static final int MAX_INSTRUMENTATIONS = 31;
    private static final int MAX_TAGS_AND_INSTRUMENTATIONS = 50;
    private static final EnumSet<TypeKind> BOXABLE_TYPE_KINDS = EnumSet.of(TypeKind.BOOLEAN, new TypeKind[]{TypeKind.BYTE, TypeKind.INT, TypeKind.FLOAT, TypeKind.LONG, TypeKind.DOUBLE});

    @Override
    protected BytecodeDSLModels parse(Element element, List<AnnotationMirror> mirror) {
        List<BytecodeDSLModel> models;
        AnnotationMirror topLevelAnnotationMirror;
        TypeElement typeElement = (TypeElement)element;
        AnnotationMirror generateBytecodeTestVariantsMirror = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), (TypeMirror)this.types.GenerateBytecodeTestVariants);
        if (generateBytecodeTestVariantsMirror != null) {
            topLevelAnnotationMirror = generateBytecodeTestVariantsMirror;
            models = this.parseGenerateBytecodeTestVariants(typeElement, generateBytecodeTestVariantsMirror);
        } else {
            AnnotationMirror generateBytecodeMirror = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), (TypeMirror)this.types.GenerateBytecode);
            assert (generateBytecodeMirror != null);
            topLevelAnnotationMirror = generateBytecodeMirror;
            models = List.of(this.createBytecodeDSLModel(typeElement, generateBytecodeMirror, "Gen", this.types.BytecodeBuilder));
        }
        BytecodeDSLModels modelList = new BytecodeDSLModels(this.context, typeElement, topLevelAnnotationMirror, models);
        if (modelList.hasErrors()) {
            return modelList;
        }
        for (BytecodeDSLModel model : models) {
            this.parseBytecodeDSLModel(typeElement, model, model.getTemplateTypeAnnotation());
            if (!model.hasErrors()) continue;
            break;
        }
        return modelList;
    }

    private List<BytecodeDSLModel> parseGenerateBytecodeTestVariants(TypeElement typeElement, AnnotationMirror mirror) {
        List<AnnotationMirror> variants = ElementUtils.getAnnotationValueList(AnnotationMirror.class, mirror, "value");
        boolean first = true;
        HashSet<String> suffixes = new HashSet<String>();
        TypeMirror languageClass = null;
        boolean enableYield = false;
        boolean enableMaterializedLocalAccessors = false;
        boolean enableTagInstrumentation = false;
        TypeMirror abstractBuilderType = BytecodeDSLCodeGenerator.createAbstractBuilderType(typeElement).asType();
        ArrayList<BytecodeDSLModel> result = new ArrayList<BytecodeDSLModel>();
        for (AnnotationMirror variant : variants) {
            AnnotationValue suffixValue = ElementUtils.getAnnotationValue(variant, "suffix");
            String suffix = ElementUtils.resolveAnnotationValue(String.class, suffixValue);
            AnnotationValue generateBytecodeMirrorValue = ElementUtils.getAnnotationValue(variant, "configuration");
            AnnotationMirror generateBytecodeMirror = ElementUtils.resolveAnnotationValue(AnnotationMirror.class, generateBytecodeMirrorValue);
            BytecodeDSLModel model = this.createBytecodeDSLModel(typeElement, generateBytecodeMirror, suffix, abstractBuilderType);
            if (!first && suffixes.contains(suffix)) {
                model.addError(variant, suffixValue, "A variant with suffix \"%s\" already exists. Each variant must have a unique suffix.", suffix);
            }
            suffixes.add(suffix);
            AnnotationValue variantLanguageClassValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "languageClass");
            TypeMirror variantLanguageClass = ElementUtils.resolveAnnotationValue(TypeMirror.class, variantLanguageClassValue);
            if (first) {
                languageClass = variantLanguageClass;
            } else if (!languageClass.equals(variantLanguageClass)) {
                model.addError(generateBytecodeMirror, variantLanguageClassValue, "Incompatible variant: all variants must use the same language class.", new Object[0]);
            }
            AnnotationValue variantEnableYieldValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "enableYield");
            boolean variantEnableYield = ElementUtils.resolveAnnotationValue(Boolean.class, variantEnableYieldValue);
            if (first) {
                enableYield = variantEnableYield;
            } else if (variantEnableYield != enableYield) {
                model.addError(generateBytecodeMirror, variantEnableYieldValue, "Incompatible variant: all variants must have the same value for enableYield.", new Object[0]);
            }
            AnnotationValue variantEnableMaterializedLocalAccessesValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "enableMaterializedLocalAccesses");
            boolean variantEnableMaterializedLocalAccesses = ElementUtils.resolveAnnotationValue(Boolean.class, variantEnableMaterializedLocalAccessesValue);
            if (first) {
                enableMaterializedLocalAccessors = variantEnableMaterializedLocalAccesses;
            } else if (variantEnableMaterializedLocalAccesses != enableMaterializedLocalAccessors) {
                model.addError(generateBytecodeMirror, variantEnableMaterializedLocalAccessesValue, "Incompatible variant: all variants must have the same value for enableMaterializedLocalAccesses.", new Object[0]);
            }
            AnnotationValue variantEnableTagInstrumentationValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "enableTagInstrumentation");
            boolean variantEnableTagInstrumentation = ElementUtils.resolveAnnotationValue(Boolean.class, variantEnableTagInstrumentationValue);
            if (first) {
                enableTagInstrumentation = variantEnableTagInstrumentation;
            } else if (variantEnableTagInstrumentation != enableTagInstrumentation) {
                model.addError(generateBytecodeMirror, variantEnableTagInstrumentationValue, "Incompatible variant: all variants must have the same value for enableTagInstrumentation.", new Object[0]);
            }
            first = false;
            result.add(model);
        }
        return result;
    }

    private BytecodeDSLModel createBytecodeDSLModel(TypeElement typeElement, AnnotationMirror generateBytecodeMirror, String suffix, TypeMirror abstractBuilderType) {
        return new BytecodeDSLModel(this.context, typeElement, generateBytecodeMirror, String.valueOf(typeElement.getSimpleName()) + suffix, abstractBuilderType);
    }

    /*
     * WARNING - void declaration
     */
    private void parseBytecodeDSLModel(TypeElement typeElement, BytecodeDSLModel model, AnnotationMirror generateBytecodeMirror) {
        TypeSystemData typeSystemData;
        model.languageClass = (DeclaredType)ElementUtils.getAnnotationValue(generateBytecodeMirror, "languageClass").getValue();
        model.enableUncachedInterpreter = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableUncachedInterpreter");
        model.enableSerialization = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableSerialization");
        model.enableSpecializationIntrospection = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableSpecializationIntrospection");
        model.allowUnsafe = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "allowUnsafe");
        model.enableMaterializedLocalAccesses = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableMaterializedLocalAccesses");
        model.enableYield = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableYield");
        model.storeBciInFrame = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "storeBytecodeIndexInFrame");
        model.enableQuickening = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableQuickening");
        model.enableTagInstrumentation = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableTagInstrumentation");
        model.enableRootTagging = model.enableTagInstrumentation && ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableRootTagging") != false;
        model.enableRootBodyTagging = model.enableTagInstrumentation && ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableRootBodyTagging") != false;
        model.enableBlockScoping = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableBlockScoping");
        model.defaultLocalValue = ElementUtils.getAnnotationValue(String.class, generateBytecodeMirror, "defaultLocalValue", false);
        boolean enableBytecodeDebugListener = ElementUtils.getAnnotationValue(Boolean.class, generateBytecodeMirror, "enableBytecodeDebugListener");
        model.bytecodeDebugListener = !enableBytecodeDebugListener || this.types.BytecodeDebugListener == null ? false : ElementUtils.isAssignable(typeElement.asType(), this.types.BytecodeDebugListener);
        BytecodeDSLBuiltins.addBuiltins(model, this.types, this.context);
        Set<Modifier> modifiers = typeElement.getModifiers();
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            model.addError(typeElement, "Bytecode DSL class must be declared abstract.", new Object[0]);
        }
        if (!ElementUtils.isAssignable(typeElement.asType(), this.types.RootNode)) {
            model.addError(typeElement, "Bytecode DSL class must directly or indirectly subclass %s.", ElementUtils.getSimpleName(this.types.RootNode));
        }
        if (!ElementUtils.isAssignable(typeElement.asType(), this.types.BytecodeRootNode)) {
            model.addError(typeElement, "Bytecode DSL class must directly or indirectly implement %s.", ElementUtils.getSimpleName(this.types.BytecodeRootNode));
        }
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.PROTECTED)) {
            model.addError(typeElement, "Bytecode DSL class must be public or package-private.", new Object[0]);
        }
        if (typeElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !modifiers.contains((Object)Modifier.STATIC)) {
            model.addError(typeElement, "Bytecode DSL class must be static if it is a nested class.", new Object[0]);
        }
        List<? extends AnnotationMirror> annotations = typeElement.getAnnotationMirrors();
        BytecodeDSLParser.checkUnsupportedAnnotation(model, annotations, this.types.GenerateAOT, null);
        BytecodeDSLParser.checkUnsupportedAnnotation(model, annotations, this.types.GenerateInline, null);
        BytecodeDSLParser.checkUnsupportedAnnotation(model, annotations, this.types.GenerateCached, "Bytecode DSL always generates a cached interpreter.");
        BytecodeDSLParser.checkUnsupportedAnnotation(model, annotations, this.types.GenerateUncached, "Set GenerateBytecode#enableUncachedInterpreter to generate an uncached interpreter.");
        List viableConstructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(ctor -> {
            if (!ctor.getModifiers().contains((Object)Modifier.PUBLIC) && !ctor.getModifiers().contains((Object)Modifier.PROTECTED)) {
                return false;
            }
            List<? extends VariableElement> params = ctor.getParameters();
            if (params.size() != 2) {
                return false;
            }
            if (!ElementUtils.typeEquals(params.get(0).asType(), model.languageClass)) {
                return false;
            }
            TypeMirror secondParameterType = ctor.getParameters().get(1).asType();
            boolean isFrameDescriptor = ElementUtils.isAssignable(secondParameterType, this.types.FrameDescriptor);
            boolean isFrameDescriptorBuilder = ElementUtils.isAssignable(secondParameterType, this.types.FrameDescriptor_Builder);
            return isFrameDescriptor || isFrameDescriptorBuilder;
        }).collect(Collectors.toList());
        if (viableConstructors.isEmpty()) {
            model.addError(typeElement, "Bytecode DSL class should declare a constructor that has signature (%s, %s) or (%s, %s.%s). The constructor should be visible to subclasses.", ElementUtils.getSimpleName(model.languageClass), ElementUtils.getSimpleName(this.types.FrameDescriptor), ElementUtils.getSimpleName(model.languageClass), ElementUtils.getSimpleName(this.types.FrameDescriptor), ElementUtils.getSimpleName(this.types.FrameDescriptor_Builder));
            return;
        }
        if (model.enableTagInstrumentation) {
            AnnotationValue taginstrumentationValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "enableTagInstrumentation");
            if (model.getProvidedTags().isEmpty()) {
                model.addError(generateBytecodeMirror, taginstrumentationValue, String.format("Tag instrumentation cannot be enabled if the specified language class '%s' does not export any tags using @%s. Specify at least one provided tag or disable tag instrumentation for this root node.", ElementUtils.getQualifiedName(model.languageClass), ElementUtils.getSimpleName(this.types.ProvidedTags)), new Object[0]);
            } else if (model.enableRootTagging && model.getProvidedRootTag() == null) {
                model.addError(generateBytecodeMirror, taginstrumentationValue, "Tag instrumentation uses implicit root tagging, but the RootTag was not provded by the language class '%s'. Specify the tag using @%s(%s.class) on the language class or explicitly disable root tagging using @%s(.., enableRootTagging=false) to resolve this.", ElementUtils.getQualifiedName(model.languageClass), ElementUtils.getSimpleName(this.types.ProvidedTags), ElementUtils.getSimpleName(this.types.StandardTags_RootTag), ElementUtils.getSimpleName(this.types.GenerateBytecode));
                model.enableRootTagging = false;
            } else if (model.enableRootBodyTagging && model.getProvidedRootBodyTag() == null) {
                model.addError(generateBytecodeMirror, taginstrumentationValue, "Tag instrumentation uses implicit root body tagging, but the RootTag was not provded by the language class '%s'. Specify the tag using @%s(%s.class) on the language class or explicitly disable root tagging using @%s(.., enableRootBodyTagging=false) to resolve this.", ElementUtils.getQualifiedName(model.languageClass), ElementUtils.getSimpleName(this.types.ProvidedTags), ElementUtils.getSimpleName(this.types.StandardTags_RootBodyTag), ElementUtils.getSimpleName(this.types.GenerateBytecode));
                model.enableRootBodyTagging = false;
            }
            if (model.getProvidedTags().size() > 32) {
                model.addError(generateBytecodeMirror, taginstrumentationValue, "Tag instrumentation is currently limited to a maximum of 32 tags. The language '%s' provides %s tags. Reduce the number of tags to resolve this.", ElementUtils.getQualifiedName(model.languageClass), model.getProvidedTags().size());
            }
            this.parseTagTreeNodeLibrary(model, generateBytecodeMirror);
        } else {
            AnnotationValue tagTreeNodeLibraryValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "tagTreeNodeLibrary", false);
            if (tagTreeNodeLibraryValue != null) {
                model.addError(generateBytecodeMirror, tagTreeNodeLibraryValue, "The attribute tagTreeNodeLibrary must not be set if enableTagInstrumentation is not enabled. Enable tag instrumentation or remove this attribute.", new Object[0]);
            }
        }
        Map<String, List<ExecutableElement>> constructorsByFDType = viableConstructors.stream().collect(Collectors.groupingBy(ctor -> {
            TypeMirror secondParameterType = ctor.getParameters().get(1).asType();
            if (ElementUtils.isAssignable(secondParameterType, this.types.FrameDescriptor)) {
                return "com.oracle.truffle.api.frame.FrameDescriptor";
            }
            return "com.oracle.truffle.api.frame.FrameDescriptor.Builder";
        }));
        if (constructorsByFDType.containsKey("com.oracle.truffle.api.frame.FrameDescriptor.Builder")) {
            ctors = constructorsByFDType.get("com.oracle.truffle.api.frame.FrameDescriptor.Builder");
            assert (ctors.size() == 1);
            model.fdBuilderConstructor = ctors.get(0);
        } else {
            ctors = constructorsByFDType.get("com.oracle.truffle.api.frame.FrameDescriptor");
            assert (ctors.size() == 1);
            model.fdConstructor = ctors.get(0);
        }
        model.interceptControlFlowException = ElementUtils.findMethod(typeElement, "interceptControlFlowException");
        model.interceptInternalException = ElementUtils.findMethod(typeElement, "interceptInternalException");
        model.interceptTruffleException = ElementUtils.findMethod(typeElement, "interceptTruffleException");
        List<ExecutableElement> overrides = List.of(ElementUtils.findMethod(this.types.RootNode, "execute"), ElementUtils.findMethod(this.types.BytecodeRootNode, "getBytecodeNode"), ElementUtils.findMethod(this.types.BytecodeRootNode, "getRootNodes"), ElementUtils.findMethod(this.types.BytecodeOSRNode, "executeOSR"), ElementUtils.findMethod(this.types.BytecodeOSRNode, "getOSRMetadata"), ElementUtils.findMethod(this.types.BytecodeOSRNode, "setOSRMetadata"), ElementUtils.findMethod(this.types.BytecodeOSRNode, "storeParentFrameInArguments"), ElementUtils.findMethod(this.types.BytecodeOSRNode, "restoreParentFrameFromArguments"));
        for (ExecutableElement executableElement : overrides) {
            ExecutableElement executableElement2 = ElementUtils.findMethod(typeElement, executableElement.getSimpleName().toString());
            if (executableElement2 == null) continue;
            if (executableElement2.getModifiers().contains((Object)Modifier.FINAL)) {
                model.addError(executableElement2, "This method is overridden by the generated Bytecode DSL class, so it cannot be declared final. Since it is overridden, the definition is unreachable and can be removed.", new Object[0]);
                continue;
            }
            model.addWarning(executableElement2, "This method is overridden by the generated Bytecode DSL class, so this definition is unreachable and can be removed.", new Object[0]);
        }
        if (model.hasErrors()) {
            return;
        }
        ArrayList<Element> elementsForDSLExpressions = new ArrayList<Element>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!variableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            elementsForDSLExpressions.add(variableElement);
        }
        for (Element element : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            elementsForDSLExpressions.add(element);
        }
        DSLExpressionResolver dSLExpressionResolver = new DSLExpressionResolver(this.context, typeElement, elementsForDSLExpressions);
        BytecodeDSLParser.parseDefaultUncachedThreshold(model, generateBytecodeMirror, dSLExpressionResolver);
        if (model.defaultLocalValue != null) {
            model.defaultLocalValueExpression = DSLExpression.parse(model, "defaultLocalValue", model.defaultLocalValue);
            if (model.defaultLocalValueExpression != null) {
                model.defaultLocalValueExpression = DSLExpression.resolve(dSLExpressionResolver, model, "defaultLocalValue", model.defaultLocalValueExpression, model.defaultLocalValue);
            }
        }
        if ((typeSystemData = this.parseTypeSystemReference(typeElement)) == null) {
            model.addError("The used type system is invalid. Fix errors in the type system first.", new Object[0]);
            return;
        }
        model.typeSystem = typeSystemData;
        LinkedHashSet<TypeMirror> beTypes = new LinkedHashSet<TypeMirror>();
        List boxingEliminatedTypes = (List)ElementUtils.getAnnotationValue(generateBytecodeMirror, "boxingEliminationTypes").getValue();
        for (AnnotationValue annotationValue : boxingEliminatedTypes) {
            TypeMirror typeMirror = BytecodeDSLParser.getTypeMirror(this.context, annotationValue);
            if (BOXABLE_TYPE_KINDS.contains((Object)typeMirror.getKind())) {
                beTypes.add(typeMirror);
                continue;
            }
            model.addError("Cannot perform boxing elimination on %s. Remove this type from the boxing eliminated types list. Only primitive types boolean, byte, int, float, long, and double are supported.", typeMirror);
        }
        model.boxingEliminatedTypes = beTypes;
        if (model.hasErrors()) {
            return;
        }
        for (OperationModel operationModel : model.getOperations()) {
            NodeData nodeData;
            if (operationModel.instruction == null || (nodeData = operationModel.instruction.nodeData) == null) continue;
            BytecodeDSLParser.validateUniqueSpecializationNames(nodeData, model);
        }
        if (model.hasErrors()) {
            return;
        }
        boolean customOperationDeclared = false;
        for (TypeElement typeElement2 : ElementFilter.typesIn(typeElement.getEnclosedElements())) {
            AnnotationMirror mir = this.findOperationAnnotation(model, typeElement2);
            if (mir == null) continue;
            customOperationDeclared = true;
            CustomOperationParser.forCodeGeneration(model, this.types.Operation).parseCustomRegularOperation(mir, typeElement2, null);
        }
        if (model.getInstrumentations().size() > 31) {
            model.addError("Too many @Instrumentation annotated operations specified. The number of instrumentations is " + model.getInstrumentations().size() + ". The maximum number of instrumentations is 31.", new Object[0]);
        } else if (model.getInstrumentations().size() + model.getProvidedTags().size() > 50) {
            model.addError("Too many @Instrumentation and provided tags specified. The number of instrumentrations is " + model.getInstrumentations().size() + " and provided tags is " + model.getProvidedTags().size() + ". The maximum number of instrumentations and provided tags is 50.", new Object[0]);
        }
        for (AnnotationMirror annotationMirror : ElementUtils.getRepeatedAnnotation(typeElement.getAnnotationMirrors(), this.types.OperationProxy)) {
            CustomOperationModel customOperation;
            customOperationDeclared = true;
            AnnotationValue mirrorValue = ElementUtils.getAnnotationValue(annotationMirror, "value");
            TypeMirror proxiedType = BytecodeDSLParser.getTypeMirror(this.context, mirrorValue);
            String name = ElementUtils.getAnnotationValue(String.class, annotationMirror, "name");
            if (proxiedType.getKind() != TypeKind.DECLARED) {
                model.addError(annotationMirror, mirrorValue, "Could not proxy operation: the proxied type must be a class, not %s.", proxiedType);
                continue;
            }
            TypeElement typeElement3 = (TypeElement)((DeclaredType)proxiedType).asElement();
            AnnotationMirror proxyable = ElementUtils.findAnnotationMirror(typeElement3.getAnnotationMirrors(), (TypeMirror)this.types.OperationProxy_Proxyable);
            if (proxyable == null) {
                model.addError(annotationMirror, mirrorValue, "Could not use %s as an operation proxy: the class must be annotated with @%s.%s.", typeElement3.getQualifiedName(), ElementUtils.getSimpleName(this.types.OperationProxy), ElementUtils.getSimpleName(this.types.OperationProxy_Proxyable));
            } else if (model.enableUncachedInterpreter) {
                boolean allowUncached = ElementUtils.getAnnotationValue(Boolean.class, proxyable, "allowUncached", true);
                boolean forceCached = ElementUtils.getAnnotationValue(Boolean.class, annotationMirror, "forceCached", true);
                if (!allowUncached && !forceCached) {
                    model.addError(annotationMirror, mirrorValue, "Could not use %s as an operation proxy: the class must be annotated with @%s.%s(allowUncached=true) when an uncached interpreter is requested (or the proxy declaration should use @%s(..., forceCached=true)).", typeElement3.getQualifiedName(), ElementUtils.getSimpleName(this.types.OperationProxy), ElementUtils.getSimpleName(this.types.OperationProxy_Proxyable), ElementUtils.getSimpleName(this.types.OperationProxy));
                }
            }
            if ((customOperation = CustomOperationParser.forCodeGeneration(model, this.types.OperationProxy_Proxyable).parseCustomRegularOperation(annotationMirror, typeElement3, name)) == null || !customOperation.hasErrors()) continue;
            model.addError(annotationMirror, mirrorValue, "Encountered errors using %s as an OperationProxy. These errors must be resolved before the DSL can proceed.", typeElement3.getQualifiedName());
        }
        for (AnnotationMirror annotationMirror : ElementUtils.getRepeatedAnnotation(typeElement.getAnnotationMirrors(), this.types.ShortCircuitOperation)) {
            Iterator<List> booleanConverterTypeElement;
            customOperationDeclared = true;
            String name = ElementUtils.getAnnotationValue(String.class, annotationMirror, "name");
            AnnotationValue operatorValue = ElementUtils.getAnnotationValue(annotationMirror, "operator");
            ShortCircuitInstructionModel.Operator operator = ShortCircuitInstructionModel.Operator.valueOf(((VariableElement)operatorValue.getValue()).getSimpleName().toString());
            AnnotationValue annotationValue = ElementUtils.getAnnotationValue(annotationMirror, "booleanConverter");
            TypeMirror booleanConverter = BytecodeDSLParser.getTypeMirror(this.context, annotationValue);
            if (booleanConverter.getKind() == TypeKind.DECLARED) {
                booleanConverterTypeElement = (TypeElement)((DeclaredType)booleanConverter).asElement();
            } else if (booleanConverter.getKind() == TypeKind.VOID) {
                if (operator.returnConvertedBoolean) {
                    ShortCircuitInstructionModel.Operator alternative = switch (operator) {
                        case ShortCircuitInstructionModel.Operator.AND_RETURN_CONVERTED -> ShortCircuitInstructionModel.Operator.AND_RETURN_VALUE;
                        case ShortCircuitInstructionModel.Operator.OR_RETURN_CONVERTED -> ShortCircuitInstructionModel.Operator.OR_RETURN_VALUE;
                        default -> throw new AssertionError();
                    };
                    model.addError(annotationMirror, operatorValue, "Short circuit operation uses %s but no boolean converter was declared. Use %s or specify a boolean converter.", new Object[]{operator, alternative});
                    continue;
                }
                booleanConverterTypeElement = null;
            } else {
                model.addError(annotationMirror, annotationValue, "Could not use class as boolean converter: the converter type must be a declared type, not %s.", booleanConverter);
                continue;
            }
            CustomOperationParser.forCodeGeneration(model, this.types.ShortCircuitOperation).parseCustomShortCircuitOperation(annotationMirror, name, operator, (TypeElement)((Object)booleanConverterTypeElement));
        }
        if (!customOperationDeclared) {
            model.addError("At least one operation must be declared using @%s, @%s, or @%s.", ElementUtils.getSimpleName(this.types.Operation), ElementUtils.getSimpleName(this.types.OperationProxy), ElementUtils.getSimpleName(this.types.ShortCircuitOperation));
        }
        if (model.hasErrors()) {
            return;
        }
        if (model.localAccessesNeedLocalIndex()) {
            model.loadLocalOperation.instruction.addImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX, "local_index");
            model.storeLocalOperation.instruction.addImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX, "local_index");
        }
        if (model.materializedLocalAccessesNeedLocalIndex()) {
            model.loadLocalMaterializedOperation.instruction.addImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX, "local_index");
            model.storeLocalMaterializedOperation.instruction.addImmediate(InstructionModel.ImmediateKind.LOCAL_INDEX, "local_index");
        }
        List<OptimizationDecisionsModel.QuickenDecision> list = this.parseForceQuickenings(model);
        ArrayList<OptimizationDecisionsModel.ResolvedQuickenDecision> arrayList = new ArrayList<OptimizationDecisionsModel.ResolvedQuickenDecision>();
        if (model.usesBoxingElimination()) {
            for (OperationModel operation : model.getOperations()) {
                if (operation.kind != OperationModel.OperationKind.CUSTOM && operation.kind != OperationModel.OperationKind.CUSTOM_INSTRUMENTATION) continue;
                boolean genericReturnBoxingEliminated = model.isBoxingEliminated(operation.instruction.signature.returnType);
                LinkedHashMap<List, List> linkedHashMap = new LinkedHashMap<List, List>();
                int signatureCount = 0;
                for (SpecializationData specialization : operation.instruction.nodeData.getReachableSpecializations()) {
                    if (specialization.getMethod() == null) continue;
                    List<TypeMirror> baseSignature = operation.getSpecializationSignature(specialization).signature().getDynamicOperandTypes();
                    List<List<TypeMirror>> expandedSignatures = this.expandBoxingEliminatedImplicitCasts(model, operation.instruction.nodeData.getTypeSystem(), baseSignature);
                    signatureCount += expandedSignatures.size();
                    TypeMirror boxingReturnType = specialization.hasUnexpectedResultRewrite() ? this.context.getType(Object.class) : (genericReturnBoxingEliminated ? this.context.getType(Object.class) : specialization.getReturnType().getType());
                    for (List<TypeMirror> list2 : expandedSignatures) {
                        list2.add(0, boxingReturnType);
                    }
                    for (List<TypeMirror> list3 : expandedSignatures.stream().filter(e -> e.stream().anyMatch(model::isBoxingEliminated)).toList()) {
                        linkedHashMap.computeIfAbsent(list3, s -> new ArrayList()).add(specialization);
                    }
                    if (specialization.getBoxingOverloads().size() <= 0) continue;
                    boolean isBoxingEliminatedOverload = false;
                    for (SpecializationData boxingOverload : specialization.getBoxingOverloads()) {
                        if (!model.isBoxingEliminated(boxingOverload.getReturnType().getType())) continue;
                        isBoxingEliminatedOverload = true;
                        break;
                    }
                    if (!isBoxingEliminatedOverload || operation.instruction.nodeData.getReachableSpecializations().size() <= 1) continue;
                    for (Object signature : expandedSignatures) {
                        List<TypeMirror> parameterTypes = signature.subList(1, signature.size());
                        arrayList.add(new OptimizationDecisionsModel.ResolvedQuickenDecision(operation, List.of(specialization), parameterTypes));
                    }
                }
                if (signatureCount > 32 && operation.customModel != null) {
                    operation.customModel.addWarning(String.format("This operation expands to '%s' instructions due to boxing elimination.", signatureCount), new Object[0]);
                }
                for (List boxingGroup : linkedHashMap.keySet().stream().filter(s -> BytecodeDSLParser.countBoxingEliminatedTypes(model, s) > 0L).sorted((s0, s1) -> Long.compare(BytecodeDSLParser.countBoxingEliminatedTypes(model, s0), BytecodeDSLParser.countBoxingEliminatedTypes(model, s1))).toList()) {
                    List specializations = (List)linkedHashMap.get(boxingGroup);
                    List<TypeMirror> parameterTypes = boxingGroup.subList(1, boxingGroup.size());
                    arrayList.add(new OptimizationDecisionsModel.ResolvedQuickenDecision(operation, specializations, parameterTypes));
                }
            }
        }
        List<OptimizationDecisionsModel.ResolvedQuickenDecision> resolvedQuickenings = Stream.concat(arrayList.stream(), list.stream().map(e -> e.resolve(model))).distinct().sorted(Comparator.comparingInt(e -> e.specializations().size())).toList();
        Map decisionsBySpecializations = resolvedQuickenings.stream().collect(Collectors.groupingBy(e -> e.specializations(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : decisionsBySpecializations.entrySet()) {
            List includedSpecializations = (List)entry.getKey();
            List decisions = (List)entry.getValue();
            for (OptimizationDecisionsModel.ResolvedQuickenDecision quickening : decisions) {
                Object signature;
                assert (!includedSpecializations.isEmpty());
                NodeData node = quickening.operation().instruction.nodeData;
                Object name = includedSpecializations.size() == quickening.operation().instruction.nodeData.getSpecializations().size() ? "#" : String.join((CharSequence)"#", includedSpecializations.stream().map(s -> s.getId()).toList());
                if (decisions.size() > 1) {
                    for (TypeMirror typeMirror : quickening.types()) {
                        if (model.isBoxingEliminated(typeMirror)) {
                            name = (String)name + "$" + ElementUtils.getSimpleName(typeMirror);
                            continue;
                        }
                        name = (String)name + "$Object";
                    }
                }
                List<ExecutableElement> includedSpecializationElements = includedSpecializations.stream().map(s -> s.getMethod()).toList();
                List<SpecializationSignatureParser.SpecializationSignature> list4 = CustomOperationParser.parseSignatures(includedSpecializationElements, node, quickening.operation().constantOperands);
                signature = SpecializationSignatureParser.createPolymorphicSignature(list4, includedSpecializationElements, node);
                for (int i = 0; i < quickening.types().size(); ++i) {
                    TypeMirror type = quickening.types().get(i);
                    if (!model.isBoxingEliminated(type)) continue;
                    signature = ((Signature)signature).specializeOperandType(i, type);
                }
                InstructionModel baseInstruction = quickening.operation().instruction;
                InstructionModel quickenedInstruction = model.quickenInstruction(baseInstruction, (Signature)signature, ElementUtils.firstLetterUpperCase(name));
                quickenedInstruction.filteredSpecializations = includedSpecializations;
            }
        }
        if (model.usesBoxingElimination()) {
            InstructionModel conditional = model.instruction(InstructionModel.InstructionKind.MERGE_CONDITIONAL, "merge.conditional", model.signature(Object.class, Boolean.TYPE, Object.class));
            model.conditionalOperation.setInstruction(conditional);
            block36: for (InstructionModel instruction : (InstructionModel[])model.getInstructions().toArray(InstructionModel[]::new)) {
                switch (instruction.kind) {
                    case CUSTOM: {
                        for (int i = 0; i < instruction.signature.dynamicOperandCount; ++i) {
                            if (!instruction.getQuickeningRoot().needsBoxingElimination(model, i)) continue;
                            instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, BytecodeDSLParser.createChildBciName(i));
                        }
                        SpecializationData singleSpecialization = instruction.resolveSingleSpecialization();
                        if (singleSpecialization != null) {
                            HashSet<TypeMirror> overloadedTypes = new HashSet<TypeMirror>();
                            for (SpecializationData boxingOverload : singleSpecialization.getBoxingOverloads()) {
                                TypeMirror typeMirror = boxingOverload.getReturnType().getType();
                                if (!overloadedTypes.add(typeMirror) || !model.isBoxingEliminated(typeMirror) || ElementUtils.typeEquals(instruction.signature.returnType, typeMirror)) continue;
                                InstructionModel returnTypeQuickening = model.quickenInstruction(instruction, instruction.signature.specializeReturnType(typeMirror), ElementUtils.getSimpleName(typeMirror));
                                returnTypeQuickening.specializedType = typeMirror;
                                returnTypeQuickening.returnTypeQuickening = true;
                            }
                            if (!overloadedTypes.isEmpty()) {
                                InstructionModel specialization = model.quickenInstruction(instruction, instruction.signature, "Generic");
                                specialization.returnTypeQuickening = false;
                                specialization.generic = true;
                            }
                        }
                        if (!model.isBoxingEliminated(instruction.signature.returnType)) continue block36;
                        InstructionModel returnTypeQuickening = model.quickenInstruction(instruction, instruction.signature, "unboxed");
                        returnTypeQuickening.returnTypeQuickening = true;
                        continue block36;
                    }
                    case CUSTOM_SHORT_CIRCUIT: {
                        continue block36;
                    }
                    case LOAD_ARGUMENT: 
                    case LOAD_CONSTANT: {
                        for (TypeMirror boxedType : model.boxingEliminatedTypes) {
                            InstructionModel returnTypeQuickening = model.quickenInstruction(instruction, new Signature(boxedType, List.of()), ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxedType)));
                            returnTypeQuickening.returnTypeQuickening = true;
                        }
                        continue block36;
                    }
                    case BRANCH_FALSE: {
                        if (!model.isBoxingEliminated(this.context.getType(Boolean.TYPE))) continue block36;
                        instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, BytecodeDSLParser.createChildBciName(0));
                        InstructionModel specialization = model.quickenInstruction(instruction, new Signature(this.context.getType(Void.TYPE), List.of(this.context.getType(Object.class))), "Generic");
                        specialization.generic = true;
                        specialization.returnTypeQuickening = false;
                        InstructionModel returnTypeQuickening = model.quickenInstruction(instruction, new Signature(this.context.getType(Void.TYPE), List.of(this.context.getType(Boolean.TYPE))), "Boolean");
                        returnTypeQuickening.returnTypeQuickening = true;
                        continue block36;
                    }
                    case MERGE_CONDITIONAL: {
                        InstructionModel argumentQuickening;
                        instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, BytecodeDSLParser.createChildBciName(0));
                        instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, BytecodeDSLParser.createChildBciName(1));
                        for (TypeMirror boxedType : model.boxingEliminatedTypes) {
                            InstructionModel specializedInstruction = model.quickenInstruction(instruction, new Signature(this.context.getType(Object.class), List.of(this.context.getType(Boolean.TYPE), boxedType)), ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxedType)));
                            specializedInstruction.returnTypeQuickening = false;
                            specializedInstruction.specializedType = boxedType;
                            Signature signature = new Signature(boxedType, specializedInstruction.signature.operandTypes);
                            argumentQuickening = model.quickenInstruction(specializedInstruction, signature, "unboxed");
                            argumentQuickening.returnTypeQuickening = true;
                            argumentQuickening.specializedType = boxedType;
                        }
                        InstructionModel genericQuickening = model.quickenInstruction(instruction, instruction.signature, "generic");
                        genericQuickening.generic = true;
                        genericQuickening.returnTypeQuickening = false;
                        genericQuickening.specializedType = null;
                        continue block36;
                    }
                    case POP: {
                        instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, BytecodeDSLParser.createChildBciName(0));
                        instruction.specializedType = this.context.getType(Object.class);
                        for (TypeMirror boxedType : model.boxingEliminatedTypes) {
                            InstructionModel instructionModel = model.quickenInstruction(instruction, new Signature(this.context.getType(Void.TYPE), List.of(boxedType)), ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxedType)));
                            instructionModel.returnTypeQuickening = false;
                            instructionModel.specializedType = boxedType;
                        }
                        InstructionModel genericQuickening = model.quickenInstruction(instruction, instruction.signature, "generic");
                        genericQuickening.generic = true;
                        genericQuickening.returnTypeQuickening = false;
                        genericQuickening.specializedType = null;
                        continue block36;
                    }
                    case TAG_YIELD: {
                        continue block36;
                    }
                    case TAG_LEAVE: {
                        InstructionModel argumentQuickening;
                        Signature newSignature;
                        instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, BytecodeDSLParser.createChildBciName(0));
                        instruction.specializedType = this.context.getType(Object.class);
                        for (TypeMirror boxedType : model.boxingEliminatedTypes) {
                            InstructionModel instructionModel = model.quickenInstruction(instruction, new Signature(this.context.getType(Object.class), List.of(boxedType)), ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxedType)));
                            instructionModel.returnTypeQuickening = false;
                            instructionModel.specializedType = boxedType;
                            newSignature = new Signature(boxedType, instruction.signature.operandTypes);
                            argumentQuickening = model.quickenInstruction(instructionModel, newSignature, "unboxed");
                            argumentQuickening.returnTypeQuickening = true;
                            argumentQuickening.specializedType = boxedType;
                        }
                        InstructionModel genericQuickening = model.quickenInstruction(instruction, instruction.signature, "generic");
                        genericQuickening.generic = true;
                        genericQuickening.returnTypeQuickening = false;
                        genericQuickening.specializedType = null;
                        continue block36;
                    }
                    case DUP: {
                        continue block36;
                    }
                    case LOAD_LOCAL: 
                    case LOAD_LOCAL_MATERIALIZED: {
                        InstructionModel argumentQuickening;
                        Signature newSignature;
                        for (TypeMirror boxedType : model.boxingEliminatedTypes) {
                            InstructionModel instructionModel = model.quickenInstruction(instruction, instruction.signature, ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxedType)));
                            instructionModel.returnTypeQuickening = false;
                            instructionModel.specializedType = boxedType;
                            newSignature = new Signature(boxedType, instruction.signature.operandTypes);
                            argumentQuickening = model.quickenInstruction(instructionModel, newSignature, "unboxed");
                            argumentQuickening.returnTypeQuickening = true;
                            argumentQuickening.specializedType = boxedType;
                        }
                        InstructionModel genericQuickening = model.quickenInstruction(instruction, instruction.signature, "generic");
                        genericQuickening.generic = true;
                        genericQuickening.returnTypeQuickening = false;
                        genericQuickening.specializedType = null;
                        continue block36;
                    }
                    case STORE_LOCAL: 
                    case STORE_LOCAL_MATERIALIZED: {
                        InstructionModel argumentQuickening;
                        instruction.addImmediate(InstructionModel.ImmediateKind.BYTECODE_INDEX, BytecodeDSLParser.createChildBciName(0));
                        for (TypeMirror boxedType : model.boxingEliminatedTypes) {
                            InstructionModel instructionModel = model.quickenInstruction(instruction, instruction.signature, ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxedType)));
                            instructionModel.returnTypeQuickening = false;
                            instructionModel.specializedType = boxedType;
                            argumentQuickening = model.quickenInstruction(instructionModel, instruction.signature.specializeOperandType(0, boxedType), ElementUtils.firstLetterUpperCase(ElementUtils.getSimpleName(boxedType)));
                            argumentQuickening.returnTypeQuickening = false;
                            argumentQuickening.specializedType = boxedType;
                        }
                        InstructionModel genericQuickening = model.quickenInstruction(instruction, instruction.signature, "generic");
                        genericQuickening.generic = true;
                        genericQuickening.returnTypeQuickening = false;
                        genericQuickening.specializedType = null;
                    }
                }
            }
        }
        if (model.enableSerialization) {
            void var21_57;
            ArrayList<VariableElement> serializedFields = new ArrayList<VariableElement>();
            TypeElement typeElement4 = model.getTemplateType();
            while (var21_57 != null && !ElementUtils.typeEquals(this.types.RootNode, var21_57.asType())) {
                for (VariableElement field : ElementFilter.fieldsIn(var21_57.getEnclosedElements())) {
                    boolean visible;
                    boolean inTemplateType;
                    if (field.getModifiers().contains((Object)Modifier.STATIC) || field.getModifiers().contains((Object)Modifier.TRANSIENT) || field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                    boolean bl = inTemplateType = model.getTemplateType() == var21_57;
                    boolean bl2 = inTemplateType ? !field.getModifiers().contains((Object)Modifier.PRIVATE) : (visible = ElementUtils.isVisible(model.getTemplateType(), field));
                    if (!visible) {
                        model.addError(inTemplateType ? field : null, this.errorPrefix() + "The field '%s' is not accessible to generated code. The field must be accessible for serialization. Add the transient modifier to the field or make it accessible to resolve this problem.", ElementUtils.getReadableReference(model.getTemplateType(), field));
                        continue;
                    }
                    serializedFields.add(field);
                }
                TypeElement typeElement5 = ElementUtils.castTypeElement(var21_57.getSuperclass());
            }
            model.serializedFields = serializedFields;
        }
        model.finalizeInstructions();
    }

    private static void parseDefaultUncachedThreshold(BytecodeDSLModel model, AnnotationMirror generateBytecodeMirror, DSLExpressionResolver resolver) {
        String defaultUncachedThreshold;
        AnnotationValue explicitValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "defaultUncachedThreshold", false);
        if (explicitValue != null) {
            if (!model.enableUncachedInterpreter) {
                model.addError(generateBytecodeMirror, explicitValue, "An uncached interpreter is not enabled, so the uncached threshold has no effect.", new Object[0]);
                return;
            }
            defaultUncachedThreshold = ElementUtils.resolveAnnotationValue(String.class, explicitValue);
        } else {
            defaultUncachedThreshold = ElementUtils.getAnnotationValue(String.class, generateBytecodeMirror, "defaultUncachedThreshold");
        }
        DSLExpression expression = DSLExpression.parse(model, "defaultUncachedThreshold", defaultUncachedThreshold);
        if (expression == null) {
            return;
        }
        DSLExpression resolvedExpression = DSLExpression.resolve(resolver, model, "defaultUncachedThreshold", expression, defaultUncachedThreshold);
        if (resolvedExpression == null) {
            return;
        }
        if (!ElementUtils.typeEquals(resolvedExpression.getResolvedType(), model.getContext().getType(Integer.TYPE))) {
            model.addError(generateBytecodeMirror, explicitValue, "Expression has type %s, but type int required. Change the expression to evaluate to an int.", resolvedExpression.getResolvedType());
            return;
        }
        model.defaultUncachedThreshold = defaultUncachedThreshold;
        model.defaultUncachedThresholdExpression = resolvedExpression;
    }

    private List<List<TypeMirror>> expandBoxingEliminatedImplicitCasts(BytecodeDSLModel model, TypeSystemData typeSystem, List<TypeMirror> signatureTypes) {
        ArrayList<List<TypeMirror>> expandedSignatures = new ArrayList<List<TypeMirror>>();
        expandedSignatures.add(new ArrayList());
        for (TypeMirror actualType : signatureTypes) {
            TypeMirror boxingType = model.isBoxingEliminated(actualType) ? actualType : this.context.getType(Object.class);
            List<ImplicitCastData> implicitCasts = typeSystem.lookupByTargetType(actualType);
            ArrayList newSignatures = new ArrayList();
            for (ImplicitCastData implicitCastData : implicitCasts) {
                if (!model.isBoxingEliminated(implicitCastData.getTargetType())) continue;
                for (List list : expandedSignatures) {
                    ArrayList<TypeMirror> appended = new ArrayList<TypeMirror>(list);
                    appended.add(implicitCastData.getSourceType());
                    newSignatures.add(appended);
                }
            }
            for (List list : expandedSignatures) {
                ArrayList<TypeMirror> appended = new ArrayList<TypeMirror>(list);
                appended.add(boxingType);
                newSignatures.add(appended);
            }
            expandedSignatures = newSignatures;
        }
        return expandedSignatures;
    }

    private TypeSystemData parseTypeSystemReference(TypeElement typeElement) {
        AnnotationMirror typeSystemRefMirror = ElementUtils.findAnnotationMirror((Element)typeElement, (TypeMirror)this.types.TypeSystemReference);
        if (typeSystemRefMirror != null) {
            TypeMirror typeSystemType = ElementUtils.getAnnotationValue(TypeMirror.class, typeSystemRefMirror, "value");
            if (typeSystemType instanceof DeclaredType) {
                return this.context.parseIfAbsent((TypeElement)((DeclaredType)typeSystemType).asElement(), TypeSystemParser.class, e -> {
                    TypeSystemParser parser = new TypeSystemParser();
                    return (TypeSystemData)parser.parse((Element)e, false);
                });
            }
            return null;
        }
        return new TypeSystemData(this.context, typeElement, null, true);
    }

    private void parseTagTreeNodeLibrary(BytecodeDSLModel model, AnnotationMirror generateBytecodeMirror) {
        ExportsData exports;
        AnnotationValue tagTreeNodeLibraryValue = ElementUtils.getAnnotationValue(generateBytecodeMirror, "tagTreeNodeLibrary");
        TypeMirror tagTreeNodeLibrary = ElementUtils.getAnnotationValue(TypeMirror.class, generateBytecodeMirror, "tagTreeNodeLibrary");
        ExportsParser parser = new ExportsParser();
        TypeElement type = ElementUtils.castTypeElement(tagTreeNodeLibrary);
        if (type == null) {
            model.addError(generateBytecodeMirror, tagTreeNodeLibraryValue, "Invalid type specified for the tag tree node library. Must be a declared class.", ElementUtils.getQualifiedName(tagTreeNodeLibrary));
            return;
        }
        model.tagTreeNodeLibrary = exports = (ExportsData)parser.parse((Element)type, false);
        if (exports.hasErrors()) {
            model.addError(generateBytecodeMirror, tagTreeNodeLibraryValue, "The provided tag tree node library '%s' contains errors. Please fix the errors in the class to resolve this problem.", ElementUtils.getQualifiedName(tagTreeNodeLibrary));
            return;
        }
        ExportsLibrary nodeLibrary = exports.getExportedLibraries().get(ElementUtils.getTypeSimpleId(this.types.NodeLibrary));
        if (nodeLibrary == null) {
            model.addError(generateBytecodeMirror, tagTreeNodeLibraryValue, "The provided tag tree node library '%s' must export a library of type '%s' but does not. Add @%s(value = %s.class, receiverType = %s.class) to the class declaration to resolve this.", ElementUtils.getQualifiedName(tagTreeNodeLibrary), ElementUtils.getQualifiedName(this.types.NodeLibrary), ElementUtils.getSimpleName(this.types.ExportLibrary), ElementUtils.getSimpleName(this.types.NodeLibrary), ElementUtils.getSimpleName(this.types.TagTreeNode));
            return;
        }
        if (!ElementUtils.typeEquals(nodeLibrary.getReceiverType(), this.types.TagTreeNode)) {
            model.addError(generateBytecodeMirror, tagTreeNodeLibraryValue, "The provided tag tree node library '%s' must export the '%s' library with receiver type '%s' but it currently uses '%s'. Change the receiver type to '%s' to resolve this.", ElementUtils.getQualifiedName(tagTreeNodeLibrary), ElementUtils.getSimpleName(this.types.NodeLibrary), ElementUtils.getSimpleName(this.types.TagTreeNode), ElementUtils.getSimpleName(nodeLibrary.getReceiverType()), ElementUtils.getSimpleName(this.types.TagTreeNode));
            return;
        }
    }

    private static void checkUnsupportedAnnotation(BytecodeDSLModel model, List<? extends AnnotationMirror> annotations, TypeMirror annotation, String error) {
        AnnotationMirror mirror = ElementUtils.findAnnotationMirror(annotations, annotation);
        if (mirror != null) {
            String errorMessage = error != null ? error : String.format("Bytecode DSL interpreters do not support the %s annotation.", ElementUtils.getSimpleName(annotation));
            model.addError(mirror, null, errorMessage, new Object[0]);
        }
    }

    private AnnotationMirror findOperationAnnotation(BytecodeDSLModel model, TypeElement typeElement) {
        AnnotationMirror foundMirror = null;
        TypeMirror foundType = null;
        for (TypeMirror typeMirror : List.of(this.types.Operation, this.types.Instrumentation, this.types.Prolog, this.types.EpilogReturn, this.types.EpilogExceptional)) {
            AnnotationMirror annotationMirror = ElementUtils.findAnnotationMirror((Element)typeElement, typeMirror);
            if (annotationMirror == null) continue;
            if (foundMirror == null) {
                foundMirror = annotationMirror;
                foundType = typeMirror;
                continue;
            }
            model.addError(typeElement, "@%s and @%s cannot be used at the same time. Remove one of the annotations to resolve this.", ElementUtils.getSimpleName(foundType), ElementUtils.getSimpleName(typeMirror));
            return null;
        }
        return foundMirror;
    }

    private static String createChildBciName(int i) {
        return "child" + i;
    }

    private static long countBoxingEliminatedTypes(BytecodeDSLModel model, List<TypeMirror> s0) {
        return s0.stream().filter(t -> model.isBoxingEliminated((TypeMirror)t)).count();
    }

    private List<OptimizationDecisionsModel.QuickenDecision> parseForceQuickenings(BytecodeDSLModel model) {
        ArrayList<OptimizationDecisionsModel.QuickenDecision> decisions = new ArrayList<OptimizationDecisionsModel.QuickenDecision>();
        for (OperationModel operation : model.getOperations()) {
            NodeData node;
            InstructionModel instruction = operation.instruction;
            if (instruction == null || (node = instruction.nodeData) == null) continue;
            HashSet<ExecutableElement> processedElements = new HashSet<ExecutableElement>();
            if (node != null) {
                LinkedHashMap<String, Set> grouping = new LinkedHashMap<String, Set>();
                block1: for (SpecializationData specializationData : node.getSpecializations()) {
                    if (specializationData.getMethod() == null) continue;
                    ExecutableElement method = specializationData.getMethod();
                    processedElements.add(method);
                    LinkedHashMap<String, List> seenNames = new LinkedHashMap<String, List>();
                    for (AnnotationMirror annotationMirror : ElementUtils.getRepeatedAnnotation(method.getAnnotationMirrors(), this.types.ForceQuickening)) {
                        String name = ElementUtils.getAnnotationValue(String.class, annotationMirror, "value", false);
                        if (!model.enableQuickening) {
                            model.addError(method, "Cannot use @%s if quickening is not enabled for @%s. Enable quickening in @%s to resolve this.", ElementUtils.getSimpleName(this.types.ForceQuickening), ElementUtils.getSimpleName(this.types.GenerateBytecode), ElementUtils.getSimpleName(this.types.ForceQuickening));
                            break;
                        }
                        if (name == null) {
                            name = "";
                        } else if (name.equals("")) {
                            model.addError(method, "Identifier for @%s must not be an empty string.", ElementUtils.getSimpleName(this.types.ForceQuickening));
                            continue;
                        }
                        seenNames.computeIfAbsent(name, v -> new ArrayList()).add(specializationData);
                        grouping.computeIfAbsent(name, v -> new LinkedHashSet()).add(specializationData);
                    }
                    for (Map.Entry entry : seenNames.entrySet()) {
                        if (((List)entry.getValue()).size() <= 1) continue;
                        model.addError(method, "Multiple @%s with the same value are not allowed for one specialization.", ElementUtils.getSimpleName(this.types.ForceQuickening));
                        continue block1;
                    }
                }
                for (Map.Entry entry : grouping.entrySet()) {
                    if (((String)entry.getKey()).equals("")) {
                        for (SpecializationData specialization : (Set)entry.getValue()) {
                            decisions.add(new OptimizationDecisionsModel.QuickenDecision(operation, Set.of(specialization)));
                        }
                        continue;
                    }
                    if (((Set)entry.getValue()).size() == 1) {
                        SpecializationData s = (SpecializationData)((Set)entry.getValue()).iterator().next();
                        model.addError(s.getMethod(), "@%s with name '%s' does only match a single quickening, but must match more than one. Specify additional quickenings with the same name or remove the value from the annotation to resolve this.", ElementUtils.getSimpleName(this.types.ForceQuickening), entry.getKey());
                        continue;
                    }
                    decisions.add(new OptimizationDecisionsModel.QuickenDecision(operation, (Collection)entry.getValue()));
                }
            }
            for (Element e : ElementUtils.loadFilteredMembers(node.getTemplateType())) {
                if (processedElements.contains(e) || ElementUtils.getRepeatedAnnotation(e.getAnnotationMirrors(), this.types.ForceQuickening).isEmpty()) continue;
                model.addError(e, "Invalid location of @%s. The annotation can only be used on method annotated with @%s.", ElementUtils.getSimpleName(this.types.ForceQuickening), ElementUtils.getSimpleName(this.types.Specialization));
            }
        }
        return decisions;
    }

    private static void validateUniqueSpecializationNames(NodeData node, MessageContainer messageTarget) {
        HashSet<String> seenSpecializationNames = new HashSet<String>();
        for (SpecializationData specialization : node.getSpecializations()) {
            String methodName;
            if (specialization.getMethod() == null || seenSpecializationNames.add(methodName = specialization.getMethodName())) continue;
            messageTarget.addError(specialization.getMethod(), "Specialization method name %s is not unique but might be used as an identifier to refer to specializations. Use a unique specialization method name to resolve this. It is recommended to choose a defining characteristic of a specialization when naming it, for example 'doBelowZero'.", new Object[0]);
        }
    }

    private String errorPrefix() {
        return String.format("Failed to generate code for @%s: ", ElementUtils.getSimpleName(this.types.GenerateBytecode));
    }

    public static TypeMirror getTypeMirror(ProcessorContext context, AnnotationValue value) throws AssertionError {
        if (value.getValue() instanceof Class) {
            return context.getType((Class)value.getValue());
        }
        if (value.getValue() instanceof TypeMirror) {
            return (TypeMirror)value.getValue();
        }
        throw new AssertionError();
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.GenerateBytecode;
    }

    @Override
    public DeclaredType getRepeatAnnotationType() {
        return this.types.GenerateBytecodeTestVariants;
    }
}

