/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class CodeExecutableElement
extends CodeElement<Element>
implements ExecutableElement {
    private final List<TypeMirror> throwables = new ArrayList<TypeMirror>();
    private final List<VariableElement> parameters = this.parentableList(this, new ArrayList());
    private final List<TypeParameterElement> typeParameters = this.parentableList(this, new ArrayList());
    private TypeMirror returnType;
    private Name name;
    private CodeTree bodyTree;
    private String body;
    private AnnotationValue defaultValue;
    private boolean varArgs;

    public CodeExecutableElement(TypeMirror returnType, String name) {
        super(ElementUtils.modifiers(new Modifier[0]));
        this.returnType = returnType;
        this.name = CodeNames.of(name);
    }

    public CodeExecutableElement(Set<Modifier> modifiers, TypeMirror returnType, String name, CodeVariableElement ... parameters) {
        super(modifiers);
        this.returnType = returnType;
        this.name = CodeNames.of(name);
        for (CodeVariableElement codeParameter : parameters) {
            this.addParameter(codeParameter);
        }
    }

    public void setVisibility(Modifier visibility) {
        ElementUtils.setVisibility(this.getModifiers(), visibility);
    }

    public Modifier getVisibility() {
        return ElementUtils.getVisibility(this.getModifiers());
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public List<TypeMirror> getThrownTypes() {
        return this.throwables;
    }

    @Override
    public TypeMirror asType() {
        return this.returnType;
    }

    @Override
    public ElementKind getKind() {
        if (this.getReturnType() == null) {
            return ElementKind.CONSTRUCTOR;
        }
        return ElementKind.METHOD;
    }

    public List<TypeParameterElement> getTypeParameters() {
        return this.typeParameters;
    }

    public void setVarArgs(boolean varargs) {
        this.varArgs = varargs;
    }

    @Override
    public boolean isVarArgs() {
        return this.varArgs;
    }

    public void setDefaultValue(AnnotationValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public AnnotationValue getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Name getSimpleName() {
        return this.name;
    }

    public CodeTreeBuilder getBuilder() {
        CodeTree tree = this.bodyTree;
        return this.createBuilder().tree(tree);
    }

    public CodeTreeBuilder createBuilder() {
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        builder.setEnclosingElement(this);
        this.bodyTree = builder.getTree();
        this.body = null;
        return builder;
    }

    public CodeTreeBuilder appendBuilder() {
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        builder.setEnclosingElement(this);
        if (this.bodyTree != null) {
            builder.tree(this.bodyTree);
        }
        this.bodyTree = builder.getTree();
        this.body = null;
        return builder;
    }

    public void setBodyTree(CodeTree body) {
        this.bodyTree = body;
    }

    public CodeTree getBodyTree() {
        return this.bodyTree;
    }

    @Override
    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public List<VariableElement> getParameters() {
        return this.parameters;
    }

    public TypeMirror[] getParameterTypes() {
        TypeMirror[] types = new TypeMirror[this.getParameters().size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.parameters.get(i).asType();
        }
        return types;
    }

    public void setReturnType(TypeMirror type) {
        this.returnType = type;
    }

    public void addParameter(VariableElement parameter) {
        this.parameters.add(parameter);
    }

    public void addThrownType(TypeMirror thrownType) {
        this.throwables.add(thrownType);
    }

    public void setSimpleName(Name name) {
        this.name = name;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitExecutable(this, p);
    }

    public static CodeExecutableElement cloneNoAnnotations(ExecutableElement executable) {
        CodeExecutableElement clone = CodeExecutableElement.clone(executable);
        clone.getAnnotationMirrors().clear();
        for (VariableElement var : clone.getParameters()) {
            ((CodeVariableElement)var).getAnnotationMirrors().clear();
        }
        return clone;
    }

    public static CodeExecutableElement clone(ExecutableElement method) {
        CodeExecutableElement copy = new CodeExecutableElement(method.getReturnType(), method.getSimpleName().toString());
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            copy.addThrownType(typeMirror);
        }
        copy.setDefaultValue(method.getDefaultValue());
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            copy.getTypeParameters().add(typeParameterElement);
        }
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            copy.addAnnotationMirror(annotationMirror);
        }
        for (VariableElement variableElement : method.getParameters()) {
            copy.addParameter(CodeVariableElement.clone(variableElement));
        }
        for (Element element : method.getEnclosedElements()) {
            copy.add(element);
        }
        copy.getModifiers().addAll(method.getModifiers());
        copy.setVarArgs(method.isVarArgs());
        if (method instanceof CodeExecutableElement) {
            copy.setBodyTree(((CodeExecutableElement)method).getBodyTree());
        }
        return copy;
    }

    @Override
    public TypeMirror getReceiverType() {
        throw new UnsupportedOperationException();
    }

    public void renameArguments(String ... args) {
        for (int i = 0; i < args.length && i < this.getParameters().size(); ++i) {
            ((CodeVariableElement)this.getParameters().get(i)).setName(args[i]);
        }
    }

    public void changeTypes(TypeMirror ... args) {
        for (int i = 0; i < args.length && i < this.getParameters().size(); ++i) {
            ((CodeVariableElement)this.getParameters().get(i)).setType(args[i]);
        }
    }
}

