/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.generator.BitSet;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.StateQuery;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.GuardExpression;
import com.oracle.truffle.dsl.processor.model.InlineFieldData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.parser.SpecializationGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

final class BitStateList {
    private final List<BitRangedState> entries;
    private final LinkedHashMap<Object, List<BitRangedState>> byKey = new LinkedHashMap();
    private final int bitCount;

    BitStateList(List<State<?>> stateObjects) {
        int bitOffset = 0;
        ArrayList<BitRangedState> newStates = new ArrayList<BitRangedState>();
        for (State<?> state : stateObjects) {
            List values = this.byKey.computeIfAbsent(state.key, v -> new ArrayList());
            for (BitRangedState nodeState : values) {
                if (nodeState.state.getClass() != state.getClass()) continue;
                throw new IllegalArgumentException(String.format("Duplicate state for value with key %s and class %s.", state.key, nodeState.state.getClass()));
            }
            int bits = state.getBits();
            BitRangedState rangedState = new BitRangedState(state, new BitSet.BitRange(bitOffset, bits));
            newStates.add(rangedState);
            values.add(rangedState);
            bitOffset += bits;
        }
        this.entries = Collections.unmodifiableList(newStates);
        this.bitCount = bitOffset;
    }

    int getBitCount() {
        return this.bitCount;
    }

    List<BitRangedState> getEntries() {
        return this.entries;
    }

    boolean contains(Class<?> clazz, Object key) {
        return this.lookup(clazz, key) != null;
    }

    <T extends State<?>> List<T> queryStates(Class<T> statesClass) {
        ArrayList<State> newStates = new ArrayList<State>();
        for (BitRangedState ranged : this.entries) {
            if (!statesClass.isInstance(ranged.state)) continue;
            newStates.add((State)statesClass.cast(ranged.state));
        }
        return newStates;
    }

    <T extends State<E>, E> Collection<E> queryKeys(Class<T> statesClass) {
        if (statesClass == null) {
            return this.byKey.keySet();
        }
        LinkedHashSet newKeys = new LinkedHashSet();
        for (BitRangedState ranged : this.entries) {
            if (!statesClass.isInstance(ranged.state)) continue;
            newKeys.add(((State)statesClass.cast(ranged.state)).key);
        }
        return newKeys;
    }

    List<BitSet.BitRange> queryRanges(StateQuery query) {
        ArrayList<BitSet.BitRange> range = new ArrayList<BitSet.BitRange>();
        for (Object object : this.getQueryKeys(query)) {
            List<BitRangedState> values = this.byKey.get(object);
            if (values == null) continue;
            for (BitRangedState v : values) {
                if (!query.match(v.state)) continue;
                range.add(v.bitRange);
            }
        }
        return range;
    }

    BitSet.BitRange queryRange(StateQuery query) {
        if (!query.filtersClass()) {
            throw new IllegalArgumentException("A query for a single range must query the state class.");
        }
        for (Object object : this.getQueryKeys(query)) {
            BitRangedState state = BitStateList.matchQueryAny(query, this.byKey.get(object));
            if (state == null) continue;
            return state.bitRange;
        }
        return null;
    }

    boolean contains(StateQuery query) {
        for (Object object : this.getQueryKeys(query)) {
            if (BitStateList.matchQueryAny(query, this.byKey.get(object)) == null) continue;
            return true;
        }
        return false;
    }

    private Collection<? extends Object> getQueryKeys(StateQuery query) {
        if (query.keys == null) {
            return this.byKey.keySet();
        }
        return query.keys;
    }

    private static BitRangedState matchQueryAny(StateQuery query, List<BitRangedState> values) {
        if (values != null) {
            for (BitRangedState v : values) {
                if (!query.match(v.state)) continue;
                return v;
            }
        }
        return null;
    }

    <T> StateQuery filter(StateQuery query) {
        ArrayList newKeys = new ArrayList();
        for (Object object : query.keys) {
            BitRangedState state = BitStateList.matchQueryAny(query, this.byKey.get(object));
            if (state == null) continue;
            newKeys.add(state.state.key);
        }
        return StateQuery.create(query.filterClass, newKeys);
    }

    String toString(StateQuery query, String elementSep) {
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (Object object : query.keys) {
            BitRangedState state = BitStateList.matchQueryAny(query, this.byKey.get(object));
            if (state == null) continue;
            b.append(sep).append(state.state.toString());
            sep = elementSep;
        }
        return b.toString();
    }

    FlatNodeGenFactory.MultiStateBitSet splitBitSets(String namePrefix, NodeData activeNode, int maxBitWidth) {
        List<StateGroup> groups = BitStateList.groupByDependentSpecializations(this.entries);
        List<BitStateList> stateLists = BitStateList.splitByWidth(groups, maxBitWidth);
        for (BitRangedState state : this.entries) {
            boolean found = false;
            Class<?> stateClass = state.state.getClass();
            for (BitStateList list : stateLists) {
                if (!list.contains(stateClass, state.state.key)) continue;
                if (found) {
                    throw new AssertionError((Object)"found twice");
                }
                found = true;
            }
            if (!found) {
                throw new AssertionError((Object)("element not contained in split lists " + state));
            }
        }
        ArrayList<BitSet> allBitSets = new ArrayList<BitSet>();
        ArrayList<BitSet> activeBitSets = new ArrayList<BitSet>();
        int index = 0;
        for (BitStateList list : stateLists) {
            BitSet bitSet = new BitSet(namePrefix + "state_" + index, list);
            if (list.isRelevantFor(activeNode)) {
                if (list.getBitCount() == 0) continue;
                activeBitSets.add(bitSet);
            }
            allBitSets.add(bitSet);
            ++index;
        }
        return new FlatNodeGenFactory.MultiStateBitSet(allBitSets, activeBitSets);
    }

    private static int countGroupBits(List<StateGroup> groupedStates) {
        int bits = 0;
        for (StateGroup state : groupedStates) {
            bits += state.countBits();
        }
        return bits;
    }

    private static List<BitStateList> splitByWidth(List<StateGroup> groups, int maxBitWidth) {
        ArrayList<ArrayList<StateGroup>> split = new ArrayList<ArrayList<StateGroup>>();
        ArrayList<StateGroup> currentStates = new ArrayList<StateGroup>();
        int currentWidth = 0;
        for (StateGroup grouped : groups) {
            int n = grouped.countBits();
            if (!currentStates.isEmpty()) {
                boolean forceNewGroup;
                boolean bl = forceNewGroup = !BitStateList.canBeInSameBitSet(currentStates, grouped);
                if (forceNewGroup || currentWidth + n > maxBitWidth) {
                    split.add(currentStates);
                    currentStates = new ArrayList();
                    currentWidth = 0;
                }
            }
            currentStates.add(grouped);
            currentWidth += n;
        }
        if (!currentStates.isEmpty()) {
            split.add(currentStates);
        }
        if (split.size() > 1) {
            block1: for (int i = split.size() - 1; i >= 0; --i) {
                List pack = (List)split.get(i);
                int n = BitStateList.countGroupBits(pack);
                block2: for (int y = i - 1; y >= 0; --y) {
                    List otherPack = (List)split.get(y);
                    int otherBits = BitStateList.countGroupBits(otherPack);
                    int otherBitsLeft = maxBitWidth - otherBits;
                    if (otherBitsLeft <= 0) continue;
                    if (n <= otherBitsLeft) {
                        boolean canFullyMerge = true;
                        for (StateGroup group : pack) {
                            if (BitStateList.canBeInSameBitSet(otherPack, group)) continue;
                            canFullyMerge = false;
                            break;
                        }
                        if (canFullyMerge) {
                            otherPack.addAll(pack);
                            split.remove(i);
                            continue block1;
                        }
                    }
                    if (pack.size() <= 1) continue;
                    ListIterator packsIterator = pack.listIterator();
                    while (packsIterator.hasNext()) {
                        StateGroup group = (StateGroup)packsIterator.next();
                        int groupBits = group.countBits();
                        if (groupBits > otherBitsLeft || !BitStateList.canBeInSameBitSet(otherPack, group)) continue;
                        packsIterator.remove();
                        otherPack.add(group);
                        if ((otherBitsLeft -= groupBits) > 0) continue;
                        continue block2;
                    }
                }
            }
        }
        ArrayList<BitStateList> packedLists = new ArrayList<BitStateList>();
        for (List list : split) {
            ArrayList flattendGroup = new ArrayList();
            for (StateGroup group : list) {
                flattendGroup.addAll(group.states);
            }
            BitStateList list2 = new BitStateList(flattendGroup);
            if (maxBitWidth == 32 && list2.getBitCount() > maxBitWidth) {
                throw new AssertionError((Object)"Max bitwidth exceeded. Probably packing error.");
            }
            packedLists.add(list2);
        }
        return packedLists;
    }

    private static boolean canBeInSameBitSet(List<StateGroup> states, StateGroup group) {
        for (StateGroup state : states) {
            if (state.canBeInSameBitSet(group)) continue;
            return false;
        }
        return true;
    }

    private static List<StateGroup> groupByDependentSpecializations(List<BitRangedState> states) {
        ArrayList<StateGroup> groups = new ArrayList<StateGroup>();
        LinkedHashMap<SpecializationData, StateGroup> specializationGroups = new LinkedHashMap<SpecializationData, StateGroup>();
        for (BitRangedState state : states) {
            SpecializationData dependentSpecialization = state.state.getDependentSpecialization();
            if (dependentSpecialization != null) {
                StateGroup group = (StateGroup)specializationGroups.get(dependentSpecialization);
                if (group == null) {
                    SpecializationData replaces;
                    Iterator<SpecializationData> iterator = dependentSpecialization.getReplaces().iterator();
                    while (iterator.hasNext() && (group = (StateGroup)specializationGroups.get(replaces = iterator.next())) == null) {
                    }
                }
                if (group == null) {
                    group = new StateGroup(new ArrayList(), null, dependentSpecialization);
                    specializationGroups.put(dependentSpecialization, group);
                    groups.add(group);
                }
                if (group.excludedSpecialization != state.state.getExcludedSpecialization()) {
                    throw new AssertionError((Object)"States with dependent specializations must not use excluded specializations.");
                }
                group.states.add(state.state);
                continue;
            }
            groups.add(new StateGroup(Arrays.asList(state.state), state.state.getExcludedSpecialization(), null));
        }
        return groups;
    }

    private boolean isRelevantFor(NodeData activeNode) {
        for (BitRangedState ranged : this.entries) {
            if (ranged.state.node != activeNode) continue;
            return true;
        }
        return false;
    }

    private BitRangedState lookup(Class<? extends State<?>> clazz, Object key) {
        List<BitRangedState> values = this.byKey.get(key);
        if (values != null) {
            for (BitRangedState v : values) {
                if (v.state.getClass() != clazz) continue;
                return v;
            }
        }
        return null;
    }

    static abstract class State<T> {
        final NodeData node;
        final T key;

        State(NodeData node, T key) {
            this.node = node;
            this.key = key;
        }

        SpecializationData getDependentSpecialization() {
            return null;
        }

        SpecializationData getExcludedSpecialization() {
            return null;
        }

        abstract int getBits();

        public abstract String toString();

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            return Objects.equals(this.key, other.key);
        }

        void addStateDoc(CodeTreeBuilder docBuilder) {
            docBuilder.string(this.toString());
        }

        abstract boolean isInlined();
    }

    static final class BitRangedState {
        final State<?> state;
        final BitSet.BitRange bitRange;

        BitRangedState(State<?> state, BitSet.BitRange bitRange) {
            this.state = state;
            this.bitRange = bitRange;
        }
    }

    static final class StateGroup {
        final List<State<?>> states;
        final SpecializationData excludedSpecialization;
        final SpecializationData dependentSpecialization;

        StateGroup(List<State<?>> states, SpecializationData excludedSpecialization, SpecializationData dependentSpecialization) {
            this.states = states;
            this.excludedSpecialization = excludedSpecialization;
            this.dependentSpecialization = dependentSpecialization;
        }

        boolean canBeInSameBitSet(StateGroup group) {
            if (this.excludedSpecialization != null && this.excludedSpecialization.equals(group.dependentSpecialization)) {
                return false;
            }
            return group.excludedSpecialization == null || !group.excludedSpecialization.equals(this.dependentSpecialization);
        }

        int countBits() {
            int bits = 0;
            for (State<?> state : this.states) {
                bits += state.getBits();
            }
            return bits;
        }
    }

    static final class AOTPreparedState
    extends State<String> {
        AOTPreparedState(NodeData node) {
            super(node, "aot-prepared");
        }

        @Override
        int getBits() {
            return 1;
        }

        @Override
        public String toString() {
            return "AOTPrepared";
        }

        @Override
        boolean isInlined() {
            return false;
        }
    }

    static final class InlinedNodeState
    extends State<InlineFieldData> {
        private final CacheExpression cache;
        private final SpecializationData excludedSpecialization;

        InlinedNodeState(NodeData node, CacheExpression cache, InlineFieldData key, SpecializationData excludedSpecialization) {
            super(node, key);
            this.excludedSpecialization = excludedSpecialization;
            this.cache = cache;
        }

        @Override
        int getBits() {
            return ((InlineFieldData)this.key).getBits();
        }

        @Override
        SpecializationData getExcludedSpecialization() {
            return this.excludedSpecialization;
        }

        @Override
        public String toString() {
            return String.format("InlinedCache[cache=%s]", ElementUtils.getReadableReference(this.node.getMessageElement(), this.cache.getParameter().getVariableElement()));
        }

        @Override
        void addStateDoc(CodeTreeBuilder docBuilder) {
            docBuilder.string("InlinedCache").newLine();
            FlatNodeGenFactory.addCacheInfo(docBuilder, "       ", this.getDependentSpecialization(), this.cache, (InlineFieldData)this.key);
        }

        @Override
        boolean isInlined() {
            return true;
        }
    }

    static final class EncodedEnumState
    extends State<CacheExpression> {
        private final CacheExpression cache;

        EncodedEnumState(NodeData node, CacheExpression cache) {
            super(node, cache);
            this.cache = cache;
        }

        @Override
        int getBits() {
            List<Element> values = ElementUtils.getEnumValues(ElementUtils.castTypeElement(this.cache.getParameter().getType()));
            int reservedValues = 0;
            reservedValues = this.cache.isNeverDefault() ? 2 : 1;
            int maxValue = values.size() + reservedValues;
            return 32 - Integer.numberOfLeadingZeros(maxValue);
        }

        @Override
        public String toString() {
            return String.format("EncodedEnum[cache=%s]", ElementUtils.getReadableReference(this.node.getMessageElement(), this.cache.getParameter().getVariableElement()));
        }

        @Override
        boolean isInlined() {
            return false;
        }
    }

    static final class ImplicitCastState
    extends State<SpecializationGroup.TypeGuard> {
        ImplicitCastState(NodeData node, SpecializationGroup.TypeGuard key) {
            super(node, key);
        }

        @Override
        int getBits() {
            TypeMirror type = ((SpecializationGroup.TypeGuard)this.key).getType();
            Collection<TypeMirror> sourceTypes = ((SpecializationGroup.TypeGuard)this.key).getTypeSystem().lookupSourceTypes(type);
            if (sourceTypes.size() > 1) {
                return sourceTypes.size();
            }
            throw new AssertionError();
        }

        @Override
        public String toString() {
            return String.format("ImplicitCast[type=%s, index=%s]", ElementUtils.getSimpleName(((SpecializationGroup.TypeGuard)this.key).getType()), ((SpecializationGroup.TypeGuard)this.key).getSignatureIndex());
        }

        @Override
        boolean isInlined() {
            return false;
        }
    }

    static final class GuardActive
    extends State<GuardExpression> {
        private final SpecializationData specialization;

        GuardActive(SpecializationData specialization, GuardExpression key) {
            super(specialization.getNode(), key);
            this.specialization = specialization;
        }

        @Override
        SpecializationData getDependentSpecialization() {
            return this.specialization;
        }

        @Override
        int getBits() {
            return 1;
        }

        @Override
        public String toString() {
            return String.format("GuardActive[specialization=%s, guardIndex=%s]", ElementUtils.getReadableReference(this.node.getMessageElement(), this.specialization.getMethod()), this.getDependentSpecialization().getGuards().indexOf(this.key));
        }

        @Override
        void addStateDoc(CodeTreeBuilder docBuilder) {
            docBuilder.string(String.format("GuardActive[guardIndex=%s] ", this.getDependentSpecialization().getGuards().indexOf(this.key)));
            docBuilder.javadocLink(this.getDependentSpecialization().getMethod(), null);
        }

        @Override
        boolean isInlined() {
            return false;
        }
    }

    static final class SpecializationCachesInitialized
    extends State<SpecializationData> {
        private final SpecializationData specialization;

        SpecializationCachesInitialized(SpecializationData specialization) {
            super(specialization.getNode(), specialization);
            this.specialization = specialization;
        }

        @Override
        int getBits() {
            return 1;
        }

        @Override
        public String toString() {
            return String.format("SpecializationCachesInitialized ", ElementUtils.getReadableReference(this.node.getMessageElement(), ((SpecializationData)this.key).getMethod()));
        }

        @Override
        void addStateDoc(CodeTreeBuilder docBuilder) {
            docBuilder.string("SpecializationCachesInitialized ");
            docBuilder.javadocLink(this.specialization.getMethod(), null);
        }

        @Override
        boolean isInlined() {
            return false;
        }
    }

    static final class SpecializationExcluded
    extends State<SpecializationData> {
        SpecializationExcluded(SpecializationData key) {
            super(key.getNode(), key);
        }

        @Override
        SpecializationData getDependentSpecialization() {
            return (SpecializationData)this.key;
        }

        @Override
        int getBits() {
            return 1;
        }

        @Override
        public String toString() {
            return String.format("SpecializationExcluded ", ElementUtils.getReadableReference(this.node.getMessageElement(), ((SpecializationData)this.key).getMethod()));
        }

        @Override
        void addStateDoc(CodeTreeBuilder docBuilder) {
            docBuilder.string("SpecializationExcluded ");
            docBuilder.javadocLink(this.getDependentSpecialization().getMethod(), null);
        }

        @Override
        boolean isInlined() {
            return false;
        }
    }

    static final class SpecializationActive
    extends State<SpecializationData> {
        SpecializationActive(SpecializationData key) {
            super(key.getNode(), key);
        }

        @Override
        SpecializationData getDependentSpecialization() {
            return (SpecializationData)this.key;
        }

        @Override
        int getBits() {
            return 1;
        }

        @Override
        public String toString() {
            return String.format("SpecializationActive[%s]", ElementUtils.getReadableReference(this.node.getMessageElement(), ((SpecializationData)this.key).getMethod()));
        }

        @Override
        void addStateDoc(CodeTreeBuilder docBuilder) {
            docBuilder.string("SpecializationActive ");
            docBuilder.javadocLink(this.getDependentSpecialization().getMethod(), null);
        }

        @Override
        boolean isInlined() {
            return false;
        }
    }
}

