/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.model.InlinedNodeData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.Parameter;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class CacheExpression
extends MessageContainer {
    private final Parameter sourceParameter;
    private final AnnotationMirror sourceAnnotationMirror;
    private int dimensions = -1;
    private DSLExpression defaultExpression;
    private DSLExpression uncachedExpression;
    private boolean alwaysInitialized;
    private boolean eagerInitialize;
    private MessageContainer.Message uncachedExpressionError;
    private boolean requiresBoundary;
    private boolean mergedLibrary;
    private boolean isWeakReferenceGet;
    private boolean isWeakReference;
    private boolean adopt = true;
    private boolean neverDefault;
    private boolean neverDefaultGuaranteed;
    private InlinedNodeData inlinedNode;
    private LibraryData cachedlibrary;
    private boolean usedInGuard;
    private AnnotationMirror sharedGroupMirror;
    private AnnotationValue sharedGroupValue;
    private String sharedGroup;

    public CacheExpression(Parameter sourceParameter, AnnotationMirror sourceAnnotationMirror) {
        this.sourceParameter = sourceParameter;
        this.sourceAnnotationMirror = sourceAnnotationMirror;
        this.sharedGroupMirror = ElementUtils.findAnnotationMirror((Element)sourceParameter.getVariableElement(), (TypeMirror)this.types.Cached_Shared);
        this.sharedGroupValue = this.sharedGroupMirror != null ? ElementUtils.getAnnotationValue(this.sharedGroupMirror, "value") : null;
        String string = this.sharedGroup = this.sharedGroupMirror != null ? ElementUtils.getAnnotationValue(String.class, this.sharedGroupMirror, "value", false) : null;
        if (this.sharedGroupMirror != null && this.sharedGroup == null) {
            this.sharedGroup = sourceParameter.getVariableElement().getSimpleName().toString();
        }
    }

    public CacheExpression copy() {
        CacheExpression copy = new CacheExpression(this.sourceParameter, this.sourceAnnotationMirror);
        copy.dimensions = this.dimensions;
        copy.defaultExpression = this.defaultExpression;
        copy.uncachedExpression = this.uncachedExpression;
        copy.alwaysInitialized = this.alwaysInitialized;
        copy.eagerInitialize = this.eagerInitialize;
        copy.uncachedExpressionError = this.uncachedExpressionError;
        copy.requiresBoundary = this.requiresBoundary;
        copy.mergedLibrary = this.mergedLibrary;
        copy.isWeakReference = this.isWeakReference;
        copy.isWeakReferenceGet = this.isWeakReferenceGet;
        copy.adopt = this.adopt;
        copy.inlinedNode = this.inlinedNode != null ? this.inlinedNode.copy() : null;
        copy.cachedlibrary = this.cachedlibrary;
        copy.usedInGuard = this.usedInGuard;
        copy.neverDefault = this.neverDefault;
        copy.neverDefaultGuaranteed = this.neverDefaultGuaranteed;
        return copy;
    }

    public void setIsUsedInGuard(boolean b) {
        this.usedInGuard = b;
    }

    public boolean isUsedInGuard() {
        return this.usedInGuard;
    }

    public boolean isNeverDefault() {
        return this.neverDefault;
    }

    public void setNeverDefault(boolean neverDefault) {
        this.neverDefault = neverDefault;
    }

    public boolean isNeverDefaultGuaranteed() {
        return this.neverDefaultGuaranteed;
    }

    public void setNeverDefaultGuaranteed(boolean neverDefault) {
        this.neverDefaultGuaranteed = neverDefault;
    }

    public void setInlinedNode(InlinedNodeData inlinedNode) {
        this.inlinedNode = inlinedNode;
    }

    public InlinedNodeData getInlinedNode() {
        return this.inlinedNode;
    }

    public boolean isEagerInitialize() {
        return this.eagerInitialize;
    }

    public void setEagerInitialize(boolean alreadyInitialized) {
        this.eagerInitialize = alreadyInitialized;
    }

    public void clearSharing() {
        this.sharedGroup = null;
        this.sharedGroupMirror = null;
        this.sharedGroupValue = null;
    }

    public AnnotationMirror getSharedGroupMirror() {
        return this.sharedGroupMirror;
    }

    public boolean isEncodedEnum() {
        if (!this.isCached()) {
            return false;
        }
        return ElementUtils.isAssignable(this.getParameter().getType(), ProcessorContext.getInstance().getType(Enum.class));
    }

    public AnnotationValue getSharedGroupValue() {
        return this.sharedGroupValue;
    }

    public String getSharedGroup() {
        return this.sharedGroup;
    }

    public void setDefaultExpression(DSLExpression expression) {
        this.defaultExpression = expression;
    }

    public void setUncachedExpressionError(MessageContainer.Message message) {
        this.uncachedExpressionError = message;
    }

    public void setUncachedExpression(DSLExpression getUncachedExpression) {
        this.uncachedExpression = getUncachedExpression;
    }

    public MessageContainer.Message getUncachedExpresionError() {
        return this.uncachedExpressionError;
    }

    public DSLExpression getUncachedExpression() {
        return this.uncachedExpression;
    }

    public void setAlwaysInitialized(boolean fastPathCache) {
        this.alwaysInitialized = fastPathCache;
    }

    public boolean isAlwaysInitialized() {
        return this.alwaysInitialized;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Parameter getParameter() {
        return this.sourceParameter;
    }

    public boolean isCached() {
        return this.isType(this.types.Cached);
    }

    public boolean isBind() {
        return this.isType(this.types.Bind);
    }

    public boolean isCachedLibrary() {
        return this.isType(this.types.CachedLibrary);
    }

    public boolean isCachedLibraryManuallyDispatched() {
        return this.isType(this.types.CachedLibrary);
    }

    public String getCachedLibraryExpression() {
        if (!this.isCachedLibrary()) {
            return null;
        }
        return ElementUtils.getAnnotationValue(String.class, this.getMessageAnnotation(), "value", false);
    }

    public String getCachedLibraryLimit() {
        if (!this.isCachedLibrary()) {
            return null;
        }
        return ElementUtils.getAnnotationValue(String.class, this.getMessageAnnotation(), "limit", false);
    }

    private boolean isType(DeclaredType type) {
        return ElementUtils.typeEquals(this.sourceAnnotationMirror.getAnnotationType(), type);
    }

    @Override
    public Element getMessageElement() {
        return this.sourceParameter.getVariableElement();
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.sourceAnnotationMirror;
    }

    public void setRequiresBoundary(boolean requiresBoundary) {
        this.requiresBoundary = requiresBoundary;
    }

    public boolean isRequiresBoundary() {
        return this.requiresBoundary;
    }

    public DSLExpression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setMergedLibrary(boolean mergedLibrary) {
        this.mergedLibrary = mergedLibrary;
    }

    public boolean isMergedLibrary() {
        return this.mergedLibrary;
    }

    public boolean isThisExpression() {
        DSLExpression e = this.getDefaultExpression();
        if (!(e instanceof DSLExpression.Variable)) {
            return false;
        }
        DSLExpression.Variable v = (DSLExpression.Variable)e;
        return v.getResolvedVariable() instanceof CodeVariableElement && v.getResolvedVariable().getSimpleName().toString().equals("this");
    }

    public String getMergedLibraryIdentifier() {
        DSLExpression identifierExpression = this.getDefaultExpression().reduce(new DSLExpression.DSLExpressionReducer(){

            @Override
            public DSLExpression visitVariable(DSLExpression.Variable binary) {
                if (binary.getReceiver() == null) {
                    DSLExpression.Variable var = new DSLExpression.Variable(binary.getReceiver(), "receiver");
                    var.setResolvedTargetType(binary.getResolvedTargetType());
                    var.setResolvedVariable(new CodeVariableElement(binary.getResolvedType(), "receiver"));
                    return var;
                }
                return binary;
            }

            @Override
            public DSLExpression visitNegate(DSLExpression.Negate negate) {
                return negate;
            }

            @Override
            public DSLExpression visitCall(DSLExpression.Call binary) {
                return binary;
            }

            @Override
            public DSLExpression visitBinary(DSLExpression.Binary binary) {
                return binary;
            }
        });
        String expressionText = identifierExpression.asString();
        StringBuilder b = new StringBuilder(expressionText);
        boolean nextUpperCase = false;
        int i = 0;
        while (i < b.length()) {
            char charAt = b.charAt(i);
            if (!Character.isJavaIdentifierPart(charAt)) {
                b.deleteCharAt(i);
                nextUpperCase = true;
                continue;
            }
            if (nextUpperCase) {
                nextUpperCase = false;
                if (i != 0) {
                    b.setCharAt(i, Character.toUpperCase(b.charAt(i)));
                }
                ++i;
                continue;
            }
            ++i;
        }
        String libraryName = ElementUtils.getSimpleName(this.getParameter().getType());
        return b.toString() + libraryName + "_";
    }

    public void setWeakReferenceGet(boolean b) {
        this.isWeakReferenceGet = b;
    }

    public boolean isWeakReferenceGet() {
        return this.isWeakReferenceGet;
    }

    public void setWeakReference(boolean ignoreInUncached) {
        this.isWeakReference = ignoreInUncached;
    }

    public boolean isWeakReference() {
        return this.isWeakReference;
    }

    public boolean isAdopt() {
        return this.adopt;
    }

    public void setAdopt(boolean adopt) {
        this.adopt = adopt;
    }

    public LibraryData getCachedLibrary() {
        return this.cachedlibrary;
    }

    public void setCachedLibrary(LibraryData cachedlibrary) {
        this.cachedlibrary = cachedlibrary;
    }

    public boolean usesDefaultCachedInitializer() {
        return ElementUtils.getAnnotationValue(this.getMessageAnnotation(), "value", false) == null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + Objects.toString(this.sourceParameter) + "]";
    }
}

