/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.util;

import com.oracle.truffle.dsl.processor.util.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Filterator<T>
implements Iterator<T> {
    private final Predicate<T> includePredicate;
    private final Iterator<T> elements;
    private boolean hasCached;
    private T cached;

    public Filterator(Iterator<T> elements, Predicate<T> includePredicate) {
        this.elements = elements;
        this.includePredicate = includePredicate;
    }

    @Override
    public boolean hasNext() {
        if (this.hasCached) {
            return true;
        }
        this.nextValue();
        return this.hasCached;
    }

    private void nextValue() {
        while (!this.hasCached && this.elements.hasNext()) {
            T element = this.elements.next();
            if (!this.includePredicate.evaluate(element)) continue;
            this.cached = element;
            this.hasCached = true;
        }
    }

    @Override
    public T next() {
        T foundCached = this.getCached();
        if (foundCached != null) {
            return foundCached;
        }
        this.nextValue();
        if (!this.hasCached) {
            throw new NoSuchElementException();
        }
        return this.getCached();
    }

    private T getCached() {
        if (this.hasCached) {
            this.hasCached = false;
            T value = this.cached;
            this.cached = null;
            return value;
        }
        return null;
    }

    @Override
    public void remove() {
        this.elements.remove();
    }
}

