/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;

public final class AssumptionExpression
extends MessageContainer {
    private final SpecializationData specialization;
    private final DSLExpression expression;
    private final String id;

    public AssumptionExpression(SpecializationData source, DSLExpression expression, String id) {
        this.specialization = source;
        this.expression = expression;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean needsCaching() {
        return !this.specialization.isCompilationFinalExpression(this.expression);
    }

    @Override
    public Element getMessageElement() {
        return this.specialization.getMessageElement();
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.specialization.getMessageAnnotation();
    }

    @Override
    public AnnotationValue getMessageAnnotationValue() {
        return ElementUtils.getAnnotationValue(this.getMessageAnnotation(), "assumptions");
    }

    public DSLExpression getExpression() {
        return this.expression;
    }
}

