/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.library.ExportMessageData;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryDefaultExportData;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class LibraryParser
extends AbstractParser<LibraryData> {
    @Override
    public boolean isDelegateToRootDeclaredType() {
        return true;
    }

    @Override
    protected LibraryData parse(Element element, List<AnnotationMirror> mirrors) {
        TypeMirror customReceiverType;
        AnnotationMirror invalidAnnotation;
        TypeElement type = (TypeElement)element;
        if (mirrors.isEmpty()) {
            return null;
        }
        AnnotationMirror mirror = mirrors.iterator().next();
        LibraryData model = new LibraryData((TypeElement)element, mirror);
        if (!ElementUtils.typeEquals(type.getSuperclass(), this.types.Library)) {
            model.addError("Declared library classes must exactly extend the type %s.", ElementUtils.getQualifiedName(this.types.Library));
            return model;
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            model.addError("Declared library classes must be abstract.", new Object[0]);
            return model;
        }
        if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            model.addError("Declared inner library classes must be static.", new Object[0]);
            return model;
        }
        AnnotationMirror generateAOT = ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.GenerateAOT);
        if (generateAOT != null) {
            model.setGenerateAOT(true);
        }
        if ((invalidAnnotation = ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.GenerateCached)) == null) {
            invalidAnnotation = ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.GenerateUncached);
        }
        if (invalidAnnotation == null) {
            invalidAnnotation = ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.GenerateInline);
        }
        if (invalidAnnotation != null) {
            model.addError(invalidAnnotation, null, "The annotation @%s cannot be used on a library.", ElementUtils.getSimpleName(invalidAnnotation.getAnnotationType()));
            return model;
        }
        model.setDefaultExportLookupEnabled(ElementUtils.getAnnotationValue(Boolean.class, mirror, "defaultExportLookupEnabled"));
        model.setDynamicDispatchEnabled(ElementUtils.getAnnotationValue(Boolean.class, mirror, "dynamicDispatchEnabled"));
        model.setPushEncapsulatingNode(ElementUtils.getAnnotationValue(Boolean.class, mirror, "pushEncapsulatingNode"));
        boolean defaultExportReachable = true;
        List<AnnotationMirror> defaultExports = ElementUtils.getRepeatedAnnotation(element.getAnnotationMirrors(), this.types.GenerateLibrary_DefaultExport);
        for (AnnotationMirror defaultExport : defaultExports) {
            LibraryDefaultExportData export = this.loadDefaultExportImpl(model, defaultExport, "value");
            if (export == null) continue;
            for (LibraryDefaultExportData libraryDefaultExportData : model.getDefaultExports()) {
                if (!ElementUtils.isAssignable(export.getReceiverType(), libraryDefaultExportData.getReceiverType())) continue;
                model.addError(defaultExport, null, "The receiver type '%s' of the export '%s' is not reachable. It is shadowed by receiver type '%s' of export '%s'.", ElementUtils.getSimpleName(export.getReceiverType()), ElementUtils.getSimpleName(export.getImplType()), ElementUtils.getSimpleName(libraryDefaultExportData.getReceiverType()), ElementUtils.getSimpleName(libraryDefaultExportData.getImplType()));
                break;
            }
            model.getDefaultExports().add(export);
            if (!ElementUtils.isAssignable(this.context.getType(Object.class), export.getReceiverType())) continue;
            defaultExportReachable = false;
        }
        LibraryParser.parseAssertions(element, mirror, type, model);
        List<ExecutableElement> allMethods = ElementFilter.methodsIn(CompilerFactory.getCompiler(type).getEnclosedElementsInDeclarationOrder(type));
        allMethods.add(ElementUtils.findExecutableElement(this.types.Library, "accepts"));
        TypeMirror inferredReceiverType = null;
        LinkedHashMap<String, List<LibraryMessage>> messageByName = new LinkedHashMap<String, List<LibraryMessage>>();
        for (ExecutableElement executableElement : allMethods) {
            Modifier visibility = ElementUtils.getVisibility(executableElement.getModifiers());
            if (visibility == Modifier.PRIVATE || executableElement.getModifiers().contains((Object)Modifier.FINAL) || executableElement.getModifiers().contains((Object)Modifier.STATIC) || model.isDynamicDispatch() && executableElement.getSimpleName().toString().equals("cast")) continue;
            boolean isDeprecated = ElementUtils.isDeprecated(executableElement);
            String messageName = executableElement.getSimpleName().toString();
            LibraryMessage message = new LibraryMessage(model, messageName, executableElement, isDeprecated);
            messageByName.computeIfAbsent(messageName, e -> new ArrayList()).add(message);
            if (visibility == null) {
                message.addError("Library messages must be public or protected. Annotate with @GenerateLibrary.Ignore to ignore this method for generation. ", new Object[0]);
            }
            if (executableElement.getParameters().isEmpty()) {
                message.addError("Not enough arguments specified for a library message. The first argument of a library method must be of type Object. Add a receiver argument with type Object resolve this.If this method is not intended to be a library message then add the private or final modifier to ignore it.", new Object[0]);
                continue;
            }
            TypeMirror methodReceiverType = executableElement.getParameters().get(0).asType();
            if (inferredReceiverType == null) {
                inferredReceiverType = methodReceiverType;
                continue;
            }
            if (ElementUtils.isAssignable(methodReceiverType, inferredReceiverType) || message.getName().equals("accepts")) continue;
            message.addError(String.format("Invalid first argument type %s specified. The first argument of a library method must be of the same type for all methods. If this method is not intended to be a library message then add the private or final modifier to ignore it.", ElementUtils.getSimpleName(methodReceiverType)), new Object[0]);
        }
        block3: for (Map.Entry entry : messageByName.entrySet()) {
            List messages = (List)entry.getValue();
            for (LibraryMessage message : messages) {
                if (!message.isDeprecated() || !message.isAbstract()) continue;
                message.addError("A deprecated message must not be abstract. Deprecated messages need a default implementation.", new Object[0]);
                model.getMethods().add(message);
                continue block3;
            }
            if (messages.size() > 1) {
                ArrayList<LibraryMessage> deprecatedMessages = new ArrayList<LibraryMessage>();
                ArrayList<LibraryMessage> nonDeprecatedMessages = new ArrayList<LibraryMessage>();
                for (LibraryMessage overload : messages) {
                    if (overload.isDeprecated()) {
                        deprecatedMessages.add(overload);
                        continue;
                    }
                    nonDeprecatedMessages.add(overload);
                }
                LibraryMessage primaryMessage = null;
                if (nonDeprecatedMessages.size() > 1) {
                    for (LibraryMessage message : nonDeprecatedMessages) {
                        message.addError("Library message must have a unique name. Two methods with the same name found. If this method is not intended to be a library message then add the private or final modifier to ignore it. Note it is also possible to deprecate all messages except one using the @Deprecated annotation in order to evolve APIs in a compatible way.", new Object[0]);
                    }
                    model.getMethods().addAll(nonDeprecatedMessages);
                    continue;
                }
                if (nonDeprecatedMessages.size() == 1) {
                    primaryMessage = (LibraryMessage)nonDeprecatedMessages.get(0);
                    for (LibraryMessage message : deprecatedMessages) {
                        if (primaryMessage.canBeDeprecatedFrom(message)) continue;
                        message.addError("Could not delegate from this deprecated message to method %s. Method parameters are not compatible.", ElementUtils.getReadableSignature(primaryMessage.getExecutable()));
                        model.getMethods().add(message);
                        continue block3;
                    }
                } else {
                    block8: for (LibraryMessage m1 : deprecatedMessages) {
                        for (LibraryMessage m2 : deprecatedMessages) {
                            if (m1.canBeDeprecatedFrom(m2)) continue;
                            continue block8;
                        }
                        primaryMessage = m1;
                    }
                    if (primaryMessage == null) {
                        for (LibraryMessage message : deprecatedMessages) {
                            message.addError("Could not determine primary overload for all deprecated messages. There must be one library message with the same name that all other messages can delegate to.", new Object[0]);
                        }
                        model.getMethods().addAll(deprecatedMessages);
                        continue;
                    }
                    deprecatedMessages.remove(primaryMessage);
                }
                for (LibraryMessage deprecated : deprecatedMessages) {
                    deprecated.setDeprecatedReplacement(primaryMessage);
                }
                primaryMessage.setDeprecatedOverloads(deprecatedMessages);
                model.getMethods().add(primaryMessage);
                continue;
            }
            model.getMethods().addAll(messages);
        }
        if (!model.hasErrors() && model.getMethods().size() <= 1) {
            model.addError("The library does not export any messages. Use public instance methods to declare library messages.", new Object[0]);
        }
        for (LibraryMessage libraryMessage : model.getMethods()) {
            AnnotationMirror abstractMirror = ElementUtils.findAnnotationMirror((Element)libraryMessage.getExecutable(), (TypeMirror)this.types.GenerateLibrary_Abstract);
            if (abstractMirror == null) continue;
            libraryMessage.setAbstract(true);
            libraryMessage.getAbstractIfExported().addAll(LibraryParser.parseAbstractIfExported(libraryMessage, abstractMirror, "ifExported", messageByName));
            libraryMessage.getAbstractIfExportedAsWarning().addAll(LibraryParser.parseAbstractIfExported(libraryMessage, abstractMirror, "ifExportedAsWarning", messageByName));
        }
        if (inferredReceiverType == null) {
            inferredReceiverType = this.context.getType(Object.class);
        }
        if (!model.hasErrors() && inferredReceiverType.getKind().isPrimitive()) {
            model.addError("Primitive receiver type found. Only reference types are supported.", new Object[0]);
            inferredReceiverType = this.context.getType(Object.class);
        }
        if ((customReceiverType = ElementUtils.getAnnotationValue(TypeMirror.class, mirror, "receiverType", false)) != null) {
            AnnotationValue annotationValue = ElementUtils.getAnnotationValue(mirror, "receiverType");
            if (ElementUtils.typeEquals(customReceiverType, inferredReceiverType)) {
                model.addError(mirror, annotationValue, "Redundant receiver type. This receiver type could be inferred from the method signatures. Remove the explicit receiver type to resolve this redundancy.", new Object[0]);
            }
            if (customReceiverType.getKind() != TypeKind.DECLARED) {
                model.addError(mirror, annotationValue, "Invalid type. Valid declared type expected.", new Object[0]);
            }
            model.setExportsReceiverType(customReceiverType);
        } else {
            model.setExportsReceiverType(inferredReceiverType);
        }
        model.setSignatureReceiverType(inferredReceiverType);
        if (defaultExportReachable) {
            model.getDefaultExports().add(new LibraryDefaultExportData(null, this.context.getType(Object.class)));
            ExportsData exportsData = new ExportsData(this.context, type, mirror);
            ExportsLibrary objectExports = new ExportsLibrary(this.context, type, mirror, exportsData, model, model.getSignatureReceiverType(), true);
            for (LibraryMessage message : objectExports.getLibrary().getMethods()) {
                if (message.getName().equals("accepts")) continue;
                ExportMessageData exportMessage = new ExportMessageData(objectExports, message, null, null);
                objectExports.getExportedMessages().put(message.getName(), exportMessage);
            }
            model.setObjectExports(objectExports);
        }
        for (LibraryMessage message : model.getMethods()) {
            model.getAllMethods().add(message);
            model.getAllMethods().addAll(message.getDeprecatedOverloads());
        }
        return model;
    }

    private static Set<LibraryMessage> parseAbstractIfExported(LibraryMessage message, AnnotationMirror abstractMirror, String ifExportedAttribute, Map<String, List<LibraryMessage>> messages) {
        LinkedHashSet<LibraryMessage> abstractIfExportedMessages = new LinkedHashSet<LibraryMessage>();
        AnnotationValue value = ElementUtils.getAnnotationValue(abstractMirror, ifExportedAttribute);
        List<String> valueList = ElementUtils.getAnnotationValueList(String.class, abstractMirror, ifExportedAttribute);
        for (String ifExported : valueList) {
            LibraryMessage ifExportedMessage;
            List<LibraryMessage> ifExportedMessages = messages.get(ifExported);
            LibraryMessage libraryMessage = ifExportedMessage = ifExportedMessages != null ? ifExportedMessages.get(0) : null;
            if (ifExportedMessage == message) {
                message.addError(abstractMirror, value, "The %s condition links to itself. Remove that condition to resolve this problem.", ifExportedAttribute);
                continue;
            }
            if (ifExportedMessage == null) {
                message.addError(abstractMirror, value, "The %s condition links to an unknown message '%s'. Only valid library messages may be linked.", ifExportedAttribute, ifExported);
                continue;
            }
            abstractIfExportedMessages.add(ifExportedMessage);
        }
        return abstractIfExportedMessages;
    }

    private static void parseAssertions(Element element, AnnotationMirror mirror, TypeElement type, LibraryData model) {
        TypeMirror assertions = ElementUtils.getAnnotationValue(TypeMirror.class, mirror, "assertions", false);
        if (assertions != null) {
            AnnotationValue value = ElementUtils.getAnnotationValue(mirror, "assertions");
            TypeElement assertionsType = ElementUtils.castTypeElement(assertions);
            if (assertionsType.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                model.addError(value, "Assertions type must not be abstract.", new Object[0]);
                return;
            }
            if (!ElementUtils.isVisible(element, assertionsType)) {
                model.addError(value, "Assertions type must be visible.", new Object[0]);
                return;
            }
            if (!ElementUtils.isAssignable(assertions, type.asType())) {
                model.addError(value, "Assertions type must be a subclass of the library type '%s'.", ElementUtils.getSimpleName(model.getTemplateType()));
                return;
            }
            ExecutableElement foundConstructor = null;
            for (ExecutableElement constructor : ElementFilter.constructorsIn(assertionsType.getEnclosedElements())) {
                if (constructor.getParameters().size() != 1 || !ElementUtils.typeEquals(constructor.getParameters().get(0).asType(), model.getTemplateType().asType())) continue;
                foundConstructor = constructor;
                break;
            }
            if (foundConstructor == null) {
                model.addError(value, "No constructor with single delegate parameter of type %s found.", ElementUtils.getSimpleName(model.getTemplateType()));
                return;
            }
            if (!ElementUtils.isVisible(model.getTemplateType(), foundConstructor)) {
                model.addError(value, "Assertions constructor is not visible.", new Object[0]);
                return;
            }
            model.setAssertions(assertions);
        }
    }

    private LibraryDefaultExportData loadDefaultExportImpl(LibraryData model, AnnotationMirror exportAnnotation, String annotationName) {
        TypeMirror type = ElementUtils.getAnnotationValue(TypeMirror.class, exportAnnotation, annotationName);
        AnnotationValue typeValue = ElementUtils.getAnnotationValue(exportAnnotation, annotationName, false);
        if (typeValue == null) {
            return null;
        }
        if (type.getKind() != TypeKind.DECLARED) {
            model.addError(exportAnnotation, typeValue, "The %s type '%s' is invalid.", annotationName, ElementUtils.getSimpleName(type));
            return null;
        }
        List<AnnotationMirror> exportedLibraries = ElementUtils.getRepeatedAnnotation(ElementUtils.castTypeElement(type).getAnnotationMirrors(), this.types.ExportLibrary);
        TypeMirror receiverClass = null;
        for (AnnotationMirror exportedLibrary : exportedLibraries) {
            TypeMirror exportedLib = ElementUtils.getAnnotationValue(TypeMirror.class, exportedLibrary, "value");
            if (!ElementUtils.typeEquals(model.getTemplateType().asType(), exportedLib)) continue;
            receiverClass = ElementUtils.getAnnotationValue(TypeMirror.class, exportedLibrary, "receiverType", false);
            if (receiverClass != null) break;
            model.addError(exportAnnotation, typeValue, "Default export '%s' must specify a receiverType.", ElementUtils.getSimpleName(exportedLib));
            return null;
        }
        if (receiverClass == null) {
            model.addError(exportAnnotation, typeValue, "Default export '%s' does not export a library '%s'.", ElementUtils.getSimpleName(type), ElementUtils.getSimpleName(model.getMessageElement().asType()));
            return null;
        }
        return new LibraryDefaultExportData(type, receiverClass);
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.GenerateLibrary;
    }
}

