/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.transform;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeElementScanner;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class GenerateOverrideVisitor
extends CodeElementScanner<Void, Void> {
    private final DeclaredType overrideType;

    public GenerateOverrideVisitor(DeclaredType overrideType) {
        this.overrideType = overrideType;
    }

    @Override
    public Void visitExecutable(CodeExecutableElement e, Void p) {
        if (!e.getModifiers().contains((Object)Modifier.STATIC) && !e.getModifiers().contains((Object)Modifier.PRIVATE)) {
            String name = e.getSimpleName().toString();
            TypeMirror[] params = e.getParameterTypes();
            for (AnnotationMirror mirror : e.getAnnotationMirrors()) {
                if (!ElementUtils.typeEquals(this.overrideType, mirror.getAnnotationType())) continue;
                return (Void)super.visitExecutable(e, p);
            }
            if (e.getEnclosingClass() != null && ElementUtils.isDeclaredMethodInSuperType(e.getEnclosingClass(), name, params)) {
                e.addAnnotationMirror(new CodeAnnotationMirror(this.overrideType));
            }
        }
        return (Void)super.visitExecutable(e, p);
    }
}

