/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.ImplicitCastParser;
import com.oracle.truffle.dsl.processor.parser.TypeCastParser;
import com.oracle.truffle.dsl.processor.parser.TypeCheckParser;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

public class TypeSystemParser
extends AbstractParser<TypeSystemData> {
    private static final TypeKind[] TYPE_KIND_VALUES = TypeKind.values();

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.TypeSystem;
    }

    private static List<Element> newElementList(List<? extends Element> src) {
        ArrayList<Element> workaround = new ArrayList<Element>(src);
        return workaround;
    }

    @Override
    protected TypeSystemData parse(Element element, List<AnnotationMirror> mirror) {
        TypeElement templateType = (TypeElement)element;
        AnnotationMirror templateTypeAnnotation = mirror.iterator().next();
        TypeSystemData typeSystem = new TypeSystemData(this.context, templateType, templateTypeAnnotation, false);
        if (templateType.getModifiers().contains((Object)Modifier.PRIVATE)) {
            typeSystem.addError("A @%s must have at least package protected visibility.", this.getAnnotationType().asElement().getSimpleName().toString());
        }
        if (templateType.getModifiers().contains((Object)Modifier.FINAL)) {
            typeSystem.addError("The @%s must not be final.", this.getAnnotationType().asElement().getSimpleName().toString());
        }
        if (typeSystem.hasErrors()) {
            return typeSystem;
        }
        if (typeSystem.hasErrors()) {
            return typeSystem;
        }
        TypeSystemParser.verifyExclusiveMethodAnnotation(typeSystem, this.types.TypeCast, this.types.TypeCheck);
        List<Element> elements = TypeSystemParser.newElementList(CompilerFactory.getCompiler(templateType).getAllMembersInDeclarationOrder(this.context.getEnvironment(), templateType));
        List implicitCasts = new ImplicitCastParser(this.context, typeSystem).parse(elements);
        List casts = new TypeCastParser(this.context, typeSystem).parse(elements);
        List checks = new TypeCheckParser(this.context, typeSystem).parse(elements);
        if (casts == null || checks == null || implicitCasts == null) {
            return typeSystem;
        }
        List<TypeMirror> legacyTypes = ElementUtils.getAnnotationValueList(TypeMirror.class, typeSystem.getTemplateTypeAnnotation(), "value");
        for (int i = 0; i < legacyTypes.size(); ++i) {
            legacyTypes.set(i, ElementUtils.fillInGenericWildcards(legacyTypes.get(i)));
        }
        typeSystem.getLegacyTypes().addAll(legacyTypes);
        this.verifyTypes(typeSystem);
        typeSystem.getLegacyTypes().add(this.context.getType(Object.class));
        typeSystem.getLegacyTypes().add(this.context.getType(Void.TYPE));
        TypeSystemParser.verifyNamesUnique(typeSystem);
        typeSystem.getImplicitCasts().addAll(implicitCasts);
        typeSystem.getCasts().addAll(casts);
        typeSystem.getChecks().addAll(checks);
        if (typeSystem.hasErrors()) {
            return typeSystem;
        }
        return typeSystem;
    }

    private static void verifyExclusiveMethodAnnotation(Template template, DeclaredType ... annotationTypes) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(template.getTemplateType().getEnclosedElements());
        for (ExecutableElement method : methods) {
            ArrayList<AnnotationMirror> foundAnnotations = new ArrayList<AnnotationMirror>();
            for (int i = 0; i < annotationTypes.length; ++i) {
                DeclaredType annotationType = annotationTypes[i];
                AnnotationMirror mirror = ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)annotationType);
                if (mirror == null) continue;
                foundAnnotations.add(mirror);
            }
            if (foundAnnotations.size() <= 1) continue;
            ArrayList<CallSite> annotationNames = new ArrayList<CallSite>();
            for (AnnotationMirror mirror : foundAnnotations) {
                annotationNames.add((CallSite)((Object)("@" + ElementUtils.getSimpleName(mirror.getAnnotationType()))));
            }
            template.addError("Non exclusive usage of annotations %s.", annotationNames);
        }
    }

    private void verifyTypes(TypeSystemData typeSystem) {
        for (TypeMirror type : typeSystem.getLegacyTypes()) {
            if (this.isPrimitiveWrapper(type)) {
                typeSystem.addError("Types must not contain primitive wrapper types.", new Object[0]);
            }
            if (!ElementUtils.typeEquals(type, this.context.getType(Object.class))) continue;
            typeSystem.addError("Types must not contain the generic type java.lang.Object.", new Object[0]);
        }
        TypeSystemParser.verifyTypeOrder(typeSystem);
    }

    private static void verifyTypeOrder(TypeSystemData typeSystem) {
        HashMap<String, ArrayList<String>> invalidTypes = new HashMap<String, ArrayList<String>>();
        for (int i = typeSystem.getLegacyTypes().size() - 1; i >= 0; --i) {
            TypeMirror typeData = typeSystem.getLegacyTypes().get(i);
            TypeMirror type = typeSystem.boxType(typeData);
            if (invalidTypes.containsKey(ElementUtils.getQualifiedName(type))) {
                typeSystem.addError("Invalid type order. The type(s) %s are inherited from a earlier defined type %s.", invalidTypes.get(ElementUtils.getQualifiedName(type)), ElementUtils.getQualifiedName(type));
            }
            TypeElement element = ElementUtils.fromTypeMirror(type);
            ArrayList<String> nextInvalidTypes = new ArrayList<String>();
            if (element != null) {
                nextInvalidTypes.addAll(ElementUtils.getQualifiedSuperTypeNames(element));
            }
            nextInvalidTypes.add(ElementUtils.getQualifiedName(type));
            for (String qualifiedName : nextInvalidTypes) {
                ArrayList<String> inheritedTypes = (ArrayList<String>)invalidTypes.get(qualifiedName);
                if (inheritedTypes == null) {
                    inheritedTypes = new ArrayList<String>();
                    invalidTypes.put(qualifiedName, inheritedTypes);
                }
                inheritedTypes.add(ElementUtils.getQualifiedName(typeSystem.boxType(typeData)));
            }
        }
    }

    private boolean isPrimitiveWrapper(TypeMirror type) {
        Types typeUtils = this.context.getEnvironment().getTypeUtils();
        for (TypeKind kind : TYPE_KIND_VALUES) {
            if (!kind.isPrimitive() || !ElementUtils.typeEquals(type, typeUtils.boxedClass(typeUtils.getPrimitiveType(kind)).asType())) continue;
            return true;
        }
        return false;
    }

    private static void verifyNamesUnique(TypeSystemData typeSystem) {
        HashSet<String> usedNames = new HashSet<String>();
        for (TypeMirror type : typeSystem.getLegacyTypes()) {
            String boxedName = ElementUtils.getSimpleName(typeSystem.boxType(type));
            String primitiveName = ElementUtils.getSimpleName(type);
            if (usedNames.contains(boxedName)) {
                typeSystem.addError("Two types result in the same boxed name: %s.", boxedName);
            } else if (usedNames.contains(primitiveName)) {
                typeSystem.addError("Two types result in the same primitive name: %s.", primitiveName);
            }
            usedNames.add(boxedName);
            usedNames.add(primitiveName);
        }
    }
}

