/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class CodeVariableElement
extends CodeElement<Element>
implements VariableElement {
    private Name name;
    private TypeMirror type;
    private Object constantValue;
    private CodeTree init;

    public CodeVariableElement(TypeMirror type, String name) {
        super(ElementUtils.modifiers(new Modifier[0]));
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        this.type = type;
        this.name = CodeNames.of(name);
    }

    public CodeVariableElement(Set<Modifier> modifiers, TypeMirror type, String name) {
        super(modifiers);
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        this.type = type;
        this.name = CodeNames.of(name);
    }

    public CodeTreeBuilder createInitBuilder() {
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        builder.setEnclosingElement(this);
        this.init = builder.getTree();
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CodeVariableElement) {
            CodeVariableElement other = (CodeVariableElement)obj;
            return Objects.equals(this.name, other.name) && ElementUtils.typeEquals(this.type, other.type) && Objects.equals(this.constantValue, other.constantValue) && Objects.equals(this.init, other.init) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, ElementUtils.getTypeId(this.type), this.constantValue, this.init, super.hashCode());
    }

    public void setInit(CodeTree init) {
        this.init = init;
    }

    public CodeTree getInit() {
        return this.init;
    }

    @Override
    public Name getSimpleName() {
        return this.name;
    }

    public TypeMirror getType() {
        return this.type;
    }

    @Override
    public TypeMirror asType() {
        return this.type;
    }

    @Override
    public String toString() {
        return super.toString() + "/* " + ElementUtils.getSimpleName(this.type) + "*/";
    }

    @Override
    public ElementKind getKind() {
        if (this.getEnclosingElement() instanceof ExecutableElement) {
            return ElementKind.PARAMETER;
        }
        if (this.getEnclosingElement() instanceof TypeElement) {
            return ElementKind.FIELD;
        }
        return ElementKind.PARAMETER;
    }

    public void setConstantValue(Object constantValue) {
        this.constantValue = constantValue;
    }

    @Override
    public Object getConstantValue() {
        return this.constantValue;
    }

    public String getName() {
        return this.getSimpleName().toString();
    }

    public void setSimpleName(Name name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = CodeNames.of(name);
    }

    public void setType(TypeMirror type) {
        this.type = type;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitVariable(this, p);
    }

    public static CodeVariableElement clone(VariableElement var) {
        CodeVariableElement copy = new CodeVariableElement(var.getModifiers(), var.asType(), var.getSimpleName().toString());
        copy.setConstantValue(var.getConstantValue());
        for (AnnotationMirror annotationMirror : var.getAnnotationMirrors()) {
            copy.addAnnotationMirror(annotationMirror);
        }
        for (Element element : var.getEnclosedElements()) {
            copy.add(element);
        }
        return copy;
    }
}

