/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.compiler;

import com.oracle.truffle.dsl.processor.java.compiler.AbstractCompiler;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public class JavaCCompiler
extends AbstractCompiler {
    public static boolean isValidElement(Element currentElement) {
        try {
            Class<?> elementClass = Class.forName("com.sun.tools.javac.code.Symbol");
            return elementClass.isAssignableFrom(currentElement.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public List<? extends Element> getAllMembersInDeclarationOrder(ProcessingEnvironment environment, TypeElement type) {
        return environment.getElementUtils().getAllMembers(type);
    }

    @Override
    public List<? extends Element> getEnclosedElementsInDeclarationOrder(TypeElement type) {
        return type.getEnclosedElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean emitDeprecationWarningImpl(ProcessingEnvironment environment, Element element) {
        try {
            Object javacContext = JavaCCompiler.method(environment, "getContext");
            Object elementTreePath = JavaCCompiler.getTreePathForElement(environment, element);
            if (elementTreePath == null) {
                return false;
            }
            Object log = JavaCCompiler.getLog(javacContext);
            Object check = JavaCCompiler.getCheck(javacContext);
            Object file = JavaCCompiler.field(JavaCCompiler.method(elementTreePath, "getCompilationUnit"), "sourcefile");
            Object prev = JavaCCompiler.useSource(log, file);
            try {
                JavaCCompiler.reportProblem(check, elementTreePath, element);
            }
            finally {
                JavaCCompiler.useSource(log, prev);
            }
            return true;
        }
        catch (ReflectiveOperationException reflectiveException) {
            return false;
        }
    }

    private static Object getTreePathForElement(ProcessingEnvironment environment, Element element) throws ReflectiveOperationException {
        Class<?> treesClass = Class.forName("com.sun.source.util.Trees", false, element.getClass().getClassLoader());
        Object trees = JavaCCompiler.staticMethod(treesClass, "instance", new Class[]{ProcessingEnvironment.class}, environment);
        return JavaCCompiler.method(trees, "getPath", new Class[]{Element.class}, element);
    }

    private static Object getLog(Object javacContext) throws ReflectiveOperationException {
        ClassLoader cl = javacContext.getClass().getClassLoader();
        Class<?> logClass = Class.forName("com.sun.tools.javac.util.Log", false, cl);
        Class<?> contextClass = Class.forName("com.sun.tools.javac.util.Context", false, cl);
        return JavaCCompiler.staticMethod(logClass, "instance", new Class[]{contextClass}, javacContext);
    }

    private static Object getCheck(Object javacContext) throws ReflectiveOperationException {
        ClassLoader cl = javacContext.getClass().getClassLoader();
        Class<?> checkClass = Class.forName("com.sun.tools.javac.comp.Check");
        Class<?> contextClass = Class.forName("com.sun.tools.javac.util.Context", false, cl);
        return JavaCCompiler.staticMethod(checkClass, "instance", new Class[]{contextClass}, javacContext);
    }

    private static Object useSource(Object log, Object currentFile) throws ReflectiveOperationException {
        return JavaCCompiler.method(log, "useSource", new Class[]{JavaFileObject.class}, currentFile);
    }

    private static void reportProblem(Object check, Object treePath, Element element) throws ReflectiveOperationException {
        ClassLoader cl = check.getClass().getClassLoader();
        Class<?> diagnosticPositionClass = Class.forName("com.sun.tools.javac.util.JCDiagnostic$DiagnosticPosition", false, cl);
        Class<?> symbolClass = Class.forName("com.sun.tools.javac.code.Symbol", false, cl);
        Object elementTree = JavaCCompiler.method(treePath, "getLeaf");
        JavaCCompiler.method(check, "warnDeprecated", new Class[]{diagnosticPositionClass, symbolClass}, elementTree, element);
    }
}

