/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public final class GuardExpression
extends MessageContainer {
    private static final Set<String> IDENTITY_FOLD_OPERATORS = new HashSet<String>(Arrays.asList("<=", ">=", "=="));
    private final SpecializationData source;
    private final DSLExpression expression;
    private boolean libraryAcceptsGuard;
    private boolean weakReferenceGuard;

    public GuardExpression(SpecializationData source, DSLExpression expression) {
        this.source = source;
        this.expression = expression;
    }

    @Override
    public Element getMessageElement() {
        return this.source.getMessageElement();
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.source.getMessageAnnotation();
    }

    @Override
    public AnnotationValue getMessageAnnotationValue() {
        return ElementUtils.getAnnotationValue(this.getMessageAnnotation(), "guards");
    }

    public DSLExpression getExpression() {
        return this.expression;
    }

    public void setLibraryAcceptsGuard(boolean forceConstantTrueInSlowPath) {
        this.libraryAcceptsGuard = forceConstantTrueInSlowPath;
    }

    public boolean isWeakReferenceGuard() {
        return this.weakReferenceGuard;
    }

    public void setWeakReferenceGuard(boolean weakReferenceGuard) {
        this.weakReferenceGuard = weakReferenceGuard;
    }

    public boolean isLibraryAcceptsGuard() {
        return this.libraryAcceptsGuard;
    }

    public String toString() {
        return "Guard[" + (this.expression != null ? this.expression.asString() : "null") + "]";
    }

    public boolean isConstantTrueInSlowPath(final ProcessorContext context, final boolean uncached) {
        if (this.libraryAcceptsGuard) {
            return true;
        }
        DSLExpression reducedExpression = this.getExpression().reduce(new DSLExpression.AbstractDSLExpressionReducer(){

            @Override
            public DSLExpression visitVariable(DSLExpression.Variable binary) {
                for (CacheExpression cache : GuardExpression.this.source.getCaches()) {
                    if (cache.getSharedGroup() != null || !ElementUtils.variableEquals(cache.getParameter().getVariableElement(), binary.getResolvedVariable())) continue;
                    return uncached ? cache.getUncachedExpression() : cache.getDefaultExpression();
                }
                return super.visitVariable(binary);
            }

            @Override
            public DSLExpression visitCall(DSLExpression.Call binary) {
                ExecutableElement method = binary.getResolvedMethod();
                if (!method.getSimpleName().toString().equals("equals")) {
                    return binary;
                }
                if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                    return binary;
                }
                if (!ElementUtils.typeEquals(method.getReturnType(), context.getType(Boolean.TYPE))) {
                    return binary;
                }
                if (method.getParameters().size() != 1) {
                    return binary;
                }
                DSLExpression receiver = binary.getReceiver();
                DSLExpression firstArg = binary.getParameters().get(0);
                if (receiver instanceof DSLExpression.Variable && firstArg instanceof DSLExpression.Variable && receiver.equals(firstArg)) {
                    return new DSLExpression.BooleanLiteral(true);
                }
                return super.visitCall(binary);
            }

            @Override
            public DSLExpression visitBinary(DSLExpression.Binary binary) {
                DSLExpression.Variable rightVar;
                DSLExpression.Variable leftVar;
                if (IDENTITY_FOLD_OPERATORS.contains(binary.getOperator()) && binary.getLeft() instanceof DSLExpression.Variable && binary.getRight() instanceof DSLExpression.Variable && (leftVar = (DSLExpression.Variable)binary.getLeft()).equals(rightVar = (DSLExpression.Variable)binary.getRight()) && !ElementUtils.typeEquals(leftVar.getResolvedType(), context.getType(Float.TYPE)) && !ElementUtils.typeEquals(leftVar.getResolvedType(), context.getType(Double.TYPE))) {
                    return new DSLExpression.BooleanLiteral(true);
                }
                return super.visitBinary(binary);
            }
        });
        Object o = reducedExpression.resolveConstant();
        return o instanceof Boolean && (Boolean)o != false;
    }

    public boolean equalsNegated(GuardExpression other) {
        boolean negated = false;
        DSLExpression thisExpression = this.expression;
        if (thisExpression instanceof DSLExpression.Negate) {
            negated = true;
            thisExpression = ((DSLExpression.Negate)thisExpression).getReceiver();
        }
        boolean otherNegated = false;
        DSLExpression otherExpression = other.expression;
        if (otherExpression instanceof DSLExpression.Negate) {
            otherNegated = true;
            otherExpression = ((DSLExpression.Negate)otherExpression).getReceiver();
        }
        return Objects.equals(thisExpression, otherExpression) && negated != otherNegated;
    }

    public boolean implies(GuardExpression other) {
        return Objects.equals(this.expression, other.expression);
    }
}

