/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.dsl.processor.model;

import java.util.Locale;

public abstract class NameUtils {
    public static String identifierToConstant(String name) {
        StringBuilder result = new StringBuilder();
        for (int n = 0; n < name.length(); ++n) {
            if (n > 0 && Character.isUpperCase(name.charAt(n))) {
                result.append('_');
            }
            result.append(Character.toUpperCase(name.charAt(n)));
        }
        return result.toString();
    }

    public static String constantToIdentifier(String name) {
        StringBuilder result = new StringBuilder();
        for (int n = 0; n < name.length(); ++n) {
            if (name.charAt(n) == '_') {
                result.append(Character.toUpperCase(name.charAt(++n)));
                continue;
            }
            result.append(Character.toLowerCase(name.charAt(n)));
        }
        return result.toString();
    }

    public static String asGetter(String name) {
        return NameUtils.withPrefix("get", name);
    }

    public static String asSetter(String name) {
        return NameUtils.withPrefix("set", name);
    }

    public static String asCompareAndSet(String name) {
        return NameUtils.withPrefix("compareAndSet", name);
    }

    public static Object asGetAndSet(String name) {
        return NameUtils.withPrefix("getAndSet", name);
    }

    private static String withPrefix(String getSet, String name) {
        return getSet + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static String typeWithoutParameters(String type) {
        return type.replaceAll("<\\w+(\\.\\w+)*>", "");
    }

    public static String titleToCamel(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

