/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.AssumptionExpression;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.GuardExpression;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.SpecializationThrowsData;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class SpecializationData
extends TemplateMethod {
    private final NodeData node;
    private SpecializationKind kind;
    private final List<SpecializationThrowsData> exceptions;
    private final boolean hasUnexpectedResultRewrite;
    private final List<GuardExpression> guards = new ArrayList<GuardExpression>();
    private List<CacheExpression> caches = Collections.emptyList();
    private List<AssumptionExpression> assumptionExpressions = Collections.emptyList();
    private final Set<SpecializationData> replaces = new LinkedHashSet<SpecializationData>();
    private final Set<String> replacesNames = new LinkedHashSet<String>();
    private final Set<SpecializationData> excludedBy = new LinkedHashSet<SpecializationData>();
    private String insertBeforeName;
    private SpecializationData insertBefore;
    private boolean replaced;
    private boolean reachable;
    private boolean reachesFallback;
    private int index;
    private DSLExpression limitExpression;
    private SpecializationData uncachedSpecialization;
    private final boolean reportPolymorphism;
    private final boolean reportMegamorphism;
    private boolean aotReachable;

    public SpecializationData(NodeData node, TemplateMethod template, SpecializationKind kind, List<SpecializationThrowsData> exceptions, boolean hasUnexpectedResultRewrite, boolean reportPolymorphism, boolean reportMegamorphism) {
        super(template);
        this.node = node;
        this.kind = kind;
        this.exceptions = exceptions;
        this.hasUnexpectedResultRewrite = hasUnexpectedResultRewrite;
        this.index = template.getNaturalOrder();
        this.reportPolymorphism = reportPolymorphism;
        this.reportMegamorphism = reportMegamorphism;
    }

    public SpecializationData copy() {
        SpecializationData copy = new SpecializationData(this.node, this, this.kind, new ArrayList<SpecializationThrowsData>(this.exceptions), this.hasUnexpectedResultRewrite, this.reportPolymorphism, this.reportMegamorphism);
        copy.guards.addAll(this.guards);
        copy.caches = new ArrayList<CacheExpression>(this.caches);
        copy.assumptionExpressions = new ArrayList<AssumptionExpression>(this.assumptionExpressions);
        copy.replaced = this.replaced;
        copy.replaces.addAll(this.replaces);
        copy.replacesNames.addAll(this.replacesNames);
        copy.excludedBy.addAll(this.excludedBy);
        copy.insertBeforeName = this.insertBeforeName;
        copy.reachable = this.reachable;
        copy.reachesFallback = this.reachesFallback;
        copy.index = this.index;
        copy.limitExpression = this.limitExpression;
        copy.aotReachable = this.aotReachable;
        return copy;
    }

    public boolean isPrepareForAOT() {
        return this.aotReachable;
    }

    public void setPrepareForAOT(boolean prepareForAOT) {
        this.aotReachable = prepareForAOT;
    }

    public void setUncachedSpecialization(SpecializationData removeCompanion) {
        this.uncachedSpecialization = removeCompanion;
    }

    public SpecializationData getUncachedSpecialization() {
        return this.uncachedSpecialization;
    }

    public boolean needsVirtualFrame() {
        return this.getFrame() != null && ElementUtils.typeEquals(this.getFrame().getType(), this.types.VirtualFrame);
    }

    public boolean needsTruffleBoundary() {
        for (CacheExpression cache : this.caches) {
            if (!cache.isAlwaysInitialized() || !cache.isRequiresBoundary()) continue;
            return true;
        }
        return false;
    }

    public boolean needsPushEncapsulatingNode() {
        for (CacheExpression cache : this.caches) {
            if (!cache.isAlwaysInitialized() || !cache.isRequiresBoundary() || !cache.isCachedLibrary() || !cache.getCachedLibrary().isPushEncapsulatingNode()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyLibraryBoundInGuard() {
        for (CacheExpression cache : this.getCaches()) {
            if (!cache.isCachedLibrary() || !this.isLibraryBoundInGuard(cache)) continue;
            return true;
        }
        return false;
    }

    public boolean isLibraryBoundInGuard(CacheExpression cachedLibrary) {
        if (!cachedLibrary.isCachedLibrary()) {
            return false;
        }
        for (GuardExpression guard : this.getGuards()) {
            if (guard.isLibraryAcceptsGuard()) continue;
            for (CacheExpression cacheExpression : this.getBoundCaches(guard.getExpression(), true)) {
                if (!cacheExpression.getParameter().equals(cachedLibrary.getParameter())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTrivialExpression(DSLExpression expression) {
        Set<ExecutableElement> boundMethod = expression.findBoundExecutableElements();
        ProcessorContext context = ProcessorContext.getInstance();
        for (ExecutableElement method : boundMethod) {
            String name = method.getSimpleName().toString();
            if (name.equals("getClass") && ElementUtils.typeEquals(method.getEnclosingElement().asType(), context.getType(Object.class))) continue;
            return false;
        }
        for (VariableElement variable : expression.findBoundVariableElements()) {
            if (variable.getSimpleName().toString().equals("null")) continue;
            Parameter parameter = this.findByVariable(variable);
            if (parameter == null) {
                return false;
            }
            if (parameter.getSpecification().isCached() || parameter.getSpecification().isSignature()) continue;
            return false;
        }
        return true;
    }

    public void setReachesFallback(boolean reachesFallback) {
        this.reachesFallback = reachesFallback;
    }

    public boolean isReportPolymorphism() {
        return this.reportPolymorphism;
    }

    public boolean isReportMegamorphism() {
        return this.reportMegamorphism;
    }

    public boolean isReachesFallback() {
        return this.reachesFallback;
    }

    public boolean isGuardBoundWithCache(GuardExpression guardExpression) {
        for (CacheExpression cache : this.getBoundCaches(guardExpression.getExpression(), false)) {
            if (cache.isAlwaysInitialized()) continue;
            return true;
        }
        return false;
    }

    public Set<CacheExpression> getBoundCaches(DSLExpression guardExpression, boolean transitiveCached) {
        return this.getBoundCachesImpl(new HashSet<DSLExpression>(), guardExpression, transitiveCached);
    }

    private Set<CacheExpression> getBoundCachesImpl(Set<DSLExpression> visitedExpressions, DSLExpression guardExpression, boolean transitiveCached) {
        List<CacheExpression> resolvedCaches = this.getCaches();
        if (resolvedCaches.isEmpty()) {
            return Collections.emptySet();
        }
        visitedExpressions.add(guardExpression);
        Set<VariableElement> boundVars = guardExpression.findBoundVariableElements();
        LinkedHashSet<CacheExpression> foundCaches = new LinkedHashSet<CacheExpression>();
        for (CacheExpression cache : resolvedCaches) {
            VariableElement cacheVar = cache.getParameter().getVariableElement();
            if (!boundVars.contains(cacheVar)) continue;
            if (cache.getDefaultExpression() != null && !visitedExpressions.contains(cache.getDefaultExpression()) && (transitiveCached || cache.isAlwaysInitialized())) {
                foundCaches.addAll(this.getBoundCachesImpl(visitedExpressions, cache.getDefaultExpression(), transitiveCached));
            }
            foundCaches.add(cache);
        }
        return foundCaches;
    }

    public void setKind(SpecializationKind kind) {
        this.kind = kind;
    }

    public boolean isOnlyLanguageReferencesBound(DSLExpression expression) {
        boolean onlyLanguageReferences = true;
        Set<CacheExpression> boundCaches = this.getBoundCaches(expression, false);
        for (CacheExpression bound : boundCaches) {
            if (bound.isCachedLanguage()) continue;
            onlyLanguageReferences = false;
            break;
        }
        return onlyLanguageReferences && expression.findBoundVariableElements().size() == boundCaches.size();
    }

    public boolean isDynamicParameterBound(DSLExpression expression, boolean transitive) {
        Set<VariableElement> boundVariables = expression.findBoundVariableElements();
        for (Parameter parameter : this.getDynamicParameters()) {
            if (!boundVariables.contains(parameter.getVariableElement())) continue;
            return true;
        }
        FindDynamicBindingVisitor visitor = new FindDynamicBindingVisitor();
        expression.accept(visitor);
        if (visitor.found) {
            return true;
        }
        if (transitive) {
            for (CacheExpression cache : this.getBoundCaches(expression, false)) {
                if (cache.isAlwaysInitialized()) {
                    if (cache.isWeakReferenceGet()) continue;
                    if (this.isDynamicParameterBound(cache.getDefaultExpression(), true)) {
                        return true;
                    }
                }
                if (!cache.isCachedContext() && !cache.isCachedLanguage() || cache.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    public Parameter findByVariable(VariableElement variable) {
        for (Parameter parameter : this.getParameters()) {
            if (!ElementUtils.variableEquals(parameter.getVariableElement(), variable)) continue;
            return parameter;
        }
        return null;
    }

    public DSLExpression getLimitExpression() {
        return this.limitExpression;
    }

    public void setLimitExpression(DSLExpression limitExpression) {
        this.limitExpression = limitExpression;
    }

    public void setInsertBefore(SpecializationData insertBefore) {
        this.insertBefore = insertBefore;
    }

    public void setInsertBeforeName(String insertBeforeName) {
        this.insertBeforeName = insertBeforeName;
    }

    public SpecializationData getInsertBefore() {
        return this.insertBefore;
    }

    public String getInsertBeforeName() {
        return this.insertBeforeName;
    }

    public Set<String> getReplacesNames() {
        return this.replacesNames;
    }

    public SpecializationData(NodeData node, TemplateMethod template, SpecializationKind kind) {
        this(node, template, kind, new ArrayList<SpecializationThrowsData>(), false, true, false);
    }

    public Set<SpecializationData> getReplaces() {
        return this.replaces;
    }

    public Set<SpecializationData> getExcludedBy() {
        return this.excludedBy;
    }

    public void setReachable(boolean reachable) {
        this.reachable = reachable;
    }

    public void setReplaced(boolean replaced) {
        this.replaced = replaced;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        ArrayList<MessageContainer> sinks = new ArrayList<MessageContainer>();
        if (this.exceptions != null) {
            sinks.addAll(this.exceptions);
        }
        if (this.guards != null) {
            sinks.addAll(this.guards);
        }
        if (this.caches != null) {
            sinks.addAll(this.caches);
        }
        if (this.assumptionExpressions != null) {
            sinks.addAll(this.assumptionExpressions);
        }
        return sinks;
    }

    public boolean needsRewrite(ProcessorContext context) {
        if (!this.getExceptions().isEmpty()) {
            return true;
        }
        if (!this.getGuards().isEmpty()) {
            return true;
        }
        if (!this.getAssumptionExpressions().isEmpty()) {
            return true;
        }
        if (!this.getCaches().isEmpty()) {
            for (CacheExpression cache : this.getCaches()) {
                if (cache.isEagerInitialize() || cache.isAlwaysInitialized()) continue;
                return true;
            }
        }
        int signatureIndex = 0;
        for (Parameter parameter : this.getSignatureParameters()) {
            for (ExecutableTypeData executableType : this.node.getExecutableTypes()) {
                TypeMirror evaluatedParameterType;
                List<TypeMirror> evaluatedParameters = executableType.getEvaluatedParameters();
                if (signatureIndex >= evaluatedParameters.size() || !ElementUtils.needsCastTo(evaluatedParameterType = evaluatedParameters.get(signatureIndex), parameter.getType())) continue;
                return true;
            }
            NodeChildData child = parameter.getSpecification().getExecution().getChild();
            if (child != null) {
                ExecutableTypeData type = child.findExecutableType(parameter.getType());
                if (type == null) {
                    type = child.findAnyGenericExecutableType(context);
                }
                if (type.hasUnexpectedValue()) {
                    return true;
                }
                if (ElementUtils.needsCastTo(type.getReturnType(), parameter.getType())) {
                    return true;
                }
            }
            ++signatureIndex;
        }
        return false;
    }

    @Override
    public int compareTo(TemplateMethod other) {
        if (this == other) {
            return 0;
        }
        if (!(other instanceof SpecializationData)) {
            return super.compareTo(other);
        }
        SpecializationData m2 = (SpecializationData)other;
        int kindOrder = this.kind.compareTo(m2.kind);
        if (kindOrder != 0) {
            return kindOrder;
        }
        int compare = 0;
        int order1 = this.index;
        int order2 = m2.index;
        if (order1 != -1 && order2 != -1 && (compare = Integer.compare(order1, order2)) != 0) {
            return compare;
        }
        return super.compareTo(other);
    }

    public void setIndex(int order) {
        this.index = order;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIntrospectionIndex() {
        if (this.getMethod() == null) {
            return -1;
        }
        return this.index;
    }

    public NodeData getNode() {
        return this.node;
    }

    public boolean isSpecialized() {
        return this.kind == SpecializationKind.SPECIALIZED;
    }

    public boolean isFallback() {
        return this.kind == SpecializationKind.FALLBACK;
    }

    public List<SpecializationThrowsData> getExceptions() {
        return this.exceptions;
    }

    public boolean hasUnexpectedResultRewrite() {
        return this.hasUnexpectedResultRewrite;
    }

    public List<GuardExpression> getGuards() {
        return this.guards;
    }

    public SpecializationData findNextSpecialization() {
        List<SpecializationData> specializations = this.node.getSpecializations();
        for (int i = 0; i < specializations.size() - 1; ++i) {
            if (specializations.get(i) != this) continue;
            return specializations.get(i + 1);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("%s [id = %s, method = %s, guards = %s, signature = %s]", this.getClass().getSimpleName(), this.getId(), this.getMethod(), this.getGuards(), this.getDynamicTypes());
    }

    public boolean isFrameUsedByGuard() {
        Parameter frame = this.getFrame();
        if (frame != null) {
            for (GuardExpression guard : this.getGuards()) {
                if (!guard.getExpression().findBoundVariableElements().contains(frame.getVariableElement())) continue;
                return true;
            }
            for (CacheExpression cache : this.getCaches()) {
                if (!cache.getDefaultExpression().findBoundVariableElements().contains(frame.getVariableElement())) continue;
                return true;
            }
        }
        return false;
    }

    public List<CacheExpression> getCaches() {
        return this.caches;
    }

    public void setCaches(List<CacheExpression> caches) {
        this.caches = caches;
    }

    public void setAssumptionExpressions(List<AssumptionExpression> assumptionExpressions) {
        this.assumptionExpressions = assumptionExpressions;
    }

    public List<AssumptionExpression> getAssumptionExpressions() {
        return this.assumptionExpressions;
    }

    public boolean hasMultipleInstances() {
        return this.getMaximumNumberOfInstances() > 1;
    }

    public boolean isExpressionBindsCache(DSLExpression expression, CacheExpression cache) {
        for (CacheExpression otherCache : this.getBoundCaches(expression, true)) {
            if (otherCache != cache) continue;
            return true;
        }
        return false;
    }

    public boolean isGuardBindsCache() {
        if (!this.getCaches().isEmpty() && !this.getGuards().isEmpty()) {
            for (GuardExpression guard : this.getGuards()) {
                if (guard.hasErrors() || !this.isDynamicParameterBound(guard.getExpression(), true) || !this.isCacheParameterBound(guard)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCacheParameterBound(GuardExpression guard) {
        for (CacheExpression cache : this.getBoundCaches(guard.getExpression(), false)) {
            if (cache.isAlwaysInitialized() || !guard.isLibraryAcceptsGuard() && cache.isCachedLibrary() || guard.isWeakReferenceGuard() && cache.isWeakReference()) continue;
            return true;
        }
        return false;
    }

    public boolean isConstantLimit() {
        if (this.isGuardBindsCache()) {
            DSLExpression expression = this.getLimitExpression();
            if (expression == null) {
                return true;
            }
            Object constant = expression.resolveConstant();
            return constant != null && constant instanceof Integer;
        }
        return true;
    }

    public int getMaximumNumberOfInstances() {
        if (this.isGuardBindsCache()) {
            DSLExpression expression = this.getLimitExpression();
            if (expression == null) {
                return 3;
            }
            Object constant = expression.resolveConstant();
            if (constant != null && constant instanceof Integer) {
                return (Integer)constant;
            }
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    public boolean isReachableAfter(SpecializationData prev) {
        if (!prev.isSpecialized()) {
            return true;
        }
        if (!prev.getExceptions().isEmpty()) {
            return true;
        }
        if (prev.isGuardBindsCache()) {
            return true;
        }
        if (this.node.isGenerateUncached() && !this.isReplaced() && prev.isReplaced()) {
            return true;
        }
        for (CacheExpression cache : prev.getCaches()) {
            if (!cache.isCachedLibrary() || !this.getReplaces().contains(prev)) continue;
            return true;
        }
        Iterator<Parameter> currentSignature = this.getSignatureParameters().iterator();
        Iterator<Parameter> prevSignature = prev.getSignatureParameters().iterator();
        TypeSystemData typeSystem = prev.getNode().getTypeSystem();
        while (currentSignature.hasNext() && prevSignature.hasNext()) {
            TypeMirror prevType;
            TypeMirror currentType = currentSignature.next().getType();
            if (typeSystem.isImplicitSubtypeOf(currentType, prevType = prevSignature.next().getType())) continue;
            return true;
        }
        if (!prev.getAssumptionExpressions().isEmpty()) {
            return true;
        }
        Iterator<GuardExpression> prevGuards = prev.getGuards().iterator();
        Iterator<GuardExpression> currentGuards = this.getGuards().iterator();
        while (prevGuards.hasNext()) {
            GuardExpression currentGuard;
            GuardExpression prevGuard = prevGuards.next();
            GuardExpression guardExpression = currentGuard = currentGuards.hasNext() ? currentGuards.next() : null;
            if (currentGuard != null && currentGuard.implies(prevGuard)) continue;
            return true;
        }
        return false;
    }

    public CacheExpression findCache(Parameter resolvedParameter) {
        for (CacheExpression cache : this.getCaches()) {
            if (!cache.getParameter().equals(resolvedParameter)) continue;
            return cache;
        }
        return null;
    }

    static final class FindDynamicBindingVisitor
    extends DSLExpression.AbstractDSLExpressionVisitor {
        boolean found;
        final String[] resultValues;

        FindDynamicBindingVisitor() {
            this.resultValues = new String[]{"get", ((TypeElement)ProcessorContext.getInstance().getTypes().TruffleLanguage_ContextReference.asElement()).getQualifiedName().toString(), "get", ((TypeElement)ProcessorContext.getInstance().getTypes().TruffleLanguage_LanguageReference.asElement()).getQualifiedName().toString(), "get", ProcessorContext.getInstance().getTypeElement(Reference.class).getQualifiedName().toString()};
        }

        @Override
        public void visitCall(DSLExpression.Call binary) {
            ExecutableElement method = binary.getResolvedMethod();
            String methodName = method.getSimpleName().toString();
            Element enclosingElement = method.getEnclosingElement();
            if (enclosingElement == null || !enclosingElement.getKind().isClass()) {
                return;
            }
            String className = ((TypeElement)enclosingElement).getQualifiedName().toString();
            for (int i = 0; i < this.resultValues.length; i += 2) {
                String searchMethod = this.resultValues[i];
                String searchClass = this.resultValues[i + 1];
                if (!searchMethod.equals(methodName) || !className.equals(searchClass)) continue;
                this.found = true;
                break;
            }
        }
    }

    public static enum SpecializationKind {
        SPECIALIZED,
        FALLBACK;

    }
}

