/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class Parameter {
    private final ParameterSpec specification;
    private String localName;
    private final int specificationVarArgsIndex;
    private final int typeVarArgsIndex;
    private final VariableElement variableElement;
    private final TypeMirror type;

    public Parameter(ParameterSpec specification, VariableElement variableElement, int specificationVarArgsIndex, int typeVarArgsIndex) {
        this.specification = specification;
        this.variableElement = variableElement;
        this.type = variableElement.asType();
        this.specificationVarArgsIndex = specificationVarArgsIndex;
        String valueName = specification.getName() + "Value";
        if (specificationVarArgsIndex > -1) {
            valueName = valueName + specificationVarArgsIndex;
        }
        this.typeVarArgsIndex = typeVarArgsIndex;
        this.localName = valueName;
    }

    public Parameter(Parameter parameter) {
        this.specification = parameter.specification;
        this.specificationVarArgsIndex = parameter.specificationVarArgsIndex;
        this.localName = parameter.localName;
        this.typeVarArgsIndex = parameter.typeVarArgsIndex;
        this.variableElement = parameter.variableElement;
        this.type = parameter.type;
    }

    public Parameter(Parameter parameter, TypeMirror newType) {
        this.specification = parameter.specification;
        this.specificationVarArgsIndex = parameter.specificationVarArgsIndex;
        this.localName = parameter.localName;
        this.typeVarArgsIndex = parameter.typeVarArgsIndex;
        this.variableElement = parameter.variableElement;
        this.type = newType;
    }

    public Parameter(Parameter parameter, VariableElement newVariable) {
        this.specification = parameter.specification;
        this.specificationVarArgsIndex = parameter.specificationVarArgsIndex;
        this.localName = newVariable.getSimpleName().toString();
        this.typeVarArgsIndex = parameter.typeVarArgsIndex;
        this.variableElement = newVariable;
        this.type = newVariable.asType();
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public VariableElement getVariableElement() {
        return this.variableElement;
    }

    public int getTypeVarArgsIndex() {
        return this.typeVarArgsIndex;
    }

    public int getSpecificationVarArgsIndex() {
        return this.specificationVarArgsIndex;
    }

    public String getLocalName() {
        return this.localName;
    }

    public ParameterSpec getSpecification() {
        return this.specification;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public boolean isTypeVarArgs() {
        return this.typeVarArgsIndex >= 0;
    }

    public String toString() {
        return "Parameter [localName=" + this.localName + ", type=" + this.getType() + ", variableElement=" + this.variableElement + "]";
    }
}

