/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.parser.SpecializationGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.TypeMirror;

class BitSet {
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private final int capacity;
    private final String name;
    private final Map<Object, Integer> offsets = new HashMap<Object, Integer>();
    private final Object[] objects;
    private final long allMask;
    private final TypeMirror type;

    BitSet(String name, Object[] objects) {
        this.name = name;
        this.objects = objects;
        this.capacity = this.intializeCapacity();
        if (this.capacity <= 32) {
            this.type = ProcessorContext.getInstance().getType(Integer.TYPE);
        } else if (this.capacity <= 64) {
            this.type = ProcessorContext.getInstance().getType(Long.TYPE);
        } else {
            throw new UnsupportedOperationException("State space too big " + this.capacity + ". Only <= 64 supported.");
        }
        this.allMask = this.createMask(objects);
    }

    private int intializeCapacity() {
        if (this.objects.length == 0) {
            return 0;
        }
        int bitIndex = 0;
        for (Object o : this.objects) {
            int size = this.calculateRequiredBits(o);
            this.offsets.put(o, bitIndex);
            bitIndex += size;
        }
        return bitIndex;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    protected int calculateRequiredBits(Object object) {
        return 1;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public final boolean contains(Object element) {
        return this.offsets.containsKey(element);
    }

    private CodeTree createLocalReference(FlatNodeGenFactory.FrameState frameState) {
        FlatNodeGenFactory.LocalVariable var;
        FlatNodeGenFactory.LocalVariable localVariable = var = frameState != null ? frameState.get(this.getName()) : null;
        if (var != null) {
            return var.createReference();
        }
        return null;
    }

    public CodeTree createReference(FlatNodeGenFactory.FrameState frameState) {
        CodeTree ref = this.createLocalReference(frameState);
        if (ref == null) {
            ref = CodeTreeBuilder.createBuilder().string("this.", this.getName(), "_").build();
        }
        return ref;
    }

    public final Object[] filter(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return elements;
        }
        ArrayList<Object> includedElements = null;
        for (int i = 0; i < elements.length; ++i) {
            if (!this.contains(elements[i])) continue;
            if (includedElements == null) {
                includedElements = new ArrayList<Object>();
            }
            includedElements.add(elements[i]);
        }
        if (includedElements == null || includedElements.isEmpty()) {
            return EMPTY_OBJECTS;
        }
        if (includedElements.size() == elements.length) {
            return elements;
        }
        return includedElements.toArray();
    }

    public CodeTree createLoad(FlatNodeGenFactory.FrameState frameState) {
        if (frameState.get(this.name) != null) {
            return CodeTreeBuilder.singleString("");
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String fieldName = this.name + "_";
        FlatNodeGenFactory.LocalVariable var = new FlatNodeGenFactory.LocalVariable(this.type, this.name, null);
        CodeTreeBuilder init = builder.create();
        init.string("this.").tree(CodeTreeBuilder.singleString(fieldName));
        builder.tree(var.createDeclaration(init.build()));
        frameState.set(this.name, var);
        return builder.build();
    }

    public CodeTree createContainsOnly(FlatNodeGenFactory.FrameState frameState, int offset, int length, Object[] selectedElements, Object[] allElements) {
        long mask = (this.createMask(offset, length, selectedElements) ^ 0xFFFFFFFFFFFFFFFFL) & this.createMask(allElements);
        if (mask == 0L) {
            return null;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, mask));
        builder.string(" == 0");
        builder.string(" /* only-active ", BitSet.toString(selectedElements, " && "), " */");
        return builder.build();
    }

    public CodeTree createContainsAny(FlatNodeGenFactory.FrameState frameState, Object[] selectedElements, Object[] allElements) {
        long mask = this.createMask(allElements);
        if (mask == 0L) {
            return null;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, mask));
        builder.string(" != 0");
        builder.string(" /* contains-any ", BitSet.toString(selectedElements, " && "), " */");
        return builder.build();
    }

    public CodeTree createIs(FlatNodeGenFactory.FrameState frameState, Object[] selectedElements, Object[] maskedElements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, maskedElements));
        builder.string(" == ").string(this.formatMask(this.createMask(selectedElements)));
        return builder.build();
    }

    private CodeTree createMaskedReference(FlatNodeGenFactory.FrameState frameState, long maskedElements) {
        if (maskedElements == this.allMask) {
            return this.createReference(frameState);
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.string("(").tree(this.createReference(frameState)).string(" & ").string(this.formatMask(maskedElements)).string(")");
        return builder.build();
    }

    public CodeTree createMaskedReference(FlatNodeGenFactory.FrameState frameState, Object[] maskedElements) {
        return this.createMaskedReference(frameState, this.createMask(maskedElements));
    }

    public CodeTree createIsNotAny(FlatNodeGenFactory.FrameState frameState, Object[] elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, elements));
        builder.string(" != 0 ");
        builder.string(" /* is-not ", BitSet.toString(elements, " && "), " */");
        return builder.build();
    }

    public String formatMask(long mask) {
        if (mask == 0L) {
            return "0";
        }
        int bitsUsed = 64 - Long.numberOfLeadingZeros(mask);
        if (bitsUsed <= 16) {
            return "0b" + Integer.toBinaryString((int)mask);
        }
        if (this.capacity <= 32) {
            return "0x" + Integer.toHexString((int)mask);
        }
        return "0x" + Long.toHexString(mask) + "L";
    }

    public CodeTree createIsOneBitOf(FlatNodeGenFactory.FrameState frameState, Object[] elements) {
        CodeTree masked = this.createMaskedReference(frameState, elements);
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startParantheses().tree(masked).string(" & ").startParantheses().tree(masked).string(" - 1").end().end().string(" == 0");
        builder.string(" /* ", this.label("is-single"), " */");
        return builder.build();
    }

    public CodeTree createContains(FlatNodeGenFactory.FrameState frameState, Object ... elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, elements));
        builder.string(" != 0");
        builder.string(" /* ", this.label("is"), BitSet.toString(elements, " || "), " */");
        return builder.build();
    }

    private static String toString(Object[] elements, String elementSep) {
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (int i = 0; i < elements.length; ++i) {
            b.append(sep).append(BitSet.toString(elements[i]));
            sep = elementSep;
        }
        return b.toString();
    }

    private static String toString(Object element) {
        if (element instanceof SpecializationData) {
            SpecializationData specialization = (SpecializationData)element;
            return ElementUtils.createReferenceName(specialization.getMethod());
        }
        if (element instanceof SpecializationGroup.TypeGuard) {
            int index = ((SpecializationGroup.TypeGuard)element).getSignatureIndex();
            String simpleName = ElementUtils.getSimpleName(((SpecializationGroup.TypeGuard)element).getType());
            return index + ":" + simpleName;
        }
        return element.toString();
    }

    public CodeTree createNotContains(FlatNodeGenFactory.FrameState frameState, Object ... elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startParantheses();
        builder.tree(this.createMaskedReference(frameState, elements));
        builder.end();
        builder.string(" == 0");
        builder.string(" /* ", this.label("is-not"), BitSet.toString(elements, " && "), " */");
        return builder.build();
    }

    private String label(String message) {
        return message + "-" + this.getName() + " ";
    }

    public String getName() {
        return this.name;
    }

    public CodeTree createExtractInteger(FlatNodeGenFactory.FrameState frameState, Object element) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        if (this.capacity > 32) {
            builder.string("(int)(");
        }
        builder.tree(this.createMaskedReference(frameState, this.createMask(element)));
        builder.string(" >>> ", Integer.toString(this.getStateOffset(element)));
        if (this.capacity > 32) {
            builder.string(")");
        }
        builder.string(" /* ", this.label("extract-implicit"), BitSet.toString(element), " */");
        return builder.build();
    }

    public CodeTree createSetZero(FlatNodeGenFactory.FrameState frameState, boolean persist) {
        return this.createSet(frameState, persist, CodeTreeBuilder.singleString("0"), false);
    }

    public CodeTree createSet(FlatNodeGenFactory.FrameState frameState, Object[] elements, boolean value, boolean persist) {
        boolean hasLocal;
        CodeTreeBuilder valueBuilder = CodeTreeBuilder.createBuilder();
        boolean bl = hasLocal = this.createLocalReference(frameState) != null;
        if (!hasLocal && elements.length == 0) {
            return valueBuilder.build();
        }
        valueBuilder.tree(this.createReference(frameState));
        if (elements.length > 0) {
            if (value) {
                valueBuilder.string(" | ");
                valueBuilder.string(this.formatMask(this.createMask(elements)));
                valueBuilder.string(" /* ", this.label("add"), BitSet.toString(elements, ", "), " */");
            } else {
                valueBuilder.string(" & ");
                valueBuilder.string(this.formatMask(this.createMask(elements) ^ 0xFFFFFFFFFFFFFFFFL));
                valueBuilder.string(" /* ", this.label("remove"), BitSet.toString(elements, ", "), " */");
            }
        }
        return this.createSet(frameState, persist, valueBuilder.build(), elements.length > 0);
    }

    private CodeTree createSet(FlatNodeGenFactory.FrameState frameState, boolean persist, CodeTree valueTree, boolean update) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startStatement();
        if (persist) {
            builder.string("this.", this.name, "_ = ");
            CodeTree localReference = this.createLocalReference(frameState);
            if (localReference != null && update) {
                builder.tree(localReference).string(" = ");
            }
        } else {
            builder.tree(this.createReference(frameState)).string(" = ");
        }
        builder.tree(valueTree);
        builder.end();
        return builder.build();
    }

    public CodeTree createSetInteger(FlatNodeGenFactory.FrameState frameState, Object element, CodeTree value) {
        int offset = this.getStateOffset(element);
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startStatement();
        builder.tree(this.createReference(frameState)).string(" = ");
        builder.startParantheses();
        builder.tree(this.createReference(frameState));
        builder.string(" | (");
        if (this.capacity > 32) {
            builder.string("(long) ");
        }
        builder.tree(value).string(" << ", Integer.toString(offset), ")");
        builder.string(" /* ", this.label("set-implicit"), BitSet.toString(element), " */");
        builder.end();
        builder.end();
        return builder.build();
    }

    private long createMask(Object e) {
        return this.createMask(new Object[]{e});
    }

    public long createMask(Object[] e) {
        return this.createMask(0, -1, e);
    }

    private long createMask(int offset, int length, Object[] e) {
        long mask = 0L;
        for (Object element : e) {
            if (!this.offsets.containsKey(element)) continue;
            int stateOffset = this.getStateOffset(element);
            int stateLength = this.calculateRequiredBits(element);
            int realLength = length < 0 ? stateLength : Math.min(stateLength, offset + length);
            for (int i = offset; i < realLength; ++i) {
                mask |= 1L << stateOffset + i;
            }
        }
        return mask;
    }

    private int getStateOffset(Object object) {
        Integer value = this.offsets.get(object);
        if (value == null) {
            return 0;
        }
        return value;
    }
}

