// CheckStyle: start generated
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.bytecode.DefaultBytecodeScope.IsMemberModifiable;
import com.oracle.truffle.api.bytecode.DefaultBytecodeScope.IsMemberReadable;
import com.oracle.truffle.api.bytecode.DefaultBytecodeScope.NameToIndexCache;
import com.oracle.truffle.api.bytecode.DefaultBytecodeScope.ReadMember;
import com.oracle.truffle.api.bytecode.DefaultBytecodeScope.WriteMember;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

@GeneratedBy(DefaultBytecodeScope.class)
@SuppressWarnings("javadoc")
final class DefaultBytecodeScopeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(DefaultBytecodeScope.class, new InteropLibraryExports());
    }

    private DefaultBytecodeScopeGen() {
    }

    @GeneratedBy(DefaultBytecodeScope.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, DefaultBytecodeScope.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof DefaultBytecodeScope;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof DefaultBytecodeScope;
            return new Cached(receiver);
        }

        @GeneratedBy(DefaultBytecodeScope.class)
        private static final class Cached extends InteropLibrary {

            static final ReferenceField<ReadMemberCachedData> READ_MEMBER_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "readMember_cached_cache", ReadMemberCachedData.class);
            static final ReferenceField<IsMemberReadableCachedData> IS_MEMBER_READABLE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberReadable_cached_cache", IsMemberReadableCachedData.class);
            static final ReferenceField<IsMemberModifiableCachedData> IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberModifiable_cached_cache", IsMemberModifiableCachedData.class);
            static final ReferenceField<WriteMemberCachedData> WRITE_MEMBER_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeMember_cached_cache", WriteMemberCachedData.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReadMember#doCached}
             *   1: SpecializationActive {@link ReadMember#doGeneric}
             *   2: SpecializationActive {@link IsMemberReadable#doCached}
             *   3: SpecializationActive {@link IsMemberReadable#doGeneric}
             *   4: SpecializationActive {@link IsMemberModifiable#doCached}
             *   5: SpecializationActive {@link IsMemberModifiable#doGeneric}
             *   6: SpecializationActive {@link WriteMember#doCached}
             *   7: SpecializationActive {@link WriteMember#doGeneric}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadMember#doCached}
             *   Parameter: {@link BytecodeNode} cachedBytecode</pre> */
            @CompilationFinal private BytecodeNode cachedBytecode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadMember#doCached}
             *   Parameter: int cachedBci</pre> */
            @CompilationFinal private int cachedBci;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadMember#doCached}
             *   Parameter: {@link NameToIndexCache} cache</pre> */
            @CompilationFinal private NameToIndexCache cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DefaultBytecodeScope#accepts}
             *   Parameter: {@link TagTreeNode} cachedNode</pre> */
            @CompilationFinal private TagTreeNode cachedNode;
            @UnsafeAccessedField @CompilationFinal private ReadMemberCachedData readMember_cached_cache;
            @UnsafeAccessedField @CompilationFinal private IsMemberReadableCachedData isMemberReadable_cached_cache;
            @UnsafeAccessedField @CompilationFinal private IsMemberModifiableCachedData isMemberModifiable_cached_cache;
            @UnsafeAccessedField @CompilationFinal private WriteMemberCachedData writeMember_cached_cache;

            protected Cached(Object receiver) {
                DefaultBytecodeScope castReceiver = ((DefaultBytecodeScope) receiver) ;
                BytecodeNode cachedBytecode_ = (castReceiver.bytecode);
                VarHandle.storeStoreFence();
                this.cachedBytecode = cachedBytecode_;
                TagTreeNode cachedNode_ = (castReceiver.node);
                VarHandle.storeStoreFence();
                this.cachedNode = cachedNode_;
                int cachedBci_ = (castReceiver.bci);
                this.cachedBci = cachedBci_;
                NameToIndexCache cache_ = (castReceiver.getCache());
                VarHandle.storeStoreFence();
                this.cache = cache_;
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof DefaultBytecodeScope) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof DefaultBytecodeScope && accepts_(receiver);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadMember#doCached}
             *     Activation probability: 0.10833
             *     With/without class size: 6/8 bytes
             *   Specialization {@link ReadMember#doGeneric}
             *     Activation probability: 0.05833
             *     With/without class size: 4/0 bytes
             * </pre> */
            @ExplodeLoop
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[DefaultBytecodeScope.ReadMember.doCached(DefaultBytecodeScope, String, BytecodeNode, int, NameToIndexCache, String, int)] || SpecializationActive[DefaultBytecodeScope.ReadMember.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[DefaultBytecodeScope.ReadMember.doCached(DefaultBytecodeScope, String, BytecodeNode, int, NameToIndexCache, String, int)] */) {
                        ReadMemberCachedData s0_ = this.readMember_cached_cache;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                return ReadMember.doCached(arg0Value, arg1Value, this.cachedBytecode, this.cachedBci, this.cache, s0_.cachedMember_, s0_.index_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[DefaultBytecodeScope.ReadMember.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                        return ReadMember.doGeneric(arg0Value, arg1Value, this.cache);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberAndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberAndSpecialize(DefaultBytecodeScope arg0Value, String arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[DefaultBytecodeScope.ReadMember.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                    while (true) {
                        int count0_ = 0;
                        ReadMemberCachedData s0_ = READ_MEMBER_CACHED_CACHE_UPDATER.getVolatile(this);
                        ReadMemberCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                String cachedMember__ = (arg1Value);
                                if ((DefaultBytecodeScope.equalsString(cachedMember__, arg1Value)) && count0_ < (5)) {
                                    s0_ = new ReadMemberCachedData(s0_original);
                                    s0_.cachedMember_ = cachedMember__;
                                    s0_.index_ = (this.cache.slotToIndex(arg0Value, cachedMember__));
                                    if (!READ_MEMBER_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[DefaultBytecodeScope.ReadMember.doCached(DefaultBytecodeScope, String, BytecodeNode, int, NameToIndexCache, String, int)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return ReadMember.doCached(arg0Value, arg1Value, this.cachedBytecode, this.cachedBci, this.cache, s0_.cachedMember_, s0_.index_);
                        }
                        break;
                    }
                }
                this.readMember_cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[DefaultBytecodeScope.ReadMember.doCached(DefaultBytecodeScope, String, BytecodeNode, int, NameToIndexCache, String, int)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[DefaultBytecodeScope.ReadMember.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */;
                this.state_0_ = state_0;
                return ReadMember.doGeneric(arg0Value, arg1Value, this.cache);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberReadable#doCached}
             *     Activation probability: 0.10833
             *     With/without class size: 6/8 bytes
             *   Specialization {@link IsMemberReadable#doGeneric}
             *     Activation probability: 0.05833
             *     With/without class size: 4/0 bytes
             * </pre> */
            @ExplodeLoop
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1100) != 0 /* is SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] || SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] */) {
                        IsMemberReadableCachedData s0_ = this.isMemberReadable_cached_cache;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                return IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedMember_, this.cache, s0_.index_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                        return IsMemberReadable.doGeneric(arg0Value, arg1Value, this.cache);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(DefaultBytecodeScope arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberReadableCachedData s0_ = IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberReadableCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                String cachedMember__ = (arg1Value);
                                if ((DefaultBytecodeScope.equalsString(cachedMember__, arg1Value)) && count0_ < (5)) {
                                    s0_ = new IsMemberReadableCachedData(s0_original);
                                    s0_.cachedMember_ = cachedMember__;
                                    s0_.index_ = (this.cache.slotToIndex(arg0Value, cachedMember__));
                                    if (!IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedMember_, this.cache, s0_.index_);
                        }
                        break;
                    }
                }
                this.isMemberReadable_cached_cache = null;
                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] */;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[DefaultBytecodeScope.IsMemberReadable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */;
                this.state_0_ = state_0;
                return IsMemberReadable.doGeneric(arg0Value, arg1Value, this.cache);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberModifiable#doCached}
             *     Activation probability: 0.10833
             *     With/without class size: 6/8 bytes
             *   Specialization {@link IsMemberModifiable#doGeneric}
             *     Activation probability: 0.05833
             *     With/without class size: 4/0 bytes
             * </pre> */
            @ExplodeLoop
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b110000) != 0 /* is SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] || SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] */) {
                        IsMemberModifiableCachedData s0_ = this.isMemberModifiable_cached_cache;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                return IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedMember_, this.cache, s0_.index_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                        return IsMemberModifiable.doGeneric(arg0Value, arg1Value, this.cache);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableAndSpecialize(DefaultBytecodeScope arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberModifiableCachedData s0_ = IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberModifiableCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                String cachedMember__ = (arg1Value);
                                if ((DefaultBytecodeScope.equalsString(cachedMember__, arg1Value)) && count0_ < (5)) {
                                    s0_ = new IsMemberModifiableCachedData(s0_original);
                                    s0_.cachedMember_ = cachedMember__;
                                    s0_.index_ = (this.cache.slotToIndex(arg0Value, cachedMember__));
                                    if (!IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedMember_, this.cache, s0_.index_);
                        }
                        break;
                    }
                }
                this.isMemberModifiable_cached_cache = null;
                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doCached(DefaultBytecodeScope, String, String, NameToIndexCache, int)] */;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[DefaultBytecodeScope.IsMemberModifiable.doGeneric(DefaultBytecodeScope, String, NameToIndexCache)] */;
                this.state_0_ = state_0;
                return IsMemberModifiable.doGeneric(arg0Value, arg1Value, this.cache);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteMember#doCached}
             *     Activation probability: 0.10833
             *     With/without class size: 6/8 bytes
             *   Specialization {@link WriteMember#doGeneric}
             *     Activation probability: 0.05833
             *     With/without class size: 4/0 bytes
             * </pre> */
            @ExplodeLoop
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[DefaultBytecodeScope.WriteMember.doCached(DefaultBytecodeScope, String, Object, BytecodeNode, int, NameToIndexCache, String, int)] || SpecializationActive[DefaultBytecodeScope.WriteMember.doGeneric(DefaultBytecodeScope, String, Object, NameToIndexCache)] */) {
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[DefaultBytecodeScope.WriteMember.doCached(DefaultBytecodeScope, String, Object, BytecodeNode, int, NameToIndexCache, String, int)] */) {
                        WriteMemberCachedData s0_ = this.writeMember_cached_cache;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                WriteMember.doCached(arg0Value, arg1Value, arg2Value, this.cachedBytecode, this.cachedBci, this.cache, s0_.cachedMember_, s0_.index_);
                                return;
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[DefaultBytecodeScope.WriteMember.doGeneric(DefaultBytecodeScope, String, Object, NameToIndexCache)] */) {
                        WriteMember.doGeneric(arg0Value, arg1Value, arg2Value, this.cache);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberAndSpecialize(DefaultBytecodeScope arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[DefaultBytecodeScope.WriteMember.doGeneric(DefaultBytecodeScope, String, Object, NameToIndexCache)] */) {
                    while (true) {
                        int count0_ = 0;
                        WriteMemberCachedData s0_ = WRITE_MEMBER_CACHED_CACHE_UPDATER.getVolatile(this);
                        WriteMemberCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((DefaultBytecodeScope.equalsString(s0_.cachedMember_, arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                String cachedMember__ = (arg1Value);
                                if ((DefaultBytecodeScope.equalsString(cachedMember__, arg1Value)) && count0_ < (5)) {
                                    s0_ = new WriteMemberCachedData(s0_original);
                                    s0_.cachedMember_ = cachedMember__;
                                    s0_.index_ = (this.cache.slotToIndex(arg0Value, cachedMember__));
                                    if (!WRITE_MEMBER_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[DefaultBytecodeScope.WriteMember.doCached(DefaultBytecodeScope, String, Object, BytecodeNode, int, NameToIndexCache, String, int)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            WriteMember.doCached(arg0Value, arg1Value, arg2Value, this.cachedBytecode, this.cachedBci, this.cache, s0_.cachedMember_, s0_.index_);
                            return;
                        }
                        break;
                    }
                }
                this.writeMember_cached_cache = null;
                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[DefaultBytecodeScope.WriteMember.doCached(DefaultBytecodeScope, String, Object, BytecodeNode, int, NameToIndexCache, String, int)] */;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[DefaultBytecodeScope.WriteMember.doGeneric(DefaultBytecodeScope, String, Object, NameToIndexCache)] */;
                this.state_0_ = state_0;
                WriteMember.doGeneric(arg0Value, arg1Value, arg2Value, this.cache);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link DefaultBytecodeScope#accepts(DefaultBytecodeScope, BytecodeNode, TagTreeNode, int, NameToIndexCache)}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre> */
            private boolean accepts_(Object arg0Value_) {
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                return arg0Value.accepts(this.cachedBytecode, this.cachedNode, this.cachedBci, this.cache);
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).hasLanguage();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link DefaultBytecodeScope#getLanguage(DefaultBytecodeScope, TagTreeNode)}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                return arg0Value.getLanguage(this.cachedNode);
            }

            @Override
            public boolean isScope(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).isScope();
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).isMemberInsertable(member);
            }

            @TruffleBoundary
            @Override
            public boolean hasSourceLocation(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).hasSourceLocation();
            }

            @TruffleBoundary
            @Override
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).getSourceLocation();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DefaultBytecodeScope) receiver)).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(DefaultBytecodeScope.class)
            @DenyReplace
            private static final class ReadMemberCachedData implements SpecializationDataNode {

                @CompilationFinal final ReadMemberCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReadMember#doCached}
                 *   Parameter: {@link String} cachedMember</pre> */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReadMember#doCached}
                 *   Parameter: int index</pre> */
                @CompilationFinal int index_;

                ReadMemberCachedData(ReadMemberCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(DefaultBytecodeScope.class)
            @DenyReplace
            private static final class IsMemberReadableCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberReadableCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: {@link String} cachedMember</pre> */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: int index</pre> */
                @CompilationFinal int index_;

                IsMemberReadableCachedData(IsMemberReadableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(DefaultBytecodeScope.class)
            @DenyReplace
            private static final class IsMemberModifiableCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberModifiableCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: {@link String} cachedMember</pre> */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: int index</pre> */
                @CompilationFinal int index_;

                IsMemberModifiableCachedData(IsMemberModifiableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(DefaultBytecodeScope.class)
            @DenyReplace
            private static final class WriteMemberCachedData implements SpecializationDataNode {

                @CompilationFinal final WriteMemberCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link WriteMember#doCached}
                 *   Parameter: {@link String} cachedMember</pre> */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link WriteMember#doCached}
                 *   Parameter: int index</pre> */
                @CompilationFinal int index_;

                WriteMemberCachedData(WriteMemberCachedData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(DefaultBytecodeScope.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof DefaultBytecodeScope) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof DefaultBytecodeScope && accepts_(receiver);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                return ReadMember.doGeneric(arg0Value, arg1Value, (arg0Value.getCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                return IsMemberReadable.doGeneric(arg0Value, arg1Value, (arg0Value.getCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                return IsMemberModifiable.doGeneric(arg0Value, arg1Value, (arg0Value.getCache()));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                WriteMember.doGeneric(arg0Value, arg1Value, arg2Value, (arg0Value.getCache()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                return arg0Value.getLanguage((arg0Value.node));
            }

            @TruffleBoundary
            @Override
            public boolean isScope(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .isScope();
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .isMemberInsertable(member);
            }

            @TruffleBoundary
            @Override
            public boolean hasSourceLocation(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .hasSourceLocation();
            }

            @TruffleBoundary
            @Override
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .getSourceLocation();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DefaultBytecodeScope) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                DefaultBytecodeScope arg0Value = ((DefaultBytecodeScope) arg0Value_);
                return arg0Value.accepts((arg0Value.bytecode), (arg0Value.node), (arg0Value.bci), (arg0Value.getCache()));
            }

        }
    }
}
