/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.StrongKeyWeakValueEntry;
import com.oracle.truffle.object.WeakKey;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;

final class TransitionMap<K, V> {
    private final EconomicMap<Object, StrongKeyWeakValueEntry<Object, V>> map = EconomicMap.create((Equivalence)WEAK_KEY_EQUIVALENCE);
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private static final Equivalence WEAK_KEY_EQUIVALENCE = new WeakKeyEquivalence();

    TransitionMap() {
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    private V getValue(StrongKeyWeakValueEntry<? super K, V> entry) {
        return entry == null ? null : (V)entry.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            return this.getValue((StrongKeyWeakValueEntry)this.map.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putAnyKey(Object key, V value) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            return this.getValue((StrongKeyWeakValueEntry)this.map.put(key, new StrongKeyWeakValueEntry<Object, V>(key, value, this.queue)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putAnyKeyIfAbsent(Object key, V value) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            V prevValue = this.getValue((StrongKeyWeakValueEntry)this.map.get(key));
            if (prevValue != null) {
                return prevValue;
            }
            this.map.put(key, new StrongKeyWeakValueEntry<Object, V>(key, value, this.queue));
            return null;
        }
    }

    public V put(K key, V value) {
        return this.putAnyKey(key, value);
    }

    public V putIfAbsent(K key, V value) {
        return this.putAnyKeyIfAbsent(key, value);
    }

    public V putWeakKey(K key, V value) {
        ShapeImpl.shapeCacheWeakKeys.inc();
        WeakKey<K> weakKey = new WeakKey<K>(key);
        return this.putAnyKey(weakKey, value);
    }

    public V putWeakKeyIfAbsent(K key, V value) {
        ShapeImpl.shapeCacheWeakKeys.inc();
        WeakKey<K> weakKey = new WeakKey<K>(key);
        return this.putAnyKeyIfAbsent(weakKey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            return this.getValue((StrongKeyWeakValueEntry)this.map.removeKey(key));
        }
    }

    private void expungeStaleEntries() {
        Reference<V> r;
        while ((r = this.queue.poll()) != null) {
            StrongKeyWeakValueEntry entry;
            if (!(r instanceof StrongKeyWeakValueEntry) || this.map.get((entry = (StrongKeyWeakValueEntry)r).getKey()) != entry) continue;
            this.map.removeKey(entry.getKey());
            ShapeImpl.shapeCacheExpunged.inc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            while (this.queue.poll() != null) {
            }
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            MapCursor cursor = this.map.getEntries();
            while (cursor.advance()) {
                K key;
                Object value = ((StrongKeyWeakValueEntry)cursor.getValue()).get();
                if (value == null || (key = this.unwrapKey(cursor.getKey())) == null) continue;
                consumer.accept(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R iterateEntries(BiFunction<? super K, ? super V, R> consumer) {
        ReferenceQueue<V> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            MapCursor cursor = this.map.getEntries();
            while (cursor.advance()) {
                R result;
                K key;
                Object value = ((StrongKeyWeakValueEntry)cursor.getValue()).get();
                if (value == null || (key = this.unwrapKey(cursor.getKey())) == null || (result = consumer.apply(key, value)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private K unwrapKey(Object key) {
        if (key instanceof WeakKey) {
            return (K)((WeakKey)key).get();
        }
        return (K)key;
    }

    private static final class WeakKeyEquivalence
    extends Equivalence {
        private WeakKeyEquivalence() {
        }

        public int hashCode(Object o) {
            return o.hashCode();
        }

        public boolean equals(Object a, Object b) {
            boolean aIsWeak = a instanceof WeakKey;
            boolean bIsWeak = b instanceof WeakKey;
            if (aIsWeak && !bIsWeak) {
                return Objects.equals(((WeakKey)a).get(), b);
            }
            if (!aIsWeak && bIsWeak) {
                return Objects.equals(a, ((WeakKey)b).get());
            }
            return a.equals(b);
        }
    }
}

