/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.provider.InternalResourceProvider;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.InternalResourceRoots;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.ModuleUtils;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.nativeimage.ImageInfo;

final class InternalResourceCache {
    private static final char[] FILE_SYSTEM_SPECIAL_CHARACTERS = new char[]{'/', '\\', ':'};
    private static final Map<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, Map<String, Supplier<InternalResourceCache>>>> optionalInternalResourcesCaches = new HashMap<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, Map<String, Supplier<InternalResourceCache>>>>();
    private static final Map<String, Map<String, Supplier<InternalResourceCache>>> nativeImageCache = TruffleOptions.AOT ? new HashMap() : null;
    private static boolean useInternalResources = true;
    private final String id;
    private final String resourceId;
    private final Supplier<InternalResource> resourceFactory;
    private InternalResourceRoots.Root owningRoot;
    private volatile Path path;

    InternalResourceCache(String languageId, String resourceId, Supplier<InternalResource> resourceFactory) {
        this.id = Objects.requireNonNull(languageId);
        this.resourceId = Objects.requireNonNull(resourceId);
        this.resourceFactory = Objects.requireNonNull(resourceFactory);
    }

    String getResourceId() {
        return this.resourceId;
    }

    Path getPathOrNull() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path getPath(PolyglotEngineImpl polyglotEngine) throws IOException {
        if (InternalResourceCache.usesInternalResources()) {
            Path result = this.path;
            if (result == null) {
                InternalResourceCache internalResourceCache = this;
                synchronized (internalResourceCache) {
                    result = this.path;
                    if (result == null) {
                        this.path = result = this.installResource(resource -> EngineAccessor.LANGUAGE.createInternalResourceEnv((InternalResource)resource, () -> polyglotEngine.inEnginePreInitialization));
                    }
                }
            }
            return result;
        }
        throw new IllegalArgumentException("Internal resources are restricted. To enable them, use '-H:+CopyLanguageResources' during the native image build.");
    }

    void initializeOwningRoot(InternalResourceRoots.Root root) {
        assert (this.owningRoot == null);
        assert (this.path == null);
        this.owningRoot = root;
        this.path = switch (root.kind()) {
            default -> throw new IncompatibleClassChangeError();
            case InternalResourceRoots.Root.Kind.RESOURCE -> root.path();
            case InternalResourceRoots.Root.Kind.COMPONENT -> root.path().resolve(InternalResourceCache.sanitize(this.resourceId));
            case InternalResourceRoots.Root.Kind.UNVERSIONED -> this.findStandaloneResourceRoot(root.path());
            case InternalResourceRoots.Root.Kind.VERSIONED -> null;
        };
    }

    void clearCache() {
        this.owningRoot = null;
        this.path = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path installRuntimeResource(InternalResource resource) throws IOException {
        InternalResourceCache cache;
        InternalResourceCache internalResourceCache = cache = InternalResourceCache.createRuntimeResourceCache(resource);
        synchronized (internalResourceCache) {
            return cache.installResource(InternalResourceCache::createInternalResourceEnvReflectively);
        }
    }

    private static InternalResourceCache createRuntimeResourceCache(InternalResource resource) {
        InternalResource.Id id = resource.getClass().getAnnotation(InternalResource.Id.class);
        assert (id != null) : resource.getClass() + " must be annotated by @InternalResource.Id";
        InternalResourceCache cache = new InternalResourceCache("engine", id.value(), () -> resource);
        InternalResourceRoots.initializeRuntimeResource(cache);
        return cache;
    }

    private static InternalResource.Env createInternalResourceEnvReflectively(InternalResource resource) {
        try {
            Constructor newEnv = InternalResource.Env.class.getDeclaredConstructor(InternalResource.class, BooleanSupplier.class);
            newEnv.setAccessible(true);
            return (InternalResource.Env)newEnv.newInstance(resource, () -> TruffleOptions.AOT);
        }
        catch (ReflectiveOperationException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    private Path installResource(Function<InternalResource, InternalResource.Env> resourceEnvProvider) throws IOException {
        InternalResource.Env env;
        Objects.requireNonNull(resourceEnvProvider, "ResourceEnvProvider must be non-null.");
        assert (Thread.holdsLock(this)) : "Unpacking must be called under lock";
        assert (this.owningRoot.kind() == InternalResourceRoots.Root.Kind.VERSIONED);
        assert (!ImageInfo.inImageRuntimeCode()) : "Must not be called in the image execution time.";
        InternalResource resource = this.resourceFactory.get();
        String versionHash = resource.versionHash(env = resourceEnvProvider.apply(resource));
        if (versionHash.getBytes().length > 128) {
            throw new IOException("The version hash length is restricted to a maximum of 128 bytes.");
        }
        Path target = this.owningRoot.path().resolve(Path.of(InternalResourceCache.sanitize(this.id), InternalResourceCache.sanitize(this.resourceId), InternalResourceCache.sanitize(versionHash)));
        if (!Files.exists(target, new LinkOption[0])) {
            Path parent = target.getParent();
            if (parent == null) {
                throw CompilerDirectives.shouldNotReachHere("Target must have a parent directory but was " + target);
            }
            Path owner = Files.createDirectories(Objects.requireNonNull(parent), new FileAttribute[0]);
            Path tmpDir = Files.createTempDirectory(owner, null, new FileAttribute[0]);
            resource.unpackFiles(env, tmpDir);
            try {
                Files.move(tmpDir, target, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (FileAlreadyExistsException existsException) {
                InternalResourceCache.unlink(tmpDir);
            }
            catch (FileSystemException fsException) {
                if (Files.isDirectory(target, new LinkOption[0])) {
                    InternalResourceCache.unlink(tmpDir);
                }
            }
        } else {
            InternalResourceCache.verifyResourceRoot(target);
        }
        return target;
    }

    private static void verifyResourceRoot(Path resourceRoot) throws IOException {
        if (!Files.isDirectory(resourceRoot, new LinkOption[0])) {
            throw new IOException("Resource cache root " + resourceRoot + " must be a directory.");
        }
        if (!Files.isReadable(resourceRoot)) {
            throw new IOException("Resource cache root " + resourceRoot + " must be readable.");
        }
    }

    private Path findStandaloneResourceRoot(Path root) {
        return root.resolve(Path.of(InternalResourceCache.sanitize(this.id), InternalResourceCache.sanitize(this.resourceId)));
    }

    private static String sanitize(String pathElement) {
        String result = pathElement;
        for (char fileSystemsSpecialChar : FILE_SYSTEM_SPECIAL_CHARACTERS) {
            result = result.replace(fileSystemsSpecialChar, '_');
        }
        return result;
    }

    public static boolean usesInternalResources() {
        return useInternalResources;
    }

    static void initializeNativeImageState(ClassLoader nativeImageClassLoader) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.putAll(InternalResourceCache.collectOptionalResources(List.of(new EngineAccessor.StrongClassLoaderSupplier(nativeImageClassLoader))));
    }

    static void resetNativeImageState() {
        nativeImageCache.clear();
    }

    static boolean copyResourcesForNativeImage(Path target, String ... components) throws IOException {
        Collection<InstrumentCache> instruments;
        Collection<LanguageCache> languages;
        boolean result = false;
        if (components.length == 0) {
            languages = LanguageCache.languages().values();
            instruments = InstrumentCache.load();
        } else {
            HashSet requiredComponentIds = new HashSet();
            Collections.addAll(requiredComponentIds, components);
            HashSet<String> requiredLanguageIds = new HashSet<String>(LanguageCache.languages().keySet());
            requiredLanguageIds.retainAll(requiredComponentIds);
            Set requiredInstrumentIds = InstrumentCache.load().stream().map(InstrumentCache::getId).collect(Collectors.toSet());
            requiredInstrumentIds.retainAll(requiredComponentIds);
            requiredComponentIds.removeAll(requiredLanguageIds);
            requiredComponentIds.removeAll(requiredInstrumentIds);
            if (!requiredComponentIds.isEmpty()) {
                TreeSet<String> installedComponents = new TreeSet<String>(LanguageCache.languages().keySet());
                InstrumentCache.load().stream().map(InstrumentCache::getId).forEach(installedComponents::add);
                throw new IllegalArgumentException(String.format("Components with ids %s are not installed. Installed components are: %s.", String.join((CharSequence)", ", requiredComponentIds), String.join((CharSequence)", ", installedComponents)));
            }
            HashSet<LanguageCache> requiredLanguages = new HashSet<LanguageCache>(LanguageCache.internalLanguages());
            for (String requiredLanguageId : requiredLanguageIds) {
                requiredLanguages.addAll(LanguageCache.computeTransitiveLanguageDependencies(requiredLanguageId));
            }
            languages = requiredLanguages;
            HashSet<InstrumentCache> requiredInstruments = new HashSet<InstrumentCache>(InstrumentCache.internalInstruments());
            InstrumentCache.load().stream().filter(ic -> requiredInstrumentIds.contains(ic.getId())).forEach(requiredInstruments::add);
            instruments = requiredInstruments;
        }
        for (LanguageCache language : languages) {
            for (InternalResourceCache cache : language.getResources()) {
                result |= cache.copyResourcesForNativeImage(target);
            }
        }
        for (InstrumentCache instrument : instruments) {
            for (InternalResourceCache cache : instrument.getResources()) {
                result |= cache.copyResourcesForNativeImage(target);
            }
        }
        for (InternalResourceCache cache : InternalResourceCache.getEngineResources()) {
            result |= cache.copyResourcesForNativeImage(target);
        }
        return result;
    }

    private boolean copyResourcesForNativeImage(Path target) throws IOException {
        Path root = this.findStandaloneResourceRoot(target);
        InternalResourceCache.unlink(root);
        Files.createDirectories(root, new FileAttribute[0]);
        InternalResource resource = this.resourceFactory.get();
        InternalResource.Env env = EngineAccessor.LANGUAGE.createInternalResourceEnv(resource, () -> false);
        resource.unpackFiles(env, root);
        if (InternalResourceCache.isEmpty(root)) {
            Files.deleteIfExists(root);
            return false;
        }
        return true;
    }

    static Collection<String> getEngineResourceIds() {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        return engineResources != null ? engineResources.keySet() : List.of();
    }

    static Collection<InternalResourceCache> getEngineResources() {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        if (engineResources != null) {
            return engineResources.values().stream().map(Supplier::get).collect(Collectors.toList());
        }
        return List.of();
    }

    static InternalResourceCache getEngineResource(String resourceId) {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        Supplier<InternalResourceCache> resourceSupplier = engineResources != null ? engineResources.get(resourceId) : null;
        return resourceSupplier != null ? resourceSupplier.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Map<String, Supplier<InternalResourceCache>>> loadOptionalInternalResources(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        if (TruffleOptions.AOT) {
            assert (nativeImageCache != null);
            return nativeImageCache;
        }
        Class<InternalResourceCache> clazz = InternalResourceCache.class;
        synchronized (InternalResourceCache.class) {
            Map<String, Map<String, Supplier<InternalResourceCache>>> cache = optionalInternalResourcesCaches.get(suppliers);
            if (cache == null) {
                cache = InternalResourceCache.collectOptionalResources(suppliers);
                optionalInternalResourcesCaches.put(suppliers, cache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, Map<String, Supplier<InternalResourceCache>>> collectOptionalResources(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        HashMap<String, Map<String, Supplier<InternalResourceCache>>> cache = new HashMap<String, Map<String, Supplier<InternalResourceCache>>>();
        for (EngineAccessor.AbstractClassLoaderSupplier supplier : suppliers) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null || !InternalResourceCache.isValidLoader(loader)) continue;
            StreamSupport.stream(ServiceLoader.load(InternalResourceProvider.class, loader).spliterator(), false).filter(p -> supplier.accepts(p.getClass())).forEach(p -> {
                ModuleUtils.exportTransitivelyTo(p.getClass().getModule());
                String componentId = EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceComponentId((InternalResourceProvider)p);
                String resourceId = EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceId((InternalResourceProvider)p);
                Map componentOptionalResources = cache.computeIfAbsent(componentId, k -> new HashMap());
                OptionalResourceSupplier resourceSupplier = new OptionalResourceSupplier((InternalResourceProvider)p);
                OptionalResourceSupplier existing = componentOptionalResources.put(resourceId, resourceSupplier);
                if (existing != null && !InternalResourceCache.hasSameCodeSource(resourceSupplier, existing)) {
                    throw InternalResourceCache.throwDuplicateOptionalResourceException(existing.get(), resourceSupplier.get());
                }
            });
        }
        return cache;
    }

    private static boolean hasSameCodeSource(OptionalResourceSupplier first, OptionalResourceSupplier second) {
        return first.optionalResourceProvider.getClass() == second.optionalResourceProvider.getClass();
    }

    private static boolean isValidLoader(ClassLoader loader) {
        try {
            Class<?> truffleLanguageClassAsSeenByLoader = Class.forName(TruffleLanguage.class.getName(), true, loader);
            return truffleLanguageClassAsSeenByLoader == TruffleLanguage.class;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static RuntimeException throwDuplicateOptionalResourceException(InternalResourceCache existing, InternalResourceCache duplicate) {
        String message = String.format("Duplicate optional resource id %s for component %s. First optional resource [%s]. Second optional resource [%s].", existing.resourceId, existing.id, InternalResourceCache.formatResourceLocation(existing.resourceFactory.get()), InternalResourceCache.formatResourceLocation(duplicate.resourceFactory.get()));
        throw new IllegalStateException(message);
    }

    private static String formatResourceLocation(InternalResource internalResource) {
        URL url;
        StringBuilder sb = new StringBuilder();
        sb.append("Internal resource class ").append(internalResource.getClass().getName());
        CodeSource source = internalResource.getClass().getProtectionDomain().getCodeSource();
        URL uRL = url = source != null ? source.getLocation() : null;
        if (url != null) {
            sb.append(", Loaded from ").append(url);
        }
        return sb.toString();
    }

    private static boolean isEmpty(Path folder) throws IOException {
        try (Stream<Path> children = Files.list(folder);){
            boolean bl = children.findAny().isEmpty();
            return bl;
        }
    }

    private static void unlink(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(path);){
                for (Path child : children) {
                    InternalResourceCache.unlink(child);
                }
            }
        }
        Files.deleteIfExists(path);
    }

    public String toString() {
        return "InternalResourceCache[componentId='" + this.id + "', resourceId='" + this.resourceId + "', resourceRoot=" + this.path + "}";
    }

    private static final class OptionalResourceSupplier
    implements Supplier<InternalResourceCache> {
        private final InternalResourceProvider optionalResourceProvider;
        private volatile InternalResourceCache cachedResource;

        private OptionalResourceSupplier(InternalResourceProvider optionalResourceProvider) {
            Objects.requireNonNull(optionalResourceProvider, "OptionalResourceProvider must be non null");
            this.optionalResourceProvider = optionalResourceProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InternalResourceCache get() {
            InternalResourceCache res = this.cachedResource;
            if (res == null) {
                OptionalResourceSupplier optionalResourceSupplier = this;
                synchronized (optionalResourceSupplier) {
                    res = this.cachedResource;
                    if (res == null) {
                        this.cachedResource = res = new InternalResourceCache(EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceComponentId(this.optionalResourceProvider), EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceId(this.optionalResourceProvider), () -> EngineAccessor.LANGUAGE_PROVIDER.createInternalResource(this.optionalResourceProvider));
                    }
                }
            }
            return res;
        }
    }
}

