/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.SpecializationStatistics;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.ImageBuildTimeOptions;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotEngineOptionsOptionDescriptors;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.ProcessHandlers;
import com.oracle.truffle.polyglot.WeakAssumedValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.home.HomeFinder;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;

final class PolyglotEngineImpl
implements PolyglotImpl.VMObject {
    static final int HOST_LANGUAGE_INDEX = 0;
    static final String HOST_LANGUAGE_ID = "host";
    static final String ENGINE_ID = "engine";
    static final String OPTION_GROUP_ENGINE = "engine";
    static final String OPTION_GROUP_LOG = "log";
    static final String OPTION_GROUP_IMAGE_BUILD_TIME = "image-build-time";
    static final String LOG_FILE_OPTION = "log.file";
    private static final Set<String> RESERVED_IDS = new HashSet<String>(Arrays.asList("host", "graal", "truffle", "language", "instrument", "graalvm", "context", "polyglot", "compiler", "vm", "file", "engine", "log", "image-build-time"));
    private static final Map<PolyglotEngineImpl, Void> ENGINES = Collections.synchronizedMap(new WeakHashMap());
    private static volatile boolean shutdownHookInitialized = false;
    private static final boolean DEBUG_MISSING_CLOSE = Boolean.getBoolean("polyglotimpl.DebugMissingClose");
    static final PolyglotLocals.LocalLocation[] EMPTY_LOCATIONS = new PolyglotLocals.LocalLocation[0];
    final Object lock = new Object();
    final Object instrumentationHandler;
    final PolyglotImpl impl;
    DispatchOutputStream out;
    DispatchOutputStream err;
    InputStream in;
    Engine api;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final PolyglotLanguage[] languages;
    final Map<String, PolyglotLanguage> idToLanguage;
    final Map<String, PolyglotLanguage> classToLanguage;
    final Map<String, Language> idToPublicLanguage;
    final Map<String, LanguageInfo> idToInternalLanguageInfo;
    final Map<String, PolyglotInstrument> idToInstrument;
    final Map<String, Instrument> idToPublicInstrument;
    final Map<String, InstrumentInfo> idToInternalInstrumentInfo;
    @CompilerDirectives.CompilationFinal
    OptionValuesImpl engineOptionValues;
    boolean boundEngine;
    boolean storeEngine;
    Handler logHandler;
    final Exception createdLocation = DEBUG_MISSING_CLOSE ? new Exception() : null;
    private final EconomicSet<PolyglotContextImpl.ContextWeakReference> contexts = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    final ReferenceQueue<PolyglotContextImpl> contextsReferenceQueue = new ReferenceQueue();
    private final AtomicReference<PolyglotContextImpl> preInitializedContext = new AtomicReference();
    @CompilerDirectives.CompilationFinal
    Assumption singleContext = Truffle.getRuntime().createAssumption("Single context per engine.");
    final Assumption singleThreadPerContext = Truffle.getRuntime().createAssumption("Single thread per context of an engine.");
    final Assumption noInnerContexts = Truffle.getRuntime().createAssumption("No inner contexts.");
    final Assumption customHostClassLoader = Truffle.getRuntime().createAssumption("No custom host class loader needed.");
    volatile OptionDescriptors allOptions;
    volatile boolean closed;
    final Object runtimeData;
    Map<String, Level> logLevels;
    private volatile Object engineLoggers;
    private volatile Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> fileTypeDetectorsSupplier;
    final int contextLength;
    private volatile PolyglotLimits.EngineLimits limits;
    final boolean conservativeContextReferences;
    private final MessageTransport messageInterceptor;
    private volatile int asynchronousStackDepth = 0;
    final SpecializationStatistics specializationStatistics;
    Function<String, TruffleLogger> engineLoggerSupplier;
    private volatile TruffleLogger engineLogger;
    final WeakAssumedValue<PolyglotContextImpl> singleContextValue = new WeakAssumedValue("single context");
    @CompilerDirectives.CompilationFinal
    volatile StableLocalLocations contextLocalLocations = new StableLocalLocations(EMPTY_LOCATIONS);
    @CompilerDirectives.CompilationFinal
    volatile StableLocalLocations contextThreadLocalLocations = new StableLocalLocations(EMPTY_LOCATIONS);
    @CompilerDirectives.CompilationFinal
    HostToGuestRootNode uncachedLocation;
    final PolyglotLanguageInstance hostLanguageInstance;
    @CompilerDirectives.CompilationFinal
    AbstractPolyglotImpl.AbstractHostService host;
    final boolean hostLanguageOnly;
    private static final String DISABLE_PRIVILEGES_VALUE = ImageBuildTimeOptions.get("DisablePrivileges");
    private static final String[] DISABLED_PRIVILEGES = DISABLE_PRIVILEGES_VALUE.isEmpty() ? new String[]{} : DISABLE_PRIVILEGES_VALUE.split(",");
    private static final boolean ALLOW_CREATE_PROCESS;
    static final boolean ALLOW_ENVIRONMENT_ACCESS;
    static final boolean ALLOW_IO;
    private static final Object NO_ENTER;
    private static volatile PolyglotEngineImpl fallbackEngine;

    PolyglotEngineImpl(PolyglotImpl impl, DispatchOutputStream out, DispatchOutputStream err, InputStream in, OptionValuesImpl engineOptions, Map<String, Level> logLevels, PolyglotLoggers.EngineLoggerProvider engineLogger, Map<String, String> options, boolean allowExperimentalOptions, boolean boundEngine, boolean preInitialization, MessageTransport messageInterceptor, Handler logHandler, TruffleLanguage<Object> hostImpl, boolean hostLanguageOnly) {
        this.messageInterceptor = messageInterceptor;
        this.impl = impl;
        this.out = out;
        this.err = err;
        this.in = in;
        this.logHandler = logHandler;
        this.logLevels = logLevels;
        this.boundEngine = boundEngine;
        this.storeEngine = EngineAccessor.RUNTIME.isStoreEnabled(engineOptions);
        this.hostLanguageOnly = hostLanguageOnly;
        this.hostLanguageInstance = this.createHostLanguageInstance(hostImpl);
        LinkedHashMap<String, LanguageInfo> languageInfos = new LinkedHashMap<String, LanguageInfo>();
        this.idToLanguage = Collections.unmodifiableMap(this.initializeLanguages(languageInfos));
        this.idToInternalLanguageInfo = Collections.unmodifiableMap(languageInfos);
        this.contextLength = this.idToLanguage.values().size() + 1;
        this.languages = this.createLanguageStaticIndex();
        LinkedHashMap<String, InstrumentInfo> instrumentInfos = new LinkedHashMap<String, InstrumentInfo>();
        this.idToInstrument = Collections.unmodifiableMap(this.initializeInstruments(instrumentInfos));
        this.idToInternalInstrumentInfo = Collections.unmodifiableMap(instrumentInfos);
        this.runtimeData = EngineAccessor.RUNTIME.createRuntimeData(engineOptions, engineLogger);
        this.classToLanguage = new HashMap<String, PolyglotLanguage>();
        for (PolyglotLanguage polyglotLanguage : this.idToLanguage.values()) {
            this.classToLanguage.put(polyglotLanguage.cache.getClassName(), polyglotLanguage);
        }
        for (String string : this.idToLanguage.keySet()) {
            if (!this.idToInstrument.containsKey(string)) continue;
            throw PolyglotEngineImpl.failDuplicateId(string, this.idToLanguage.get((Object)string).cache.getClassName(), this.idToInstrument.get((Object)string).cache.getClassName());
        }
        this.engineLoggerSupplier = engineLogger;
        this.engineOptionValues = engineOptions;
        LinkedHashMap<String, Language> publicLanguages = new LinkedHashMap<String, Language>();
        for (String string : this.idToLanguage.keySet()) {
            PolyglotLanguage languageImpl = this.idToLanguage.get(string);
            if (languageImpl.cache.isInternal()) continue;
            publicLanguages.put(string, languageImpl.api);
        }
        this.idToPublicLanguage = Collections.unmodifiableMap(publicLanguages);
        LinkedHashMap<String, Instrument> linkedHashMap = new LinkedHashMap<String, Instrument>();
        for (String key : this.idToInstrument.keySet()) {
            PolyglotInstrument instrumentImpl = this.idToInstrument.get(key);
            if (instrumentImpl.cache.isInternal()) continue;
            linkedHashMap.put(key, instrumentImpl.api);
        }
        this.idToPublicInstrument = Collections.unmodifiableMap(linkedHashMap);
        this.instrumentationHandler = EngineAccessor.INSTRUMENT.createInstrumentationHandler(this, out, err, in, messageInterceptor, this.storeEngine);
        if (!boundEngine) {
            this.initializeMultiContext();
        }
        this.intitializeStore(false, this.storeEngine);
        HashMap<PolyglotLanguage, Map<String, String>> hashMap = new HashMap<PolyglotLanguage, Map<String, String>>();
        HashMap<PolyglotInstrument, Map<String, String>> instrumentsOptions = new HashMap<PolyglotInstrument, Map<String, String>>();
        this.parseOptions(options, hashMap, instrumentsOptions);
        this.conservativeContextReferences = this.engineOptionValues.get(PolyglotEngineOptions.UseConservativeContextReferences);
        for (PolyglotLanguage language : hashMap.keySet()) {
            language.getOptionValues().putAll((Map)hashMap.get(language), allowExperimentalOptions);
        }
        this.specializationStatistics = this.engineOptionValues.get(PolyglotEngineOptions.SpecializationStatistics) != false ? SpecializationStatistics.create() : null;
        this.notifyCreated();
        if (!preInitialization) {
            PolyglotEngineImpl.createInstruments(instrumentsOptions, allowExperimentalOptions);
            PolyglotEngineImpl.registerShutDownHook();
        }
    }

    void ensureUncachedLocationLoaded() {
        assert (Thread.holdsLock(this.lock));
        if (this.uncachedLocation == null) {
            this.uncachedLocation = PolyglotEngineImpl.createUncachedLocation(this.hostLanguageInstance.spi);
        }
    }

    Node getUncachedLocation() {
        assert (this.uncachedLocation != null) : "uncached location not yet initialized";
        return this.uncachedLocation;
    }

    private PolyglotLanguage[] createLanguageStaticIndex() {
        int maxLanguageStaticId = 0;
        for (PolyglotLanguage language : this.idToLanguage.values()) {
            maxLanguageStaticId = Math.max(maxLanguageStaticId, language.cache.getStaticIndex());
        }
        PolyglotLanguage[] list = new PolyglotLanguage[maxLanguageStaticId + 1];
        list[0] = this.hostLanguageInstance.language;
        for (PolyglotLanguage language : this.idToLanguage.values()) {
            assert (list[language.cache.getStaticIndex()] == null) : "language index used twice";
            list[language.cache.getStaticIndex()] = language;
        }
        return list;
    }

    private static UncachedLocationNode createUncachedLocation(TruffleLanguage<?> hostLanguage) {
        UncachedLocationNode location = new UncachedLocationNode(hostLanguage);
        Truffle.getRuntime().createCallTarget(location);
        return location;
    }

    private PolyglotLanguageInstance createHostLanguageInstance(TruffleLanguage<Object> hostImpl) {
        PolyglotLanguage language = this.createLanguage(LanguageCache.createHostLanguageCache(hostImpl, new String[0]), 0, null);
        return language.allocateInstance(new OptionValuesImpl(this, language.getOptionsInternal(), false));
    }

    void notifyCreated() {
        ENGINES.put(this, null);
        EngineAccessor.RUNTIME.onEngineCreate(this, this.runtimeData);
    }

    PolyglotEngineImpl(PolyglotEngineImpl prototype) {
        this.messageInterceptor = prototype.messageInterceptor;
        this.instrumentationHandler = EngineAccessor.INSTRUMENT.createInstrumentationHandler(this, EngineAccessor.INSTRUMENT.createDispatchOutput(EngineAccessor.INSTRUMENT.getOut(prototype.out)), EngineAccessor.INSTRUMENT.createDispatchOutput(EngineAccessor.INSTRUMENT.getOut(prototype.err)), prototype.in, prototype.messageInterceptor, prototype.storeEngine);
        this.impl = prototype.impl;
        this.out = prototype.out;
        this.err = prototype.err;
        this.in = prototype.in;
        this.host = prototype.host;
        this.boundEngine = prototype.boundEngine;
        this.logHandler = prototype.logHandler;
        this.runtimeData = EngineAccessor.RUNTIME.createRuntimeData(prototype.engineOptionValues, prototype.engineLoggerSupplier);
        this.engineLoggerSupplier = prototype.engineLoggerSupplier;
        LinkedHashMap<String, LanguageInfo> languageInfos = new LinkedHashMap<String, LanguageInfo>();
        this.hostLanguageOnly = prototype.hostLanguageOnly;
        this.hostLanguageInstance = this.createHostLanguageInstance(prototype.hostLanguageInstance.spi);
        this.idToLanguage = Collections.unmodifiableMap(this.initializeLanguages(languageInfos));
        this.idToInternalLanguageInfo = Collections.unmodifiableMap(languageInfos);
        this.contextLength = this.idToLanguage.size() + 1;
        this.languages = this.createLanguageStaticIndex();
        LinkedHashMap<String, InstrumentInfo> instrumentInfos = new LinkedHashMap<String, InstrumentInfo>();
        this.idToInstrument = Collections.unmodifiableMap(this.initializeInstruments(instrumentInfos));
        this.idToInternalInstrumentInfo = Collections.unmodifiableMap(instrumentInfos);
        this.uncachedLocation = PolyglotEngineImpl.createUncachedLocation(this.hostLanguageInstance.spi);
        this.classToLanguage = new HashMap<String, PolyglotLanguage>();
        for (PolyglotLanguage polyglotLanguage : this.idToLanguage.values()) {
            this.classToLanguage.put(polyglotLanguage.cache.getClassName(), polyglotLanguage);
        }
        for (String string : this.idToLanguage.keySet()) {
            if (!this.idToInstrument.containsKey(string)) continue;
            throw PolyglotEngineImpl.failDuplicateId(string, this.idToLanguage.get((Object)string).cache.getClassName(), this.idToInstrument.get((Object)string).cache.getClassName());
        }
        LinkedHashMap<String, Language> publicLanguages = new LinkedHashMap<String, Language>();
        for (String string : this.idToLanguage.keySet()) {
            PolyglotLanguage languageImpl = this.idToLanguage.get(string);
            if (languageImpl.cache.isInternal()) continue;
            publicLanguages.put(string, languageImpl.api);
        }
        this.idToPublicLanguage = Collections.unmodifiableMap(publicLanguages);
        LinkedHashMap<String, Instrument> linkedHashMap = new LinkedHashMap<String, Instrument>();
        for (String key : this.idToInstrument.keySet()) {
            PolyglotInstrument instrumentImpl = this.idToInstrument.get(key);
            if (instrumentImpl.cache.isInternal()) continue;
            linkedHashMap.put(key, instrumentImpl.api);
        }
        this.idToPublicInstrument = Collections.unmodifiableMap(linkedHashMap);
        this.logLevels = prototype.logLevels;
        this.engineOptionValues = prototype.engineOptionValues.copy();
        this.conservativeContextReferences = this.engineOptionValues.get(PolyglotEngineOptions.UseConservativeContextReferences);
        if (!this.boundEngine) {
            this.initializeMultiContext();
        }
        this.intitializeStore(false, prototype.storeEngine);
        for (String languageId : this.idToLanguage.keySet()) {
            OptionValuesImpl prototypeOptions = prototype.idToLanguage.get(languageId).getOptionValuesIfExists();
            if (prototypeOptions == null) continue;
            prototypeOptions.copyInto(this.idToLanguage.get(languageId).getOptionValues());
        }
        this.specializationStatistics = this.engineOptionValues.get(PolyglotEngineOptions.SpecializationStatistics) != false ? SpecializationStatistics.create() : null;
        ArrayList<PolyglotInstrument> arrayList = new ArrayList<PolyglotInstrument>();
        for (String instrumentId : this.idToInstrument.keySet()) {
            OptionValuesImpl prototypeOptions = prototype.idToInstrument.get(instrumentId).getOptionValuesIfExists();
            if (prototypeOptions == null) continue;
            PolyglotInstrument instrument = this.idToInstrument.get(instrumentId);
            prototypeOptions.copyInto(instrument.getEngineOptionValues());
            arrayList.add(instrument);
        }
        this.api = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineDispatch)this.impl.engineDispatch, (Object)this);
        PolyglotEngineImpl.ensureInstrumentsCreated(arrayList);
        PolyglotEngineImpl.registerShutDownHook();
        this.notifyCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TruffleLogger getEngineLogger() {
        TruffleLogger result = this.engineLogger;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.engineLogger;
                if (result == null) {
                    result = this.engineLoggerSupplier.apply("engine");
                    Object logger = EngineAccessor.LANGUAGE.getLoggerCache(result);
                    PolyglotLoggers.LoggerCache loggerCache = (PolyglotLoggers.LoggerCache)EngineAccessor.LANGUAGE.getLoggersSPI(logger);
                    loggerCache.setOwner(this);
                    if (!this.logLevels.isEmpty()) {
                        EngineAccessor.LANGUAGE.configureLoggers(this, this.logLevels, logger);
                    }
                    this.engineLogger = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getOrCreateEngineLoggers() {
        Object res = this.engineLoggers;
        if (res == null) {
            Object object = this.lock;
            synchronized (object) {
                res = this.engineLoggers;
                if (res == null) {
                    PolyglotLoggers.LoggerCache loggerCache = PolyglotLoggers.LoggerCache.newEngineLoggerCache(this);
                    loggerCache.setOwner(this);
                    res = EngineAccessor.LANGUAGE.createEngineLoggers(loggerCache);
                    if (!this.logLevels.isEmpty()) {
                        EngineAccessor.LANGUAGE.configureLoggers(this, this.logLevels, res);
                    }
                    for (PolyglotContextImpl.ContextWeakReference contextRef : this.contexts) {
                        PolyglotContextImpl context = (PolyglotContextImpl)contextRef.get();
                        if (context == null || context.config.logLevels.isEmpty()) continue;
                        EngineAccessor.LANGUAGE.configureLoggers(context, context.config.logLevels, res);
                    }
                    this.engineLoggers = res;
                }
            }
        }
        return res;
    }

    static OptionDescriptors createEngineOptionDescriptors() {
        PolyglotEngineOptionsOptionDescriptors engineOptionDescriptors = new PolyglotEngineOptionsOptionDescriptors();
        OptionDescriptors compilerOptionDescriptors = EngineAccessor.RUNTIME.getEngineOptionDescriptors();
        return OptionDescriptors.createUnion((OptionDescriptors[])new OptionDescriptors[]{engineOptionDescriptors, compilerOptionDescriptors});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<Object> findActiveEngines() {
        Map<PolyglotEngineImpl, Void> map = ENGINES;
        synchronized (map) {
            ArrayList<Object> engines = new ArrayList<Object>(ENGINES.size());
            for (PolyglotEngineImpl engine : ENGINES.keySet()) {
                engines.add(engine.api);
            }
            return engines;
        }
    }

    void patch(DispatchOutputStream newOut, DispatchOutputStream newErr, InputStream newIn, OptionValuesImpl engineOptions, LogConfig newLogConfig, PolyglotLoggers.EngineLoggerProvider logSupplier, Map<String, String> newOptions, boolean newAllowExperimentalOptions, boolean newBoundEngine, Handler newLogHandler) {
        CompilerAsserts.neverPartOfCompilation();
        this.out = newOut;
        this.err = newErr;
        this.in = newIn;
        boolean wasBound = this.boundEngine;
        this.boundEngine = newBoundEngine;
        this.logHandler = newLogHandler;
        this.engineOptionValues = engineOptions;
        this.logLevels = newLogConfig.logLevels;
        boolean wasStore = this.storeEngine;
        this.storeEngine = EngineAccessor.RUNTIME.isStoreEnabled(engineOptions);
        this.engineLoggerSupplier = logSupplier;
        this.engineLogger = null;
        this.intitializeStore(wasStore, this.storeEngine);
        if (wasBound && !newBoundEngine) {
            this.initializeMultiContext();
        }
        EngineAccessor.INSTRUMENT.patchInstrumentationHandler(this.instrumentationHandler, newOut, newErr, newIn);
        HashMap<PolyglotLanguage, Map<String, String>> languagesOptions = new HashMap<PolyglotLanguage, Map<String, String>>();
        HashMap<PolyglotInstrument, Map<String, String>> instrumentsOptions = new HashMap<PolyglotInstrument, Map<String, String>>();
        this.parseOptions(newOptions, languagesOptions, instrumentsOptions);
        EngineAccessor.RUNTIME.onEnginePatch(this.runtimeData, engineOptions, logSupplier);
        for (PolyglotLanguage language : languagesOptions.keySet()) {
            language.getOptionValues().putAll((Map)languagesOptions.get(language), newAllowExperimentalOptions);
        }
        for (PolyglotInstrument instrument : instrumentsOptions.keySet()) {
            instrument.getEngineOptionValues().putAll((Map)instrumentsOptions.get(instrument), newAllowExperimentalOptions);
        }
        PolyglotEngineImpl.registerShutDownHook();
    }

    static Handler createLogHandler(LogConfig logConfig, DispatchOutputStream errDispatchOutputStream) {
        if (logConfig.logFile != null) {
            if (ALLOW_IO) {
                return PolyglotLoggers.getFileHandler(logConfig.logFile);
            }
            throw PolyglotEngineException.illegalState("The `log.file` option is not allowed when the allowIO() privilege is removed at image build time.");
        }
        return PolyglotLoggers.createDefaultHandler(EngineAccessor.INSTRUMENT.getOut(errDispatchOutputStream));
    }

    private static void createInstruments(Map<PolyglotInstrument, Map<String, String>> instrumentsOptions, boolean allowExperimentalOptions) {
        for (PolyglotInstrument instrument : instrumentsOptions.keySet()) {
            instrument.getEngineOptionValues().putAll(instrumentsOptions.get(instrument), allowExperimentalOptions);
        }
        PolyglotEngineImpl.ensureInstrumentsCreated(instrumentsOptions.keySet());
    }

    static void ensureInstrumentsCreated(Collection<? extends PolyglotInstrument> instruments) {
        for (PolyglotInstrument polyglotInstrument : instruments) {
            polyglotInstrument.ensureCreated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerShutDownHook() {
        if (!shutdownHookInitialized) {
            Map<PolyglotEngineImpl, Void> map = ENGINES;
            synchronized (map) {
                if (!shutdownHookInitialized) {
                    shutdownHookInitialized = true;
                    try {
                        Runtime.getRuntime().addShutdownHook(new Thread(new PolyglotShutDownHook()));
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeMultiContext() {
        Object object = this.lock;
        synchronized (object) {
            if (this.singleContext.isValid()) {
                this.singleContext.invalidate();
                this.singleContextValue.invalidate();
            }
        }
    }

    static void parseEngineOptions(Map<String, String> allOptions, Map<String, String> engineOptions, LogConfig logOptions) {
        Iterator<Map.Entry<String, String>> iterator = allOptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String value = entry.getValue();
            String group = PolyglotEngineImpl.parseOptionGroup(key);
            if (group.equals("engine")) {
                engineOptions.put(entry.getKey(), entry.getValue());
                iterator.remove();
                continue;
            }
            if (!group.equals(OPTION_GROUP_LOG)) continue;
            if (LOG_FILE_OPTION.equals(key)) {
                logOptions.logFile = value;
            } else {
                logOptions.logLevels.put(PolyglotEngineImpl.parseLoggerName(key), Level.parse(value));
            }
            iterator.remove();
        }
    }

    private void parseOptions(Map<String, String> options, Map<PolyglotLanguage, Map<String, String>> languagesOptions, Map<PolyglotInstrument, Map<String, String>> instrumentsOptions) {
        for (String key : options.keySet()) {
            String group = PolyglotEngineImpl.parseOptionGroup(key);
            String value = options.get(key);
            PolyglotLanguage language = this.idToLanguage.get(group);
            if (language != null && !language.cache.isInternal()) {
                Map<String, String> languageOptions = languagesOptions.get(language);
                if (languageOptions == null) {
                    languageOptions = new HashMap<String, String>();
                    languagesOptions.put(language, languageOptions);
                }
                languageOptions.put(key, value);
                continue;
            }
            PolyglotInstrument instrument = this.idToInstrument.get(group);
            if (instrument != null && !instrument.cache.isInternal()) {
                Map<String, String> instrumentOptions = instrumentsOptions.get(instrument);
                if (instrumentOptions == null) {
                    instrumentOptions = new HashMap<String, String>();
                    instrumentsOptions.put(instrument, instrumentOptions);
                }
                instrumentOptions.put(key, value);
                continue;
            }
            switch (group) {
                case "engine": 
                case "log": {
                    throw new AssertionError((Object)"Log or engine options should already be parsed.");
                }
                case "image-build-time": {
                    throw PolyglotEngineException.illegalArgument("Image build-time option '" + key + "' cannot be set at runtime");
                }
            }
            throw OptionValuesImpl.failNotFound(this.getAllOptions(), key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> readOptionsFromSystemProperties(Map<String, String> options) {
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            for (Object systemKey : properties.keySet()) {
                String optionKey;
                String key;
                if ("polyglot.engine.AllowExperimentalOptions".equals(systemKey) || !(key = (String)systemKey).startsWith("polyglot.") || (optionKey = key.substring("polyglot.".length())).startsWith(OPTION_GROUP_IMAGE_BUILD_TIME) || options.containsKey(optionKey)) continue;
                options.put(optionKey, System.getProperty(key));
            }
        }
        return options;
    }

    static String parseOptionGroup(String key) {
        int groupIndex = key.indexOf(46);
        String group = groupIndex != -1 ? key.substring(0, groupIndex) : key;
        return group;
    }

    static String parseLoggerName(String optionKey) {
        int end;
        String prefix = "log.";
        String suffix = ".level";
        if (!optionKey.startsWith("log.") || !optionKey.endsWith(".level")) {
            throw PolyglotEngineException.illegalArgument(optionKey);
        }
        int start = "log.".length();
        return start < (end = optionKey.length() - ".level".length()) ? optionKey.substring(start, end) : "";
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this;
    }

    PolyglotLanguage findLanguage(PolyglotLanguageContext accessingLanguage, String languageId, String mimeType, boolean failIfNotFound, boolean allowInternalAndDependent) {
        Map<String, LanguageInfo> languageMap;
        assert (languageId != null || mimeType != null) : Objects.toString(languageId) + ", " + Objects.toString(mimeType);
        if (accessingLanguage != null) {
            languageMap = accessingLanguage.getAccessibleLanguages(allowInternalAndDependent);
        } else {
            assert (allowInternalAndDependent) : "non internal access is not yet supported for instrument lookups";
            languageMap = this.idToInternalLanguageInfo;
        }
        LanguageInfo foundLanguage = null;
        if (languageId != null) {
            foundLanguage = languageMap.get(languageId);
        }
        if (mimeType != null && foundLanguage == null && (foundLanguage = languageMap.get(mimeType)) == null) {
            for (LanguageInfo searchLanguage : languageMap.values()) {
                if (!searchLanguage.getMimeTypes().contains(mimeType)) continue;
                foundLanguage = searchLanguage;
                break;
            }
        }
        assert (allowInternalAndDependent || foundLanguage == null || !foundLanguage.isInternal() && accessingLanguage.isPolyglotEvalAllowed(languageId));
        if (foundLanguage != null) {
            return (PolyglotLanguage)EngineAccessor.NODES.getPolyglotLanguage(foundLanguage);
        }
        if (failIfNotFound) {
            if (languageId != null) {
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                for (LanguageInfo language : languageMap.values()) {
                    ids.add(language.getId());
                }
                throw PolyglotEngineException.illegalState("No language for id " + languageId + " found. Supported languages are: " + ids);
            }
            LinkedHashSet<String> mimeTypes = new LinkedHashSet<String>();
            for (LanguageInfo language : languageMap.values()) {
                mimeTypes.addAll(language.getMimeTypes());
            }
            throw PolyglotEngineException.illegalState("No language for MIME type " + mimeType + " found. Supported languages are: " + mimeTypes);
        }
        return null;
    }

    private Map<String, PolyglotInstrument> initializeInstruments(Map<String, InstrumentInfo> infos) {
        if (this.hostLanguageOnly) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, PolyglotInstrument> instruments = new LinkedHashMap<String, PolyglotInstrument>();
        List<InstrumentCache> cachedInstruments = InstrumentCache.load();
        for (InstrumentCache instrumentCache : cachedInstruments) {
            Instrument instrument;
            PolyglotInstrument instrumentImpl = new PolyglotInstrument(this, instrumentCache);
            instrumentImpl.info = EngineAccessor.LANGUAGE.createInstrument(instrumentImpl, instrumentCache.getId(), instrumentCache.getName(), instrumentCache.getVersion());
            instrumentImpl.api = instrument = this.impl.getAPIAccess().newInstrument((AbstractPolyglotImpl.AbstractInstrumentDispatch)this.impl.instrumentDispatch, (Object)instrumentImpl);
            String id = instrumentImpl.cache.getId();
            PolyglotEngineImpl.verifyId(id, instrumentCache.getClassName());
            if (instruments.containsKey(id)) {
                throw PolyglotEngineImpl.failDuplicateId(id, instrumentImpl.cache.getClassName(), ((PolyglotInstrument)instruments.get((Object)id)).cache.getClassName());
            }
            instruments.put(id, instrumentImpl);
            infos.put(id, instrumentImpl.info);
        }
        return instruments;
    }

    private Map<String, PolyglotLanguage> initializeLanguages(Map<String, LanguageInfo> infos) {
        if (this.hostLanguageOnly) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, PolyglotLanguage> polyglotLanguages = new LinkedHashMap<String, PolyglotLanguage>();
        HashMap<String, LanguageCache> cachedLanguages = new HashMap<String, LanguageCache>();
        ArrayList<LanguageCache> sortedLanguages = new ArrayList<LanguageCache>();
        for (LanguageCache lang : LanguageCache.languages().values()) {
            String id = lang.getId();
            if (cachedLanguages.containsKey(id)) continue;
            sortedLanguages.add(lang);
            cachedLanguages.put(id, lang);
        }
        Collections.sort(sortedLanguages);
        LinkedHashSet<LanguageCache> serializedLanguages = new LinkedHashSet<LanguageCache>();
        HashSet<String> languageReferences = new HashSet<String>();
        HashMap<String, RuntimeException> initErrors = new HashMap<String, RuntimeException>();
        for (LanguageCache language : sortedLanguages) {
            languageReferences.addAll(language.getDependentLanguages());
        }
        for (LanguageCache language : sortedLanguages) {
            if (!language.isInternal() || languageReferences.contains(language.getId())) continue;
            this.visitLanguage(initErrors, cachedLanguages, serializedLanguages, language);
        }
        for (LanguageCache language : sortedLanguages) {
            if (language.isInternal() || languageReferences.contains(language.getId())) continue;
            this.visitLanguage(initErrors, cachedLanguages, serializedLanguages, language);
        }
        int index = 1;
        for (LanguageCache cache : serializedLanguages) {
            PolyglotLanguage languageImpl = this.createLanguage(cache, index, (RuntimeException)initErrors.get(cache.getId()));
            String id = languageImpl.cache.getId();
            PolyglotEngineImpl.verifyId(id, cache.getClassName());
            if (polyglotLanguages.containsKey(id)) {
                throw PolyglotEngineImpl.failDuplicateId(id, languageImpl.cache.getClassName(), ((PolyglotLanguage)polyglotLanguages.get((Object)id)).cache.getClassName());
            }
            polyglotLanguages.put(id, languageImpl);
            infos.put(id, languageImpl.info);
            ++index;
        }
        return polyglotLanguages;
    }

    private void visitLanguage(Map<String, RuntimeException> initErrors, Map<String, LanguageCache> cachedLanguages, LinkedHashSet<LanguageCache> serializedLanguages, LanguageCache language) {
        this.visitLanguageImpl(new HashSet<String>(), initErrors, cachedLanguages, serializedLanguages, language);
    }

    private void visitLanguageImpl(Set<String> visitedIds, Map<String, RuntimeException> initErrors, Map<String, LanguageCache> cachedLanguages, LinkedHashSet<LanguageCache> serializedLanguages, LanguageCache language) {
        Set<String> dependencies = language.getDependentLanguages();
        for (String dependency : dependencies) {
            LanguageCache dependentLanguage = cachedLanguages.get(dependency);
            if (dependentLanguage == null) continue;
            if (visitedIds.contains(dependency)) {
                initErrors.put(language.getId(), PolyglotEngineException.illegalState("Illegal cyclic language dependency found:" + language.getId() + " -> " + dependency));
                continue;
            }
            visitedIds.add(dependency);
            this.visitLanguageImpl(visitedIds, initErrors, cachedLanguages, serializedLanguages, dependentLanguage);
            visitedIds.remove(dependency);
        }
        serializedLanguages.add(language);
    }

    private PolyglotLanguage createLanguage(LanguageCache cache, int index, RuntimeException initError) {
        Language language;
        PolyglotLanguage languageImpl = new PolyglotLanguage(this, cache, index, index == 0, initError);
        languageImpl.api = language = this.impl.getAPIAccess().newLanguage((AbstractPolyglotImpl.AbstractLanguageDispatch)this.impl.languageDispatch, (Object)languageImpl);
        return languageImpl;
    }

    private static void verifyId(String id, String className) {
        if (RESERVED_IDS.contains(id)) {
            throw new IllegalStateException(String.format("The language or instrument with class '%s' uses a reserved id '%s'. Resolve this by using a not reserved id for the language or instrument. The following ids are reserved %s for internal use.", className, id, RESERVED_IDS));
        }
        if (id.contains(".")) {
            throw new IllegalStateException(String.format("The language '%s' must not contain a period in its id '%s'. Remove all periods from the id to resolve this issue. ", className, id));
        }
    }

    private static RuntimeException failDuplicateId(String duplicateId, String className1, String className2) {
        return new IllegalStateException(String.format("Duplicate id '%s' specified by language or instrument with class '%s' and '%s'. Resolve this by specifying a unique id for each language or instrument.", duplicateId, className1, className2));
    }

    void checkState() {
        if (this.closed) {
            throw PolyglotEngineException.illegalState("Engine is already closed.");
        }
    }

    void addContext(PolyglotContextImpl context) {
        assert (Thread.holdsLock(this.lock));
        this.ensureUncachedLocationLoaded();
        if (this.limits != null) {
            this.limits.validate(context.config.limits);
        }
        this.workContextReferenceQueue();
        this.contexts.add((Object)context.weakReference);
        if (context.config.limits != null) {
            PolyglotLimits.EngineLimits l = this.limits;
            if (l == null) {
                this.limits = l = new PolyglotLimits.EngineLimits(this);
            }
            l.initialize(context.config.limits, context);
        }
        if (context.config.hostClassLoader != null) {
            context.engine.customHostClassLoader.invalidate();
        }
        this.singleContextValue.update(context);
    }

    void removeContext(PolyglotContextImpl context) {
        assert (Thread.holdsLock(this.lock)) : "Must hold PolyglotEngineImpl.lock";
        this.contexts.remove((Object)context.weakReference);
        this.workContextReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeContext(PolyglotContextImpl context) {
        Object object = this.lock;
        synchronized (object) {
            assert (!context.weakReference.removed);
            context.weakReference.removed = true;
            context.weakReference.freeInstances.clear();
            this.removeContext(context);
        }
    }

    private void workContextReferenceQueue() {
        Reference<PolyglotContextImpl> ref;
        while ((ref = this.contextsReferenceQueue.poll()) != null) {
            PolyglotContextImpl.ContextWeakReference contextRef = (PolyglotContextImpl.ContextWeakReference)ref;
            if (contextRef.removed) continue;
            for (PolyglotLanguageInstance instance : contextRef.freeInstances) {
                instance.language.freeInstance(instance);
            }
            contextRef.freeInstances.clear();
            this.contexts.remove((Object)contextRef);
            contextRef.removed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportAllLanguageContexts(ContextsListener listener) {
        List<PolyglotContextImpl> allContexts;
        Iterator<PolyglotContextImpl> iterator = this.lock;
        synchronized (iterator) {
            if (this.contexts.isEmpty()) {
                return;
            }
            allContexts = this.collectAliveContexts();
        }
        for (PolyglotContextImpl context : allContexts) {
            listener.onContextCreated(context.creatorTruffleContext);
            for (PolyglotLanguageContext lc : context.contexts) {
                LanguageInfo language = lc.language.info;
                if (!lc.eventsEnabled || lc.env == null) continue;
                listener.onLanguageContextCreate(context.creatorTruffleContext, language);
                listener.onLanguageContextCreated(context.creatorTruffleContext, language);
                if (!lc.isInitialized()) continue;
                listener.onLanguageContextInitialize(context.creatorTruffleContext, language);
                listener.onLanguageContextInitialized(context.creatorTruffleContext, language);
                if (!lc.finalized) continue;
                listener.onLanguageContextFinalized(context.creatorTruffleContext, language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void reportAllContextThreads(ThreadsListener listener) {
        Iterator<PolyglotContextImpl> iterator = this.lock;
        // MONITORENTER : iterator
        if (this.contexts.isEmpty()) {
            // MONITOREXIT : iterator
            return;
        }
        List<PolyglotContextImpl> allContexts = this.collectAliveContexts();
        // MONITOREXIT : iterator
        iterator = allContexts.iterator();
        block4: while (iterator.hasNext()) {
            Thread[] context;
            Thread[] threadArray = context = iterator.next();
            // MONITORENTER : context
            Thread[] threads = context.getSeenThreads().keySet().toArray(new Thread[0]);
            // MONITOREXIT : threadArray
            threadArray = threads;
            int n = threadArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block4;
                Thread thread = threadArray[n2];
                listener.onThreadInitialized(context.creatorTruffleContext, thread);
                ++n2;
            }
            break;
        }
        return;
    }

    PolyglotLanguage requireLanguage(String id, boolean allowInternal) {
        this.checkState();
        PolyglotLanguage language = this.idToLanguage.get(id);
        if (language == null || !allowInternal && !this.idToPublicLanguage.containsKey(id)) {
            throw PolyglotEngineImpl.throwNotInstalled(id, this.idToLanguage.keySet());
        }
        return language;
    }

    private static RuntimeException throwNotInstalled(String id, Set<String> allLanguages) {
        String misspelledGuess = PolyglotEngineImpl.matchSpellingError(allLanguages, id);
        String didYouMean = "";
        if (misspelledGuess != null) {
            didYouMean = String.format("Did you mean '%s'? ", misspelledGuess);
        }
        throw PolyglotEngineException.illegalArgument(String.format("A language with id '%s' is not installed. %sInstalled languages are: %s.", id, didYouMean, allLanguages));
    }

    public Language requirePublicLanguage(String id) {
        this.checkState();
        Language language = this.idToPublicLanguage.get(id);
        if (language == null) {
            throw PolyglotEngineImpl.throwNotInstalled(id, this.idToPublicLanguage.keySet());
        }
        return language;
    }

    private static String matchSpellingError(Set<String> allIds, String enteredId) {
        String lowerCaseEnteredId = enteredId.toLowerCase();
        for (String id : allIds) {
            if (!id.toLowerCase().equals(lowerCaseEnteredId)) continue;
            return id;
        }
        return null;
    }

    public Instrument requirePublicInstrument(String id) {
        this.checkState();
        Instrument instrument = this.idToPublicInstrument.get(id);
        if (instrument == null) {
            String misspelledGuess = PolyglotEngineImpl.matchSpellingError(this.idToPublicInstrument.keySet(), id);
            String didYouMean = "";
            if (misspelledGuess != null) {
                didYouMean = String.format("Did you mean '%s'? ", misspelledGuess);
            }
            throw PolyglotEngineException.illegalState(String.format("An instrument with id '%s' is not installed. %sInstalled instruments are: %s.", id, didYouMean, this.getInstruments().keySet()));
        }
        return instrument;
    }

    @CompilerDirectives.TruffleBoundary
    <T extends TruffleLanguage<?>> PolyglotLanguage getLanguage(Class<T> languageClass, boolean fail) {
        PolyglotLanguage foundLanguage = this.classToLanguage.get(languageClass.getName());
        if (foundLanguage == null) {
            if (languageClass == this.hostLanguageInstance.spi.getClass()) {
                return this.hostLanguageInstance.language;
            }
            if (fail) {
                Set<String> languageNames = this.classToLanguage.keySet();
                throw PolyglotEngineException.illegalArgument("Cannot find language " + languageClass + " among " + languageNames);
            }
        }
        return foundLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureClosed(boolean force) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.workContextReferenceQueue();
                List<PolyglotContextImpl> localContexts = this.collectAliveContexts();
                if (!force) {
                    for (PolyglotContextImpl context : localContexts) {
                        assert (!Thread.holdsLock(context));
                        PolyglotContextImpl polyglotContextImpl = context;
                        synchronized (polyglotContextImpl) {
                            if (context.hasActiveOtherThread(false) && !context.state.isClosing()) {
                                throw PolyglotEngineException.illegalState(String.format("One of the context instances is currently executing. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
                            }
                        }
                    }
                }
                for (PolyglotContextImpl context : localContexts) {
                    assert (!Thread.holdsLock(context));
                    if (force) {
                        context.cancel(false, null);
                        continue;
                    }
                    boolean closeCompleted = context.closeImpl(true);
                    if (!closeCompleted) {
                        throw PolyglotEngineException.illegalState(String.format("One of the context instances is currently executing. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
                    }
                    context.finishCleanup();
                    context.checkSubProcessFinished();
                }
                this.contexts.clear();
                if (EngineAccessor.RUNTIME.onEngineClosing(this.runtimeData)) {
                    return;
                }
                for (PolyglotInstrument instrumentImpl : this.idToInstrument.values()) {
                    instrumentImpl.ensureFinalized();
                }
                for (PolyglotInstrument instrumentImpl : this.idToInstrument.values()) {
                    instrumentImpl.ensureClosed();
                }
                if (this.specializationStatistics != null) {
                    StringWriter logMessage = new StringWriter();
                    try (PrintWriter writer = new PrintWriter(logMessage);){
                        if (!this.specializationStatistics.hasData()) {
                            writer.printf("No specialization statistics data was collected. Either no node with @%s annotations was executed or the interpreter was not compiled with -J-Dtruffle.dsl.GenerateSpecializationStatistics=true e.g as parameter to the javac tool.", Specialization.class.getSimpleName());
                        } else {
                            this.specializationStatistics.printHistogram(writer);
                        }
                    }
                    this.getEngineLogger().log(Level.INFO, String.format("Specialization histogram: %n%s", logMessage.toString()));
                }
                EngineAccessor.RUNTIME.onEngineClosed(this.runtimeData);
                Object loggers = this.getEngineLoggers();
                if (loggers != null) {
                    EngineAccessor.LANGUAGE.closeEngineLoggers(loggers);
                }
                if (this.logHandler != null) {
                    this.logHandler.close();
                }
                this.closed = true;
                for (PolyglotLanguage language : this.idToLanguage.values()) {
                    language.close();
                }
                if (this.runtimeData != null) {
                    EngineAccessor.RUNTIME.flushCompileQueue(this.runtimeData);
                }
                ENGINES.remove(this);
            }
        }
    }

    List<PolyglotContextImpl> collectAliveContexts() {
        assert (Thread.holdsLock(this.lock));
        ArrayList<PolyglotContextImpl> localContexts = new ArrayList<PolyglotContextImpl>(this.contexts.size());
        for (PolyglotContextImpl.ContextWeakReference ref : this.contexts) {
            PolyglotContextImpl context = (PolyglotContextImpl)ref.get();
            if (context != null) {
                localContexts.add(context);
                continue;
            }
            this.contexts.remove((Object)ref);
        }
        return localContexts;
    }

    public Map<String, Instrument> getInstruments() {
        this.checkState();
        return this.idToPublicInstrument;
    }

    public Map<String, Language> getLanguages() {
        this.checkState();
        return this.idToPublicLanguage;
    }

    public OptionDescriptors getOptions() {
        this.checkState();
        return this.engineOptionValues.getDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Source> getCachedSources() {
        List<PolyglotContextImpl> activeContexts;
        this.checkState();
        HashSet<Source> sources = new HashSet<Source>();
        Object object = this.lock;
        synchronized (object) {
            activeContexts = this.collectAliveContexts();
        }
        for (PolyglotContextImpl context : activeContexts) {
            for (PolyglotLanguageContext language : context.contexts) {
                PolyglotLanguageInstance instance = language.getLanguageInstanceOrNull();
                if (instance == null) continue;
                instance.listCachedSources(sources);
            }
        }
        object = this.lock;
        synchronized (object) {
            for (PolyglotLanguage language : this.idToLanguage.values()) {
                for (PolyglotLanguageInstance instance : language.getInstancePool()) {
                    instance.listCachedSources(sources);
                }
            }
        }
        return sources;
    }

    Collection<CallTarget> getCallTargets() {
        return EngineAccessor.INSTRUMENT.getLoadedCallTargets(this.instrumentationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionDescriptors getAllOptions() {
        this.checkState();
        if (this.allOptions == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.allOptions == null) {
                    ArrayList<OptionDescriptors> allDescriptors = new ArrayList<OptionDescriptors>();
                    allDescriptors.add(this.engineOptionValues.getDescriptors());
                    for (PolyglotLanguage language : this.idToLanguage.values()) {
                        allDescriptors.add(language.getOptionsInternal());
                    }
                    for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                        allDescriptors.add(instrument.getAllOptionsInternal());
                    }
                    this.allOptions = OptionDescriptors.createUnion((OptionDescriptors[])allDescriptors.toArray(new OptionDescriptors[0]));
                }
            }
        }
        return this.allOptions;
    }

    PolyglotContextImpl getPreInitializedContext() {
        return this.preInitializedContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInitialize() {
        Object object = this.lock;
        synchronized (object) {
            this.preInitializedContext.set(PolyglotContextImpl.preInitialize(this));
        }
    }

    void intitializeStore(boolean previousStore, boolean newStore) {
        if (newStore) {
            if (previousStore && this.boundEngine && this.singleContext.isValid()) {
                this.singleContext.invalidate();
                this.singleContextValue.invalidate();
            } else {
                this.initializeMultiContext();
            }
        }
    }

    void finalizeStore() {
        assert (Thread.holdsLock(this.lock));
        this.out = null;
        this.err = null;
        this.in = null;
        this.logHandler = null;
        EngineAccessor.INSTRUMENT.finalizeStoreInstrumentationHandler(this.instrumentationHandler);
        if (this.storeEngine && this.boundEngine && !this.singleContext.isValid()) {
            this.singleContext = Truffle.getRuntime().createAssumption("Single context after preinitialization.");
        }
    }

    static void resetPreInitializedEngine() {
        ENGINES.clear();
    }

    @CompilerDirectives.TruffleBoundary
    int getAsynchronousStackDepth() {
        return this.asynchronousStackDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    void setAsynchronousStackDepth(PolyglotInstrument polyglotInstrument, int depth) {
        assert (depth >= 0) : String.format("Wrong depth: %d", depth);
        int newDepth = 0;
        Object object = this.lock;
        synchronized (object) {
            polyglotInstrument.requestedAsyncStackDepth = depth;
            for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                if (instrument.requestedAsyncStackDepth <= newDepth) continue;
                newDepth = instrument.requestedAsyncStackDepth;
            }
        }
        this.asynchronousStackDepth = newDepth;
    }

    static void cancel(PolyglotContextImpl context, List<Future<Void>> cancelationFutures) {
        PolyglotEngineImpl.cancelOrInterrupt(context, cancelationFutures, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean cancelOrInterrupt(PolyglotContextImpl context, List<Future<Void>> futures, long startMillis, Duration timeout) {
        block26: {
            try {
                PolyglotContextImpl polyglotContextImpl = context;
                synchronized (polyglotContextImpl) {
                    assert (context.singleThreaded || !context.isActive(Thread.currentThread())) : "Cancel while entered is only allowed for single-threaded contexts!";
                    context.sendInterrupt();
                }
                if (timeout == null) {
                    boolean closeCompleted = context.closeImpl(true);
                    assert (closeCompleted) : "Close was not completed!";
                    break block26;
                }
                boolean bl = PolyglotEngineImpl.waitForThreads(context, startMillis, timeout);
                return bl;
            }
            finally {
                for (Future<Void> future : futures) {
                    boolean timedOut = false;
                    try {
                        if (timeout != null) {
                            long timeoutMillis;
                            long timeElapsed = System.currentTimeMillis() - startMillis;
                            if (timeElapsed < (timeoutMillis = timeout.toMillis())) {
                                try {
                                    future.get(timeoutMillis - timeElapsed, TimeUnit.MILLISECONDS);
                                }
                                catch (TimeoutException te) {
                                    timedOut = true;
                                }
                            } else {
                                timedOut = true;
                            }
                        } else {
                            future.get();
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                    if (!timedOut) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean waitForThreads(PolyglotContextImpl context, long startMillis, Duration timeout) {
        long cancelTimeoutMillis = timeout != Duration.ZERO ? timeout.toMillis() : 0L;
        boolean success = true;
        if (!context.waitForThreads(startMillis, cancelTimeoutMillis)) {
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolyglotContextImpl createContext(OutputStream configOut, OutputStream configErr, InputStream configIn, boolean allowHostLookup, HostAccess hostAccess, PolyglotAccess polyglotAccess, boolean allowNativeAccess, boolean allowCreateThread, boolean allowHostIO, boolean allowHostClassLoading, boolean allowExperimentalOptions, Predicate<String> classFilter, Map<String, String> options, Map<String, String[]> arguments, String[] onlyLanguages, FileSystem fileSystem, Object logHandlerOrStream, boolean allowCreateProcess, ProcessHandler processHandler, EnvironmentAccess environmentAccess, Map<String, String> environment, ZoneId zone, Object limitsImpl, String currentWorkingDirectory, ClassLoader hostClassLoader, boolean allowValueSharing) {
        boolean hasContextBindings;
        boolean contextAddedToEngine;
        boolean replayEvents;
        PolyglotContextImpl context;
        Object fs;
        Object error;
        block53: {
            try {
                ProcessHandler useProcessHandler;
                InputStream useIn;
                FileSystem internalFs;
                Object object = this.lock;
                synchronized (object) {
                    this.checkState();
                    if (this.boundEngine && !this.contexts.isEmpty()) {
                        throw PolyglotEngineException.illegalArgument("Automatically created engines cannot be used to create more than one context. Use Engine.newBuilder().build() to construct a new engine and pass it using Context.newBuilder().engine(engine).build().");
                    }
                }
                EconomicSet allowedLanguages = EconomicSet.create();
                if (onlyLanguages.length == 0) {
                    allowedLanguages.addAll(this.getLanguages().keySet());
                } else {
                    allowedLanguages.addAll(Arrays.asList(onlyLanguages));
                }
                error = this.getAPIAccess().validatePolyglotAccess(polyglotAccess, (UnmodifiableEconomicSet)allowedLanguages);
                if (error != null) {
                    throw PolyglotEngineException.illegalArgument((String)error);
                }
                if (!ALLOW_IO) {
                    if (fileSystem == null) {
                        fileSystem = FileSystems.newNoIOFileSystem();
                    }
                    fs = fileSystem;
                    internalFs = fileSystem;
                } else if (allowHostIO) {
                    internalFs = fs = fileSystem != null ? fileSystem : FileSystems.newDefaultFileSystem();
                } else {
                    fs = FileSystems.newNoIOFileSystem();
                    internalFs = FileSystems.newLanguageHomeFileSystem();
                }
                if (currentWorkingDirectory != null) {
                    fs.setCurrentWorkingDirectory(fs.parsePath(currentWorkingDirectory));
                    internalFs.setCurrentWorkingDirectory(internalFs.parsePath(currentWorkingDirectory));
                }
                OutputStream useOut = configOut == null || configOut == EngineAccessor.INSTRUMENT.getOut(this.out) ? this.out : EngineAccessor.INSTRUMENT.createDelegatingOutput(configOut, this.out);
                OutputStream useErr = configErr == null || configErr == EngineAccessor.INSTRUMENT.getOut(this.err) ? this.err : EngineAccessor.INSTRUMENT.createDelegatingOutput(configErr, this.err);
                Handler useHandler = PolyglotLoggers.asHandler(logHandlerOrStream);
                Handler handler = useHandler = useHandler != null ? useHandler : this.logHandler;
                useHandler = useHandler != null ? useHandler : PolyglotLoggers.createDefaultHandler(configErr == null ? EngineAccessor.INSTRUMENT.getOut(this.err) : configErr);
                InputStream inputStream = useIn = configIn == null ? this.in : configIn;
                if (allowCreateProcess) {
                    if (!ALLOW_CREATE_PROCESS) {
                        throw PolyglotEngineException.illegalArgument("Cannot allowCreateProcess() because the privilege is removed at image build time");
                    }
                    useProcessHandler = processHandler != null ? processHandler : ProcessHandlers.newDefaultProcessHandler();
                } else {
                    useProcessHandler = null;
                }
                if (!ALLOW_ENVIRONMENT_ACCESS && environmentAccess != EnvironmentAccess.NONE) {
                    throw PolyglotEngineException.illegalArgument("Cannot allow EnvironmentAccess because the privilege is removed at image build time");
                }
                PolyglotLimits polyglotLimits = (PolyglotLimits)limitsImpl;
                PolyglotContextConfig config = new PolyglotContextConfig(this, useOut, useErr, useIn, allowHostLookup, polyglotAccess, allowNativeAccess, allowCreateThread, allowHostClassLoading, allowExperimentalOptions, classFilter, arguments, (EconomicSet<String>)allowedLanguages, options, (FileSystem)fs, internalFs, useHandler, allowCreateProcess, useProcessHandler, environmentAccess, environment, zone, polyglotLimits, hostClassLoader, hostAccess, allowValueSharing);
                context = this.loadPreinitializedContext(config);
                replayEvents = false;
                contextAddedToEngine = false;
                if (context == null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.checkState();
                        context = new PolyglotContextImpl(this, config);
                        this.addContext(context);
                        contextAddedToEngine = true;
                        break block53;
                    }
                }
                if (context.engine == this) {
                    assert (context.engine.uncachedLocation != null);
                    replayEvents = true;
                }
            }
            catch (Throwable t) {
                throw PolyglotImpl.guestToHostException(this, t);
            }
        }
        try {
            if (replayEvents) {
                error = context;
                synchronized (error) {
                    context.resizeContextLocals(this.contextLocalLocations);
                    context.initializeInstrumentContextLocals(context.contextLocals);
                }
            }
            try {
                error = context;
                synchronized (error) {
                    context.initializeContextLocals();
                    context.notifyContextCreated();
                }
            }
            catch (Throwable t) {
                if (contextAddedToEngine) {
                    fs = this.lock;
                    synchronized (fs) {
                        this.disposeContext(context);
                        if (this.boundEngine) {
                            this.ensureClosed(false);
                        }
                    }
                }
                throw t;
            }
            hasContextBindings = EngineAccessor.INSTRUMENT.hasContextBindings(this);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(context.getHostContext(), t, false);
        }
        if (replayEvents && hasContextBindings) {
            Object[] prev;
            try {
                prev = this.enter(context);
            }
            catch (Throwable t) {
                throw PolyglotImpl.guestToHostException(context.getHostContext(), t, false);
            }
            try {
                context.replayInstrumentationEvents();
            }
            catch (Throwable t) {
                throw PolyglotImpl.guestToHostException(context.getHostContext(), t, true);
            }
            finally {
                try {
                    this.leave(prev, context);
                }
                catch (Throwable t) {
                    throw PolyglotImpl.guestToHostException(context.getHostContext(), t, false);
                }
            }
        }
        this.checkTruffleRuntime();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotContextImpl loadPreinitializedContext(PolyglotContextConfig config) {
        PolyglotContextImpl context = this.preInitializedContext.getAndSet(null);
        if (!this.getEngineOptionValues().get(PolyglotEngineOptions.UsePreInitializedContext).booleanValue()) {
            context = null;
        }
        if (context != null) {
            FileSystems.PreInitializeContextFileSystem preInitFs = (FileSystems.PreInitializeContextFileSystem)context.config.fileSystem;
            preInitFs.onLoadPreinitializedContext(config.fileSystem);
            FileSystem oldFileSystem = config.fileSystem;
            config.fileSystem = preInitFs;
            preInitFs = (FileSystems.PreInitializeContextFileSystem)context.config.internalFileSystem;
            preInitFs.onLoadPreinitializedContext(config.internalFileSystem);
            FileSystem oldInternalFileSystem = config.internalFileSystem;
            config.internalFileSystem = preInitFs;
            boolean patchResult = false;
            Object object = this.lock;
            synchronized (object) {
                this.addContext(context);
            }
            try {
                patchResult = context.patch(config);
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.removeContext(context);
                }
                if (patchResult && PolyglotEngineImpl.arePreInitializedLanguagesCompatible(context, config)) {
                    HashSet<PolyglotInstrument> toCreate = null;
                    for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                        if (instrument.getOptionValuesIfExists() == null) continue;
                        if (toCreate == null) {
                            toCreate = new HashSet<PolyglotInstrument>();
                        }
                        toCreate.add(instrument);
                    }
                    if (toCreate != null) {
                        PolyglotEngineImpl.ensureInstrumentsCreated(toCreate);
                    }
                    Object object3 = this.lock;
                    synchronized (object3) {
                        this.addContext(context);
                    }
                }
                context.closeImpl(false);
                config.fileSystem = oldFileSystem;
                config.internalFileSystem = oldInternalFileSystem;
                PolyglotEngineImpl engine = new PolyglotEngineImpl(this);
                this.ensureClosed(true);
                Object object4 = engine.lock;
                synchronized (object4) {
                    context = new PolyglotContextImpl(engine, config);
                    engine.addContext(context);
                }
                throw throwable;
            }
            synchronized (object) {
                this.removeContext(context);
            }
            if (patchResult && PolyglotEngineImpl.arePreInitializedLanguagesCompatible(context, config)) {
                HashSet<PolyglotInstrument> toCreate = null;
                for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                    if (instrument.getOptionValuesIfExists() == null) continue;
                    if (toCreate == null) {
                        toCreate = new HashSet<PolyglotInstrument>();
                    }
                    toCreate.add(instrument);
                }
                if (toCreate != null) {
                    PolyglotEngineImpl.ensureInstrumentsCreated(toCreate);
                }
                Object object5 = this.lock;
                synchronized (object5) {
                    this.addContext(context);
                }
            } else {
                context.closeImpl(false);
                config.fileSystem = oldFileSystem;
                config.internalFileSystem = oldInternalFileSystem;
                PolyglotEngineImpl engine = new PolyglotEngineImpl(this);
                this.ensureClosed(true);
                Object object6 = engine.lock;
                synchronized (object6) {
                    context = new PolyglotContextImpl(engine, config);
                    engine.addContext(context);
                }
            }
        }
        return context;
    }

    private static boolean arePreInitializedLanguagesCompatible(PolyglotContextImpl context, PolyglotContextConfig config) {
        HashMap<String, PolyglotLanguageContext> preInitializedLanguages = new HashMap<String, PolyglotLanguageContext>();
        for (PolyglotLanguageContext languageContext : context.contexts) {
            if (!languageContext.isInitialized() || languageContext.language.isHost()) continue;
            preInitializedLanguages.put(languageContext.language.getId(), languageContext);
        }
        for (String allowedLanguage : config.allowedPublicLanguages) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)preInitializedLanguages.remove(allowedLanguage);
            if (languageContext == null) continue;
            preInitializedLanguages.keySet().removeAll(languageContext.getAccessibleLanguages(true).keySet());
        }
        return preInitializedLanguages.isEmpty();
    }

    private void checkTruffleRuntime() {
        if (this.getEngineOptionValues().get(PolyglotEngineOptions.WarnInterpreterOnly).booleanValue() && Truffle.getRuntime().getClass() == DefaultTruffleRuntime.class) {
            this.getEngineLogger().log(Level.WARNING, "The polyglot context is using an implementation that does not support runtime compilation.\nThe guest application code will therefore be executed in interpreted mode only.\nExecution only in interpreted mode will strongly impact the guest application performance.\nFor more information on using GraalVM see https://www.graalvm.org/java/quickstart/.\nTo disable this warning the '--engine.WarnInterpreterOnly=false' option or use the '-Dpolyglot.engine.WarnInterpreterOnly=false' system property.");
        }
    }

    OptionValuesImpl getEngineOptionValues() {
        return this.engineOptionValues;
    }

    Object getEngineLoggers() {
        return this.engineLoggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> getFileTypeDetectorsSupplier() {
        Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> res = this.fileTypeDetectorsSupplier;
        if (res == null) {
            Object object = this.lock;
            synchronized (object) {
                res = this.fileTypeDetectorsSupplier;
                if (res == null) {
                    ArrayList<LanguageCache> languageCaches = new ArrayList<LanguageCache>(this.idToLanguage.size());
                    for (PolyglotLanguage language : this.idToLanguage.values()) {
                        languageCaches.add(language.cache);
                    }
                    this.fileTypeDetectorsSupplier = res = FileSystems.newFileTypeDetectorsSupplier(languageCaches);
                }
            }
        }
        return res;
    }

    boolean needsEnter(PolyglotContextImpl context) {
        return PolyglotFastThreadLocals.needsEnter(context);
    }

    Object enterIfNeeded(PolyglotContextImpl context, boolean pollSafepoint) {
        CompilerAsserts.neverPartOfCompilation("not designed for compilation");
        if (this.needsEnter(context)) {
            return this.enterCached(context, pollSafepoint);
        }
        assert (PolyglotFastThreadLocals.getContext(null) != null);
        return NO_ENTER;
    }

    void leaveIfNeeded(Object prev, PolyglotContextImpl context) {
        CompilerAsserts.neverPartOfCompilation("not designed for compilation");
        if (prev != NO_ENTER) {
            this.leave((Object[])prev, context);
        }
    }

    Object[] enter(PolyglotContextImpl context) {
        if (CompilerDirectives.isPartialEvaluationConstant(this)) {
            return this.enterCached(context, true);
        }
        return this.enterBoundary(context);
    }

    @CompilerDirectives.TruffleBoundary
    private Object[] enterBoundary(PolyglotContextImpl context) {
        return this.enterCached(context, true);
    }

    Object[] enterCached(PolyglotContextImpl context, boolean pollSafepoint) {
        Object[] prev;
        PolyglotThreadInfo info = context.getCachedThread();
        boolean enterReverted = false;
        if (CompilerDirectives.injectBranchProbability(0.75, info.getThread() == Thread.currentThread())) {
            prev = info.enterInternal();
            if (CompilerDirectives.injectBranchProbability(0.9999, info == context.getCachedThread())) {
                try {
                    info.notifyEnter(this, context);
                }
                catch (Throwable e) {
                    info.leaveInternal(prev);
                    throw e;
                }
                return prev;
            }
            info.leaveInternal(prev);
            enterReverted = true;
        }
        prev = context.enterThreadChanged(true, enterReverted, pollSafepoint, false);
        assert (PolyglotEngineImpl.verifyContext(context));
        return prev;
    }

    private static boolean verifyContext(PolyglotContextImpl context) {
        PolyglotContextImpl.State localState = context.state;
        return context == PolyglotFastThreadLocals.getContext(null) || localState.isInvalidOrClosed();
    }

    void leave(Object[] prev, PolyglotContextImpl context) {
        if (CompilerDirectives.isPartialEvaluationConstant(this)) {
            this.leaveCached(prev, context);
        } else {
            this.leaveBoundary(prev, context);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void leaveBoundary(Object[] prev, PolyglotContextImpl context) {
        this.leaveCached(prev, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveCached(Object[] prev, PolyglotContextImpl context) {
        assert (context.state.isClosed() || PolyglotFastThreadLocals.getContext(null) == context) : "Cannot leave context that is currently not entered. Forgot to enter or leave a context?";
        boolean entered = true;
        PolyglotThreadInfo info = context.getCachedThread();
        if (CompilerDirectives.injectBranchProbability(0.75, info.getThread() == Thread.currentThread())) {
            try {
                info.notifyLeave(this, context);
            }
            finally {
                info.leaveInternal(prev);
                entered = false;
            }
            if (CompilerDirectives.injectBranchProbability(0.9999, info == context.getCachedThread())) {
                return;
            }
        }
        context.leaveThreadChanged(prev, true, entered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotLocals.LocalLocation[] addContextLocals(List<? extends PolyglotLocals.AbstractContextLocal<?>> newLocals) {
        PolyglotLocals.LocalLocation[] newLocations;
        StableLocalLocations newStableLocations;
        List<PolyglotContextImpl> aliveContexts;
        Iterator<PolyglotContextImpl> iterator = this.lock;
        synchronized (iterator) {
            StableLocalLocations stableLocations = this.contextLocalLocations;
            int index = stableLocations.locations.length;
            PolyglotLocals.LocalLocation[] locationsCopy = Arrays.copyOf(stableLocations.locations, stableLocations.locations.length + newLocals.size());
            for (PolyglotLocals.AbstractContextLocal<?> newLocal : newLocals) {
                locationsCopy[index] = newLocal.createLocation(index);
                newLocal.initializeLocation(locationsCopy[index]);
                ++index;
            }
            aliveContexts = this.collectAliveContexts();
            this.contextLocalLocations = newStableLocations = new StableLocalLocations(locationsCopy);
            stableLocations.assumption.invalidate("Context local added");
            newLocations = Arrays.copyOfRange(locationsCopy, stableLocations.locations.length, index);
        }
        iterator = aliveContexts.iterator();
        while (iterator.hasNext()) {
            PolyglotContextImpl context;
            PolyglotContextImpl polyglotContextImpl = context = iterator.next();
            synchronized (polyglotContextImpl) {
                if (context.localsCleared) {
                    continue;
                }
                context.resizeContextLocals(newStableLocations);
            }
        }
        return newLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotLocals.LocalLocation[] addContextThreadLocals(List<? extends PolyglotLocals.AbstractContextThreadLocal<?>> newLocals) {
        PolyglotLocals.LocalLocation[] newLocations;
        StableLocalLocations newStableLocations;
        List<PolyglotContextImpl> aliveContexts;
        Iterator<PolyglotContextImpl> iterator = this.lock;
        synchronized (iterator) {
            StableLocalLocations stableLocations = this.contextThreadLocalLocations;
            int index = stableLocations.locations.length;
            PolyglotLocals.LocalLocation[] locationsCopy = Arrays.copyOf(stableLocations.locations, stableLocations.locations.length + newLocals.size());
            for (PolyglotLocals.AbstractContextThreadLocal<?> newLocal : newLocals) {
                locationsCopy[index] = newLocal.createLocation(index);
                newLocal.initializeLocation(locationsCopy[index]);
                ++index;
            }
            aliveContexts = this.collectAliveContexts();
            this.contextThreadLocalLocations = newStableLocations = new StableLocalLocations(locationsCopy);
            stableLocations.assumption.invalidate("Context thread local added");
            newLocations = Arrays.copyOfRange(locationsCopy, stableLocations.locations.length, index);
        }
        iterator = aliveContexts.iterator();
        while (iterator.hasNext()) {
            PolyglotContextImpl context;
            PolyglotContextImpl polyglotContextImpl = context = iterator.next();
            synchronized (polyglotContextImpl) {
                if (context.localsCleared) {
                    continue;
                }
                context.resizeContextThreadLocals(newStableLocations);
            }
        }
        return newLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PolyglotEngineImpl getFallbackEngine() {
        if (fallbackEngine != null) return fallbackEngine;
        Class<PolyglotImpl> clazz = PolyglotImpl.class;
        synchronized (PolyglotImpl.class) {
            if (fallbackEngine != null) return fallbackEngine;
            fallbackEngine = PolyglotImpl.getInstance().createDefaultEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fallbackEngine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetFallbackEngine() {
        Class<PolyglotImpl> clazz = PolyglotImpl.class;
        synchronized (PolyglotImpl.class) {
            if (fallbackEngine != null) {
                fallbackEngine.ensureClosed(false);
                fallbackEngine = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    String getVersion() {
        String version = HomeFinder.getInstance().getVersion();
        if (version.equals("snapshot")) {
            return "Development Build";
        }
        return version;
    }

    static {
        boolean createProcess = true;
        boolean environmentAccess = true;
        boolean io = true;
        String[] stringArray = DISABLED_PRIVILEGES;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String privilege;
            switch (privilege = stringArray[i]) {
                case "createProcess": {
                    createProcess = false;
                    continue block10;
                }
                case "environmentAccess": {
                    environmentAccess = false;
                    continue block10;
                }
                case "io": {
                    io = false;
                    continue block10;
                }
                default: {
                    throw new Error("Invalid privilege name for DisablePrivileges: " + privilege);
                }
            }
        }
        ALLOW_CREATE_PROCESS = createProcess;
        ALLOW_ENVIRONMENT_ACCESS = environmentAccess;
        ALLOW_IO = io;
        NO_ENTER = new Object();
    }

    private static final class UncachedLocationNode
    extends HostToGuestRootNode {
        UncachedLocationNode(TruffleLanguage<?> hostLanguage) {
            super(hostLanguage);
        }

        @Override
        protected Class<?> getReceiverType() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        protected Object executeImpl(PolyglotLanguageContext languageContext, Object receiver, Object[] args) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public boolean isInternal() {
            return true;
        }
    }

    static final class StableLocalLocations {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final PolyglotLocals.LocalLocation[] locations;
        final Assumption assumption = Truffle.getRuntime().createAssumption();

        StableLocalLocations(PolyglotLocals.LocalLocation[] locations) {
            this.locations = locations;
        }
    }

    static final class LogConfig {
        final Map<String, Level> logLevels = new HashMap<String, Level>();
        String logFile;

        LogConfig() {
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class InterruptExecution
    extends AbstractTruffleException {
        private static final long serialVersionUID = 8652484189010224048L;

        InterruptExecution(Node location) {
            super("Execution got interrupted.", location);
        }

        @ExportMessage
        ExceptionType getExceptionType() {
            return ExceptionType.INTERRUPT;
        }
    }

    static final class CancelExecution
    extends ThreadDeath {
        private final Node location;
        private final String cancelMessage;
        private final boolean resourceLimit;

        CancelExecution(Node location, String cancelMessage, boolean resourceLimit) {
            this.location = location;
            this.cancelMessage = cancelMessage;
            this.resourceLimit = resourceLimit;
        }

        Node getLocation() {
            return this.location;
        }

        SourceSection getSourceLocation() {
            return this.location == null ? null : this.location.getEncapsulatingSourceSection();
        }

        public boolean isResourceLimit() {
            return this.resourceLimit;
        }

        @Override
        public String getMessage() {
            if (this.cancelMessage == null) {
                return "Execution got cancelled.";
            }
            return this.cancelMessage;
        }
    }

    private static final class PolyglotShutDownHook
    implements Runnable {
        private PolyglotShutDownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PolyglotEngineImpl[] engines;
            PolyglotEngineImpl[] polyglotEngineImplArray = ENGINES;
            synchronized (polyglotEngineImplArray) {
                engines = ENGINES.keySet().toArray(new PolyglotEngineImpl[0]);
            }
            for (PolyglotEngineImpl engine : engines) {
                if (DEBUG_MISSING_CLOSE) {
                    PrintStream out = System.out;
                    out.println("Missing close on vm shutdown: ");
                    out.print(" InitializedLanguages:");
                    Object object = engine.lock;
                    synchronized (object) {
                        for (PolyglotContextImpl context : engine.collectAliveContexts()) {
                            for (PolyglotLanguageContext langContext : context.contexts) {
                                if (langContext.env == null) continue;
                                out.print(langContext.language.getId());
                                out.print(", ");
                            }
                        }
                    }
                    out.println();
                    engine.createdLocation.printStackTrace();
                }
                if (engine == null) continue;
                for (PolyglotInstrument instrumentImpl : engine.idToInstrument.values()) {
                    try {
                        instrumentImpl.ensureFinalized();
                    }
                    catch (Throwable e) {
                        engine.getEngineLogger().log(Level.WARNING, "Instrument " + instrumentImpl.getName() + " threw an exception during onFinalize.", e);
                    }
                }
                Object object = engine.lock;
                synchronized (object) {
                    if (engine.logHandler != null) {
                        engine.logHandler.flush();
                    }
                }
            }
        }
    }
}

