/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.options.OptionValues;

final class PolyglotThread
extends Thread {
    private final PolyglotLanguageContext languageContext;
    PolyglotContextImpl context;
    final CallTarget callTarget;
    private static final AtomicInteger THREAD_INIT_NUMBER = new AtomicInteger(0);

    PolyglotThread(PolyglotLanguageContext languageContext, Runnable runnable, ThreadGroup group, long stackSize) {
        super(group, runnable, PolyglotThread.createDefaultName(languageContext), stackSize);
        this.languageContext = languageContext;
        this.setUncaughtExceptionHandler(languageContext.getPolyglotExceptionHandler());
        this.callTarget = ThreadSpawnRootNode.lookup(languageContext.getLanguageInstance());
    }

    PolyglotThread(PolyglotLanguageContext languageContext, Runnable runnable, ThreadGroup group) {
        this(languageContext, runnable, group, 0L);
    }

    PolyglotThread(PolyglotLanguageContext languageContext, Runnable runnable) {
        this(languageContext, runnable, null, 0L);
    }

    private static String createDefaultName(PolyglotLanguageContext creator) {
        return "Polyglot-" + creator.language.getId() + "-" + THREAD_INIT_NUMBER.getAndIncrement();
    }

    boolean isOwner(PolyglotContextImpl testContext) {
        return this.languageContext.context == testContext;
    }

    @Override
    public void run() {
        this.callTarget.call(this.languageContext, this, new PolyglotThreadRunnable(){

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute() {
                PolyglotThread.super.run();
            }
        });
    }

    static final class ThreadSpawnRootNode
    extends RootNode {
        ThreadSpawnRootNode(PolyglotLanguageInstance languageInstance) {
            super(languageInstance.spi);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] args = frame.getArguments();
            return ThreadSpawnRootNode.executeImpl((PolyglotLanguageContext)args[0], (PolyglotThread)args[1], (PolyglotThreadRunnable)args[2]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private static Object executeImpl(PolyglotLanguageContext languageContext, PolyglotThread thread, PolyglotThreadRunnable run) {
            PolyglotContextImpl prev = languageContext.enterThread(thread);
            assert (prev == null);
            try {
                run.execute();
            }
            catch (PolyglotEngineImpl.CancelExecution cancel) {
                if (((Boolean)PolyglotEngineOptions.TriggerUncaughtExceptionHandlerForCancel.getValue((OptionValues)languageContext.context.engine.getEngineOptionValues())).booleanValue()) {
                    throw cancel;
                }
                Object var5_5 = null;
                return var5_5;
            }
            finally {
                languageContext.leaveAndDisposePolyglotThread(prev, thread);
            }
            return null;
        }

        @Override
        public boolean isInternal() {
            return true;
        }

        public static CallTarget lookup(PolyglotLanguageInstance languageInstance) {
            CallTarget target = languageInstance.lookupCallTarget(ThreadSpawnRootNode.class);
            if (target == null) {
                target = languageInstance.installCallTarget(new ThreadSpawnRootNode(languageInstance));
            }
            return target;
        }
    }

    private static interface PolyglotThreadRunnable {
        public void execute();
    }
}

