/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.memory;

import com.oracle.truffle.api.memory.ByteArraySupport;

final class ReversedByteArraySupport
extends ByteArraySupport {
    final ByteArraySupport access;

    ReversedByteArraySupport(ByteArraySupport access) {
        this.access = access;
    }

    @Override
    public byte getByte(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return this.access.getByte(buffer, index);
    }

    @Override
    public void putByte(byte[] buffer, int index, byte value) throws IndexOutOfBoundsException {
        this.access.putByte(buffer, index, value);
    }

    @Override
    public short getShort(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getShort(buffer, index));
    }

    @Override
    public void putShort(byte[] buffer, int index, short value) throws IndexOutOfBoundsException {
        this.access.putShort(buffer, index, Short.reverseBytes(value));
    }

    @Override
    public int getInt(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getInt(buffer, index));
    }

    @Override
    public void putInt(byte[] buffer, int index, int value) throws IndexOutOfBoundsException {
        this.access.putInt(buffer, index, Integer.reverseBytes(value));
    }

    @Override
    public long getLong(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getLong(buffer, index));
    }

    @Override
    public void putLong(byte[] buffer, int index, long value) throws IndexOutOfBoundsException {
        this.access.putLong(buffer, index, Long.reverseBytes(value));
    }

    @Override
    public float getFloat(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(Integer.reverseBytes(this.access.getInt(buffer, index)));
    }

    @Override
    public void putFloat(byte[] buffer, int index, float value) throws IndexOutOfBoundsException {
        this.access.putInt(buffer, index, Integer.reverseBytes(Float.floatToIntBits(value)));
    }

    @Override
    public double getDouble(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(Long.reverseBytes(this.access.getLong(buffer, index)));
    }

    @Override
    public void putDouble(byte[] buffer, int index, double value) throws IndexOutOfBoundsException {
        this.access.putLong(buffer, index, Long.reverseBytes(Double.doubleToLongBits(value)));
    }
}

