// CheckStyle: start generated
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.DynamicObjectLibraryImpl;
import com.oracle.truffle.object.DynamicObjectLibraryImpl.MakeSharedNode;
import com.oracle.truffle.object.DynamicObjectLibraryImpl.ResetShapeNode;
import com.oracle.truffle.object.DynamicObjectLibraryImpl.SetDynamicTypeNode;
import com.oracle.truffle.object.DynamicObjectLibraryImpl.SetFlagsNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(DynamicObjectLibraryImpl.class)
final class DynamicObjectLibraryImplFactory {

    @GeneratedBy(SetFlagsNode.class)
    static final class SetFlagsNodeGen extends SetFlagsNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private SetFlagsNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(DynamicObject arg0Value, Shape arg1Value, int arg2Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(DynamicObject, Shape, int, int, Shape) || doUncached(DynamicObject, Shape, int) */) {
                if ((state & 0b1) != 0 /* is-active doCached(DynamicObject, Shape, int, int, Shape) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg2Value == s1_.newFlags_)) {
                            return SetFlagsNode.doCached(arg0Value, arg1Value, arg2Value, s1_.newFlags_, s1_.newShape_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(DynamicObject, Shape, int) */) {
                    return SetFlagsNode.doUncached(arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private boolean executeAndSpecialize(DynamicObject arg0Value, Shape arg1Value, int arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(DynamicObject, Shape, int, int, Shape) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(DynamicObject, Shape, int, int, Shape) */) {
                        while (s1_ != null) {
                            if ((arg2Value == s1_.newFlags_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg2Value == s1_.newFlags_);
                        if (count1_ < (3)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.newFlags_ = (arg2Value);
                            s1_.newShape_ = (SetFlagsNode.shapeSetFlags(arg1Value, s1_.newFlags_));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(DynamicObject, Shape, int, int, Shape) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return SetFlagsNode.doCached(arg0Value, arg1Value, arg2Value, s1_.newFlags_, s1_.newShape_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(DynamicObject, Shape, int, int, Shape) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(DynamicObject, Shape, int, int, Shape) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(DynamicObject, Shape, int) */;
                lock.unlock();
                hasLock = false;
                return SetFlagsNode.doUncached(arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SetFlagsNode create() {
            return new SetFlagsNodeGen();
        }

        public static SetFlagsNode getUncached() {
            return SetFlagsNodeGen.UNCACHED;
        }

        @GeneratedBy(SetFlagsNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int newFlags_;
            @CompilationFinal Shape newShape_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(SetFlagsNode.class)
        private static final class Uncached extends SetFlagsNode {

            @TruffleBoundary
            @Override
            boolean execute(DynamicObject arg0Value, Shape arg1Value, int arg2Value) {
                return SetFlagsNode.doUncached(arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(SetDynamicTypeNode.class)
    static final class SetDynamicTypeNodeGen extends SetDynamicTypeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private SetDynamicTypeNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(DynamicObject arg0Value, Shape arg1Value, Object arg2Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(DynamicObject, Shape, Object, Object, Shape) || doUncached(DynamicObject, Shape, Object) */) {
                if ((state & 0b1) != 0 /* is-active doCached(DynamicObject, Shape, Object, Object, Shape) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg2Value == s1_.newObjectType_)) {
                            return SetDynamicTypeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.newObjectType_, s1_.newShape_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(DynamicObject, Shape, Object) */) {
                    return SetDynamicTypeNode.doUncached(arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private boolean executeAndSpecialize(DynamicObject arg0Value, Shape arg1Value, Object arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(DynamicObject, Shape, Object, Object, Shape) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(DynamicObject, Shape, Object, Object, Shape) */) {
                        while (s1_ != null) {
                            if ((arg2Value == s1_.newObjectType_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg2Value == s1_.newObjectType_);
                        if (count1_ < (3)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.newObjectType_ = (arg2Value);
                            s1_.newShape_ = (SetDynamicTypeNode.shapeSetDynamicType(arg1Value, s1_.newObjectType_));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(DynamicObject, Shape, Object, Object, Shape) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return SetDynamicTypeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.newObjectType_, s1_.newShape_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(DynamicObject, Shape, Object, Object, Shape) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(DynamicObject, Shape, Object, Object, Shape) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(DynamicObject, Shape, Object) */;
                lock.unlock();
                hasLock = false;
                return SetDynamicTypeNode.doUncached(arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SetDynamicTypeNode create() {
            return new SetDynamicTypeNodeGen();
        }

        public static SetDynamicTypeNode getUncached() {
            return SetDynamicTypeNodeGen.UNCACHED;
        }

        @GeneratedBy(SetDynamicTypeNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal Object newObjectType_;
            @CompilationFinal Shape newShape_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(SetDynamicTypeNode.class)
        private static final class Uncached extends SetDynamicTypeNode {

            @TruffleBoundary
            @Override
            boolean execute(DynamicObject arg0Value, Shape arg1Value, Object arg2Value) {
                return SetDynamicTypeNode.doUncached(arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(MakeSharedNode.class)
    static final class MakeSharedNodeGen extends MakeSharedNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private Shape newShape_;

        private MakeSharedNodeGen() {
        }

        @Override
        void execute(DynamicObject arg0Value, Shape arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(DynamicObject, Shape, Shape) */) {
                MakeSharedNode.doCached(arg0Value, arg1Value, this.newShape_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(DynamicObject arg0Value, Shape arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                this.newShape_ = (arg1Value.makeSharedShape());
                this.state_ = state = state | 0b1 /* add-active doCached(DynamicObject, Shape, Shape) */;
                lock.unlock();
                hasLock = false;
                MakeSharedNode.doCached(arg0Value, arg1Value, this.newShape_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static MakeSharedNode create() {
            return new MakeSharedNodeGen();
        }

        public static MakeSharedNode getUncached() {
            return MakeSharedNodeGen.UNCACHED;
        }

        @GeneratedBy(MakeSharedNode.class)
        private static final class Uncached extends MakeSharedNode {

            @TruffleBoundary
            @Override
            void execute(DynamicObject arg0Value, Shape arg1Value) {
                MakeSharedNode.doCached(arg0Value, arg1Value, (arg1Value.makeSharedShape()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ResetShapeNode.class)
    static final class ResetShapeNodeGen extends ResetShapeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private CachedData cached_cache;

        private ResetShapeNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(DynamicObject arg0Value, Shape arg1Value, Shape arg2Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(DynamicObject, Shape, Shape, Shape) */) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if ((arg2Value == s1_.cachedOtherShape_)) {
                        return ResetShapeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedOtherShape_);
                    }
                    s1_ = s1_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private boolean executeAndSpecialize(DynamicObject arg0Value, Shape arg1Value, Shape arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if (state != 0 /* is-active doCached(DynamicObject, Shape, Shape, Shape) */) {
                    while (s1_ != null) {
                        if ((arg2Value == s1_.cachedOtherShape_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    {
                        Shape cachedOtherShape__ = (ResetShapeNode.verifyResetShape(arg1Value, arg2Value));
                        if ((arg2Value == cachedOtherShape__) && count1_ < (3)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.cachedOtherShape_ = cachedOtherShape__;
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(DynamicObject, Shape, Shape, Shape) */;
                        }
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return ResetShapeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedOtherShape_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ResetShapeNode create() {
            return new ResetShapeNodeGen();
        }

        public static ResetShapeNode getUncached() {
            return ResetShapeNodeGen.UNCACHED;
        }

        @GeneratedBy(ResetShapeNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal Shape cachedOtherShape_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ResetShapeNode.class)
        private static final class Uncached extends ResetShapeNode {

            @TruffleBoundary
            @Override
            boolean execute(DynamicObject arg0Value, Shape arg1Value, Shape arg2Value) {
                if ((arg2Value == (ResetShapeNode.verifyResetShape(arg1Value, arg2Value)))) {
                    return ResetShapeNode.doCached(arg0Value, arg1Value, arg2Value, (ResetShapeNode.verifyResetShape(arg1Value, arg2Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
