/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Set;
import java.util.concurrent.locks.Lock;

final class NodeAccessor
extends Accessor {
    static final NodeAccessor ACCESSOR = new NodeAccessor();

    private NodeAccessor() {
    }

    @Override
    protected ThreadLocal<Object> createFastThreadLocal() {
        return super.createFastThreadLocal();
    }

    @Override
    protected void onLoopCount(Node source, int iterations) {
        super.onLoopCount(source, iterations);
    }

    @Override
    protected IndirectCallNode createUncachedIndirectCall() {
        IndirectCallNode callNode = super.createUncachedIndirectCall();
        assert (!callNode.isAdoptable());
        return callNode;
    }

    @Override
    protected <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return super.createBlockNode(elements, executor);
    }

    static final class AccessNodes
    extends Accessor.NodeSupport {
        AccessNodes() {
        }

        @Override
        public boolean isInstrumentable(RootNode rootNode) {
            return rootNode.isInstrumentable();
        }

        @Override
        public void setCallTarget(RootNode rootNode, RootCallTarget callTarget) {
            rootNode.setCallTarget(callTarget);
        }

        @Override
        public boolean isTaggedWith(Node node, Class<?> tag) {
            return node.isTaggedWith(tag);
        }

        @Override
        public boolean isCloneUninitializedSupported(RootNode rootNode) {
            return rootNode.isCloneUninitializedSupported();
        }

        @Override
        public RootNode cloneUninitialized(RootNode rootNode) {
            return rootNode.cloneUninitialized();
        }

        @Override
        public int adoptChildrenAndCount(RootNode rootNode) {
            return rootNode.adoptChildrenAndCount();
        }

        @Override
        public Object getPolyglotLanguage(LanguageInfo languageInfo) {
            return languageInfo.getPolyglotLanguage();
        }

        @Override
        public LanguageInfo createLanguage(Object polyglotLanguage, String id, String name, String version, String defaultMimeType, Set<String> mimeTypes, boolean internal, boolean interactive) {
            return new LanguageInfo(polyglotLanguage, id, name, version, defaultMimeType, mimeTypes, internal, interactive);
        }

        @Override
        public Object getPolyglotEngine(RootNode rootNode) {
            return rootNode.polyglotEngine;
        }

        @Override
        public TruffleLanguage<?> getLanguage(RootNode rootNode) {
            return rootNode.language;
        }

        @Override
        public int getRootNodeBits(RootNode root) {
            return root.instrumentationBits;
        }

        @Override
        public void setRootNodeBits(RootNode root, int bits) {
            assert ((byte)bits == bits) : "root bits currently limit to a byte";
            root.instrumentationBits = (byte)bits;
        }

        @Override
        public Lock getLock(Node node) {
            return node.getLock();
        }

        @Override
        public void clearPolyglotEngine(RootNode rootNode) {
            rootNode.polyglotEngine = null;
        }

        @Override
        public void applyPolyglotEngine(RootNode from, RootNode to) {
            to.polyglotEngine = from.polyglotEngine;
        }
    }
}

