/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.polyglot.PolyglotException;

public final class TruffleStackTrace
extends Exception {
    private static final TruffleStackTrace EMPTY = new TruffleStackTrace(Collections.emptyList(), 0);
    private List<TruffleStackTraceElement> frames;
    private final int lazyFrames;
    private Exception materializedHostException;

    private TruffleStackTrace(List<TruffleStackTraceElement> frames, int lazyFrames) {
        this.frames = frames;
        this.lazyFrames = lazyFrames;
    }

    private void materializeHostException() {
        if (this.materializedHostException == null) {
            this.materializedHostException = new Exception();
        }
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    StackTraceElement[] getInternalStackTrace() {
        Exception hostException = this.materializedHostException;
        if (hostException == null) {
            hostException = this;
        }
        StackTraceElement[] hostFrames = hostException.getStackTrace();
        if (this.lazyFrames == 0) {
            return hostFrames;
        }
        StackTraceElement[] extended = new StackTraceElement[hostFrames.length + this.lazyFrames];
        System.arraycopy(hostFrames, 0, extended, this.lazyFrames, hostFrames.length);
        return extended;
    }

    @Override
    public String toString() {
        return "Attached Guest Language Frames (" + this.frames.size() + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleStackTraceElement> getStackTrace(Throwable throwable) {
        TruffleStackTrace stack = TruffleStackTrace.fillIn(throwable);
        if (stack != null) {
            return stack.frames;
        }
        return null;
    }

    static void materializeHostFrames(Throwable t) {
        TruffleStackTrace stack = TruffleStackTrace.fillIn(t);
        if (stack != null) {
            stack.materializeHostException();
        }
    }

    private static LazyStackTrace findImpl(Throwable t) {
        assert (!(t instanceof ControlFlowException));
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof LazyStackTrace)) continue;
            return (LazyStackTrace)cause;
        }
        return null;
    }

    private static Throwable findInsertCause(Throwable t) {
        Throwable parentCause;
        Throwable lastException = t;
        while (lastException != null && (parentCause = lastException.getCause()) != null) {
            lastException = parentCause;
        }
        if (lastException != null && !(lastException instanceof StackOverflowError)) {
            return lastException;
        }
        return null;
    }

    private static void insert(Throwable t, LazyStackTrace trace) {
        try {
            t.initCause(trace);
        }
        catch (IllegalStateException e) {
            CompilerDirectives.transferToInterpreter();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleStackTrace fillIn(Throwable throwable) {
        int stackFrameLimit;
        Node topCallSite;
        if (throwable instanceof ControlFlowException) {
            return EMPTY;
        }
        LazyStackTrace lazy = TruffleStackTrace.findImpl(throwable);
        if (lazy == null) {
            Throwable insertCause = TruffleStackTrace.findInsertCause(throwable);
            if (insertCause == null) {
                return null;
            }
            lazy = new LazyStackTrace();
            TruffleStackTrace.insert(insertCause, lazy);
        }
        if (lazy.stackTrace != null) {
            return lazy.stackTrace;
        }
        if (throwable instanceof TruffleException) {
            TruffleException te = (TruffleException)((Object)throwable);
            topCallSite = te.getLocation();
            stackFrameLimit = te.getStackTraceElementLimit();
        } else {
            topCallSite = null;
            stackFrameLimit = -1;
        }
        ArrayList<TracebackElement> elements = new ArrayList<TracebackElement>();
        TracebackElement currentElement = lazy.current;
        while (currentElement != null) {
            elements.add(currentElement);
            currentElement = currentElement.last;
        }
        Collections.reverse(elements);
        ArrayList<TruffleStackTraceElement> frames = new ArrayList<TruffleStackTraceElement>();
        for (TracebackElement element : elements) {
            if (element.root != null) {
                frames.add(new TruffleStackTraceElement(topCallSite, element.root, element.frame));
                topCallSite = null;
            }
            if (element.callNode == null) continue;
            topCallSite = element.callNode;
        }
        int lazyFrames = frames.size();
        TruffleStackTrace.addStackFrames(stackFrameLimit, lazyFrames, topCallSite, frames);
        return lazy.stackTrace = new TruffleStackTrace(frames, lazyFrames);
    }

    static void addStackFrameInfo(Node callNode, RootCallTarget root, Throwable t, Frame currentFrame) {
        if (t instanceof ControlFlowException) {
            return;
        }
        if (t instanceof PolyglotException) {
            return;
        }
        boolean isTProfiled = CompilerDirectives.isPartialEvaluationConstant(t.getClass());
        if (currentFrame != null && root.getRootNode().isCaptureFramesForTrace()) {
            TruffleStackTrace.callInnerAddStackFrameInfo(isTProfiled, callNode, root, t, currentFrame.materialize());
        } else {
            TruffleStackTrace.callInnerAddStackFrameInfo(isTProfiled, callNode, root, t, null);
        }
    }

    private static void callInnerAddStackFrameInfo(boolean isTProfiled, Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        if (isTProfiled) {
            TruffleStackTrace.innerAddStackFrameInfo(callNode, root, t, currentFrame);
        } else {
            TruffleStackTrace.innerAddStackFrameInfoBoundary(callNode, root, t, currentFrame);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void innerAddStackFrameInfoBoundary(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        TruffleStackTrace.innerAddStackFrameInfo(callNode, root, t, currentFrame);
    }

    private static void innerAddStackFrameInfo(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        LazyStackTrace lazy;
        if (!(t instanceof TruffleException) || ((TruffleException)((Object)t)).isInternalError()) {
            TruffleStackTrace.fillIn(t);
            return;
        }
        int stackTraceElementLimit = ((TruffleException)((Object)t)).getStackTraceElementLimit();
        Throwable cause = t.getCause();
        if (cause == null) {
            lazy = new LazyStackTrace();
            TruffleStackTrace.insert(t, lazy);
        } else if (cause instanceof LazyStackTrace) {
            lazy = (LazyStackTrace)cause;
        } else {
            TruffleStackTrace.addStackFrameInfoSlowPath(callNode, root, cause, currentFrame, stackTraceElementLimit);
            return;
        }
        TruffleStackTrace.appendLazyStackTrace(callNode, root, currentFrame, lazy, stackTraceElementLimit);
    }

    @CompilerDirectives.TruffleBoundary
    private static void addStackFrameInfoSlowPath(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame, int stackTraceElementLimit) {
        LazyStackTrace lazy = TruffleStackTrace.findImpl(t);
        if (lazy == null) {
            Throwable insertCause = TruffleStackTrace.findInsertCause(t);
            if (insertCause == null) {
                return;
            }
            lazy = new LazyStackTrace();
            TruffleStackTrace.insert(insertCause, lazy);
        }
        TruffleStackTrace.appendLazyStackTrace(callNode, root, currentFrame, lazy, stackTraceElementLimit);
    }

    private static void appendLazyStackTrace(Node callNode, RootCallTarget root, MaterializedFrame currentFrame, LazyStackTrace lazy, int stackTraceElementLimit) {
        if (lazy.stackTrace == null) {
            if (stackTraceElementLimit >= 0 && lazy.frameCount >= stackTraceElementLimit) {
                return;
            }
            lazy.current = new TracebackElement(lazy.current, callNode, root, currentFrame);
            if (root != null && !root.getRootNode().isInternal()) {
                ++lazy.frameCount;
            }
        }
    }

    private static void addStackFrames(final int stackFrameLimit, final int lazyFrames, final Node topCallSite, final List<TruffleStackTraceElement> frames) {
        if (stackFrameLimit >= 0 && lazyFrames >= stackFrameLimit) {
            return;
        }
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){
            boolean first = true;
            int stackFrameIndex = lazyFrames;

            @Override
            public FrameInstance visitFrame(FrameInstance frameInstance) {
                if (stackFrameLimit >= 0 && this.stackFrameIndex >= stackFrameLimit) {
                    return frameInstance;
                }
                Node location = frameInstance.getCallNode();
                RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
                if (this.first) {
                    location = topCallSite;
                    this.first = false;
                }
                boolean captureFrames = target != null && target.getRootNode().isCaptureFramesForTrace();
                Frame frame = captureFrames ? frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY) : null;
                frames.add(new TruffleStackTraceElement(location, target, frame));
                this.first = false;
                if (target != null && !target.getRootNode().isInternal()) {
                    ++this.stackFrameIndex;
                }
                return null;
            }
        });
    }

    static final class LazyStackTrace
    extends Throwable {
        private TracebackElement current;
        private TruffleStackTrace stackTrace;
        public int frameCount;

        LazyStackTrace() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }

        public TruffleStackTrace getInternalStackTrace() {
            return this.stackTrace;
        }

        @Override
        public Throwable initCause(Throwable cause) {
            throw new IllegalAccessError("cannot change cause of TruffleException stacktrace");
        }

        @Override
        public String toString() {
            return "Attached Guest Language Frames (" + (this.frameCount + (this.stackTrace != null ? this.stackTrace.frames.size() : 0)) + ")";
        }
    }

    private static final class TracebackElement {
        private final TracebackElement last;
        private final Node callNode;
        private final RootCallTarget root;
        private final MaterializedFrame frame;

        TracebackElement(TracebackElement last, Node callNode, RootCallTarget root, MaterializedFrame frame) {
            this.last = last;
            this.callNode = callNode;
            this.root = root;
            this.frame = frame;
        }
    }
}

