/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.AsPointer;
import com.oracle.truffle.api.interop.Execute;
import com.oracle.truffle.api.interop.GetSize;
import com.oracle.truffle.api.interop.HasKeys;
import com.oracle.truffle.api.interop.HasSize;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.Invoke;
import com.oracle.truffle.api.interop.IsBoxed;
import com.oracle.truffle.api.interop.IsExecutable;
import com.oracle.truffle.api.interop.IsInstantiable;
import com.oracle.truffle.api.interop.IsNull;
import com.oracle.truffle.api.interop.IsPointer;
import com.oracle.truffle.api.interop.KeyInfoMsg;
import com.oracle.truffle.api.interop.Keys;
import com.oracle.truffle.api.interop.KnownMessage;
import com.oracle.truffle.api.interop.LegacyToLibraryNode;
import com.oracle.truffle.api.interop.New;
import com.oracle.truffle.api.interop.Read;
import com.oracle.truffle.api.interop.Remove;
import com.oracle.truffle.api.interop.ToNative;
import com.oracle.truffle.api.interop.Unbox;
import com.oracle.truffle.api.interop.Write;
import com.oracle.truffle.api.nodes.Node;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
public abstract class Message {
    @Deprecated
    public static final Message READ = Read.INSTANCE;
    @Deprecated
    public static final Message UNBOX = Unbox.INSTANCE;
    @Deprecated
    public static final Message WRITE = Write.INSTANCE;
    @Deprecated
    public static final Message REMOVE = Remove.INSTANCE;
    @Deprecated
    public static final Message EXECUTE = Execute.INSTANCE;
    @Deprecated
    public static final Message IS_EXECUTABLE = IsExecutable.INSTANCE;
    @Deprecated
    public static final Message IS_INSTANTIABLE = IsInstantiable.INSTANCE;
    @Deprecated
    public static final Message INVOKE = Invoke.INSTANCE;
    @Deprecated
    public static final Message NEW = New.INSTANCE;
    @Deprecated
    public static final Message IS_NULL = IsNull.INSTANCE;
    @Deprecated
    public static final Message HAS_SIZE = HasSize.INSTANCE;
    @Deprecated
    public static final Message GET_SIZE = GetSize.INSTANCE;
    @Deprecated
    public static final Message IS_BOXED = IsBoxed.INSTANCE;
    @Deprecated
    public static final Message KEY_INFO = KeyInfoMsg.INSTANCE;
    @Deprecated
    public static final Message HAS_KEYS = HasKeys.INSTANCE;
    @Deprecated
    public static final Message KEYS = Keys.INSTANCE;
    @Deprecated
    public static final Message IS_POINTER = IsPointer.INSTANCE;
    @Deprecated
    public static final Message AS_POINTER = AsPointer.INSTANCE;
    @Deprecated
    public static final Message TO_NATIVE = ToNative.INSTANCE;
    InteropAccessNode uncached;
    private static final Map<String, Message> CLASS_TO_MESSAGE = new ConcurrentHashMap<String, Message>();

    protected Message() {
        Message.registerClass(this);
    }

    @Deprecated
    public static Message createExecute(int argumentsLength) {
        return EXECUTE;
    }

    @Deprecated
    public static Message createInvoke(int argumentsLength) {
        return INVOKE;
    }

    @Deprecated
    public static Message createNew(int argumentsLength) {
        return NEW;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Deprecated
    public final Node createNode() {
        CompilerAsserts.neverPartOfCompilation();
        if (this instanceof KnownMessage) {
            return LegacyToLibraryNode.create(this);
        }
        return InteropAccessNode.create(this);
    }

    @Deprecated
    public static String toString(Message message) {
        if (READ == message) {
            return "READ";
        }
        if (WRITE == message) {
            return "WRITE";
        }
        if (REMOVE == message) {
            return "REMOVE";
        }
        if (UNBOX == message) {
            return "UNBOX";
        }
        if (GET_SIZE == message) {
            return "GET_SIZE";
        }
        if (HAS_SIZE == message) {
            return "HAS_SIZE";
        }
        if (IS_NULL == message) {
            return "IS_NULL";
        }
        if (IS_BOXED == message) {
            return "IS_BOXED";
        }
        if (IS_EXECUTABLE == message) {
            return "IS_EXECUTABLE";
        }
        if (IS_INSTANTIABLE == message) {
            return "IS_INSTANTIABLE";
        }
        if (HAS_KEYS == message) {
            return "HAS_KEYS";
        }
        if (KEYS == message) {
            return "KEYS";
        }
        if (KEY_INFO == message) {
            return "KEY_INFO";
        }
        if (IS_POINTER == message) {
            return "IS_POINTER";
        }
        if (AS_POINTER == message) {
            return "AS_POINTER";
        }
        if (TO_NATIVE == message) {
            return "TO_NATIVE";
        }
        if (Execute.INSTANCE == message) {
            return "EXECUTE";
        }
        if (Invoke.INSTANCE == message) {
            return "INVOKE";
        }
        if (New.INSTANCE == message) {
            return "NEW";
        }
        return message.getClass().getName();
    }

    public static Message valueOf(String messageId) {
        Message instance;
        switch (messageId) {
            case "READ": {
                return READ;
            }
            case "WRITE": {
                return WRITE;
            }
            case "REMOVE": {
                return REMOVE;
            }
            case "UNBOX": {
                return UNBOX;
            }
            case "GET_SIZE": {
                return GET_SIZE;
            }
            case "HAS_SIZE": {
                return HAS_SIZE;
            }
            case "IS_NULL": {
                return IS_NULL;
            }
            case "IS_BOXED": {
                return IS_BOXED;
            }
            case "IS_EXECUTABLE": {
                return IS_EXECUTABLE;
            }
            case "IS_INSTANTIABLE": {
                return IS_INSTANTIABLE;
            }
            case "HAS_KEYS": {
                return HAS_KEYS;
            }
            case "KEYS": {
                return KEYS;
            }
            case "KEY_INFO": {
                return KEY_INFO;
            }
            case "IS_POINTER": {
                return IS_POINTER;
            }
            case "AS_POINTER": {
                return AS_POINTER;
            }
            case "TO_NATIVE": {
                return TO_NATIVE;
            }
            case "EXECUTE": {
                return EXECUTE;
            }
            case "NEW": {
                return NEW;
            }
            case "INVOKE": {
                return INVOKE;
            }
        }
        if (!TruffleOptions.AOT) {
            Message.initializeMessageClass(messageId);
        }
        if ((instance = CLASS_TO_MESSAGE.get(messageId)) == null) {
            throw new IllegalArgumentException("Cannot find existing message instance for " + messageId);
        }
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static void initializeMessageClass(String message) throws IllegalArgumentException {
        try {
            ClassLoader l = Message.class.getClassLoader();
            if (l == null) {
                l = ClassLoader.getSystemClassLoader();
            }
            Class.forName(message, false, l).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot find message for " + message, ex);
        }
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        CLASS_TO_MESSAGE.clear();
    }

    @CompilerDirectives.TruffleBoundary
    private static void registerClass(Message message) {
        if (message instanceof KnownMessage) {
            return;
        }
        String key = message.getClass().getName();
        CLASS_TO_MESSAGE.putIfAbsent(key, message);
    }
}

