// CheckStyle: start generated
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.object.DynamicObject.Accepts;
import com.oracle.truffle.api.object.DynamicObject.Dispatch;
import java.util.concurrent.locks.Lock;

@GeneratedBy(DynamicObject.class)
final class DynamicObjectGen {

    static  {
        LibraryExport.register(DynamicObject.class, new DynamicDispatchLibraryExports());
    }

    private DynamicObjectGen() {
    }

    @GeneratedBy(DynamicObject.class)
    private static final class DynamicDispatchLibraryExports extends LibraryExport<DynamicDispatchLibrary> {

        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, DynamicObject.class, false);
        }

        @Override
        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert receiver instanceof DynamicObject;
            return new Uncached(receiver);
        }

        @Override
        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert receiver instanceof DynamicObject;
            return new Cached(receiver);
        }

        @GeneratedBy(DynamicObject.class)
        private static final class Cached extends DynamicDispatchLibrary {

            private final Class<? extends DynamicObject> receiverClass_;
            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @CompilationFinal private Shape cachedShape;
            @CompilationFinal private Class<? extends ObjectType> cachedTypeClass;

            Cached(Object receiver) {
                this.receiverClass_ = ((DynamicObject) receiver).getClass();
            }

            @Override
            public Object cast(Object receiver) {
                return CompilerDirectives.castExact(receiver, receiverClass_);
            }

            @Override
            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_ && accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                DynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b11) != 0 /* is-active doCachedShape(DynamicObject, Shape) || doCachedTypeClass(DynamicObject, Class<? extends ObjectType>) */) {
                    if ((state & 0b1) != 0 /* is-active doCachedShape(DynamicObject, Shape) */) {
                        if ((this.cachedShape == arg0Value.getShape())) {
                            return Accepts.doCachedShape(arg0Value, this.cachedShape);
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCachedTypeClass(DynamicObject, Class<? extends ObjectType>) */) {
                        return Accepts.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return acceptsAndSpecialize(arg0Value);
            }

            private boolean acceptsAndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doCachedShape(DynamicObject, Shape) */) {
                        boolean CachedShape_duplicateFound_ = false;
                        if ((state & 0b1) != 0 /* is-active doCachedShape(DynamicObject, Shape) */) {
                            if ((this.cachedShape == arg0Value.getShape())) {
                                CachedShape_duplicateFound_ = true;
                            }
                        }
                        if (!CachedShape_duplicateFound_) {
                            {
                                Shape accepts_cachedShape_cachedShape__ = (arg0Value.getShape());
                                if ((accepts_cachedShape_cachedShape__ == arg0Value.getShape()) && ((state & 0b1)) == 0 /* is-not-active doCachedShape(DynamicObject, Shape) */) {
                                    if (this.cachedShape == null) {
                                        this.cachedShape = accepts_cachedShape_cachedShape__;
                                    }
                                    this.state_ = state = state | 0b1 /* add-active doCachedShape(DynamicObject, Shape) */;
                                    CachedShape_duplicateFound_ = true;
                                }
                            }
                        }
                        if (CachedShape_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            return Accepts.doCachedShape(arg0Value, this.cachedShape);
                        }
                    }
                    if (this.cachedTypeClass == null) {
                        this.cachedTypeClass = (arg0Value.getShape().getObjectType().getClass());
                    }
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedShape(DynamicObject, Shape) */;
                    state = state & 0xfffffffe /* remove-active doCachedShape(DynamicObject, Shape) */;
                    this.state_ = state = state | 0b10 /* add-active doCachedTypeClass(DynamicObject, Class<? extends ObjectType>) */;
                    lock.unlock();
                    hasLock = false;
                    return Accepts.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b11) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b11) & ((state & 0b11) - 1)) == 0 /* is-single-active  */) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Class<?> dispatch(Object arg0Value_) {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1100) != 0 /* is-active doCachedShape(DynamicObject, Shape) || doCachedTypeClass(DynamicObject, Class<? extends ObjectType>) */) {
                    if ((state & 0b100) != 0 /* is-active doCachedShape(DynamicObject, Shape) */) {
                        if ((this.cachedShape == arg0Value.getShape())) {
                            return Dispatch.doCachedShape(arg0Value, this.cachedShape);
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active doCachedTypeClass(DynamicObject, Class<? extends ObjectType>) */) {
                        return Dispatch.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return dispatchAndSpecialize(arg0Value);
            }

            private Class<?> dispatchAndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b10)) == 0 /* is-not-excluded doCachedShape(DynamicObject, Shape) */) {
                        boolean CachedShape_duplicateFound_ = false;
                        if ((state & 0b100) != 0 /* is-active doCachedShape(DynamicObject, Shape) */) {
                            if ((this.cachedShape == arg0Value.getShape())) {
                                CachedShape_duplicateFound_ = true;
                            }
                        }
                        if (!CachedShape_duplicateFound_) {
                            {
                                Shape dispatch_cachedShape_cachedShape__ = (arg0Value.getShape());
                                if ((dispatch_cachedShape_cachedShape__ == arg0Value.getShape()) && ((state & 0b100)) == 0 /* is-not-active doCachedShape(DynamicObject, Shape) */) {
                                    if (this.cachedShape == null) {
                                        this.cachedShape = dispatch_cachedShape_cachedShape__;
                                    }
                                    this.state_ = state = state | 0b100 /* add-active doCachedShape(DynamicObject, Shape) */;
                                    CachedShape_duplicateFound_ = true;
                                }
                            }
                        }
                        if (CachedShape_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            return Dispatch.doCachedShape(arg0Value, this.cachedShape);
                        }
                    }
                    if (this.cachedTypeClass == null) {
                        this.cachedTypeClass = (arg0Value.getShape().getObjectType().getClass());
                    }
                    this.exclude_ = exclude = exclude | 0b10 /* add-excluded doCachedShape(DynamicObject, Shape) */;
                    state = state & 0xfffffffb /* remove-active doCachedShape(DynamicObject, Shape) */;
                    this.state_ = state = state | 0b1000 /* add-active doCachedTypeClass(DynamicObject, Class<? extends ObjectType>) */;
                    lock.unlock();
                    hasLock = false;
                    return Dispatch.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(DynamicObject.class)
        private static final class Uncached extends DynamicDispatchLibrary {

            private final Class<? extends DynamicObject> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((DynamicObject) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_ && accepts_(receiver);
            }

            @SuppressWarnings("cast")
            @TruffleBoundary
            @Override
            public Object cast(Object receiver) {
                return (DynamicObject) receiver;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Class<?> dispatch(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return Dispatch.doCachedTypeClass(arg0Value, (arg0Value.getShape().getObjectType().getClass()));
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return Accepts.doCachedTypeClass(arg0Value, (arg0Value.getShape().getObjectType().getClass()));
            }

        }
    }
}
