// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotValue;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToGuestValueNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToGuestValuesNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToHostValueNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory.ToGuestValueNodeGen;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache;
import com.oracle.truffle.polyglot.PolyglotValue.InteropNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.AsNativePointerNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.CanExecuteNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.CanInstantiateNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.CanInvokeNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.GetArrayElementNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.GetArraySizeNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.GetMemberKeysNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.GetMemberNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.HasArrayElementsNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.HasMemberNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.HasMembersNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.IsNativePointerNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.IsNullNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.NewInstanceNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.PutMemberNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.RemoveArrayElementNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.RemoveMemberNode;
import com.oracle.truffle.polyglot.PolyglotValue.InteropCodeCache.SetArrayElementNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PolyglotValue.class)
@SuppressWarnings("unused")
final class PolyglotValueFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(InteropCodeCache.class)
    static final class InteropCodeCacheFactory {

        @GeneratedBy(IsNativePointerNode.class)
        static final class IsNativePointerNodeGen extends IsNativePointerNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private IsNativePointerNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.natives_.accepts(arg1Value))) {
                                return IsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, s1_.natives_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return IsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.natives_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.natives_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.natives_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, s1_.natives_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return IsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static IsNativePointerNode create(InteropCodeCache interop) {
                return new IsNativePointerNodeGen(interop);
            }

            @GeneratedBy(IsNativePointerNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary natives_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(AsNativePointerNode.class)
        static final class AsNativePointerNodeGen extends AsNativePointerNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @CompilationFinal private BranchProfile cached1_unsupported_;

            private AsNativePointerNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.natives_.accepts(arg1Value))) {
                                return AsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, s1_.natives_, s1_.unsupported_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return AsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.natives_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.natives_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.natives_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.unsupported_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return AsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, s1_.natives_, s1_.unsupported_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.cached1_unsupported_ = (BranchProfile.create());
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return AsNativePointerNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static AsNativePointerNode create(InteropCodeCache interop) {
                return new AsNativePointerNodeGen(interop);
            }

            @GeneratedBy(AsNativePointerNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary natives_;
                @CompilationFinal BranchProfile unsupported_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(HasArrayElementsNode.class)
        static final class HasArrayElementsNodeGen extends HasArrayElementsNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private HasArrayElementsNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.arrays_.accepts(arg1Value))) {
                                return HasArrayElementsNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return HasArrayElementsNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.arrays_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.arrays_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.arrays_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return HasArrayElementsNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return HasArrayElementsNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static HasArrayElementsNode create(InteropCodeCache interop) {
                return new HasArrayElementsNodeGen(interop);
            }

            @GeneratedBy(HasArrayElementsNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary arrays_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(GetMemberKeysNode.class)
        static final class GetMemberKeysNodeGen extends GetMemberKeysNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @CompilationFinal private ToHostValueNode cached1_toHost_;
            @CompilationFinal private BranchProfile cached1_unsupported_;

            private GetMemberKeysNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.objects_.accepts(arg1Value))) {
                                return GetMemberKeysNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.toHost_, s1_.unsupported_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return GetMemberKeysNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_toHost_, this.cached1_unsupported_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.objects_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.objects_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.objects_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toHost_ = (createToHost());
                                s1_.unsupported_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return GetMemberKeysNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.toHost_, s1_.unsupported_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.cached1_toHost_ = (createToHost());
                            this.cached1_unsupported_ = (BranchProfile.create());
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return GetMemberKeysNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_toHost_, this.cached1_unsupported_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static GetMemberKeysNode create(InteropCodeCache interop) {
                return new GetMemberKeysNodeGen(interop);
            }

            @GeneratedBy(GetMemberKeysNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary objects_;
                @CompilationFinal ToHostValueNode toHost_;
                @CompilationFinal BranchProfile unsupported_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(GetArrayElementNode.class)
        static final class GetArrayElementNodeGen extends GetArrayElementNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @Child private Cached1Data cached1_cache;

            private GetArrayElementNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.arrays_.accepts(arg1Value))) {
                                return GetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.toHost_, s1_.unsupported_, s1_.unknown_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                        Cached1Data s2_ = this.cached1_cache;
                        if (s2_ != null) {
                            return this.cached1Boundary(state, s2_, arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, Cached1Data s2_, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return GetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toHost_, s2_.unsupported_, s2_.unknown_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.arrays_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.arrays_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.arrays_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toHost_ = (createToHost());
                                s1_.unsupported_ = (BranchProfile.create());
                                s1_.unknown_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return GetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.toHost_, s1_.unsupported_, s1_.unknown_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            Cached1Data s2_ = super.insert(new Cached1Data());
                            s2_.toHost_ = (createToHost());
                            s2_.unsupported_ = (BranchProfile.create());
                            s2_.unknown_ = (BranchProfile.create());
                            this.cached1_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return GetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toHost_, s2_.unsupported_, s2_.unknown_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static GetArrayElementNode create(InteropCodeCache interop) {
                return new GetArrayElementNodeGen(interop);
            }

            @GeneratedBy(GetArrayElementNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary arrays_;
                @CompilationFinal ToHostValueNode toHost_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile unknown_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(GetArrayElementNode.class)
            private static final class Cached1Data extends Node {

                @CompilationFinal ToHostValueNode toHost_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile unknown_;

                Cached1Data() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
        @GeneratedBy(SetArrayElementNode.class)
        static final class SetArrayElementNodeGen extends SetArrayElementNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @Child private Cached1Data cached1_cache;

            private SetArrayElementNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.arrays_.accepts(arg1Value))) {
                                return SetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.toGuestValue_, s1_.unsupported_, s1_.invalidIndex_, s1_.invalidValue_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                        Cached1Data s2_ = this.cached1_cache;
                        if (s2_ != null) {
                            return this.cached1Boundary(state, s2_, arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, Cached1Data s2_, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return SetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toGuestValue_, s2_.unsupported_, s2_.invalidIndex_, s2_.invalidValue_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.arrays_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.arrays_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.arrays_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toGuestValue_ = s1_.insertAccessor((ToGuestValueNodeGen.create()));
                                s1_.unsupported_ = (BranchProfile.create());
                                s1_.invalidIndex_ = (BranchProfile.create());
                                s1_.invalidValue_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return SetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.toGuestValue_, s1_.unsupported_, s1_.invalidIndex_, s1_.invalidValue_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            Cached1Data s2_ = super.insert(new Cached1Data());
                            s2_.toGuestValue_ = s2_.insertAccessor((ToGuestValueNodeGen.create()));
                            s2_.unsupported_ = (BranchProfile.create());
                            s2_.invalidIndex_ = (BranchProfile.create());
                            s2_.invalidValue_ = (BranchProfile.create());
                            this.cached1_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return SetArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toGuestValue_, s2_.unsupported_, s2_.invalidIndex_, s2_.invalidValue_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static SetArrayElementNode create(InteropCodeCache interop) {
                return new SetArrayElementNodeGen(interop);
            }

            @GeneratedBy(SetArrayElementNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary arrays_;
                @Child ToGuestValueNode toGuestValue_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile invalidIndex_;
                @CompilationFinal BranchProfile invalidValue_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(SetArrayElementNode.class)
            private static final class Cached1Data extends Node {

                @Child ToGuestValueNode toGuestValue_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile invalidIndex_;
                @CompilationFinal BranchProfile invalidValue_;

                Cached1Data() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(RemoveArrayElementNode.class)
        static final class RemoveArrayElementNodeGen extends RemoveArrayElementNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @CompilationFinal private BranchProfile cached1_unsupported_;
            @CompilationFinal private BranchProfile cached1_invalidIndex_;

            private RemoveArrayElementNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.arrays_.accepts(arg1Value))) {
                                return RemoveArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.unsupported_, s1_.invalidIndex_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return RemoveArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_, this.cached1_invalidIndex_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.arrays_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.arrays_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.arrays_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.unsupported_ = (BranchProfile.create());
                                s1_.invalidIndex_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return RemoveArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.unsupported_, s1_.invalidIndex_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.cached1_unsupported_ = (BranchProfile.create());
                            this.cached1_invalidIndex_ = (BranchProfile.create());
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return RemoveArrayElementNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_, this.cached1_invalidIndex_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static RemoveArrayElementNode create(InteropCodeCache interop) {
                return new RemoveArrayElementNodeGen(interop);
            }

            @GeneratedBy(RemoveArrayElementNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary arrays_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile invalidIndex_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(GetArraySizeNode.class)
        static final class GetArraySizeNodeGen extends GetArraySizeNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @CompilationFinal private BranchProfile cached1_unsupported_;

            private GetArraySizeNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.arrays_.accepts(arg1Value))) {
                                return GetArraySizeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.unsupported_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return GetArraySizeNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.arrays_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.arrays_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.arrays_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.unsupported_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return GetArraySizeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.arrays_, s1_.unsupported_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.cached1_unsupported_ = (BranchProfile.create());
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return GetArraySizeNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static GetArraySizeNode create(InteropCodeCache interop) {
                return new GetArraySizeNodeGen(interop);
            }

            @GeneratedBy(GetArraySizeNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary arrays_;
                @CompilationFinal BranchProfile unsupported_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(GetMemberNode.class)
        static final class GetMemberNodeGen extends GetMemberNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @Child private Cached1Data cached1_cache;

            private GetMemberNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.objects_.accepts(arg1Value))) {
                                return GetMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.toHost_, s1_.unsupported_, s1_.unknown_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                        Cached1Data s2_ = this.cached1_cache;
                        if (s2_ != null) {
                            return this.cached1Boundary(state, s2_, arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, Cached1Data s2_, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return GetMemberNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toHost_, s2_.unsupported_, s2_.unknown_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.objects_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.objects_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.objects_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toHost_ = (createToHost());
                                s1_.unsupported_ = (BranchProfile.create());
                                s1_.unknown_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return GetMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.toHost_, s1_.unsupported_, s1_.unknown_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            Cached1Data s2_ = super.insert(new Cached1Data());
                            s2_.toHost_ = (createToHost());
                            s2_.unsupported_ = (BranchProfile.create());
                            s2_.unknown_ = (BranchProfile.create());
                            this.cached1_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToHostValueNode, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return GetMemberNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toHost_, s2_.unsupported_, s2_.unknown_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static GetMemberNode create(InteropCodeCache interop) {
                return new GetMemberNodeGen(interop);
            }

            @GeneratedBy(GetMemberNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary objects_;
                @CompilationFinal ToHostValueNode toHost_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile unknown_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(GetMemberNode.class)
            private static final class Cached1Data extends Node {

                @CompilationFinal ToHostValueNode toHost_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile unknown_;

                Cached1Data() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
        @GeneratedBy(PutMemberNode.class)
        static final class PutMemberNodeGen extends PutMemberNode {

            @CompilationFinal private int state_;
            @Child private CachedData cached_cache;

            private PutMemberNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    CachedData s1_ = this.cached_cache;
                    if (s1_ != null) {
                        return PutMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.toGuestValue_, s1_.unsupported_, s1_.invalidValue_, s1_.unknown_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    CachedData s1_ = super.insert(new CachedData());
                    s1_.objects_ = s1_.insertAccessor((INTEROP_LIBRARY_.createDispatched(InteropNode.CACHE_LIMIT)));
                    s1_.toGuestValue_ = s1_.insertAccessor((ToGuestValueNodeGen.create()));
                    s1_.unsupported_ = (BranchProfile.create());
                    s1_.invalidValue_ = (BranchProfile.create());
                    s1_.unknown_ = (BranchProfile.create());
                    this.cached_cache = s1_;
                    this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return PutMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.toGuestValue_, s1_.unsupported_, s1_.invalidValue_, s1_.unknown_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            public static PutMemberNode create(InteropCodeCache interop) {
                return new PutMemberNodeGen(interop);
            }

            @GeneratedBy(PutMemberNode.class)
            private static final class CachedData extends Node {

                @Child InteropLibrary objects_;
                @Child ToGuestValueNode toGuestValue_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile invalidValue_;
                @CompilationFinal BranchProfile unknown_;

                CachedData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(RemoveMemberNode.class)
        static final class RemoveMemberNodeGen extends RemoveMemberNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @CompilationFinal private BranchProfile cached1_unsupported_;
            @CompilationFinal private BranchProfile cached1_unknown_;

            private RemoveMemberNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.objects_.accepts(arg1Value))) {
                                return RemoveMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.unsupported_, s1_.unknown_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return RemoveMemberNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_, this.cached1_unknown_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.objects_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.objects_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.objects_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.unsupported_ = (BranchProfile.create());
                                s1_.unknown_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return RemoveMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_, s1_.unsupported_, s1_.unknown_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.cached1_unsupported_ = (BranchProfile.create());
                            this.cached1_unknown_ = (BranchProfile.create());
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return RemoveMemberNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.cached1_unsupported_, this.cached1_unknown_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static RemoveMemberNode create(InteropCodeCache interop) {
                return new RemoveMemberNodeGen(interop);
            }

            @GeneratedBy(RemoveMemberNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary objects_;
                @CompilationFinal BranchProfile unsupported_;
                @CompilationFinal BranchProfile unknown_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(IsNullNode.class)
        static final class IsNullNodeGen extends IsNullNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private IsNullNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.values_.accepts(arg1Value))) {
                                return IsNullNode.doCached(arg0Value, arg1Value, arg2Value, s1_.values_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return IsNullNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.values_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.values_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.values_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsNullNode.doCached(arg0Value, arg1Value, arg2Value, s1_.values_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return IsNullNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static IsNullNode create(InteropCodeCache interop) {
                return new IsNullNodeGen(interop);
            }

            @GeneratedBy(IsNullNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary values_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(HasMembersNode.class)
        static final class HasMembersNodeGen extends HasMembersNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private HasMembersNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.objects_.accepts(arg1Value))) {
                                return HasMembersNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return HasMembersNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.objects_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.objects_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.objects_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return HasMembersNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return HasMembersNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static HasMembersNode create(InteropCodeCache interop) {
                return new HasMembersNodeGen(interop);
            }

            @GeneratedBy(HasMembersNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary objects_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(HasMemberNode.class)
        static final class HasMemberNodeGen extends HasMemberNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private HasMemberNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.objects_.accepts(arg1Value))) {
                                return HasMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return HasMemberNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.objects_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.objects_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.objects_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return HasMemberNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return HasMemberNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static HasMemberNode create(InteropCodeCache interop) {
                return new HasMemberNodeGen(interop);
            }

            @GeneratedBy(HasMemberNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary objects_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(CanInvokeNode.class)
        static final class CanInvokeNodeGen extends CanInvokeNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private CanInvokeNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.objects_.accepts(arg1Value))) {
                                return CanInvokeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return CanInvokeNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.objects_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.objects_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.objects_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return CanInvokeNode.doCached(arg0Value, arg1Value, arg2Value, s1_.objects_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return CanInvokeNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static CanInvokeNode create(InteropCodeCache interop) {
                return new CanInvokeNodeGen(interop);
            }

            @GeneratedBy(CanInvokeNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary objects_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(CanExecuteNode.class)
        static final class CanExecuteNodeGen extends CanExecuteNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private CanExecuteNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.executables_.accepts(arg1Value))) {
                                return CanExecuteNode.doCached(arg0Value, arg1Value, arg2Value, s1_.executables_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return CanExecuteNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.executables_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.executables_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.executables_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return CanExecuteNode.doCached(arg0Value, arg1Value, arg2Value, s1_.executables_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return CanExecuteNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static CanExecuteNode create(InteropCodeCache interop) {
                return new CanExecuteNodeGen(interop);
            }

            @GeneratedBy(CanExecuteNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary executables_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(CanInstantiateNode.class)
        static final class CanInstantiateNodeGen extends CanInstantiateNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;

            private CanInstantiateNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.instantiables_.accepts(arg1Value))) {
                                return CanInstantiateNode.doCached(arg0Value, arg1Value, arg2Value, s1_.instantiables_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        return this.cached1Boundary(state, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return CanInstantiateNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.instantiables_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.instantiables_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.instantiables_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return CanInstantiateNode.doCached(arg0Value, arg1Value, arg2Value, s1_.instantiables_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return CanInstantiateNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static CanInstantiateNode create(InteropCodeCache interop) {
                return new CanInstantiateNodeGen(interop);
            }

            @GeneratedBy(CanInstantiateNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary instantiables_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(NewInstanceNode.class)
        static final class NewInstanceNodeGen extends NewInstanceNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private Cached0Data cached0_cache;
            @Child private Cached1Data cached1_cache;

            private NewInstanceNodeGen(InteropCodeCache interop) {
                super(interop);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state = state_;
                if (state != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) || doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if ((s1_.instantiables_.accepts(arg1Value))) {
                                return NewInstanceNode.doCached(arg0Value, arg1Value, arg2Value, s1_.instantiables_, s1_.toGuestValues_, s1_.toHostValue_, s1_.arity_, s1_.invalidArgument_, s1_.unsupported_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                        Cached1Data s2_ = this.cached1_cache;
                        if (s2_ != null) {
                            return this.cached1Boundary(state, s2_, arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            private Object cached1Boundary(int state, Cached1Data s2_, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return NewInstanceNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toGuestValues_, s2_.toHostValue_, s2_.arity_, s2_.invalidArgument_, s2_.unsupported_);
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */) {
                            while (s1_ != null) {
                                if ((s1_.instantiables_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.instantiables_.accepts(arg1Value));
                            if (count1_ < (InteropNode.CACHE_LIMIT)) {
                                s1_ = super.insert(new Cached0Data(cached0_cache));
                                s1_.instantiables_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toGuestValues_ = s1_.insertAccessor((ToGuestValuesNode.create()));
                                s1_.toHostValue_ = (createToHost());
                                s1_.arity_ = (BranchProfile.create());
                                s1_.invalidArgument_ = (BranchProfile.create());
                                s1_.unsupported_ = (BranchProfile.create());
                                this.cached0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return NewInstanceNode.doCached(arg0Value, arg1Value, arg2Value, s1_.instantiables_, s1_.toGuestValues_, s1_.toHostValue_, s1_.arity_, s1_.invalidArgument_, s1_.unsupported_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            Cached1Data s2_ = super.insert(new Cached1Data());
                            s2_.toGuestValues_ = s2_.insertAccessor((ToGuestValuesNode.create()));
                            s2_.toHostValue_ = (createToHost());
                            s2_.arity_ = (BranchProfile.create());
                            s2_.invalidArgument_ = (BranchProfile.create());
                            s2_.unsupported_ = (BranchProfile.create());
                            this.cached1_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            this.cached0_cache = null;
                            state = state & 0xfffffffe /* remove-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Object[], InteropLibrary, ToGuestValuesNode, ToHostValueNode, BranchProfile, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return NewInstanceNode.doCached(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s2_.toGuestValues_, s2_.toHostValue_, s2_.arity_, s2_.invalidArgument_, s2_.unsupported_);
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    Cached0Data s1_ = this.cached0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static NewInstanceNode create(InteropCodeCache interop) {
                return new NewInstanceNodeGen(interop);
            }

            @GeneratedBy(NewInstanceNode.class)
            private static final class Cached0Data extends Node {

                @Child Cached0Data next_;
                @Child InteropLibrary instantiables_;
                @Child ToGuestValuesNode toGuestValues_;
                @CompilationFinal ToHostValueNode toHostValue_;
                @CompilationFinal BranchProfile arity_;
                @CompilationFinal BranchProfile invalidArgument_;
                @CompilationFinal BranchProfile unsupported_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(NewInstanceNode.class)
            private static final class Cached1Data extends Node {

                @Child ToGuestValuesNode toGuestValues_;
                @CompilationFinal ToHostValueNode toHostValue_;
                @CompilationFinal BranchProfile arity_;
                @CompilationFinal BranchProfile invalidArgument_;
                @CompilationFinal BranchProfile unsupported_;

                Cached1Data() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
    }
}
