// CheckStyle: start generated
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(DynamicObject.class)
final class DynamicObjectGen {

    static  {
        LibraryExport.register(DynamicObject.class, new DynamicDispatchLibraryExports());
    }

    private DynamicObjectGen() {
    }

    @GeneratedBy(DynamicObject.class)
    private static final class DynamicDispatchLibraryExports extends LibraryExport<DynamicDispatchLibrary> {

        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, DynamicObject.class, false);
        }

        @Override
        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert receiver instanceof DynamicObject;
            return new Uncached(receiver);
        }

        @Override
        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert receiver instanceof DynamicObject;
            return new Cached(receiver);
        }

        @GeneratedBy(DynamicObject.class)
        private static final class Cached extends DynamicDispatchLibrary {

            private final Class<? extends DynamicObject> receiverClass_;
            @CompilationFinal private int state_;
            @CompilationFinal private ObjectType objectType;

            Cached(Object receiver) {
                this.receiverClass_ = ((DynamicObject) receiver).getClass();
            }

            @Override
            public Object cast(Object receiver) {
                return CompilerDirectives.castExact(receiver, receiverClass_);
            }

            @Override
            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_ && accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                DynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1) != 0 /* is-active accepts(DynamicObject, ObjectType) */) {
                    return arg0Value.accepts(this.objectType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return acceptsNode_AndSpecialize(arg0Value);
            }

            private boolean acceptsNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.objectType == null) {
                        this.objectType = (arg0Value.getShape().getObjectType());
                    }
                    this.state_ = state = state | 0b1 /* add-active accepts(DynamicObject, ObjectType) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.accepts(this.objectType);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public Class<?> dispatch(Object arg0Value_) {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b10) != 0 /* is-active dispatch(DynamicObject, ObjectType) */) {
                    return arg0Value.dispatch(this.objectType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return dispatchNode_AndSpecialize(arg0Value);
            }

            private Class<?> dispatchNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.objectType == null) {
                        this.objectType = (arg0Value.getShape().getObjectType());
                    }
                    this.state_ = state = state | 0b10 /* add-active dispatch(DynamicObject, ObjectType) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.dispatch(this.objectType);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(DynamicObject.class)
        private static final class Uncached extends DynamicDispatchLibrary {

            private final Class<? extends DynamicObject> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((DynamicObject) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_ && accepts_(receiver);
            }

            @SuppressWarnings("cast")
            @TruffleBoundary
            @Override
            public Object cast(Object receiver) {
                return (DynamicObject) receiver;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Class<?> dispatch(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return arg0Value.dispatch((arg0Value.getShape().getObjectType()));
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return arg0Value.accepts((arg0Value.getShape().getObjectType()));
            }

        }
    }
}
