/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.tck;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.LanguageProvider;
import org.graalvm.polyglot.tck.ResultVerifier;
import org.graalvm.polyglot.tck.Snippet;
import org.graalvm.polyglot.tck.TypeDescriptor;
import org.junit.Assert;

public class SLTCKLanguageProvider
implements LanguageProvider {
    private static final String ID = "sl";
    private static final String PATTERN_VALUE_FNC = "function %s() {return %s;}";
    private static final String PATTERN_BIN_OP_FNC = "function %s(a,b) {return a %s b;}";
    private static final String PATTERN_POST_OP_FNC = "function %s(a) {a %s;}";
    private static final String PATTERN_BUILTIN0 = "function %sBuiltin0() {return %s();}";
    private static final String PATTERN_BUILTIN1 = "function %sBuiltin1(a) {return %s(a);}";
    private static final String PATTERN_BUILTIN2 = "function %sBuiltin2(a, b) {return %s(a, b);}";
    private static final String[] PATTERN_STATEMENTS = new String[]{"function %s() {r = 0;\n%s\nreturn r;\n}", "function %s(p1) {r = 0;\n%s\nreturn r;\n}"};
    private static final TypeDescriptor NUMBER_RETURN = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[0])});

    public String getId() {
        return ID;
    }

    public Value createIdentityFunction(Context context) {
        return SLTCKLanguageProvider.eval(context, "function id (a) {return a;}", "id");
    }

    public Collection<? extends Snippet> createValueConstructors(Context context) {
        ArrayList<Snippet> res = new ArrayList<Snippet>();
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "1 == 2", "boolean", "createBoolean", TypeDescriptor.BOOLEAN));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "1", "number", "createNumber", TypeDescriptor.NUMBER));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "9223372036854775809", "bigNumber", "createBigNumber", TypeDescriptor.NUMBER));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "\"string\"", "string", "createString", TypeDescriptor.STRING));
        Snippet.Builder opb = Snippet.newBuilder((String)"object", (Value)SLTCKLanguageProvider.eval(context, "function createObject() {\nobj1 = new();\nobj1.attr = 42;\nreturn obj1;\n}", "createObject"), (TypeDescriptor)TypeDescriptor.OBJECT);
        res.add(opb.build());
        opb = Snippet.newBuilder((String)"function", (Value)SLTCKLanguageProvider.eval(context, "function fn() {\n}function createFunction() {\nreturn fn;\n}", "createFunction"), (TypeDescriptor)TypeDescriptor.EXECUTABLE);
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "wrapPrimitive(1 == 2)", "wrapped-boolean", "createWrappedBoolean", TypeDescriptor.BOOLEAN));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "wrapPrimitive(1)", "wrapped-number", "createWrappedNumber", TypeDescriptor.NUMBER));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "wrapPrimitive(\"string\")", "wrapped-string", "createWrappedString", TypeDescriptor.STRING));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "typeOf(1 == 2)", "boolean-metaobject", "createBooleanMetaObject", TypeDescriptor.META_OBJECT));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "typeOf(1)", "number-metaobject", "createNumberMetaObject", TypeDescriptor.META_OBJECT));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "typeOf(\"str\")", "string-metaobject", "createStringMetaObject", TypeDescriptor.META_OBJECT));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "typeOf(NULL)", "null-metaobject", "createNullMetaObject", TypeDescriptor.META_OBJECT));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "typeOf(new())", "object-metaobject", "createObjectMetaObject", TypeDescriptor.META_OBJECT));
        res.add(SLTCKLanguageProvider.createValueConstructor(context, "typeOf(createStringMetaObject)", "function-metaobject", "createFunctionMetaObject", TypeDescriptor.META_OBJECT));
        res.add(opb.build());
        return Collections.unmodifiableCollection(res);
    }

    public Collection<? extends Snippet> createExpressions(Context context) {
        ArrayList<Snippet> res = new ArrayList<Snippet>();
        Value fnc = SLTCKLanguageProvider.eval(context, String.format(PATTERN_BIN_OP_FNC, "add", "+"), "add");
        Snippet.Builder opb = Snippet.newBuilder((String)"+", (Value)fnc, (TypeDescriptor)NUMBER_RETURN).parameterTypes(new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.NUMBER});
        res.add(opb.build());
        opb = Snippet.newBuilder((String)"+", (Value)fnc, (TypeDescriptor)TypeDescriptor.STRING).parameterTypes(new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.ANY});
        res.add(opb.build());
        opb = Snippet.newBuilder((String)"+", (Value)fnc, (TypeDescriptor)TypeDescriptor.STRING).parameterTypes(new TypeDescriptor[]{TypeDescriptor.ANY, TypeDescriptor.STRING});
        res.add(opb.build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "-", "sub", NUMBER_RETURN, TypeDescriptor.NUMBER, TypeDescriptor.NUMBER).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "*", "mul", NUMBER_RETURN, TypeDescriptor.NUMBER, TypeDescriptor.NUMBER).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "/", "div", NUMBER_RETURN, TypeDescriptor.NUMBER, TypeDescriptor.NUMBER).resultVerifier(snippetRun -> {
            Value dividend = (Value)snippetRun.getParameters().get(0);
            Value divider = (Value)snippetRun.getParameters().get(1);
            PolyglotException exception = snippetRun.getException();
            if (dividend.isNumber() && divider.fitsInDouble() && divider.asDouble() == 0.0) {
                Assert.assertNotNull((Object)exception);
            } else {
                if (exception != null) {
                    throw exception;
                }
                Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(TypeDescriptor.forValue((Value)snippetRun.getResult())));
            }
        }).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "==", "eq", TypeDescriptor.BOOLEAN, TypeDescriptor.ANY, TypeDescriptor.ANY).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "!=", "neq", TypeDescriptor.BOOLEAN, TypeDescriptor.ANY, TypeDescriptor.ANY).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "<=", "le", TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER, TypeDescriptor.NUMBER).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, ">=", "ge", TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER, TypeDescriptor.NUMBER).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "<", "l", TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER, TypeDescriptor.NUMBER).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, ">", "g", TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER, TypeDescriptor.NUMBER).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "||", "or", TypeDescriptor.BOOLEAN, TypeDescriptor.BOOLEAN, TypeDescriptor.ANY).resultVerifier(snippetRun -> {
            Value firstParam = (Value)snippetRun.getParameters().get(0);
            Value secondParam = (Value)snippetRun.getParameters().get(1);
            PolyglotException exception = snippetRun.getException();
            if (firstParam.isBoolean() && !firstParam.asBoolean() && !secondParam.isBoolean()) {
                Assert.assertNotNull((Object)exception);
            } else {
                if (exception != null) {
                    throw exception;
                }
                Assert.assertTrue((boolean)TypeDescriptor.BOOLEAN.isAssignable(TypeDescriptor.forValue((Value)snippetRun.getResult())));
            }
        }).build());
        res.add(SLTCKLanguageProvider.createBinaryOperator(context, "&&", "land", TypeDescriptor.BOOLEAN, TypeDescriptor.BOOLEAN, TypeDescriptor.ANY).resultVerifier(snippetRun -> {
            Value firstParam = (Value)snippetRun.getParameters().get(0);
            Value secondParam = (Value)snippetRun.getParameters().get(1);
            PolyglotException exception = snippetRun.getException();
            if (firstParam.isBoolean() && firstParam.asBoolean() && !secondParam.isBoolean()) {
                Assert.assertNotNull((Object)exception);
            } else {
                if (exception != null) {
                    throw exception;
                }
                Assert.assertTrue((boolean)TypeDescriptor.BOOLEAN.isAssignable(TypeDescriptor.forValue((Value)snippetRun.getResult())));
            }
        }).build());
        res.add(SLTCKLanguageProvider.createPostfixOperator(context, "()", "callNoArg", TypeDescriptor.NULL, TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[0])).build());
        res.add(SLTCKLanguageProvider.createPostfixOperator(context, "(1)", "callOneArg", TypeDescriptor.NULL, TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER})).build());
        res.add(SLTCKLanguageProvider.createPostfixOperator(context, "(1, \"\")", "callTwoArgs", TypeDescriptor.NULL, TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})).build());
        return Collections.unmodifiableCollection(res);
    }

    public Collection<? extends Snippet> createStatements(Context context) {
        ArrayList<Snippet> res = new ArrayList<Snippet>();
        res.add(SLTCKLanguageProvider.createStatement(context, "if", "iffnc", "if ({1}) '{'\n{0}=1;\n'}' else '{'\n{0}=0;\n'}'", TypeDescriptor.NUMBER, TypeDescriptor.BOOLEAN));
        res.add(SLTCKLanguageProvider.createStatement(context, "while", "whilefnc", "while ({1}) '{'break;\n'}'", TypeDescriptor.NUMBER, TypeDescriptor.BOOLEAN));
        res.add(SLTCKLanguageProvider.createStatement(context, "assign", "assignfnc", "{1} = {0};", TypeDescriptor.ANY, TypeDescriptor.ANY));
        res.add(SLTCKLanguageProvider.createBuiltin(context, "getSize", TypeDescriptor.NUMBER, TypeDescriptor.ARRAY));
        res.add(SLTCKLanguageProvider.createBuiltin(context, "hasSize", TypeDescriptor.BOOLEAN, TypeDescriptor.ANY));
        res.add(SLTCKLanguageProvider.createBuiltin(context, "isExecutable", TypeDescriptor.BOOLEAN, TypeDescriptor.ANY));
        res.add(SLTCKLanguageProvider.createBuiltin(context, "isNull", TypeDescriptor.BOOLEAN, TypeDescriptor.ANY));
        res.add(SLTCKLanguageProvider.createBuiltin(context, "isInstance", TypeDescriptor.BOOLEAN, TypeDescriptor.META_OBJECT, TypeDescriptor.ANY));
        res.add(SLTCKLanguageProvider.createBuiltin(context, "typeOf", TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.META_OBJECT, TypeDescriptor.NULL}), TypeDescriptor.ANY));
        return res;
    }

    public Collection<? extends Snippet> createScripts(Context context) {
        ArrayList<Snippet> res = new ArrayList<Snippet>();
        res.add(SLTCKLanguageProvider.loadScript(context, "resources/Ackermann.sl", TypeDescriptor.NULL, null));
        res.add(SLTCKLanguageProvider.loadScript(context, "resources/Fibonacci.sl", TypeDescriptor.NULL, null));
        return Collections.unmodifiableCollection(res);
    }

    public Collection<? extends Source> createInvalidSyntaxScripts(Context context) {
        try {
            ArrayList<Source> res = new ArrayList<Source>();
            res.add(SLTCKLanguageProvider.createSource("resources/InvalidSyntax01.sl"));
            res.add(SLTCKLanguageProvider.createSource("resources/InvalidSyntax02.sl"));
            return Collections.unmodifiableCollection(res);
        }
        catch (IOException ioe) {
            throw new AssertionError("IOException while creating a test script.", ioe);
        }
    }

    private static Snippet createValueConstructor(Context context, String value, String id, String functionName, TypeDescriptor type) {
        Snippet.Builder opb = Snippet.newBuilder((String)id, (Value)SLTCKLanguageProvider.eval(context, String.format(PATTERN_VALUE_FNC, functionName, value), functionName), (TypeDescriptor)type);
        return opb.build();
    }

    private static Snippet.Builder createBinaryOperator(Context context, String operator, String functionName, TypeDescriptor type, TypeDescriptor ltype, TypeDescriptor rtype) {
        Value fnc = SLTCKLanguageProvider.eval(context, String.format(PATTERN_BIN_OP_FNC, functionName, operator), functionName);
        return Snippet.newBuilder((String)operator, (Value)fnc, (TypeDescriptor)type).parameterTypes(new TypeDescriptor[]{ltype, rtype});
    }

    private static Snippet.Builder createPostfixOperator(Context context, String operator, String functionName, TypeDescriptor type, TypeDescriptor ltype) {
        Value fnc = SLTCKLanguageProvider.eval(context, String.format(PATTERN_POST_OP_FNC, functionName, operator), functionName);
        return Snippet.newBuilder((String)operator, (Value)fnc, (TypeDescriptor)type).parameterTypes(new TypeDescriptor[]{ltype});
    }

    private static Snippet createStatement(Context context, String id, String functionName, String expression, TypeDescriptor returnType, TypeDescriptor ... paramTypes) {
        Object[] formalParams = new String[paramTypes.length + 1];
        formalParams[0] = "r";
        for (int i = 1; i < formalParams.length; ++i) {
            formalParams[i] = "p" + i;
        }
        String formattedExpression = MessageFormat.format(expression, formalParams);
        Value fnc = SLTCKLanguageProvider.eval(context, String.format(PATTERN_STATEMENTS[paramTypes.length], functionName, formattedExpression), functionName);
        return Snippet.newBuilder((String)id, (Value)fnc, (TypeDescriptor)returnType).parameterTypes(paramTypes).build();
    }

    private static Snippet createBuiltin(Context context, String builtinName, TypeDescriptor returnType, TypeDescriptor ... paramTypes) {
        String formattedExpression = String.format(switch (paramTypes.length) {
            case 0 -> PATTERN_BUILTIN0;
            case 1 -> PATTERN_BUILTIN1;
            case 2 -> PATTERN_BUILTIN2;
            default -> throw new AssertionError();
        }, builtinName, builtinName);
        Value fnc = SLTCKLanguageProvider.eval(context, formattedExpression, builtinName);
        return Snippet.newBuilder((String)builtinName, (Value)fnc, (TypeDescriptor)returnType).parameterTypes(paramTypes).build();
    }

    private static Snippet loadScript(Context context, String resourceName, TypeDescriptor type, ResultVerifier verifier) {
        try {
            Source src = SLTCKLanguageProvider.createSource(resourceName);
            return Snippet.newBuilder((String)src.getName(), (Value)context.eval(src), (TypeDescriptor)type).resultVerifier(verifier).build();
        }
        catch (IOException ioe) {
            throw new AssertionError("IOException while creating a test script.", ioe);
        }
    }

    private static Source createSource(String resourceName) throws IOException {
        int slashIndex = resourceName.lastIndexOf(47);
        String scriptName = slashIndex >= 0 ? resourceName.substring(slashIndex + 1) : resourceName;
        try (InputStreamReader in = new InputStreamReader(SLTCKLanguageProvider.class.getResourceAsStream(resourceName), "UTF-8");){
            Source source = Source.newBuilder((String)ID, (Reader)in, (String)scriptName).build();
            return source;
        }
    }

    private static Value eval(Context context, String fncDecl, String functionName) {
        return context.eval(ID, (CharSequence)(fncDecl + "\nfunction main() {\n" + String.format("  return %s;\n", functionName) + "}"));
    }
}

