/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class StackTraceEntry {
    private static final Set<Class<?>> DEFAULT_TAGS;
    private final SourceSection sourceSection;
    private final String rootName;
    private final Set<Class<?>> tags;
    private final Node instrumentedNode;
    private final int compilationTier;
    private final boolean compilationRoot;
    private volatile StackTraceElement stackTraceElement;

    StackTraceEntry(String rootName) {
        this.sourceSection = null;
        this.rootName = rootName;
        this.tags = DEFAULT_TAGS;
        this.instrumentedNode = null;
        this.stackTraceElement = null;
        this.compilationTier = 0;
        this.compilationRoot = true;
    }

    StackTraceEntry(Instrumenter instrumenter, EventContext context, int compilationTier, boolean compilationRoot) {
        this.tags = instrumenter.queryTags(context.getInstrumentedNode());
        this.sourceSection = context.getInstrumentedSourceSection();
        this.instrumentedNode = context.getInstrumentedNode();
        this.rootName = StackTraceEntry.extractRootName(this.instrumentedNode);
        this.compilationTier = compilationTier;
        this.compilationRoot = compilationRoot;
    }

    StackTraceEntry(Set<Class<?>> tags, SourceSection sourceSection, RootNode root, Node node, int compilationTier, boolean compilationRoot) {
        this.tags = tags;
        this.sourceSection = sourceSection;
        this.instrumentedNode = node;
        this.rootName = StackTraceEntry.extractRootName((Node)root);
        this.compilationTier = compilationTier;
        this.compilationRoot = compilationRoot;
    }

    StackTraceEntry(StackTraceEntry location, int compilationTier, boolean compilationRoot) {
        this.sourceSection = location.sourceSection;
        this.instrumentedNode = location.instrumentedNode;
        this.rootName = location.rootName;
        this.tags = location.tags;
        this.stackTraceElement = location.stackTraceElement;
        this.compilationTier = compilationTier;
        this.compilationRoot = compilationRoot;
    }

    StackTraceEntry(Instrumenter instrumenter, Node node, int compilationTier, boolean compilationRoot) {
        this.tags = instrumenter.queryTags(node);
        this.sourceSection = node.getSourceSection();
        this.instrumentedNode = node;
        this.rootName = StackTraceEntry.extractRootName(this.instrumentedNode);
        this.compilationTier = compilationTier;
        this.compilationRoot = compilationRoot;
    }

    public int getTier() {
        return this.compilationTier;
    }

    public boolean isCompilationRoot() {
        return this.compilationRoot;
    }

    @Deprecated
    public boolean isCompiled() {
        return this.compilationTier > 0;
    }

    @Deprecated
    public boolean isInterpreted() {
        return this.compilationTier == 0;
    }

    @Deprecated
    public boolean isInlined() {
        return !this.compilationRoot;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public String getRootName() {
        return this.rootName;
    }

    public Set<Class<?>> getTags() {
        return this.tags;
    }

    public StackTraceElement toStackTraceElement() {
        String methodName;
        StackTraceElement stack = this.stackTraceElement;
        if (stack != null) {
            return stack;
        }
        LanguageInfo languageInfo = this.getInstrumentedNode().getRootNode().getLanguageInfo();
        String declaringClass = languageInfo != null ? languageInfo.getId() : "";
        SourceSection sourceLocation = this.getSourceSection();
        String string = methodName = this.rootName == null ? "" : this.rootName;
        if (!this.tags.contains(StandardTags.RootTag.class)) {
            methodName = methodName + "~" + StackTraceEntry.formatIndices(this.sourceSection, true);
        }
        String fileName = this.formatFileName();
        int startLine = sourceLocation != null ? sourceLocation.getStartLine() : -1;
        this.stackTraceElement = new StackTraceElement(declaringClass, methodName, fileName, startLine);
        return this.stackTraceElement;
    }

    private String formatFileName() {
        if (this.sourceSection == null) {
            return "<Unknown>";
        }
        Source source = this.sourceSection.getSource();
        if (source.getPath() == null) {
            return source.getName();
        }
        return source.getPath();
    }

    private static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b.append(sourceSection.getCharIndex());
            } else {
                b.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b.toString();
    }

    private static String extractRootName(Node instrumentedNode) {
        RootNode rootNode = instrumentedNode.getRootNode();
        if (rootNode != null) {
            if (rootNode.getName() == null) {
                return rootNode.toString();
            }
            return rootNode.getQualifiedName();
        }
        return "<Unknown>";
    }

    Node getInstrumentedNode() {
        return this.instrumentedNode;
    }

    public int hashCode() {
        return 31 * (31 + this.rootName.hashCode()) + (this.sourceSection != null ? this.sourceSection.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackTraceEntry)) {
            return false;
        }
        StackTraceEntry other = (StackTraceEntry)obj;
        return Objects.equals(this.sourceSection, other.sourceSection) && Objects.equals(this.rootName, other.rootName);
    }

    public String toString() {
        return "StackLocation [rootName=" + this.rootName + ", tags=" + this.tags + ", sourceSection=" + this.sourceSection + ", tier=" + this.compilationTier + ", root=" + this.compilationRoot + "]";
    }

    static {
        HashSet<Class<StandardTags.RootTag>> tags = new HashSet<Class<StandardTags.RootTag>>();
        tags.add(StandardTags.RootTag.class);
        DEFAULT_TAGS = Collections.unmodifiableSet(tags);
    }
}

