/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.instrumentation.AllocationEvent;
import com.oracle.truffle.api.instrumentation.AllocationEventFilter;
import com.oracle.truffle.api.instrumentation.AllocationListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import com.oracle.truffle.tools.profiler.ShadowStack;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import com.oracle.truffle.tools.profiler.impl.MemoryTracerInstrument;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.polyglot.Engine;

public final class MemoryTracer
implements Closeable {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private SourceSectionFilter filter = null;
    private final TruffleInstrument.Env env;
    private boolean closed = false;
    private boolean collecting = false;
    private EventBinding<?> activeBinding;
    private int stackLimit = 1000;
    private ShadowStack shadowStack;
    private EventBinding<?> stacksBinding;
    private final Map<Thread, ProfilerNode<Payload>> rootNodes = new HashMap<Thread, ProfilerNode<Payload>>();
    private boolean stackOverflowed = false;
    private static final SourceSectionFilter DEFAULT_FILTER = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).sourceIs(new SourceSectionFilter.SourcePredicate(){

        public boolean test(Source source) {
            return !source.isInternal();
        }
    }).build();
    Supplier<Payload> payloadFactory = new Supplier<Payload>(){

        @Override
        public Payload get() {
            return new Payload();
        }
    };
    Function<Payload, Payload> copyPayload = new Function<Payload, Payload>(){

        @Override
        public Payload apply(Payload payload) {
            Payload copy = new Payload();
            copy.totalAllocations = payload.totalAllocations;
            for (AllocationEventInfo info : payload.events) {
                copy.events.add(new AllocationEventInfo(info.language, info.allocated, info.reallocation, info.metaObjectString));
            }
            return copy;
        }
    };
    BiConsumer<Payload, Payload> mergePayload = new BiConsumer<Payload, Payload>(){

        @Override
        public void accept(Payload source, Payload dest) {
            Payload payload = dest;
            payload.totalAllocations = payload.totalAllocations + source.totalAllocations;
            for (AllocationEventInfo info : source.events) {
                dest.events.add(new AllocationEventInfo(info.language, info.allocated, info.reallocation, info.metaObjectString));
            }
        }
    };

    MemoryTracer(TruffleInstrument.Env env) {
        this.env = env;
    }

    void resetTracer() {
        assert (Thread.holdsLock(this));
        if (this.activeBinding != null) {
            this.activeBinding.dispose();
            this.activeBinding = null;
        }
        if (!this.collecting || this.closed) {
            return;
        }
        SourceSectionFilter f = this.filter;
        if (f == null) {
            f = DEFAULT_FILTER;
        }
        this.shadowStack = new ShadowStack(this.stackLimit, f, this.env.getInstrumenter(), TruffleLogger.getLogger((String)"cputracer"));
        this.stacksBinding = this.shadowStack.install(this.env.getInstrumenter(), f, false);
        this.activeBinding = this.env.getInstrumenter().attachAllocationListener(AllocationEventFilter.ANY, (AllocationListener)new Listener());
    }

    public static MemoryTracer find(Engine engine) {
        return MemoryTracerInstrument.getTracer(engine);
    }

    public synchronized void setCollecting(boolean collecting) {
        if (this.closed) {
            throw new IllegalStateException("Memory Tracer is already closed.");
        }
        if (this.collecting != collecting) {
            this.collecting = collecting;
            this.resetTracer();
        }
    }

    public synchronized boolean isCollecting() {
        return this.collecting;
    }

    public synchronized Collection<ProfilerNode<Payload>> getRootNodes() {
        ProfilerNode<Payload> copy = new ProfilerNode<Payload>();
        for (ProfilerNode<Payload> node : this.rootNodes.values()) {
            copy.deepMergeChildrenFrom(node, this.mergePayload, this.payloadFactory);
        }
        return copy.getChildren();
    }

    public synchronized Map<Thread, Collection<ProfilerNode<Payload>>> getThreadToNodesMap() {
        HashMap returnValue = new HashMap();
        for (Map.Entry<Thread, ProfilerNode<Payload>> entry : this.rootNodes.entrySet()) {
            ProfilerNode<Payload> copy = new ProfilerNode<Payload>();
            copy.deepCopyChildrenFrom(entry.getValue(), this.copyPayload);
            returnValue.put(entry.getKey(), copy.getChildren());
        }
        return Collections.unmodifiableMap(returnValue);
    }

    public synchronized void clearData() {
        for (ProfilerNode<Payload> node : this.rootNodes.values()) {
            Map rootChildren = node.children;
            if (rootChildren == null) continue;
            rootChildren.clear();
        }
    }

    public synchronized boolean hasData() {
        boolean hasData = false;
        for (ProfilerNode<Payload> node : this.rootNodes.values()) {
            Map rootChildren = node.children;
            hasData |= rootChildren != null && !rootChildren.isEmpty();
        }
        return hasData;
    }

    public synchronized int getStackLimit() {
        return this.stackLimit;
    }

    public synchronized void setStackLimit(int stackLimit) {
        this.verifyConfigAllowed();
        if (stackLimit < 1) {
            throw new IllegalArgumentException(String.format("Invalid stack limit %s.", stackLimit));
        }
        this.stackLimit = stackLimit;
    }

    public boolean hasStackOverflowed() {
        return this.stackOverflowed;
    }

    public synchronized void setFilter(SourceSectionFilter filter) {
        this.verifyConfigAllowed();
        this.filter = filter;
    }

    @Override
    public synchronized void close() {
        assert (Thread.holdsLock(this));
        if (this.stacksBinding != null) {
            this.stacksBinding.dispose();
            this.stacksBinding = null;
        }
        if (this.shadowStack != null) {
            this.shadowStack = null;
        }
    }

    private void verifyConfigAllowed() {
        assert (Thread.holdsLock(this));
        if (this.closed) {
            throw new IllegalStateException("Memory Tracer is already closed.");
        }
        if (this.collecting) {
            throw new IllegalStateException("Cannot change tracer configuration while collecting. Call setCollecting(false) to disable collection first.");
        }
    }

    static {
        MemoryTracerInstrument.setFactory(new ProfilerToolFactory<MemoryTracer>(){

            @Override
            public MemoryTracer create(TruffleInstrument.Env env) {
                return new MemoryTracer(env);
            }
        });
    }

    public static final class AllocationEventInfo {
        private final LanguageInfo language;
        private final long allocated;
        private final boolean reallocation;
        private final String metaObjectString;

        AllocationEventInfo(LanguageInfo language, long allocated, boolean realocation, String metaObjectString) {
            this.language = language;
            this.allocated = allocated;
            this.reallocation = realocation;
            this.metaObjectString = metaObjectString;
        }

        public LanguageInfo getLanguage() {
            return this.language;
        }

        public long getAllocated() {
            return this.allocated;
        }

        public boolean isReallocation() {
            return this.reallocation;
        }

        public String getMetaObjectString() {
            return this.metaObjectString;
        }
    }

    public static final class Payload {
        private final List<AllocationEventInfo> events = new ArrayList<AllocationEventInfo>();
        private long totalAllocations = 0L;

        Payload() {
        }

        public long getTotalAllocations() {
            return this.totalAllocations;
        }

        public void incrementTotalAllocations() {
            ++this.totalAllocations;
        }

        public List<AllocationEventInfo> getEvents() {
            return this.events;
        }
    }

    private final class Listener
    implements AllocationListener {
        ThreadLocal<Boolean> gettingMetaObject = ThreadLocal.withInitial(() -> false);

        private Listener() {
        }

        public void onEnter(AllocationEvent event) {
        }

        @CompilerDirectives.TruffleBoundary
        public void onReturnValue(AllocationEvent event) {
            String metaObjectString;
            if (this.gettingMetaObject.get().booleanValue()) {
                return;
            }
            ShadowStack.ThreadLocalStack stack = MemoryTracer.this.shadowStack.getStack(Thread.currentThread());
            if (stack == null || stack.getStackIndex() == -1) {
                return;
            }
            if (stack.hasStackOverflowed()) {
                MemoryTracer.this.stackOverflowed = true;
                return;
            }
            LanguageInfo languageInfo = event.getLanguage();
            this.gettingMetaObject.set(true);
            Object view = MemoryTracer.this.env.getLanguageView(languageInfo, event.getValue());
            InteropLibrary viewLib = (InteropLibrary)InteropLibrary.getFactory().getUncached(view);
            if (viewLib.hasMetaObject(view)) {
                try {
                    metaObjectString = INTEROP.asString(INTEROP.getMetaQualifiedName(viewLib.getMetaObject(view)));
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new AssertionError((Object)e);
                }
            } else {
                metaObjectString = "null";
            }
            this.gettingMetaObject.set(false);
            AllocationEventInfo info = new AllocationEventInfo(languageInfo, event.getNewSize() - event.getOldSize(), event.getOldSize() != 0L, metaObjectString);
            this.handleEvent(stack, info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean handleEvent(ShadowStack.ThreadLocalStack stack, AllocationEventInfo info) {
            StackTraceEntry[] locations = stack.getStack();
            if (locations == null) {
                return false;
            }
            MemoryTracer memoryTracer = MemoryTracer.this;
            synchronized (memoryTracer) {
                ProfilerNode<Payload> treeNode = MemoryTracer.this.rootNodes.computeIfAbsent(Thread.currentThread(), new Function<Thread, ProfilerNode<Payload>>(){

                    @Override
                    public ProfilerNode<Payload> apply(Thread thread) {
                        return new ProfilerNode<Payload>();
                    }
                });
                for (int i = 0; i < locations.length; ++i) {
                    StackTraceEntry location = locations[i];
                    ProfilerNode<Payload> child = treeNode.findChild(location);
                    if (child == null) {
                        child = new ProfilerNode<Payload>(treeNode, location, new Payload());
                        treeNode.addChild(location, child);
                    }
                    treeNode = child;
                    treeNode.getPayload().incrementTotalAllocations();
                }
                treeNode.getPayload().getEvents().add(info);
                return true;
            }
        }
    }
}

