/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.RemoteObjectsHandler;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import com.oracle.truffle.tools.chromeinspector.types.TypeInfo;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;

public final class CustomPreview {
    private static final String DEVTOOLS_FORMATTERS = "devtoolsFormatters";
    private static final String HEADER = "header";
    private static final String HAS_BODY = "hasBody";
    private static final String BODY = "body";
    private static final String BODY_GETTER_ID = "bodyGetterId";

    private CustomPreview() {
    }

    static JSONObject create(DebugValue debugValue, LanguageInfo language, InspectorExecutionContext context) {
        return CustomPreview.create(debugValue, null, language, context);
    }

    private static JSONObject create(DebugValue debugValue, DebugValue config, LanguageInfo language, InspectorExecutionContext context) {
        DebuggerSession debuggerSession = debugValue.getSession();
        DebugValue formatters = null;
        for (DebugScope topScope = debuggerSession.getTopScope(language.getId()); topScope != null && (formatters = topScope.getDeclaredValue(DEVTOOLS_FORMATTERS)) == null; topScope = topScope.getParent()) {
        }
        if (formatters == null || !formatters.isArray()) {
            return null;
        }
        for (DebugValue formatter : formatters.getArray()) {
            DebugValue bodyFunction;
            DebugValue header;
            block14: {
                boolean hasBody;
                block13: {
                    DebugValue headerFunction;
                    try {
                        headerFunction = formatter.getProperty(HEADER);
                        if (headerFunction == null) continue;
                        if (!headerFunction.canExecute()) {
                        }
                    }
                    catch (DebugException ex) {}
                    continue;
                    DebugValue debugValue2 = header = config != null ? headerFunction.execute(new DebugValue[]{debugValue, config}) : headerFunction.execute(new DebugValue[]{debugValue});
                    if (header.isNull()) continue;
                    hasBody = false;
                    try {
                        DebugValue hasBodyFunction = formatter.getProperty(HAS_BODY);
                        if (hasBodyFunction != null && hasBodyFunction.canExecute()) {
                            DebugValue hasBodyValue = config != null ? hasBodyFunction.execute(new DebugValue[]{debugValue, config}) : hasBodyFunction.execute(new DebugValue[]{debugValue});
                            hasBody = hasBodyValue.isBoolean() ? hasBodyValue.asBoolean() : false;
                        }
                    }
                    catch (DebugException ex) {
                        PrintWriter err = context.getErr();
                        if (err == null) break block13;
                        ex.printStackTrace(err);
                    }
                }
                bodyFunction = null;
                if (hasBody) {
                    try {
                        bodyFunction = formatter.getProperty(BODY);
                        if (bodyFunction != null && !bodyFunction.canExecute()) {
                            bodyFunction = null;
                        }
                    }
                    catch (DebugException ex) {
                        PrintWriter err = context.getErr();
                        if (err == null) break block14;
                        ex.printStackTrace(err);
                    }
                }
            }
            return CustomPreview.createJSON(debugValue, config, header, bodyFunction, context);
        }
        return null;
    }

    private static JSONObject createJSON(DebugValue debugValue, DebugValue config, DebugValue headerValue, DebugValue bodyFunction, InspectorExecutionContext context) {
        JSONObject json = new JSONObject();
        json.put(HEADER, (Object)CustomPreview.value2JSON(headerValue, context).toString());
        if (bodyFunction != null) {
            RemoteObject bodyFunctionRemote = context.getRemoteObjectsHandler().getRemote(bodyFunction);
            RemoteObjectsHandler objectsHandler = context.getRemoteObjectsHandler();
            objectsHandler.registerCustomPreviewBody(bodyFunctionRemote.getId(), bodyFunction);
            if (config != null) {
                String objectId = objectsHandler.getRemote(debugValue).getId();
                objectsHandler.registerCustomPreviewConfig(objectId, config);
            }
            json.put(BODY_GETTER_ID, (Object)bodyFunctionRemote.getId());
        }
        return json;
    }

    public static Object value2JSON(DebugValue value, InspectorExecutionContext context) {
        if (value.isArray()) {
            JSONArray json = new JSONArray();
            List array = value.getArray();
            if (array.size() == 2 && ((DebugValue)array.get(0)).isReadable() && ((DebugValue)array.get(1)).isReadable() && "object".equals(((DebugValue)array.get(0)).asString()) && ((DebugValue)array.get(1)).getProperty("config") != null) {
                json.put(CustomPreview.value2JSON((DebugValue)array.get(0), context));
                DebugValue child = (DebugValue)array.get(1);
                DebugValue object = child.getProperty("object");
                DebugValue config = child.getProperty("config");
                RemoteObject remoteConfig = context.getRemoteObjectsHandler().getRemote(object);
                JSONObject childJSON = remoteConfig.toJSON();
                JSONObject customPreview = CustomPreview.create(object, config, object.getOriginalLanguage(), context);
                if (customPreview != null) {
                    childJSON.put("customPreview", (Object)customPreview);
                }
                json.put((Object)childJSON);
            } else {
                for (DebugValue element : array) {
                    if (element.isReadable()) {
                        json.put(CustomPreview.value2JSON(element, context));
                        continue;
                    }
                    json.put((Object)"<not readable>");
                }
            }
            return json;
        }
        Collection properties = value.getProperties();
        if (properties != null) {
            JSONObject json = new JSONObject();
            for (DebugValue property : properties) {
                try {
                    Object rawValue;
                    if (!property.isReadable() || property.canExecute() || property.isInternal() || (rawValue = CustomPreview.getPrimitiveValue(property)) == null) continue;
                    json.put(property.getName(), rawValue);
                }
                catch (DebugException ex) {
                    if (ex.isInternalError()) {
                        PrintWriter err = context.getErr();
                        if (err == null) continue;
                        ex.printStackTrace(err);
                        continue;
                    }
                    throw ex;
                }
            }
            return json;
        }
        return CustomPreview.getPrimitiveValue(value);
    }

    private static Object getPrimitiveValue(DebugValue value) {
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber()) {
            return TypeInfo.toNumber(value);
        }
        if (value.isString()) {
            return value.asString();
        }
        return null;
    }
}

