/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugStackTraceElement;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.StepConfig;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.tools.chromeinspector.BreakpointsHandler;
import com.oracle.truffle.tools.chromeinspector.ConsoleUtilitiesAPI;
import com.oracle.truffle.tools.chromeinspector.DebuggerSuspendedInfo;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.InspectorRuntime;
import com.oracle.truffle.tools.chromeinspector.LanguageChecks;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.chromeinspector.SuspendThreadExecutable;
import com.oracle.truffle.tools.chromeinspector.SuspendableLocationFinder;
import com.oracle.truffle.tools.chromeinspector.commands.Params;
import com.oracle.truffle.tools.chromeinspector.commands.Result;
import com.oracle.truffle.tools.chromeinspector.domains.DebuggerDomain;
import com.oracle.truffle.tools.chromeinspector.events.Event;
import com.oracle.truffle.tools.chromeinspector.server.CommandProcessException;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import com.oracle.truffle.tools.chromeinspector.types.CallArgument;
import com.oracle.truffle.tools.chromeinspector.types.CallFrame;
import com.oracle.truffle.tools.chromeinspector.types.ExceptionDetails;
import com.oracle.truffle.tools.chromeinspector.types.Location;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import com.oracle.truffle.tools.chromeinspector.types.Scope;
import com.oracle.truffle.tools.chromeinspector.types.Script;
import com.oracle.truffle.tools.chromeinspector.types.StackTrace;
import com.oracle.truffle.tools.chromeinspector.util.LineSearch;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.graalvm.collections.Pair;

public final class InspectorDebugger
extends DebuggerDomain {
    private static final StepConfig STEP_CONFIG = StepConfig.newBuilder().suspendAnchors(SourceElement.ROOT, new SuspendAnchor[]{SuspendAnchor.AFTER}).build();
    private static final Pattern FUNCTION_COMPLETION_PATTERN = Pattern.compile("\\(function\\s*\\((?<x>\\w+)\\)\\s*\\{\\s*var\\s+(?<a>\\w+)\\s*=\\s*\\[\\];\\s*for\\s*\\(var\\s+(?<o>\\w+)\\s*=\\s*\\k<x>;\\s*\\k<o>\\s*\\!==\\s*null\\s*&&\\s*typeof\\s+\\k<o>\\s*\\!==\\s*.undefined.;\\k<o>\\s*=\\s*\\k<o>\\.__proto__\\)\\s*\\{\\s*\\k<a>\\.push\\(Object\\.getOwnPropertyNames\\(\\k<o>\\)\\)\\};\\s*return\\s+\\k<a>\\}\\)\\((?<object>.*)\\)$");
    private final InspectorExecutionContext context;
    private final Object suspendLock = new Object();
    private volatile SuspendedCallbackImpl suspendedCallback;
    private volatile DebuggerSession debuggerSession;
    private volatile ScriptsHandler scriptsHandler;
    private volatile BreakpointsHandler breakpointsHandler;
    private volatile DebuggerSuspendedInfo suspendedInfo;
    private boolean running = true;
    private boolean runningUnwind = false;
    private boolean silentResume = false;
    private volatile CommandLazyResponse commandLazyResponse;
    private final AtomicBoolean delayUnlock = new AtomicBoolean();
    private final Phaser onSuspendPhaser = new Phaser();
    private final BlockingQueue<InspectorExecutionContext.CancellableRunnable> suspendThreadExecutables = new LinkedBlockingQueue<InspectorExecutionContext.CancellableRunnable>();
    private final ReadWriteLock domainLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InspectorDebugger(InspectorExecutionContext context, boolean suspend, ReadWriteLock domainLock) {
        this.context = context;
        this.domainLock = domainLock;
        context.setSuspendThreadExecutor(new InspectorExecutionContext.SuspendedThreadExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(InspectorExecutionContext.CancellableRunnable executable) throws InspectorExecutionContext.NoSuspendedThreadException {
                try {
                    Object object = InspectorDebugger.this.suspendLock;
                    synchronized (object) {
                        if (InspectorDebugger.this.running) {
                            InspectorExecutionContext.NoSuspendedThreadException.raise();
                        }
                        InspectorDebugger.this.suspendThreadExecutables.put(executable);
                        InspectorDebugger.this.suspendLock.notifyAll();
                    }
                }
                catch (InterruptedException iex) {
                    throw new RuntimeException(iex);
                }
            }
        });
        if (suspend) {
            Lock lock = domainLock.writeLock();
            lock.lock();
            try {
                this.startSession();
            }
            finally {
                lock.unlock();
            }
            this.debuggerSession.suspendNextExecution();
        }
    }

    private void startSession() {
        Debugger tdbg = (Debugger)this.context.getEnv().lookup((InstrumentInfo)this.context.getEnv().getInstruments().get("debugger"), Debugger.class);
        this.suspendedCallback = new SuspendedCallbackImpl();
        this.debuggerSession = tdbg.startSession((SuspendedCallback)this.suspendedCallback, new SourceElement[]{SourceElement.ROOT, SourceElement.STATEMENT});
        this.debuggerSession.setSourcePath(this.context.getSourcePath());
        this.debuggerSession.setSteppingFilter(SuspensionFilter.newBuilder().ignoreLanguageContextInitialization(!this.context.isInspectInitialization()).includeInternal(this.context.isInspectInternal()).build());
        this.scriptsHandler = this.context.acquireScriptsHandler();
        this.scriptsHandler.setDebuggerSession(this.debuggerSession);
        this.breakpointsHandler = new BreakpointsHandler(this.debuggerSession, this.scriptsHandler, () -> this.eventHandler);
    }

    @Override
    public void doEnable() {
        if (this.debuggerSession == null) {
            this.startSession();
        }
        this.scriptsHandler.addLoadScriptListener(new LoadScriptListenerImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDisable() {
        assert (this.debuggerSession != null);
        this.scriptsHandler.setDebuggerSession(null);
        this.debuggerSession.close();
        this.debuggerSession = null;
        this.suspendedCallback.dispose();
        this.suspendedCallback = null;
        this.context.releaseScriptsHandler();
        this.scriptsHandler = null;
        this.breakpointsHandler = null;
        Object object = this.suspendLock;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.suspendLock.notifyAll();
            }
        }
    }

    @Override
    protected void notifyDisabled() {
        if (this.debuggerSession != null) {
            this.doDisable();
        }
    }

    @Override
    public void setAsyncCallStackDepth(int maxDepth) throws CommandProcessException {
        if (maxDepth < 0) {
            throw new CommandProcessException("Invalid async call stack depth: " + maxDepth);
        }
        this.debuggerSession.setAsynchronousStackDepth(maxDepth);
    }

    @Override
    public void setBlackboxPatterns(String[] patterns) {
        Pattern[] compiledPatterns = new Pattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            compiledPatterns[i] = Pattern.compile(patterns[i]);
        }
        this.debuggerSession.setSteppingFilter(SuspensionFilter.newBuilder().ignoreLanguageContextInitialization(!this.context.isInspectInitialization()).includeInternal(this.context.isInspectInternal()).sourceIs(source -> !this.sourceMatchesBlackboxPatterns((Source)source, compiledPatterns)).build());
    }

    @Override
    public void setPauseOnExceptions(String state) throws CommandProcessException {
        switch (state) {
            case "none": {
                this.breakpointsHandler.setExceptionBreakpoint(false, false);
                break;
            }
            case "uncaught": {
                this.breakpointsHandler.setExceptionBreakpoint(false, true);
                break;
            }
            case "all": {
                this.breakpointsHandler.setExceptionBreakpoint(true, true);
                break;
            }
            default: {
                throw new CommandProcessException("Unknown Pause on exceptions mode: " + state);
            }
        }
    }

    @Override
    public Params getPossibleBreakpoints(Location start, Location end, boolean restrictToFunction) throws CommandProcessException {
        if (start == null) {
            throw new CommandProcessException("Start location required.");
        }
        int scriptId = start.getScriptId();
        if (end != null && scriptId != end.getScriptId()) {
            throw new CommandProcessException("Different location scripts: " + scriptId + ", " + end.getScriptId());
        }
        Script script = this.scriptsHandler.getScript(scriptId);
        if (script == null) {
            throw new CommandProcessException("Unknown scriptId: " + scriptId);
        }
        JSONObject json = new JSONObject();
        JSONArray arr = new JSONArray();
        Source source = script.getSourceLoaded();
        if (source.hasCharacters() && source.getLength() > 0) {
            int c2;
            int l2;
            int lc = source.getLineCount();
            int l1 = start.getLine();
            int c1 = start.getColumn();
            if (c1 <= 0) {
                c1 = 1;
            }
            if (l1 > lc) {
                l1 = lc;
                c1 = source.getLineLength(l1);
            }
            if (end != null) {
                l2 = end.getLine();
                c2 = end.getColumn();
                if (l1 != l2 || c1 != c2) {
                    if (l2 > lc) {
                        l2 = lc;
                        c2 = source.getLineLength(l2);
                    } else if (c2 <= 1) {
                        if (--l2 <= 0) {
                            l2 = 1;
                        }
                        c2 = source.getLineLength(l2);
                    } else {
                        --c2;
                    }
                    if (l1 > l2) {
                        l1 = l2;
                    }
                }
            } else {
                l2 = l1;
                c2 = source.getLineLength(l2);
            }
            if (c2 == 0) {
                c2 = 1;
            }
            if (l1 == l2 && c2 < c1) {
                c1 = c2;
            }
            SourceSection range = source.createSection(l1, c1, l2, c2);
            Iterable<SourceSection> locations = SuspendableLocationFinder.findSuspendableLocations(range, restrictToFunction, this.debuggerSession, this.context.getEnv());
            for (SourceSection ss : locations) {
                arr.put((Object)new Location(scriptId, ss.getStartLine(), ss.getStartColumn()).toJSON());
            }
        }
        json.put("locations", (Object)arr);
        return new Params(json);
    }

    @Override
    public Params getScriptSource(String scriptId) throws CommandProcessException {
        if (scriptId == null) {
            throw new CommandProcessException("A scriptId required.");
        }
        CharSequence characters = this.getScript(scriptId).getCharacters();
        JSONObject json = new JSONObject();
        json.put("scriptSource", (Object)characters.toString());
        return new Params(json);
    }

    private Script getScript(String scriptId) throws CommandProcessException {
        Script script;
        try {
            script = this.scriptsHandler.getScript(Integer.parseInt(scriptId));
            if (script == null) {
                throw new CommandProcessException("Unknown scriptId: " + scriptId);
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandProcessException(nfe.getMessage());
        }
        return script;
    }

    @Override
    public void pause() {
        DebuggerSuspendedInfo susp = this.suspendedInfo;
        if (susp == null) {
            this.debuggerSession.suspendNextExecution();
        }
    }

    @Override
    public void resume(InspectServerSession.CommandPostProcessor postProcessor) {
        DebuggerSuspendedInfo susp = this.suspendedInfo;
        if (susp != null) {
            postProcessor.setPostProcessJob(() -> this.doResume());
        }
    }

    @Override
    public void stepInto(InspectServerSession.CommandPostProcessor postProcessor) {
        DebuggerSuspendedInfo susp = this.suspendedInfo;
        if (susp != null) {
            susp.getSuspendedEvent().prepareStepInto(STEP_CONFIG);
            this.delayUnlock.set(true);
            postProcessor.setPostProcessJob(() -> this.doResume());
        }
    }

    @Override
    public void stepOver(InspectServerSession.CommandPostProcessor postProcessor) {
        DebuggerSuspendedInfo susp = this.suspendedInfo;
        if (susp != null) {
            susp.getSuspendedEvent().prepareStepOver(STEP_CONFIG);
            this.delayUnlock.set(true);
            postProcessor.setPostProcessJob(() -> this.doResume());
        }
    }

    @Override
    public void stepOut(InspectServerSession.CommandPostProcessor postProcessor) {
        DebuggerSuspendedInfo susp = this.suspendedInfo;
        if (susp != null) {
            susp.getSuspendedEvent().prepareStepOut(STEP_CONFIG);
            this.delayUnlock.set(true);
            postProcessor.setPostProcessJob(() -> this.doResume());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResume() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.suspendLock.notifyAll();
            }
        }
        try {
            this.onSuspendPhaser.awaitAdvanceInterruptibly(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private CallFrame[] createCallFrames(Iterable<DebugStackFrame> frames, SuspendAnchor topAnchor, DebugValue returnValue) {
        return this.createCallFrames(frames, topAnchor, returnValue, null);
    }

    CallFrame[] refreshCallFrames(Iterable<DebugStackFrame> frames, SuspendAnchor topAnchor, CallFrame[] oldFrames) {
        DebugValue returnValue = null;
        if (oldFrames.length > 0 && oldFrames[0].getReturnValue() != null) {
            returnValue = oldFrames[0].getReturnValue().getDebugValue();
        }
        return this.createCallFrames(frames, topAnchor, returnValue, oldFrames);
    }

    private CallFrame[] createCallFrames(Iterable<DebugStackFrame> frames, SuspendAnchor topAnchor, DebugValue returnValue, CallFrame[] oldFrames) {
        ArrayList<CallFrame> cfs = new ArrayList<CallFrame>();
        int depth = 0;
        int depthAll = -1;
        if (this.scriptsHandler == null || this.debuggerSession == null) {
            return new CallFrame[0];
        }
        for (DebugStackFrame frame : frames) {
            RemoteObject thisObj;
            int scopeIndex;
            int thisIndex;
            ArrayList<DebugValue> receivers;
            Scope[] oldScopes;
            SourceSection functionSourceSection;
            DebugScope dscope;
            ArrayList<Scope> scopes;
            Script script;
            SourceSection sourceSection;
            block23: {
                ++depthAll;
                sourceSection = frame.getSourceSection();
                if (sourceSection == null || !sourceSection.isAvailable() || !this.context.isInspectInternal() && frame.isInternal()) continue;
                Source source = sourceSection.getSource();
                if (!this.context.isInspectInternal() && source.isInternal()) continue;
                script = this.scriptsHandler.assureLoaded(source);
                scopes = new ArrayList<Scope>();
                try {
                    dscope = frame.getScope();
                }
                catch (DebugException ex) {
                    PrintWriter err = this.context.getErr();
                    if (err != null) {
                        err.println("getScope() has caused " + ex);
                        ex.printStackTrace(err);
                    }
                    dscope = null;
                }
                String scopeType = "block";
                boolean wasFunction = false;
                functionSourceSection = null;
                if (dscope == null) {
                    functionSourceSection = sourceSection;
                }
                oldScopes = oldFrames != null && oldFrames.length > depth ? oldFrames[depth].getScopeChain() : null;
                receivers = new ArrayList<DebugValue>();
                thisIndex = -1;
                scopeIndex = 0;
                TriState isJS = TriState.UNDEFINED;
                while (dscope != null) {
                    if (wasFunction) {
                        scopeType = "closure";
                    } else if (dscope.isFunctionScope()) {
                        scopeType = "local";
                        functionSourceSection = dscope.getSourceSection();
                        wasFunction = true;
                    }
                    boolean scopeAdded = this.addScope(scopes, dscope, scopeType, scopeIndex, oldScopes);
                    if (scopeAdded) {
                        DebugValue receiver = dscope.getReceiver();
                        receivers.add(receiver);
                        if (receiver != null) {
                            if (thisIndex == -1 && "this".equals(receiver.getName())) {
                                thisIndex = scopes.size() - 1;
                            } else {
                                if (TriState.UNDEFINED == isJS) {
                                    isJS = TriState.valueOf((boolean)LanguageChecks.isJS(receiver.getOriginalLanguage()));
                                }
                                if (TriState.FALSE == isJS) {
                                    thisIndex = -2;
                                }
                            }
                        }
                    }
                    dscope = this.getParent(dscope);
                    ++scopeIndex;
                }
                try {
                    dscope = this.debuggerSession.getTopScope(source.getLanguage());
                }
                catch (DebugException ex) {
                    PrintWriter err = this.context.getErr();
                    if (err == null) break block23;
                    err.println("getTopScope() has caused " + ex);
                    ex.printStackTrace(err);
                }
            }
            while (dscope != null) {
                this.addScope(scopes, dscope, "global", scopeIndex, oldScopes);
                dscope = this.getParent(dscope);
                ++scopeIndex;
            }
            RemoteObject returnObj = null;
            if (depthAll == 0 && returnValue != null) {
                returnObj = this.context.getRemoteObjectsHandler().getRemote(returnValue);
            }
            if (thisIndex < -1) {
                for (int i = 0; i < receivers.size(); ++i) {
                    DebugValue receiver = (DebugValue)receivers.get(i);
                    if (receiver == null) continue;
                    ((Scope)scopes.get(i)).getObject().setScopeReceiver(receiver);
                }
                thisObj = null;
            } else {
                thisObj = thisIndex == -1 ? null : this.context.getRemoteObjectsHandler().getRemote((DebugValue)receivers.get(thisIndex));
            }
            SuspendAnchor anchor = depthAll == 0 ? topAnchor : SuspendAnchor.BEFORE;
            CallFrame cf = new CallFrame(frame, depth++, script, sourceSection, anchor, functionSourceSection, thisObj, returnObj, scopes.toArray(new Scope[scopes.size()]));
            cfs.add(cf);
        }
        return cfs.toArray(new CallFrame[cfs.size()]);
    }

    private boolean addScope(List<Scope> scopes, DebugScope dscope, String scopeType, int scopeIndex, Scope[] oldScopes) {
        if (dscope.isFunctionScope() || dscope.getDeclaredValues().iterator().hasNext()) {
            String lastId = InspectorDebugger.getLastScopeId(oldScopes, scopeIndex);
            scopes.add(this.createScope(scopeType, dscope, scopeIndex, lastId));
            return true;
        }
        return false;
    }

    private static String getLastScopeId(Scope[] oldScopes, int scopeIndex) {
        if (oldScopes != null) {
            for (Scope scope : oldScopes) {
                if (scope.getInternalIndex() != scopeIndex) continue;
                return scope.getObject().getId();
            }
        }
        return null;
    }

    private Scope createScope(String scopeType, DebugScope dscope, int index, String lastId) {
        RemoteObject scopeVars = new RemoteObject(dscope, lastId);
        this.context.getRemoteObjectsHandler().register(scopeVars);
        return new Scope(scopeType, scopeVars, dscope.getName(), null, null, index);
    }

    private DebugScope getParent(DebugScope dscope) {
        DebugScope parentScope;
        try {
            parentScope = dscope.getParent();
        }
        catch (DebugException ex) {
            PrintWriter err = this.context.getErr();
            if (err != null) {
                err.println("Scope.getParent() has caused " + ex);
                ex.printStackTrace(err);
            }
            parentScope = null;
        }
        return parentScope;
    }

    @Override
    public Params searchInContent(String scriptId, String query, boolean caseSensitive, boolean isRegex) throws CommandProcessException {
        JSONArray matchLines;
        if (scriptId.isEmpty() || query.isEmpty()) {
            throw new CommandProcessException("Must specify both scriptId and query.");
        }
        Source source = this.getScript(scriptId).getSource();
        try {
            matchLines = LineSearch.matchLines(source, query, caseSensitive, isRegex);
        }
        catch (PatternSyntaxException ex) {
            throw new CommandProcessException(ex.getDescription());
        }
        JSONObject match = new JSONObject();
        match.put("properties", (Object)matchLines);
        return new Params(match);
    }

    @Override
    public void setBreakpointsActive(Optional<Boolean> active) throws CommandProcessException {
        if (!active.isPresent()) {
            throw new CommandProcessException("Must specify active argument.");
        }
        this.debuggerSession.setBreakpointsActive(Breakpoint.Kind.SOURCE_LOCATION, active.get().booleanValue());
    }

    @Override
    public void setSkipAllPauses(Optional<Boolean> skip) throws CommandProcessException {
        if (!skip.isPresent()) {
            throw new CommandProcessException("Must specify 'skip' argument.");
        }
        boolean active = skip.get() == false;
        for (Breakpoint.Kind kind : Breakpoint.Kind.values()) {
            this.debuggerSession.setBreakpointsActive(kind, active);
        }
    }

    @Override
    public Params setBreakpointByUrl(String url, String urlRegex, int line, int column, String condition) throws CommandProcessException {
        if (url.isEmpty() && urlRegex.isEmpty()) {
            throw new CommandProcessException("Must specify either url or urlRegex.");
        }
        if (line <= 0) {
            throw new CommandProcessException("Must specify line number.");
        }
        if (!url.isEmpty()) {
            return this.breakpointsHandler.createURLBreakpoint(url, line, column, condition);
        }
        return this.breakpointsHandler.createURLBreakpoint(Pattern.compile(urlRegex), line, column, condition);
    }

    @Override
    public Params setBreakpoint(Location location, String condition) throws CommandProcessException {
        if (location == null) {
            throw new CommandProcessException("Must specify location.");
        }
        return this.breakpointsHandler.createBreakpoint(location, condition);
    }

    @Override
    public Params setBreakpointOnFunctionCall(String functionObjectId, final String condition) throws CommandProcessException {
        if (functionObjectId == null) {
            throw new CommandProcessException("Must specify function object ID.");
        }
        RemoteObject functionObject = this.context.getRemoteObjectsHandler().getRemote(functionObjectId);
        if (functionObject != null) {
            final DebugValue functionValue = functionObject.getDebugValue();
            try {
                return this.context.executeInSuspendThread(new SuspendThreadExecutable<Params>(){

                    @Override
                    public Params executeCommand() throws CommandProcessException {
                        return InspectorDebugger.this.breakpointsHandler.createFunctionBreakpoint(functionValue, condition);
                    }

                    @Override
                    public Params processException(DebugException dex) {
                        return new Params(new JSONObject());
                    }
                });
            }
            catch (InspectorExecutionContext.NoSuspendedThreadException e) {
                return new Params(new JSONObject());
            }
        }
        throw new CommandProcessException("Function with object ID " + functionObjectId + " does not exist.");
    }

    @Override
    public void removeBreakpoint(String id) throws CommandProcessException {
        if (!this.breakpointsHandler.removeBreakpoint(id)) {
            throw new CommandProcessException("No breakpoint with id '" + id + "'");
        }
    }

    @Override
    public void continueToLocation(Location location, InspectServerSession.CommandPostProcessor postProcessor) throws CommandProcessException {
        if (location == null) {
            throw new CommandProcessException("Must specify location.");
        }
        this.breakpointsHandler.createOneShotBreakpoint(location);
        this.resume(postProcessor);
    }

    static String getEvalNonInteractiveMessage() {
        return "<Can not evaluate in a non-interactive language>";
    }

    @Override
    public Params evaluateOnCallFrame(String callFrameId, String expressionOrig, final String objectGroup, boolean includeCommandLineAPI, boolean silent, boolean returnByValue, final boolean generatePreview, boolean throwOnSideEffect) throws CommandProcessException {
        JSONObject jsonResult;
        int frameId;
        if (callFrameId == null) {
            throw new CommandProcessException("A callFrameId required.");
        }
        if (expressionOrig == null) {
            throw new CommandProcessException("An expression required.");
        }
        try {
            frameId = Integer.parseInt(callFrameId);
        }
        catch (NumberFormatException ex) {
            throw new CommandProcessException(ex.getLocalizedMessage());
        }
        final ConsoleUtilitiesAPI cuAPI = includeCommandLineAPI ? ConsoleUtilitiesAPI.parse(expressionOrig) : null;
        final String expression = cuAPI != null ? cuAPI.getExpression() : expressionOrig;
        try {
            jsonResult = this.context.executeInSuspendThread(new SuspendThreadExecutable<JSONObject>(){

                @Override
                public JSONObject executeCommand() throws CommandProcessException {
                    LanguageInfo languageInfo;
                    JSONObject json;
                    if (frameId >= InspectorDebugger.this.suspendedInfo.getCallFrames().length) {
                        throw new CommandProcessException("Too big callFrameId: " + frameId);
                    }
                    CallFrame cf = InspectorDebugger.this.suspendedInfo.getCallFrames()[frameId];
                    if (InspectorDebugger.this.runSpecialFunctions(expression, cf, json = new JSONObject())) {
                        return json;
                    }
                    DebugValue value = InspectorDebugger.getVarValue(expression, cf);
                    if (value == null) {
                        try {
                            value = cf.getFrame().eval(expression);
                            InspectorDebugger.this.suspendedInfo.refreshFrames();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    if (!(value != null || (languageInfo = cf.getFrame().getLanguage()) != null && languageInfo.isInteractive())) {
                        String errorMessage = InspectorDebugger.getEvalNonInteractiveMessage();
                        ExceptionDetails exceptionDetails = new ExceptionDetails(errorMessage);
                        json.put("exceptionDetails", (Object)exceptionDetails.createJSON(InspectorDebugger.this.context));
                        JSONObject err = new JSONObject();
                        err.putOpt("value", (Object)errorMessage);
                        err.putOpt("type", (Object)"string");
                        json.put("result", (Object)err);
                    }
                    if (value != null) {
                        if (cuAPI != null && (value = cuAPI.process(value, InspectorDebugger.this.breakpointsHandler)) == null) {
                            return json;
                        }
                        RemoteObject ro = new RemoteObject(value, generatePreview, InspectorDebugger.this.context);
                        InspectorDebugger.this.context.getRemoteObjectsHandler().register(ro, objectGroup);
                        json.put("result", (Object)ro.toJSON());
                    }
                    return json;
                }

                @Override
                public JSONObject processException(DebugException dex) {
                    JSONObject json = new JSONObject();
                    InspectorRuntime.fillExceptionDetails(json, dex, InspectorDebugger.this.context);
                    DebugValue exceptionObject = dex.getExceptionObject();
                    if (exceptionObject != null) {
                        RemoteObject ro = InspectorDebugger.this.context.createAndRegister(exceptionObject, generatePreview);
                        json.put("result", (Object)ro.toJSON());
                    } else {
                        JSONObject err = new JSONObject();
                        err.putOpt("value", (Object)dex.getLocalizedMessage());
                        err.putOpt("type", (Object)"string");
                        json.put("result", (Object)err);
                    }
                    return json;
                }
            });
        }
        catch (InspectorExecutionContext.NoSuspendedThreadException e) {
            jsonResult = new JSONObject();
            JSONObject err = new JSONObject();
            err.putOpt("value", (Object)e.getLocalizedMessage());
            jsonResult.put("result", (Object)err);
        }
        return new Params(jsonResult);
    }

    private boolean runSpecialFunctions(String expression, CallFrame cf, JSONObject json) {
        Matcher completionMatcher = FUNCTION_COMPLETION_PATTERN.matcher(expression);
        if (completionMatcher.matches()) {
            String objectOfCompletion = completionMatcher.group("object");
            DebugValue value = InspectorDebugger.getVarValue(objectOfCompletion, cf);
            if (value == null) {
                try {
                    value = cf.getFrame().eval(objectOfCompletion);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (value != null) {
                JSONObject result = InspectorRuntime.createCodecompletion(value, null, this.context, false);
                json.put("result", (Object)result);
                return true;
            }
        }
        return false;
    }

    static DebugValue getVarValue(String name, CallFrame cf) {
        for (Scope scope : cf.getScopeChain()) {
            DebugScope debugScope = scope.getObject().getScope();
            DebugValue var = debugScope.getDeclaredValue(name);
            if (var != null) {
                return var;
            }
            DebugValue receiver = debugScope.getReceiver();
            if (receiver == null || !name.equals(receiver.getName())) continue;
            return receiver;
        }
        return null;
    }

    @Override
    public Params restartFrame(long cmdId, String callFrameId, InspectServerSession.CommandPostProcessor postProcessor) throws CommandProcessException {
        int frameId;
        if (callFrameId == null) {
            throw new CommandProcessException("A callFrameId required.");
        }
        try {
            frameId = Integer.parseInt(callFrameId);
        }
        catch (NumberFormatException ex) {
            throw new CommandProcessException(ex.getLocalizedMessage());
        }
        DebuggerSuspendedInfo susp = this.suspendedInfo;
        if (susp != null) {
            if (frameId >= susp.getCallFrames().length) {
                throw new CommandProcessException("Too big callFrameId: " + frameId);
            }
            CallFrame cf = susp.getCallFrames()[frameId];
            susp.getSuspendedEvent().prepareUnwindFrame(cf.getFrame());
            postProcessor.setPostProcessJob(() -> {
                this.silentResume = true;
                this.commandLazyResponse = suspInfo -> {
                    JSONObject res = new JSONObject();
                    res.put("callFrames", (Object)InspectorDebugger.getFramesParam(suspInfo.getCallFrames()));
                    return new Event(cmdId, new Result(new Params(res)));
                };
                this.runningUnwind = true;
                this.doResume();
            });
        }
        return new Params(null);
    }

    @Override
    public void setVariableValue(final int scopeNumber, final String variableName, final CallArgument newValue, String callFrameId) throws CommandProcessException {
        int frameId;
        if (variableName == null) {
            throw new CommandProcessException("A variableName required.");
        }
        if (newValue == null) {
            throw new CommandProcessException("A newValue required.");
        }
        if (callFrameId == null) {
            throw new CommandProcessException("A callFrameId required.");
        }
        try {
            frameId = Integer.parseInt(callFrameId);
        }
        catch (NumberFormatException ex) {
            throw new CommandProcessException(ex.getLocalizedMessage());
        }
        try {
            this.context.executeInSuspendThread(new SuspendThreadExecutable<Void>(){

                @Override
                public Void executeCommand() throws CommandProcessException {
                    DebuggerSuspendedInfo susp = InspectorDebugger.this.suspendedInfo;
                    if (susp != null) {
                        if (frameId >= susp.getCallFrames().length) {
                            throw new CommandProcessException("Too big callFrameId: " + frameId);
                        }
                        CallFrame cf = susp.getCallFrames()[frameId];
                        Scope[] scopeChain = cf.getScopeChain();
                        if (scopeNumber < 0 || scopeNumber >= scopeChain.length) {
                            throw new CommandProcessException("Wrong scopeNumber: " + scopeNumber + ", there are " + scopeChain.length + " scopes.");
                        }
                        Scope scope = scopeChain[scopeNumber];
                        DebugScope debugScope = scope.getObject().getScope();
                        DebugValue debugValue = debugScope.getDeclaredValue(variableName);
                        Pair evaluatedValue = susp.lastEvaluatedValue.getAndSet(null);
                        try {
                            if (evaluatedValue != null && Objects.equals(evaluatedValue.getRight(), newValue.getPrimitiveValue())) {
                                debugValue.set((DebugValue)evaluatedValue.getLeft());
                            } else {
                                InspectorDebugger.this.context.setValue(debugValue, newValue);
                            }
                        }
                        catch (DebugException ex) {
                            PrintWriter err = InspectorDebugger.this.context.getErr();
                            if (err != null) {
                                err.println("set of " + debugValue.getName() + " has caused " + ex);
                                ex.printStackTrace(err);
                            }
                            throw ex;
                        }
                    }
                    return null;
                }

                @Override
                public Void processException(DebugException dex) {
                    return null;
                }
            });
        }
        catch (InspectorExecutionContext.NoSuspendedThreadException ex) {
            throw new CommandProcessException(ex.getLocalizedMessage());
        }
    }

    @Override
    public void setReturnValue(final CallArgument newValue) throws CommandProcessException {
        if (newValue == null) {
            throw new CommandProcessException("A newValue required.");
        }
        try {
            this.context.executeInSuspendThread(new SuspendThreadExecutable<Void>(){

                @Override
                public Void executeCommand() throws CommandProcessException {
                    DebuggerSuspendedInfo susp = InspectorDebugger.this.suspendedInfo;
                    if (susp != null) {
                        SuspendedEvent suspendedEvent = susp.getSuspendedEvent();
                        DebugValue returnValue = InspectorDebugger.this.context.getDebugValue(newValue, suspendedEvent.getSession());
                        susp.getSuspendedEvent().setReturnValue(returnValue);
                    }
                    return null;
                }

                @Override
                public Void processException(DebugException dex) {
                    return null;
                }
            });
        }
        catch (InspectorExecutionContext.NoSuspendedThreadException ex) {
            throw new CommandProcessException(ex.getLocalizedMessage());
        }
    }

    public boolean sourceMatchesBlackboxPatterns(Source source, Pattern[] patterns) {
        String uri = this.scriptsHandler.getSourceURL(source);
        for (Pattern pattern : patterns) {
            int idx;
            if (pattern.pattern().equals(source.getName())) {
                return true;
            }
            Matcher matcher = pattern.matcher(uri);
            if (matcher.matches() || pattern.pattern().endsWith("$") && matcher.find()) {
                return true;
            }
            String path = source.getPath();
            int n = idx = path != null ? path.lastIndexOf(File.separatorChar) : -1;
            if (idx <= 0 || !(path = path.substring(0, idx)).endsWith(File.separator + pattern.pattern())) continue;
            return true;
        }
        return false;
    }

    private static JSONArray getFramesParam(CallFrame[] callFrames) {
        JSONArray array = new JSONArray();
        for (CallFrame cf : callFrames) {
            array.put((Object)cf.toJSON());
        }
        return array;
    }

    private JSONObject findAsyncStackTrace(List<List<DebugStackTraceElement>> asyncStacks) {
        if (asyncStacks.isEmpty()) {
            return null;
        }
        StackTrace stackTrace = new StackTrace(this.context, asyncStacks);
        return stackTrace.toJSON();
    }

    private static interface CommandLazyResponse {
        public Event getResponse(DebuggerSuspendedInfo var1);
    }

    private static class SchedulerThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;

        SchedulerThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "Suspend Unlocking Scheduler");
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }

    private class SuspendedCallbackImpl
    implements SuspendedCallback {
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new SchedulerThreadFactory());
        private final AtomicReference<ScheduledFuture<?>> future = new AtomicReference();
        private Thread locked = null;

        private SuspendedCallbackImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onSuspend(SuspendedEvent se) {
            try {
                InspectorDebugger.this.context.waitForRunPermission();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SourceSection ss = se.getSourceSection();
            this.lock();
            InspectorDebugger.this.onSuspendPhaser.register();
            try {
                block42: {
                    LinkedList<InspectorExecutionContext.CancellableRunnable> executables;
                    Event paused;
                    Object jsonParams;
                    Lock lock = InspectorDebugger.this.domainLock.readLock();
                    lock.lock();
                    try {
                        if (InspectorDebugger.this.debuggerSession == null) {
                            return;
                        }
                        DebugValue returnValue = se.getReturnValue();
                        if (se.hasSourceElement(SourceElement.ROOT) && se.getBreakpoints().isEmpty() && (!se.hasSourceElement(SourceElement.STATEMENT) && se.getSuspendAnchor() == SuspendAnchor.BEFORE || se.getSuspendAnchor() == SuspendAnchor.AFTER && returnValue == null)) {
                            se.prepareStepInto(STEP_CONFIG);
                            return;
                        }
                        Object object = InspectorDebugger.this.suspendLock;
                        // MONITORENTER : object
                        InspectorDebugger.this.running = false;
                        // MONITOREXIT : object
                        if (!InspectorDebugger.this.runningUnwind) {
                            InspectorDebugger.this.scriptsHandler.assureLoaded(ss.getSource());
                            InspectorDebugger.this.context.setLastLanguage(ss.getSource().getLanguage(), ss.getSource().getMimeType());
                        } else {
                            InspectorDebugger.this.runningUnwind = false;
                        }
                        jsonParams = new JSONObject();
                        if (!se.hasSourceElement(SourceElement.ROOT)) {
                            returnValue = null;
                        }
                        CallFrame[] callFrames = InspectorDebugger.this.createCallFrames(se.getStackFrames(), se.getSuspendAnchor(), returnValue);
                        InspectorDebugger.this.suspendedInfo = new DebuggerSuspendedInfo(InspectorDebugger.this, se, callFrames);
                        InspectorDebugger.this.context.setSuspendedInfo(InspectorDebugger.this.suspendedInfo);
                        if (InspectorDebugger.this.commandLazyResponse != null) {
                            paused = InspectorDebugger.this.commandLazyResponse.getResponse(InspectorDebugger.this.suspendedInfo);
                            InspectorDebugger.this.commandLazyResponse = null;
                        } else {
                            jsonParams.put("callFrames", (Object)InspectorDebugger.getFramesParam(callFrames));
                            jsonParams.putOpt("asyncStackTrace", (Object)InspectorDebugger.this.findAsyncStackTrace(se.getAsynchronousStacks()));
                            List breakpoints = se.getBreakpoints();
                            JSONArray bpArr = new JSONArray();
                            HashSet<Breakpoint.Kind> kinds = new HashSet<Breakpoint.Kind>(1);
                            for (Breakpoint bp : breakpoints) {
                                String id = InspectorDebugger.this.breakpointsHandler.getId(bp);
                                if (id != null) {
                                    bpArr.put((Object)id);
                                }
                                kinds.add(bp.getKind());
                            }
                            jsonParams.put("reason", (Object)this.getHaltReason(kinds));
                            JSONObject data = this.getHaltData(se);
                            if (data != null) {
                                jsonParams.put("data", (Object)data);
                            }
                            jsonParams.put("hitBreakpoints", (Object)bpArr);
                            Params params = new Params((JSONObject)jsonParams);
                            paused = new Event("Debugger.paused", params);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                    InspectorDebugger.this.eventHandler.event(paused);
                    while (true) {
                        executables = null;
                        jsonParams = InspectorDebugger.this.suspendLock;
                        // MONITORENTER : jsonParams
                        if (!InspectorDebugger.this.running && InspectorDebugger.this.suspendThreadExecutables.isEmpty()) {
                            if (InspectorDebugger.this.context.isSynchronous()) {
                                InspectorDebugger.this.running = true;
                            } else {
                                try {
                                    InspectorDebugger.this.suspendLock.wait();
                                }
                                catch (InterruptedException callFrames) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!InspectorDebugger.this.suspendThreadExecutables.isEmpty()) {
                            InspectorExecutionContext.CancellableRunnable r;
                            executables = new LinkedList<InspectorExecutionContext.CancellableRunnable>();
                            while ((r = (InspectorExecutionContext.CancellableRunnable)InspectorDebugger.this.suspendThreadExecutables.poll()) != null) {
                                executables.add(r);
                            }
                        }
                        if (InspectorDebugger.this.running) {
                            InspectorDebugger.this.suspendedInfo = null;
                            InspectorDebugger.this.context.setSuspendedInfo(null);
                            // MONITOREXIT : jsonParams
                            if (executables != null) {
                                break;
                            }
                            break block42;
                        }
                        // MONITOREXIT : jsonParams
                        if (executables == null) continue;
                        for (InspectorExecutionContext.CancellableRunnable r : executables) {
                            r.run();
                        }
                        executables = null;
                    }
                    for (InspectorExecutionContext.CancellableRunnable r : executables) {
                        r.cancel();
                    }
                }
                if (!InspectorDebugger.this.silentResume) {
                    Event resumed = new Event("Debugger.resumed", null);
                    InspectorDebugger.this.eventHandler.event(resumed);
                    return;
                }
                InspectorDebugger.this.silentResume = false;
                return;
            }
            finally {
                InspectorDebugger.this.onSuspendPhaser.arriveAndDeregister();
                if (InspectorDebugger.this.delayUnlock.getAndSet(false)) {
                    this.future.set(this.scheduler.schedule(() -> this.unlock(), 1L, TimeUnit.SECONDS));
                } else {
                    this.unlock();
                }
            }
        }

        private synchronized void lock() {
            Thread current = Thread.currentThread();
            if (this.locked != current) {
                while (this.locked != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.locked = current;
            } else {
                ScheduledFuture sf = this.future.getAndSet(null);
                if (sf != null) {
                    sf.cancel(true);
                }
            }
        }

        private synchronized void unlock() {
            this.locked = null;
            this.notify();
        }

        private String getHaltReason(Set<Breakpoint.Kind> kinds) {
            if (kinds.size() > 1) {
                return "ambiguous";
            }
            if (kinds.contains(Breakpoint.Kind.HALT_INSTRUCTION)) {
                return "debugCommand";
            }
            if (kinds.contains(Breakpoint.Kind.EXCEPTION)) {
                return "exception";
            }
            return "other";
        }

        private JSONObject getHaltData(SuspendedEvent se) {
            JSONObject data;
            DebugException exception = se.getException();
            if (exception == null) {
                return null;
            }
            boolean uncaught = exception.getCatchLocation() == null;
            DebugValue exceptionObject = exception.getExceptionObject();
            if (exceptionObject != null) {
                RemoteObject remoteObject = InspectorDebugger.this.context.createAndRegister(exceptionObject, false);
                data = remoteObject.toJSON();
            } else {
                data = new JSONObject();
            }
            data.put("uncaught", uncaught);
            return data;
        }

        private void dispose() {
            this.unlock();
            ScheduledFuture sf = this.future.getAndSet(null);
            if (sf != null) {
                sf.cancel(true);
            }
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class LoadScriptListenerImpl
    implements ScriptsHandler.LoadScriptListener {
        private LoadScriptListenerImpl() {
        }

        @Override
        public void loadedScript(Script script) {
            int length;
            int lastColumn;
            int lastLine;
            JSONObject jsonParams = new JSONObject();
            jsonParams.put("scriptId", (Object)Integer.toString(script.getId()));
            jsonParams.put("url", (Object)script.getUrl());
            jsonParams.put("startLine", 0);
            jsonParams.put("startColumn", 0);
            Source source = script.getSource();
            if (source.hasCharacters()) {
                lastLine = source.getLineCount() - 1;
                if (lastLine < 0) {
                    lastLine = 0;
                    lastColumn = 0;
                } else {
                    CharSequence sourceMapURL;
                    CharSequence line;
                    lastColumn = source.getLineLength(lastLine + 1);
                    int srcMapLine = lastLine + 1;
                    do {
                        line = source.getCharacters(srcMapLine);
                    } while (--srcMapLine > 0 && (line.length() == 0 || "});".equals(line)));
                    CharSequence charSequence = sourceMapURL = srcMapLine > 0 ? this.getSourceMapURL(source, srcMapLine) : null;
                    if (sourceMapURL != null) {
                        jsonParams.put("sourceMapURL", (Object)sourceMapURL.toString());
                        lastLine = srcMapLine - 1;
                        lastColumn = source.getLineLength(lastLine + 1);
                    }
                }
                length = source.getLength();
            } else {
                lastLine = 3;
                lastColumn = 0;
                length = script.getCharacters().length();
            }
            jsonParams.put("endLine", lastLine);
            jsonParams.put("endColumn", lastColumn);
            jsonParams.put("executionContextId", InspectorDebugger.this.context.getId());
            jsonParams.put("hash", (Object)script.getHash());
            jsonParams.put("length", length);
            Params params = new Params(jsonParams);
            Event scriptParsed = new Event("Debugger.scriptParsed", params);
            InspectorDebugger.this.eventHandler.event(scriptParsed);
        }

        private CharSequence getSourceMapURL(Source source, int lastLine) {
            int i;
            String mapKeyword = "sourceMappingURL=";
            int mapKeywordLength = mapKeyword.length();
            CharSequence line = source.getCharacters(lastLine + 1);
            int lineLength = line.length();
            for (i = 0; i < lineLength && Character.isWhitespace(line.charAt(i)); ++i) {
            }
            if (i + 3 < lineLength && line.charAt(i) == '/' && line.charAt(i + 1) == '/' && (line.charAt(i + 2) == '#' || line.charAt(i + 2) == '@')) {
                i += 3;
            } else {
                return null;
            }
            while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            if (i + mapKeywordLength >= lineLength || !line.subSequence(i, i + mapKeywordLength).equals(mapKeyword)) {
                return null;
            }
            return line.subSequence(i += mapKeywordLength, line.length());
        }
    }
}

