/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.chromeinspector.TypeHandler;
import com.oracle.truffle.tools.chromeinspector.commands.Params;
import com.oracle.truffle.tools.chromeinspector.domains.ProfilerDomain;
import com.oracle.truffle.tools.chromeinspector.instrument.Enabler;
import com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import com.oracle.truffle.tools.chromeinspector.types.CoverageRange;
import com.oracle.truffle.tools.chromeinspector.types.FunctionCoverage;
import com.oracle.truffle.tools.chromeinspector.types.Profile;
import com.oracle.truffle.tools.chromeinspector.types.ProfileNode;
import com.oracle.truffle.tools.chromeinspector.types.RuntimeCallFrame;
import com.oracle.truffle.tools.chromeinspector.types.Script;
import com.oracle.truffle.tools.chromeinspector.types.ScriptCoverage;
import com.oracle.truffle.tools.chromeinspector.types.ScriptTypeProfile;
import com.oracle.truffle.tools.chromeinspector.types.TypeObject;
import com.oracle.truffle.tools.chromeinspector.types.TypeProfileEntry;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.CPUTracer;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class InspectorProfiler
extends ProfilerDomain {
    private CPUSampler sampler;
    private CPUTracer tracer;
    private TypeHandler typeHandler;
    private ScriptsHandler slh;
    private long startTimestamp;
    private boolean oldGatherSelfHitTimes;
    private final InspectorExecutionContext context;
    private final ConnectionWatcher connectionWatcher;
    private Enabler enabler;

    public InspectorProfiler(InspectorExecutionContext context, ConnectionWatcher connectionWatcher) {
        this.context = context;
        this.connectionWatcher = connectionWatcher;
    }

    @Override
    public void doEnable() {
        this.slh = this.context.acquireScriptsHandler();
        this.sampler = (CPUSampler)this.context.getEnv().lookup((InstrumentInfo)this.context.getEnv().getInstruments().get("cpusampler"), CPUSampler.class);
        this.tracer = (CPUTracer)this.context.getEnv().lookup((InstrumentInfo)this.context.getEnv().getInstruments().get("cputracer"), CPUTracer.class);
        InstrumentInfo instrumentInfo = (InstrumentInfo)this.context.getEnv().getInstruments().get("TypeProfileInstrument");
        this.enabler = (Enabler)this.context.getEnv().lookup(instrumentInfo, Enabler.class);
        this.enabler.enable();
        this.typeHandler = ((TypeHandler.Provider)this.context.getEnv().lookup(instrumentInfo, TypeHandler.Provider.class)).getTypeHandler();
    }

    @Override
    public void doDisable() {
        if (this.slh != null) {
            this.context.releaseScriptsHandler();
            this.slh = null;
            this.sampler = null;
            this.tracer = null;
            this.typeHandler = null;
            this.enabler.disable();
            this.enabler = null;
        }
    }

    @Override
    public void setSamplingInterval(long interval) {
        this.sampler.setPeriod(Math.max(1L, TimeUnit.MICROSECONDS.toMillis(interval)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.connectionWatcher.setWaitForClose();
        CPUSampler cPUSampler = this.sampler;
        synchronized (cPUSampler) {
            this.oldGatherSelfHitTimes = this.sampler.isGatherSelfHitTimes();
            this.sampler.setGatherSelfHitTimes(true);
            this.sampler.setFilter(SourceSectionFilter.newBuilder().includeInternal(this.context.isInspectInternal()).build());
            this.sampler.setCollecting(true);
        }
        this.startTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Params stop() {
        long time = System.currentTimeMillis();
        CPUSampler cPUSampler = this.sampler;
        synchronized (cPUSampler) {
            this.sampler.setCollecting(false);
            this.sampler.setGatherSelfHitTimes(this.oldGatherSelfHitTimes);
            long idleHitCount = (time - this.startTimestamp) / this.sampler.getPeriod() - this.sampler.getSampleCount();
            Params profile = this.getProfile(this.sampler.getRootNodes(), idleHitCount, this.startTimestamp, time);
            this.sampler.clearData();
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPreciseCoverage(boolean callCount, boolean detailed) {
        this.connectionWatcher.setWaitForClose();
        CPUTracer cPUTracer = this.tracer;
        synchronized (cPUTracer) {
            this.tracer.setFilter(SourceSectionFilter.newBuilder().tagIs(new Class[]{detailed ? StandardTags.StatementTag.class : StandardTags.RootTag.class}).includeInternal(this.context.isInspectInternal()).build());
            this.tracer.setCollecting(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPreciseCoverage() {
        CPUTracer cPUTracer = this.tracer;
        synchronized (cPUTracer) {
            this.tracer.setCollecting(false);
            this.tracer.clearData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Params takePreciseCoverage() {
        CPUTracer cPUTracer = this.tracer;
        synchronized (cPUTracer) {
            Params coverage = this.getCoverage(this.tracer.getPayloads());
            this.tracer.clearData();
            return coverage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Params getBestEffortCoverage() {
        CPUTracer cPUTracer = this.tracer;
        synchronized (cPUTracer) {
            Params coverage = this.getCoverage(this.tracer.getPayloads());
            this.tracer.clearData();
            return coverage;
        }
    }

    @Override
    public void startTypeProfile() {
        this.connectionWatcher.setWaitForClose();
        this.typeHandler.start(this.context.isInspectInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTypeProfile() {
        TypeHandler typeHandler = this.typeHandler;
        synchronized (typeHandler) {
            this.typeHandler.stop();
            this.typeHandler.clearData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Params takeTypeProfile() {
        TypeHandler typeHandler = this.typeHandler;
        synchronized (typeHandler) {
            Params typeProfile = this.getTypeProfile(this.typeHandler.getSectionTypeProfiles());
            this.typeHandler.clearData();
            return typeProfile;
        }
    }

    private Params getCoverage(Collection<CPUTracer.Payload> payloads) {
        JSONObject json = new JSONObject();
        LinkedHashMap sourceToRoots = new LinkedHashMap();
        payloads.forEach(payload -> {
            Map rootsToPayloads = sourceToRoots.computeIfAbsent(payload.getSourceSection().getSource(), s -> new LinkedHashMap());
            Collection pls = rootsToPayloads.computeIfAbsent(payload.getRootName(), t -> new LinkedList());
            pls.add(payload);
        });
        JSONArray result = new JSONArray();
        sourceToRoots.entrySet().stream().map(sourceEntry -> {
            ArrayList functions = new ArrayList();
            ((Map)sourceEntry.getValue()).entrySet().forEach(rootEntry -> {
                boolean isBlockCoverage = false;
                ArrayList<CoverageRange> ranges = new ArrayList<CoverageRange>();
                for (CPUTracer.Payload payload : (Collection)rootEntry.getValue()) {
                    isBlockCoverage |= payload.getTags().contains(StandardTags.StatementTag.class);
                    ranges.add(new CoverageRange(payload.getSourceSection().getCharIndex(), payload.getSourceSection().getCharEndIndex(), payload.getCount()));
                }
                functions.add(new FunctionCoverage((String)rootEntry.getKey(), isBlockCoverage, ranges.toArray(new CoverageRange[ranges.size()])));
            });
            int scriptId = this.slh.getScriptId((Source)sourceEntry.getKey());
            Script script = scriptId < 0 ? null : this.slh.getScript(scriptId);
            return new ScriptCoverage(script != null ? script.getId() : 0, script != null ? script.getUrl() : "", functions.toArray(new FunctionCoverage[functions.size()]));
        }).forEachOrdered(scriptCoverage -> result.put((Object)scriptCoverage.toJSON()));
        json.put("result", (Object)result);
        return new Params(json);
    }

    private Params getProfile(Collection<ProfilerNode<CPUSampler.Payload>> rootProfilerNodes, long idleHitCount, long startTime, long endTime) {
        ArrayList<ProfileNode> nodes = new ArrayList<ProfileNode>();
        ArrayList<Profile.TimeLineItem> timeLine = new ArrayList<Profile.TimeLineItem>();
        int counter = 1;
        ProfileNode root = new ProfileNode(counter++, new RuntimeCallFrame("(root)", 0, "", 0, 0), idleHitCount);
        nodes.add(root);
        this.fillChildren(root, rootProfilerNodes, nodes, timeLine, counter);
        Collections.sort(timeLine, (item1, item2) -> Long.compare(item1.getTimestamp(), item2.getTimestamp()));
        JSONObject json = new JSONObject();
        json.put("profile", (Object)new Profile(nodes.toArray(new ProfileNode[nodes.size()]), startTime, endTime, timeLine.toArray(new Profile.TimeLineItem[timeLine.size()])).toJSON());
        return new Params(json);
    }

    private void fillChildren(ProfileNode node, Collection<ProfilerNode<CPUSampler.Payload>> childProfilerNodes, List<ProfileNode> nodes, List<Profile.TimeLineItem> timeLine, int lastCounter) {
        HashMap<ProfilerNode<CPUSampler.Payload>, Integer> node2id = new HashMap<ProfilerNode<CPUSampler.Payload>, Integer>();
        ArrayDeque<ProfilerNode<CPUSampler.Payload>> dequeue = new ArrayDeque<ProfilerNode<CPUSampler.Payload>>();
        dequeue.addAll(childProfilerNodes);
        int counter = InspectorProfiler.assignChildIDs(node, childProfilerNodes, node2id, lastCounter);
        while (!dequeue.isEmpty()) {
            ProfilerNode childProfilerNode = (ProfilerNode)dequeue.pollFirst();
            int id = (Integer)node2id.get(childProfilerNode);
            if (id >= 0) continue;
            id = -id;
            int scriptId = this.slh.getScriptId(childProfilerNode.getSourceSection().getSource());
            Script script = scriptId < 0 ? null : this.slh.getScript(scriptId);
            SourceSection sourceSection = childProfilerNode.getSourceSection();
            ProfileNode childNode = new ProfileNode(id, new RuntimeCallFrame(childProfilerNode.getRootName(), script != null ? script.getId() : 0, script != null ? script.getUrl() : "", sourceSection.getStartLine(), sourceSection.getStartColumn()), ((CPUSampler.Payload)childProfilerNode.getPayload()).getSelfHitCount());
            nodes.add(childNode);
            for (Long timestamp : ((CPUSampler.Payload)childProfilerNode.getPayload()).getSelfHitTimes()) {
                timeLine.add(new Profile.TimeLineItem(timestamp, id));
            }
            node2id.put((ProfilerNode<CPUSampler.Payload>)childProfilerNode, id);
            Collection grandChildren = childProfilerNode.getChildren();
            counter = InspectorProfiler.assignChildIDs(childNode, grandChildren, node2id, counter);
            dequeue.addAll(grandChildren);
        }
    }

    private static int assignChildIDs(ProfileNode node, Collection<ProfilerNode<CPUSampler.Payload>> childProfilerNodes, Map<ProfilerNode<CPUSampler.Payload>, Integer> node2id, int lastCounter) {
        int counter = lastCounter;
        for (ProfilerNode<CPUSampler.Payload> child : childProfilerNodes) {
            Integer id = node2id.get(child);
            if (id == null) {
                id = counter++;
                node2id.put(child, -id.intValue());
            }
            node.addChild(Math.abs(id));
        }
        return counter;
    }

    private Params getTypeProfile(Collection<TypeHandler.SectionTypeProfile> profiles) {
        JSONObject json = new JSONObject();
        LinkedHashMap sourceToProfiles = new LinkedHashMap();
        profiles.forEach(profile -> {
            Collection pfs = sourceToProfiles.computeIfAbsent(profile.getSourceSection().getSource(), t -> new LinkedList());
            pfs.add(profile);
        });
        JSONArray result = new JSONArray();
        sourceToProfiles.entrySet().forEach(entry -> {
            ArrayList entries = new ArrayList();
            ((Collection)entry.getValue()).forEach(sectionProfile -> {
                ArrayList types = new ArrayList();
                sectionProfile.getTypes().forEach(type -> types.add(new TypeObject((String)type)));
                if (!types.isEmpty()) {
                    entries.add(new TypeProfileEntry(sectionProfile.getSourceSection().getCharEndIndex(), types.toArray(new TypeObject[types.size()])));
                }
            });
            int scriptId = this.slh.getScriptId((Source)entry.getKey());
            Script script = scriptId < 0 ? null : this.slh.getScript(scriptId);
            result.put((Object)new ScriptTypeProfile(script != null ? script.getId() : 0, script != null ? script.getUrl() : "", entries.toArray(new TypeProfileEntry[entries.size()])).toJSON());
        });
        json.put("result", (Object)result);
        return new Params(json);
    }
}

