/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.instrument;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.client.InspectWSClient;
import com.oracle.truffle.tools.chromeinspector.instrument.InspectorIOException;
import com.oracle.truffle.tools.chromeinspector.instrument.InspectorInstrumentOptionDescriptors;
import com.oracle.truffle.tools.chromeinspector.instrument.InspectorWSConnection;
import com.oracle.truffle.tools.chromeinspector.instrument.KeyStoreOptions;
import com.oracle.truffle.tools.chromeinspector.instrument.Token;
import com.oracle.truffle.tools.chromeinspector.objects.Inspector;
import com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import com.oracle.truffle.tools.chromeinspector.server.InspectorServer;
import com.oracle.truffle.tools.chromeinspector.server.InspectorServerConnection;
import com.oracle.truffle.tools.chromeinspector.server.WSInterceptorServer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.io.MessageEndpoint;
import org.graalvm.polyglot.io.MessageTransport;

@TruffleInstrument.Registration(id="inspect", name="Chrome Inspector", version="0.1", services={TruffleObject.class})
public final class InspectorInstrument
extends TruffleInstrument {
    private static final int DEFAULT_PORT = 9229;
    private static final HostAndPort DEFAULT_ADDRESS = new HostAndPort(null, 9229);
    private Server server;
    private ConnectionWatcher connectionWatcher;
    static final OptionType<HostAndPort> ADDRESS_OR_BOOLEAN = new OptionType("[[host:]port]", address -> {
        String host;
        String port;
        if (address.isEmpty() || address.equals("true")) {
            return DEFAULT_ADDRESS;
        }
        int colon = address.indexOf(58);
        if (colon >= 0) {
            port = address.substring(colon + 1);
            host = address.substring(0, colon);
        } else {
            try {
                Integer.parseInt(address);
                port = address;
                host = null;
            }
            catch (NumberFormatException e) {
                port = Integer.toString(9229);
                host = address;
            }
        }
        return new HostAndPort(host, port);
    }, address -> address.verify());
    static final OptionType<List<URI>> SOURCE_PATH = new OptionType("folder" + File.pathSeparator + "file.zip" + File.pathSeparator + "...", str -> {
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        int i1 = 0;
        while (i1 < str.length()) {
            int i2 = str.indexOf(File.pathSeparatorChar, i1);
            if (i2 < 0) {
                i2 = str.length();
            }
            String path = str.substring(i1, i2);
            try {
                uris.add(InspectorInstrument.createURIFromPath(path));
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Wrong path: " + path, ex);
            }
            i1 = i2 + 1;
        }
        return uris;
    });
    @Option(name="", help="Start the Chrome inspector on [[host:]port]. (default: <loopback address>:9229)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<HostAndPort> Inspect = new OptionKey((Object)DEFAULT_ADDRESS, ADDRESS_OR_BOOLEAN);
    @Option(help="Attach to an existing endpoint instead of creating a new one. (default:false)", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> Attach = new OptionKey((Object)false);
    @Option(help="Suspend the execution at first executed source line. (default:true)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> Suspend = new OptionKey((Object)true);
    @Option(help="Do not execute any source code until inspector client is attached. (default:false)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> WaitAttached = new OptionKey((Object)false);
    @Option(help="Specifies list of directories or ZIP/JAR files representing source path. (default:none)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<List<URI>> SourcePath = new OptionKey(Collections.emptyList(), SOURCE_PATH);
    @Option(help="Hide internal errors that can occur as a result of debugger inspection. (default:false)", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> HideErrors = new OptionKey((Object)false);
    @Option(help="Path to the chrome inspect. This path should be unpredictable. Do note that any website opened in your browser that has knowledge of the URL can connect to the debugger. A predictable path can thus be abused by a malicious website to execute arbitrary code on your computer, even if you are behind a firewall. (default: randomly generated)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> Path = new OptionKey((Object)"");
    @Option(help="Inspect internal sources. (default:false)", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> Internal = new OptionKey((Object)false);
    @Option(help="Inspect language initialization. (default:false)", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> Initialization = new OptionKey((Object)false);
    @Option(help="Use TLS/SSL. (default: false for loopback address, true otherwise)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> Secure = new OptionKey((Object)true);
    @Option(help="File path to keystore used for secure connection. (default:javax.net.ssl.keyStore system property)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> KeyStore = new OptionKey((Object)"");
    @Option(help="The keystore type. (default:javax.net.ssl.keyStoreType system property, or \\\"JKS\\\")", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> KeyStoreType = new OptionKey((Object)"");
    @Option(help="The keystore password. (default:javax.net.ssl.keyStorePassword system property)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> KeyStorePassword = new OptionKey((Object)"");
    @Option(help="Password for recovering keys from a keystore. (default:javax.net.ssl.keyPassword system property, or keystore password)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> KeyPassword = new OptionKey((Object)"");
    public static final String INSTRUMENT_ID = "inspect";
    static final String VERSION = "0.1";

    private static URI createURIFromPath(String path) throws URISyntaxException {
        String lpath = path.toLowerCase();
        int index = 0;
        File jarFile = null;
        while (index < lpath.length()) {
            int zi = lpath.indexOf(".zip", index);
            int ji = lpath.indexOf(".jar", index);
            if (zi >= 0 && zi < ji || ji < 0) {
                ji = zi;
            }
            if (ji >= 0) {
                index = ji + 4;
                File jar = new File(path.substring(0, index));
                if (!jar.isFile()) continue;
                jarFile = jar;
                break;
            }
            index = path.length();
        }
        if (jarFile != null) {
            StringBuilder ssp = new StringBuilder("file://").append(jarFile.getAbsolutePath());
            if (index < path.length()) {
                if (path.charAt(index) != '!') {
                    ssp.append('!');
                }
                ssp.append(path.substring(index));
            } else {
                ssp.append("!/");
            }
            return new URI("jar", ssp.toString(), null);
        }
        return new File(path).toPath().toUri();
    }

    protected void onCreate(final TruffleInstrument.Env env) {
        final OptionValues options = env.getOptions();
        if (options.hasSetOptions()) {
            HostAndPort hostAndPort = (HostAndPort)options.get(Inspect);
            this.connectionWatcher = new ConnectionWatcher();
            try {
                this.server = new Server(env, "Main Context", hostAndPort, (Boolean)options.get(Attach), (Boolean)options.get(Suspend), (Boolean)options.get(WaitAttached), (Boolean)options.get(HideErrors), (Boolean)options.get(Internal), (Boolean)options.get(Initialization), (String)options.get(Path), options.hasBeenSet(Secure), (Boolean)options.get(Secure), new KeyStoreOptions(options), (List)options.get(SourcePath), this.connectionWatcher);
            }
            catch (IOException e) {
                throw new InspectorIOException(hostAndPort.getHostPort(), e);
            }
        }
        env.registerService((Object)new Inspector(this.server != null ? this.server.getConnection() : null, new InspectorServerConnection.Open(){

            @Override
            public synchronized InspectorServerConnection open(int port, String host, boolean wait) {
                if (InspectorInstrument.this.server != null && InspectorInstrument.this.server.wss != null) {
                    return null;
                }
                HostAndPort hostAndPort = (HostAndPort)options.get(Inspect);
                if (port < 0) {
                    port = hostAndPort.port;
                }
                if (host == null) {
                    host = hostAndPort.host;
                }
                InspectorInstrument.this.connectionWatcher = new ConnectionWatcher();
                hostAndPort = new HostAndPort(host, port);
                try {
                    InspectorInstrument.this.server = new Server(env, "Main Context", hostAndPort, false, false, wait, (Boolean)options.get(HideErrors), (Boolean)options.get(Internal), (Boolean)options.get(Initialization), null, options.hasBeenSet(Secure), (Boolean)options.get(Secure), new KeyStoreOptions(options), (List)options.get(SourcePath), InspectorInstrument.this.connectionWatcher);
                }
                catch (IOException e) {
                    PrintWriter info = new PrintWriter(env.err());
                    info.println(new InspectorIOException(hostAndPort.getHostPort(), e).getLocalizedMessage());
                    info.flush();
                }
                return InspectorInstrument.this.server != null ? InspectorInstrument.this.server.getConnection() : null;
            }
        }, new Supplier<InspectorExecutionContext>(){

            @Override
            public InspectorExecutionContext get() {
                if (InspectorInstrument.this.server != null) {
                    return InspectorInstrument.this.server.getConnection().getExecutionContext();
                }
                PrintWriter err = (Boolean)options.get(HideErrors) != false ? null : new PrintWriter(env.err(), true);
                return new InspectorExecutionContext("Main Context", (Boolean)options.get(Internal), (Boolean)options.get(Initialization), env, Collections.emptyList(), err);
            }
        }));
    }

    protected void onFinalize(TruffleInstrument.Env env) {
        if (this.connectionWatcher != null && this.connectionWatcher.shouldWaitForClose()) {
            PrintWriter info = new PrintWriter(env.out());
            info.println("Waiting for the debugger to disconnect...");
            info.flush();
            this.connectionWatcher.waitForClose();
        }
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected OptionDescriptors getOptionDescriptors() {
        final InspectorInstrumentOptionDescriptors descriptors = new InspectorInstrumentOptionDescriptors();
        return new OptionDescriptors(){

            public OptionDescriptor get(String optionName) {
                return descriptors.get(optionName);
            }

            public Iterator<OptionDescriptor> iterator() {
                final Iterator iterator = descriptors.iterator();
                return new Iterator<OptionDescriptor>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public OptionDescriptor next() {
                        OptionDescriptor descriptor = (OptionDescriptor)iterator.next();
                        if (descriptor.getKey() == SourcePath) {
                            String example = " Example: " + File.separator + "projects" + File.separator + "foo" + File.separator + "src" + File.pathSeparator + "sources.jar" + File.pathSeparator + "package.zip!/src";
                            descriptor = OptionDescriptor.newBuilder(SourcePath, (String)descriptor.getName()).deprecated(descriptor.isDeprecated()).category(descriptor.getCategory()).help(descriptor.getHelp() + example).build();
                        }
                        return descriptor;
                    }
                };
            }
        };
    }

    private static final class Server {
        private InspectorWSConnection wss;
        private final Token token;
        private final String urlContainingToken;
        private final InspectorExecutionContext executionContext;
        private static final String DEV_TOOLS_PREFIX = "chrome-devtools://devtools/bundled/js_app.html?";
        private static final String WS_PREFIX = "ws=";
        private static final String WS_PREFIX_SECURE = "wss=";

        Server(TruffleInstrument.Env env, String contextName, HostAndPort hostAndPort, boolean attach, boolean debugBreak, boolean waitAttached, boolean hideErrors, boolean inspectInternal, final boolean inspectInitialization, String pathOrNull, boolean secureHasBeenSet, boolean secureValue, KeyStoreOptions keyStoreOptions, List<URI> sourcePath, ConnectionWatcher connectionWatcher) throws IOException {
            String pathContainingToken;
            InetSocketAddress socketAddress = hostAndPort.createSocket();
            PrintWriter info = new PrintWriter(env.err(), true);
            if (pathOrNull == null || pathOrNull.isEmpty()) {
                pathContainingToken = "/" + Server.generateSecureToken();
            } else {
                String head = pathOrNull.startsWith("/") ? "" : "/";
                pathContainingToken = head + pathOrNull;
            }
            this.token = Token.createHashedTokenFromString(pathContainingToken);
            boolean secure = !secureHasBeenSet && socketAddress.getAddress().isLoopbackAddress() ? false : secureValue;
            PrintWriter err = hideErrors ? null : info;
            this.executionContext = new InspectorExecutionContext(contextName, inspectInternal, inspectInitialization, env, sourcePath, err);
            if (attach) {
                this.wss = new InspectWSClient(socketAddress, pathContainingToken, this.executionContext, debugBreak, secure, keyStoreOptions, connectionWatcher, info);
                this.urlContainingToken = ((InspectWSClient)this.wss).getURI().toString();
            } else {
                MessageEndpoint serverEndpoint;
                URI wsuri;
                try {
                    wsuri = new URI(secure ? "wss" : "ws", null, socketAddress.getAddress().getHostAddress(), socketAddress.getPort(), pathContainingToken, null, null);
                }
                catch (URISyntaxException ex) {
                    throw new IOException(ex);
                }
                InspectServerSession iss = InspectServerSession.create(this.executionContext, debugBreak, connectionWatcher);
                WSInterceptorServer interceptor = new WSInterceptorServer(socketAddress.getPort(), this.token, iss, connectionWatcher);
                try {
                    serverEndpoint = env.startServer(wsuri, (MessageEndpoint)iss);
                }
                catch (MessageTransport.VetoException vex) {
                    throw new IOException(vex.getLocalizedMessage());
                }
                if (serverEndpoint == null) {
                    interceptor.close(this.token);
                    this.wss = InspectorServer.get(socketAddress, this.token, pathContainingToken, this.executionContext, debugBreak, secure, keyStoreOptions, connectionWatcher, iss);
                    String wsStr = Server.buildAddress(socketAddress.getAddress().getHostAddress(), this.wss.getPort(), pathContainingToken, secure);
                    String address = DEV_TOOLS_PREFIX + wsStr;
                    this.urlContainingToken = wsStr.replace("=", "://");
                    info.println("Debugger listening on port " + this.wss.getPort() + ".");
                    info.println("To start debugging, open the following URL in Chrome:");
                    info.println("    " + address);
                    info.flush();
                } else {
                    Server.restartServerEndpointOnClose(hostAndPort, env, wsuri, this.executionContext, connectionWatcher, iss, interceptor);
                    interceptor.opened(serverEndpoint);
                    this.wss = interceptor;
                    this.urlContainingToken = wsuri.toString();
                }
            }
            if (debugBreak || waitAttached) {
                final AtomicReference<EventBinding> execEnter = new AtomicReference<EventBinding>();
                final AtomicBoolean disposeBinding = new AtomicBoolean(false);
                execEnter.set(env.getInstrumenter().attachContextsListener(new ContextsListener(){

                    public void onContextCreated(TruffleContext context) {
                    }

                    public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
                        if (inspectInitialization) {
                            this.waitForRunPermission();
                        }
                    }

                    public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
                        if (!inspectInitialization) {
                            this.waitForRunPermission();
                        }
                    }

                    public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
                    }

                    public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
                    }

                    public void onContextClosed(TruffleContext context) {
                    }

                    @CompilerDirectives.TruffleBoundary
                    private void waitForRunPermission() {
                        try {
                            executionContext.waitForRunPermission();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        EventBinding binding = execEnter.getAndSet(null);
                        if (binding != null) {
                            binding.dispose();
                        } else {
                            disposeBinding.set(true);
                        }
                    }
                }, true));
                if (disposeBinding.get()) {
                    ((EventBinding)execEnter.get()).dispose();
                }
            }
        }

        private static String generateSecureToken() {
            byte[] tokenRaw = Server.generateSecureRawToken();
            return Base64.getEncoder().withoutPadding().encodeToString(tokenRaw).replace('/', '_').replace('+', '-');
        }

        private static byte[] generateSecureRawToken() {
            byte[] tokenRaw = new byte[32];
            new SecureRandom().nextBytes(tokenRaw);
            return tokenRaw;
        }

        private static String buildAddress(String hostAddress, int port, String path, boolean secure) {
            String prefix = secure ? WS_PREFIX_SECURE : WS_PREFIX;
            return prefix + hostAddress + ":" + port + path;
        }

        private static void restartServerEndpointOnClose(HostAndPort hostAndPort, TruffleInstrument.Env env, URI wsuri, InspectorExecutionContext executionContext, ConnectionWatcher connectionWatcher, InspectServerSession iss, WSInterceptorServer interceptor) {
            iss.onClose(() -> {
                MessageEndpoint serverEndpoint;
                InspectServerSession newSession = InspectServerSession.create(executionContext, false, connectionWatcher);
                interceptor.newSession(newSession);
                try {
                    serverEndpoint = env.startServer(wsuri, (MessageEndpoint)newSession);
                }
                catch (MessageTransport.VetoException vex) {
                    return;
                }
                catch (IOException ioex) {
                    throw new InspectorIOException(hostAndPort.getHostPort(), ioex);
                }
                interceptor.opened(serverEndpoint);
                Server.restartServerEndpointOnClose(hostAndPort, env, wsuri, executionContext, connectionWatcher, newSession, interceptor);
            });
        }

        public void close() throws IOException {
            if (this.wss != null) {
                this.wss.close(this.token);
                this.wss = null;
            }
        }

        InspectorServerConnection getConnection() {
            return new InspectorServerConnection(){

                @Override
                public String getURL() {
                    return urlContainingToken;
                }

                @Override
                public void close() throws IOException {
                    this.close();
                }

                @Override
                public InspectorExecutionContext getExecutionContext() {
                    return executionContext;
                }

                @Override
                public void consoleAPICall(String type, Object text) {
                    if (wss != null) {
                        wss.consoleAPICall(token, type, text);
                    }
                }
            };
        }
    }

    private static final class HostAndPort {
        private final String host;
        private String portStr;
        private int port;
        private InetAddress inetAddress;

        HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        HostAndPort(String host, String portStr) {
            this.host = host;
            this.portStr = portStr;
        }

        void verify() {
            if (this.port == 0 && this.portStr != null) {
                try {
                    this.port = Integer.parseInt(this.portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Port is not a number: " + this.portStr);
                }
            }
            if (this.port != 0 && (this.port < 1024 || 65535 < this.port)) {
                throw new IllegalArgumentException("Invalid port number: " + this.port + ". Needs to be 0, or in range from 1024 to 65535.");
            }
            if (this.host != null && !this.host.isEmpty()) {
                try {
                    this.inetAddress = InetAddress.getByName(this.host);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException(ex.getLocalizedMessage(), ex);
                }
            }
        }

        String getHostPort() {
            String hostName = this.host;
            if (hostName == null || hostName.isEmpty()) {
                hostName = this.inetAddress != null ? this.inetAddress.toString() : InetAddress.getLoopbackAddress().toString();
            }
            return hostName + ":" + this.port;
        }

        InetSocketAddress createSocket() {
            InetAddress ia = this.inetAddress == null ? InetAddress.getLoopbackAddress() : this.inetAddress;
            return new InetSocketAddress(ia, this.port);
        }
    }
}

