/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.libc.GLibC;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.PosixLibC;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_NFIUnsatisfiedLinkError;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.posix.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext_Linux;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;

final class PosixTruffleNFISupport
extends TruffleNFISupport {
    private static final int ISOLATED_NAMESPACE_FLAG = 65536;
    private static final int ISOLATED_NAMESPACE_NOT_SUPPORTED_FLAG = 0;
    static int isolatedNamespaceFlag = 0;

    static void initialize() {
        if (Platform.includedIn(Platform.LINUX.class)) {
            isolatedNamespaceFlag = LibCBase.singleton().hasIsolatedNamespaces() ? 65536 : 0;
        }
        ImageSingletons.add(TruffleNFISupport.class, (Object)new PosixTruffleNFISupport());
    }

    private PosixTruffleNFISupport() {
        super(PosixTruffleNFISupport.getErrnoGetterFunctionName());
    }

    private static String getErrnoGetterFunctionName() {
        if (Platform.includedIn(Platform.LINUX.class)) {
            return "__errno_location";
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return "__error";
        }
        throw VMError.unsupportedFeature((String)("PosixTruffleNFISupport.getErrnoGetterFunctionName() on unexpected OS: " + ((Platform)ImageSingletons.lookup(Platform.class)).getOS()));
    }

    @Override
    protected CCharPointer strdupImpl(CCharPointer src) {
        return PosixLibC.strdup((CCharPointer)src);
    }

    @Platforms(value={Platform.LINUX.class})
    private static PointerBase dlmopen(Dlfcn.GNUExtensions.Lmid_t lmid, String filename, int mode) {
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)filename);){
            CCharPointer pathPtr = pathPin.get();
            PointerBase pointerBase = Dlfcn.GNUExtensions.dlmopen((Dlfcn.GNUExtensions.Lmid_t)lmid, (CCharPointer)pathPtr, (int)mode);
            return pointerBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.LINUX.class})
    private static PointerBase loadLibraryInNamespace(long nativeContext, String name, int mode) {
        assert ((mode & isolatedNamespaceFlag) == 0);
        Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext_Linux context = (Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext_Linux)SubstrateUtil.cast((Object)PosixTruffleNFISupport.getContext(nativeContext), Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext_Linux.class);
        long namespaceId = context.isolatedNamespaceId;
        if (namespaceId == 0L) {
            Target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext_Linux target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext_Linux = context;
            synchronized (target_com_oracle_truffle_nfi_backend_libffi_LibFFIContext_Linux) {
                namespaceId = context.isolatedNamespaceId;
                if (namespaceId == 0L) {
                    PointerBase handle = PosixTruffleNFISupport.dlmopen((Dlfcn.GNUExtensions.Lmid_t)Word.signed((int)Dlfcn.GNUExtensions.LM_ID_NEWLM()), name, mode);
                    if (handle.equal((ComparableWord)Word.zero())) {
                        return handle;
                    }
                    Dlfcn.GNUExtensions.Lmid_tPointer namespacePtr = (Dlfcn.GNUExtensions.Lmid_tPointer)UnsafeStackValue.get(Dlfcn.GNUExtensions.Lmid_tPointer.class);
                    int ret = Dlfcn.GNUExtensions.dlinfo((PointerBase)handle, (int)Dlfcn.GNUExtensions.RTLD_DI_LMID(), (PointerBase)namespacePtr);
                    if (ret != 0) {
                        CompilerDirectives.transferToInterpreter();
                        String error = PosixUtils.dlerror();
                        throw VMError.shouldNotReachHere((String)("dlinfo failed to obtain link-map list (namespace) of '" + name + "': " + error));
                    }
                    namespaceId = namespacePtr.read().rawValue();
                    assert (namespaceId != 0L);
                    context.isolatedNamespaceId = namespaceId;
                    return handle;
                }
            }
        }
        assert (namespaceId != 0L);
        return PosixTruffleNFISupport.dlmopen((Dlfcn.GNUExtensions.Lmid_t)Word.signed((long)namespaceId), name, mode);
    }

    @Override
    protected long loadLibraryImpl(long nativeContext, String name, int flags) {
        PointerBase handle = Platform.includedIn(Platform.LINUX.class) && LibCBase.targetLibCIs(GLibC.class) && (flags & isolatedNamespaceFlag) != 0 ? PosixTruffleNFISupport.loadLibraryInNamespace(nativeContext, name, flags & ~isolatedNamespaceFlag) : PosixUtils.dlopen((String)name, (int)flags);
        if (handle.equal((ComparableWord)Word.zero())) {
            CompilerDirectives.transferToInterpreter();
            String error = PosixUtils.dlerror();
            throw (AbstractTruffleException)SubstrateUtil.cast((Object)new Target_com_oracle_truffle_nfi_backend_libffi_NFIUnsatisfiedLinkError(error), AbstractTruffleException.class);
        }
        return handle.rawValue();
    }

    @Override
    protected void freeLibraryImpl(long library) {
        Dlfcn.dlclose((PointerBase)Word.pointer((long)library));
    }

    @Override
    protected long lookupImpl(long nativeContext, long library, String name) {
        Dlfcn.dlerror();
        PlatformNativeLibrarySupport nativeLibrarySupport = PlatformNativeLibrarySupport.singleton();
        PointerBase ret = library == 0L ? nativeLibrarySupport.findBuiltinSymbol(name) : PosixUtils.dlsym((PointerBase)Word.pointer((long)library), (String)name);
        if (ret.equal((ComparableWord)Word.zero())) {
            CompilerDirectives.transferToInterpreter();
            String error = PosixUtils.dlerror();
            if (error != null) {
                throw (AbstractTruffleException)SubstrateUtil.cast((Object)new Target_com_oracle_truffle_nfi_backend_libffi_NFIUnsatisfiedLinkError(error), AbstractTruffleException.class);
            }
        }
        return ret.rawValue();
    }
}

