/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.InvokeJavaFunctionPointer;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.truffle.TruffleSupport;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTargetInstalledCode;
import com.oracle.svm.truffle.api.SubstrateTruffleOptions;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class SubstrateOptimizedCallTarget
extends OptimizedCallTarget
implements SubstrateCompilableTruffleAST {
    protected SubstrateOptimizedCallTargetInstalledCode installedCode = this.createInitializationInstalledCode();

    public SubstrateOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        super(sourceCallTarget, rootNode);
        assert (this.installedCode != null) : "Must never be null";
    }

    public SubstrateOptimizedCallTarget(EngineData engine) {
        super(engine);
        assert (this.installedCode != null) : "Must never be null";
    }

    public SubstrateSpeculationLog getSpeculationLog() {
        return (SubstrateSpeculationLog)super.getSpeculationLog();
    }

    public SpeculationLog getCompilationSpeculationLog() {
        return this.getSpeculationLog();
    }

    public boolean isValid() {
        return this.installedCode.isValid();
    }

    public boolean isValidLastTier() {
        return this.installedCode.isValidLastTier();
    }

    public long getCodeAddress() {
        return this.installedCode.getAddress();
    }

    public Object doInvoke(Object[] args) {
        return SubstrateOptimizedCallTargetInstalledCode.doInvoke(this, args);
    }

    public boolean cancelCompilation(CharSequence reason) {
        if (SubstrateTruffleOptions.isMultiThreaded()) {
            return super.cancelCompilation(reason);
        }
        return false;
    }

    @Override
    public InstalledCode createPreliminaryInstalledCode() {
        return this.createInstalledCode();
    }

    @Uninterruptible(reason="Transitioning back to interruptible code", calleeMustBe=false)
    protected Object invokeCallBoundary(Object[] args) {
        return this.callBoundary(args);
    }

    public SubstrateOptimizedCallTargetInstalledCode createSubstrateInstalledCode() {
        assert (TruffleSupport.isIsolatedCompilation()) : "Must be called only with isolated compilation";
        return this.createInstalledCode();
    }

    protected void onCodeInstalled(SubstrateOptimizedCallTargetInstalledCode code) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Must be at a safepoint");
        assert (code != null) : "Must never become null";
        if (code == this.installedCode) {
            return;
        }
        this.installedCode.makeNonEntrant();
        this.installedCode = code;
    }

    protected void onCodeCleared(SubstrateOptimizedCallTargetInstalledCode code) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Must be at a safepoint");
    }

    protected SubstrateOptimizedCallTargetInstalledCode createInitializationInstalledCode() {
        return this.createInstalledCode();
    }

    private SubstrateOptimizedCallTargetInstalledCode createInstalledCode() {
        return new SubstrateOptimizedCallTargetInstalledCode(this);
    }

    static interface CallBoundaryFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public Object invoke(OptimizedCallTarget var1, Object[] var2);
    }
}

