/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.truffle.TruffleFeature;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class TruffleFeature_Options_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(TruffleFeature.Options.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "PrintStaticTruffleBoundaries": {
                return OptionDescriptor.create((String)"PrintStaticTruffleBoundaries", (OptionType)OptionType.Debug, Boolean.class, (String)"Print truffle boundaries found during the analysis", (Object)this.getContainer(), TruffleFeature.Options.PrintStaticTruffleBoundaries, (String)"PrintStaticTruffleBoundaries", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TruffleCheckBlackListedMethods": {
                return OptionDescriptor.create((String)"TruffleCheckBlackListedMethods", (OptionType)OptionType.Debug, Boolean.class, (String)"Fail if a method known as not suitable for partial evaluation is reachable for runtime compilation", (Object)this.getContainer(), TruffleFeature.Options.TruffleCheckBlackListedMethods, (String)"TruffleCheckBlackListedMethods", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
            case "TruffleCheckBlockListMethods": {
                return OptionDescriptor.create((String)"TruffleCheckBlockListMethods", (OptionType)OptionType.Debug, Boolean.class, (String)"Fail if a method known as not suitable for partial evaluation is reachable for runtime compilation", (Object)this.getContainer(), TruffleFeature.Options.TruffleCheckBlockListMethods, (String)"TruffleCheckBlockListMethods", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TruffleCheckFrameImplementation": {
                return OptionDescriptor.create((String)"TruffleCheckFrameImplementation", (OptionType)OptionType.Debug, Boolean.class, (String)"Enforce that the Truffle runtime provides the only implementation of Frame", (Object)this.getContainer(), TruffleFeature.Options.TruffleCheckFrameImplementation, (String)"TruffleCheckFrameImplementation", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TruffleCheckNeverPartOfCompilation": {
                return OptionDescriptor.create((String)"TruffleCheckNeverPartOfCompilation", (OptionType)OptionType.Debug, Boolean.class, (String)"Check that CompilerAsserts.neverPartOfCompilation is not reachable for runtime compilation", (Object)this.getContainer(), TruffleFeature.Options.TruffleCheckNeverPartOfCompilation, (String)"TruffleCheckNeverPartOfCompilation", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TruffleInlineDuringParsing": {
                return OptionDescriptor.create((String)"TruffleInlineDuringParsing", (OptionType)OptionType.Debug, Boolean.class, (String)"No longer has any effect", (Object)this.getContainer(), TruffleFeature.Options.TruffleInlineDuringParsing, (String)"TruffleInlineDuringParsing", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 6;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return TruffleFeature_Options_OptionDescriptors.this.get("PrintStaticTruffleBoundaries");
                    }
                    case 1: {
                        return TruffleFeature_Options_OptionDescriptors.this.get("TruffleCheckBlackListedMethods");
                    }
                    case 2: {
                        return TruffleFeature_Options_OptionDescriptors.this.get("TruffleCheckBlockListMethods");
                    }
                    case 3: {
                        return TruffleFeature_Options_OptionDescriptors.this.get("TruffleCheckFrameImplementation");
                    }
                    case 4: {
                        return TruffleFeature_Options_OptionDescriptors.this.get("TruffleCheckNeverPartOfCompilation");
                    }
                    case 5: {
                        return TruffleFeature_Options_OptionDescriptors.this.get("TruffleInlineDuringParsing");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

