/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.staticobject.StaticProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaKind;

final class StaticPropertyOffsetTransformer
implements FieldValueTransformerWithAvailability {
    private static final Method GET_PROPERTY_TYPE = ReflectionUtil.lookupMethod(StaticProperty.class, (String)"getPropertyType", (Class[])new Class[0]);
    private final int primitiveAlignmentCorrection;

    StaticPropertyOffsetTransformer(int primitiveAlignmentCorrection) {
        this.primitiveAlignmentCorrection = primitiveAlignmentCorrection;
    }

    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        int svmAlignmentCorrection;
        int indexScale;
        int baseOffset;
        JavaKind javaKind;
        Class propertyType;
        int offset = (Integer)originalValue;
        if (offset == 0) {
            return offset;
        }
        StaticProperty receiverStaticProperty = (StaticProperty)receiver;
        try {
            propertyType = (Class)GET_PROPERTY_TYPE.invoke((Object)receiverStaticProperty, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere((Throwable)e);
        }
        if (propertyType.isPrimitive()) {
            javaKind = JavaKind.Byte;
            baseOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
            indexScale = Unsafe.ARRAY_BYTE_INDEX_SCALE;
            svmAlignmentCorrection = this.primitiveAlignmentCorrection;
        } else {
            javaKind = JavaKind.Object;
            baseOffset = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
            indexScale = Unsafe.ARRAY_OBJECT_INDEX_SCALE;
            svmAlignmentCorrection = 0;
        }
        assert ((long)offset >= baseOffset && ((long)offset - baseOffset) % (long)indexScale == 0L);
        long index = ((long)offset - baseOffset) / (long)indexScale;
        long svmArrayBaseOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(javaKind);
        long svmArrayIndexScaleOffset = ConfigurationValues.getObjectLayout().getArrayIndexScale(javaKind);
        return Math.toIntExact(svmArrayBaseOffset + (long)svmAlignmentCorrection + svmArrayIndexScaleOffset * index);
    }
}

