/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.truffle.nfi.ErrnoMirror;
import com.oracle.svm.truffle.nfi.TruffleNFIFeature;
import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CIntPointer;

@TargetClass(className="com.oracle.truffle.nfi.backend.spi.NFIState", onlyWith={TruffleNFIFeature.IsEnabled.class})
final class Target_com_oracle_truffle_nfi_backend_spi_NFIState {
    @Alias
    boolean hasPendingException;

    Target_com_oracle_truffle_nfi_backend_spi_NFIState() {
    }

    @Substitute
    private static long initNfiErrnoAddress(Thread thread) {
        GetErrnoMirrorAddressOperation op = new GetErrnoMirrorAddressOperation(thread);
        op.enqueue();
        long address = op.result;
        if (address == 0L) {
            throw CompilerDirectives.shouldNotReachHere((String)("Could not find the IsolateThread for " + String.valueOf(thread)));
        }
        return address;
    }

    @Substitute
    private void freeNfiErrnoAddress() {
    }

    @Alias
    native void setPendingException(Throwable var1);

    private static class GetErrnoMirrorAddressOperation
    extends JavaVMOperation {
        private final Thread thread;
        private long result = 0L;

        GetErrnoMirrorAddressOperation(Thread thread) {
            super(VMOperationInfos.get(GetErrnoMirrorAddressOperation.class, (String)"Get ErrnoMirror address", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.thread = thread;
        }

        protected void operate() {
            IsolateThread isolateThread = PlatformThreads.getIsolateThread((Thread)this.thread);
            if (isolateThread.isNonNull()) {
                this.result = ((CIntPointer)ErrnoMirror.errnoMirror.getAddress(isolateThread)).rawValue();
            }
        }
    }
}

