/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCodeInstallBridge;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.graal.isolated.IsolatedSpeculationLog;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.BinaryInput;
import com.oracle.svm.truffle.isolated.BinaryOutput;
import com.oracle.svm.truffle.isolated.IsolatedStringSupplier;
import com.oracle.truffle.compiler.TruffleCompilable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;

final class IsolatedCompilableTruffleAST
extends IsolatedObjectProxy<SubstrateCompilableTruffleAST>
implements SubstrateCompilableTruffleAST {
    private String cachedName;
    private IsolatedSpeculationLog cachedSpeculationLog;

    IsolatedCompilableTruffleAST(ClientHandle<SubstrateCompilableTruffleAST> compilable) {
        super(compilable);
    }

    public JavaConstant asJavaConstant() {
        return new IsolatedObjectConstant(this.handle, false);
    }

    public SpeculationLog getCompilationSpeculationLog() {
        if (this.cachedSpeculationLog == null) {
            ClientHandle<SpeculationLog> logHandle = IsolatedCompilableTruffleAST.getCompilationSpeculationLog0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle);
            this.cachedSpeculationLog = new IsolatedSpeculationLog(logHandle);
        }
        return this.cachedSpeculationLog;
    }

    public void onCompilationFailed(Supplier<String> serializedException, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        IsolatedCompilableTruffleAST.onCompilationFailed0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle, (CompilerHandle<Supplier<String>>)IsolatedCompileContext.get().hand(serializedException), silent, bailout, permanentBailout, graphTooBig);
    }

    public void onCompilationSuccess(int compilationTier, boolean lastTier) {
        IsolatedCompilableTruffleAST.onCompilationSuccess0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle, compilationTier, lastTier);
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = (String)IsolatedCompileContext.get().unhand(IsolatedCompilableTruffleAST.getName0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle));
        }
        return this.cachedName;
    }

    public boolean onInvalidate(Object source, CharSequence reason, boolean wasActive) {
        throw GraalError.shouldNotReachHere((String)"Should not be reachable for SVM.");
    }

    public int getNonTrivialNodeCount() {
        return IsolatedCompilableTruffleAST.getNonTrivialNodeCount0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle);
    }

    public int countDirectCallNodes() {
        return IsolatedCompilableTruffleAST.countDirectCallNodes0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle);
    }

    public int getCallCount() {
        return IsolatedCompilableTruffleAST.getCallCount0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle);
    }

    public boolean cancelCompilation(CharSequence reason) {
        IsolatedCompileContext context = IsolatedCompileContext.get();
        return IsolatedCompilableTruffleAST.cancelCompilation0(context.getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle, (ClientHandle<String>)context.createStringInClient(reason));
    }

    public boolean isSameOrSplit(TruffleCompilable ast) {
        ClientHandle astHandle = ast == null ? (ClientHandle)IsolatedHandles.nullHandle() : ((IsolatedCompilableTruffleAST)ast).handle;
        return IsolatedCompilableTruffleAST.isSameOrSplit0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle, (ClientHandle<SubstrateCompilableTruffleAST>)astHandle);
    }

    public int getKnownCallSiteCount() {
        return IsolatedCompilableTruffleAST.getKnownCallSiteCount0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle);
    }

    public boolean prepareForCompilation(boolean rootCompilation, int compilationTier, boolean lastTier) {
        return IsolatedCompilableTruffleAST.prepareForCompilation0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle, rootCompilation, compilationTier, lastTier);
    }

    public SubstrateInstalledCode createSubstrateInstalledCode() {
        throw VMError.shouldNotReachHere((String)"Must not be called during isolated compilation");
    }

    @Override
    public InstalledCode createPreliminaryInstalledCode() {
        return new IsolatedCodeInstallBridge(this.handle);
    }

    public boolean isTrivial() {
        return IsolatedCompilableTruffleAST.isTrivial0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle);
    }

    public long engineId() {
        return IsolatedCompilableTruffleAST.engineId0(IsolatedCompileContext.get().getClient(), (ClientHandle<SubstrateCompilableTruffleAST>)this.handle);
    }

    public Map<String, String> getCompilerOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        CompilerHandle optionsHandle = IsolatedCompileContext.get().hand(options);
        IsolatedCompilableTruffleAST.getCompilerOptions0(IsolatedCompileContext.get().getClient(), (ClientHandle<? extends TruffleCompilable>)this.handle, (CompilerHandle<Map<String, String>>)optionsHandle);
        return options;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<SpeculationLog> getCompilationSpeculationLog0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle);
        SpeculationLog log = compilable.getCompilationSpeculationLog();
        return IsolatedCompileClient.get().hand((Object)log);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void onCompilationFailed0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, CompilerHandle<Supplier<String>> serializedExceptionHandle, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        IsolatedStringSupplier serializedException = new IsolatedStringSupplier(serializedExceptionHandle);
        ((SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle)).onCompilationFailed(serializedException, silent, bailout, permanentBailout, graphTooBig);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void onCompilationSuccess0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, int tier, boolean lastTier) {
        ((SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle)).onCompilationSuccess(tier, lastTier);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<String> getName0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        String name = ((SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle)).getName();
        return IsolatedCompileClient.get().createStringInCompiler(name);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int getNonTrivialNodeCount0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle);
        return compilable.getNonTrivialNodeCount();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int countDirectCallNodes0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle);
        return compilable.countDirectCallNodes();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int getCallCount0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle);
        return compilable.getCallCount();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean cancelCompilation0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, ClientHandle<String> reasonHandle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)isolatedCompileClient.unhand(compilableHandle);
        String reason = (String)isolatedCompileClient.unhand(reasonHandle);
        return compilable.cancelCompilation(reason);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean isSameOrSplit0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, ClientHandle<SubstrateCompilableTruffleAST> otherHandle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle);
        SubstrateCompilableTruffleAST other = null;
        if (otherHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
            other = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(otherHandle);
        }
        return compilable.isSameOrSplit(other);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int getKnownCallSiteCount0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(compilableHandle);
        return compilable.getKnownCallSiteCount();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean prepareForCompilation0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> handle, boolean rootCompilation, int compilationTier, boolean lastTier) {
        TruffleCompilable ast = (TruffleCompilable)IsolatedCompileClient.get().unhand(handle);
        return ast.prepareForCompilation(rootCompilation, compilationTier, lastTier);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean isTrivial0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> handle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(handle);
        return compilable.isTrivial();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static long engineId0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> handle) {
        SubstrateCompilableTruffleAST compilable = (SubstrateCompilableTruffleAST)IsolatedCompileClient.get().unhand(handle);
        return compilable.engineId();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void getCompilerOptions0(ClientIsolateThread client, ClientHandle<? extends TruffleCompilable> inliningHandle, CompilerHandle<Map<String, String>> targetProperties) {
        TruffleCompilable task = (TruffleCompilable)IsolatedCompileClient.get().unhand(inliningHandle);
        Map debugProperties = task.getCompilerOptions();
        BinaryOutput.ByteArrayBinaryOutput out = BinaryOutput.create();
        IsolatedCompilableTruffleAST.writeCompilerOptions(out, debugProperties);
        byte[] array = out.getArray();
        try (CTypeConversion.CCharPointerHolder pin = CTypeConversion.toCBytes((byte[])array);){
            IsolatedCompilableTruffleAST.fillCompilerOptions0(IsolatedCompileClient.get().getCompiler(), client, pin.get(), array.length, targetProperties);
        }
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void fillCompilerOptions0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread context, ClientIsolateThread client, CCharPointer buffer, int bufferLength, CompilerHandle<Map<String, String>> targetPropertiesHandle) {
        Map targetProperties = (Map)IsolatedCompileContext.get().unhand(targetPropertiesHandle);
        IsolatedCompilableTruffleAST.readCompilerOptions(targetProperties, BinaryInput.create(buffer, bufferLength));
    }

    private static Map<String, String> readCompilerOptions(Map<String, String> map, BinaryInput in) {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            map.put(key, in.readUTF());
        }
        return map;
    }

    private static void writeCompilerOptions(BinaryOutput out, Map<String, String> map) {
        out.writeInt(map.size());
        for (Map.Entry<String, String> e : map.entrySet()) {
            out.writeUTF(e.getKey());
            out.writeUTF(e.getValue());
        }
    }
}

