/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.deopt.DeoptimizationRuntime;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.Node;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

public final class SubstrateThreadLocalHandshake
extends ThreadLocalHandshake {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor FOREIGN_POLL = SnippetRuntime.findForeignCall(SubstrateThreadLocalHandshake.class, (String)"pollStub", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])SubstrateAllocationSnippets.GC_LOCATIONS);
    static final SubstrateThreadLocalHandshake SINGLETON = new SubstrateThreadLocalHandshake();
    static final FastThreadLocalInt PENDING = (FastThreadLocalInt)FastThreadLocalFactory.createInt((String)"SubstrateThreadLocalHandshake.PENDING").setMaxOffset(63);
    static final FastThreadLocalObject<ThreadLocalHandshake.TruffleSafepointImpl> STATE = (FastThreadLocalObject)FastThreadLocalFactory.createObject(ThreadLocalHandshake.TruffleSafepointImpl.class, (String)"SubstrateThreadLocalHandshake.STATE").setMaxOffset(63);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    static final ThreadLocal<Boolean> HOSTED_PENDING = ThreadLocal.withInitial(() -> Boolean.FALSE);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final ThreadLocal<ThreadLocalHandshake.TruffleSafepointImpl> HOSTED_STATE = ThreadLocal.withInitial(() -> SINGLETON.getThreadState(Thread.currentThread()));

    public void poll(Node location) {
        if (SubstrateUtil.HOSTED) {
            if (HOSTED_PENDING.get().booleanValue()) {
                SubstrateThreadLocalHandshake.invokeProcessHandshake(location);
            }
        } else if (PENDING.get() != 0) {
            SubstrateThreadLocalHandshake.invokeProcessHandshake(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Must not contain safepoint checks", calleeMustBe=false)
    @NeverInline(value="Reads stack pointer")
    private static void pollStub(Object location) throws Throwable {
        try {
            SubstrateThreadLocalHandshake.invokeProcessHandshake(location);
        }
        catch (Throwable t) {
            StackOverflowCheck.singleton().makeYellowZoneAvailable();
            try {
                Pointer sp = KnownIntrinsics.readCallerStackPointer();
                if (((Boolean)Deoptimizer.Options.TraceDeoptimization.getValue()).booleanValue()) {
                    Log.log().string("trace deopt enabled ").newline().flush();
                    CodePointer ip = KnownIntrinsics.readReturnAddress();
                    long reason = Deoptimizer.encodeDeoptActionAndReasonToLong((DeoptimizationAction)DeoptimizationAction.None, (DeoptimizationReason)DeoptimizationReason.TransferToInterpreter, (int)0);
                    DeoptimizationRuntime.traceDeoptimization((long)reason, (SpeculationLog.SpeculationReason)SpeculationLog.NO_SPECULATION.getReason(), (DeoptimizationAction)DeoptimizationAction.None, (Pointer)sp, (CodePointer)ip);
                }
                Deoptimizer.deoptimizeFrame((Pointer)sp, (boolean)false, (SpeculationLog.SpeculationReason)SpeculationLog.NO_SPECULATION.getReason());
                if (((Boolean)Deoptimizer.Options.TraceDeoptimization.getValue()).booleanValue()) {
                    Log.log().string("]").newline();
                }
            }
            finally {
                StackOverflowCheck.singleton().protectYellowZone();
            }
            throw t;
        }
    }

    @Uninterruptible(reason="Used both from uninterruptable stub.", calleeMustBe=false)
    @RestrictHeapAccess(reason="Callee may allocate", access=RestrictHeapAccess.Access.UNRESTRICTED)
    private static void invokeProcessHandshake(Object enclosingNode) {
        SINGLETON.processHandshake((Node)enclosingNode);
    }

    public void ensureThreadInitialized() {
        if (!SubstrateUtil.HOSTED) {
            STATE.set((Object)this.getThreadState(Thread.currentThread()));
        }
    }

    public ThreadLocalHandshake.TruffleSafepointImpl getCurrent() {
        if (SubstrateUtil.HOSTED) {
            return HOSTED_STATE.get();
        }
        ThreadLocalHandshake.TruffleSafepointImpl state = (ThreadLocalHandshake.TruffleSafepointImpl)STATE.get();
        if (state == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"Thread local handshake is not initialized for this thread. Did you call getCurrent() outside while a polyglot context not entered?");
        }
        return state;
    }

    protected void clearFastPending() {
        if (SubstrateUtil.HOSTED) {
            HOSTED_PENDING.set(Boolean.FALSE);
        } else {
            PENDING.setVolatile(CurrentIsolate.getCurrentThread(), 0);
        }
    }

    protected void setFastPending(Thread t) {
        if (SubstrateUtil.HOSTED) {
            HOSTED_PENDING.set(Boolean.TRUE);
        } else {
            assert (t.isAlive()) : "thread must remain alive while setting fast pending";
            IsolateThread isolateThread = PlatformThreads.getIsolateThreadUnsafe((Thread)t);
            VMError.guarantee((boolean)isolateThread.isNonNull(), (String)"Java thread must remain alive.");
            PENDING.setVolatile(isolateThread, 1);
        }
    }
}

