/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_NativePointer;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;

@ExportLibrary(value=InteropLibrary.class)
public final class ErrnoMirror
implements TruffleObject {
    static final FastThreadLocalBytes<CIntPointer> errnoMirror = FastThreadLocalFactory.createBytes(() -> SizeOf.get(CIntPointer.class), (String)"ErrnoMirror.errnoMirror");
    private static final KeysArray KEYS = new KeysArray(new String[]{"bind"});

    @ExportMessage
    Object execute(Object[] args) {
        return new Target_com_oracle_truffle_nfi_backend_libffi_NativePointer(((CIntPointer)errnoMirror.getAddress()).rawValue());
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        return member.equals("bind");
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return KEYS;
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args) throws UnknownIdentifierException {
        if (!"bind".equals(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        return this;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class KeysArray
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final String[] keys;

        KeysArray(String[] keys) {
            this.keys = keys;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.keys.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return 0L <= idx && idx < (long)this.keys.length;
        }

        @ExportMessage
        String readArrayElement(long idx, @Bind(value="$node") Node node, @Cached InlinedBranchProfile exception) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(idx)) {
                exception.enter(node);
                throw InvalidArrayIndexException.create((long)idx);
            }
            return this.keys[(int)idx];
        }
    }
}

