/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident.impl;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.IsolateThread;

public final class SafeStackWalker {
    @NeverInline(value="Starting a stack walk in the caller frame")
    public static void safeStackWalk(Thread targetThread, StackFrameVisitor visitor) {
        assert (targetThread != null);
        if (targetThread == Thread.currentThread()) {
            JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), visitor);
        } else {
            StackWalkOperation stackWalkOp = new StackWalkOperation(targetThread, visitor);
            stackWalkOp.enqueue();
        }
    }

    @InternalVMMethod
    private static final class StackWalkOperation
    extends JavaVMOperation {
        private final Thread thread;
        private final StackFrameVisitor visitor;

        StackWalkOperation(Thread thread, StackFrameVisitor visitor) {
            super(VMOperationInfos.get(StackWalkOperation.class, "Stack walking", VMOperation.SystemEffect.SAFEPOINT));
            this.thread = thread;
            this.visitor = visitor;
        }

        @Override
        @NeverInline(value="Starting a stack walk.")
        protected void operate() {
            assert (this.thread.isAlive());
            IsolateThread isolateThread = PlatformThreads.getIsolateThreadUnsafe(this.thread);
            JavaStackWalker.walkThread(isolateThread, this.visitor);
        }
    }
}

