/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident.impl;

import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.SymbolicRefs;
import com.oracle.svm.jdwp.resident.JDWPBridgeImpl;
import java.util.OptionalInt;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ResidentSymbolicRefs
implements SymbolicRefs {
    @Override
    public long toTypeRef(ResolvedJavaType resolvedJavaType) {
        if (resolvedJavaType == null) {
            return 0L;
        }
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        OptionalInt typeIndexFor = universe.getTypeIndexFor(resolvedJavaType);
        int typeIndex = typeIndexFor.orElseThrow(IllegalArgumentException::new);
        return JDWPBridgeImpl.getIds().getIdOrCreateWeak(universe.getTypeAtIndex(typeIndex));
    }

    @Override
    public long toFieldRef(ResolvedJavaField resolvedJavaField) {
        if (resolvedJavaField == null) {
            return 0L;
        }
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        OptionalInt fieldIndexFor = universe.getFieldIndexFor(resolvedJavaField);
        int fieldIndex = fieldIndexFor.orElseThrow(IllegalArgumentException::new);
        return JDWPBridgeImpl.getIds().getIdOrCreateWeak(universe.getFieldAtIndex(fieldIndex));
    }

    @Override
    public long toMethodRef(ResolvedJavaMethod resolvedJavaMethod) {
        if (resolvedJavaMethod == null) {
            return 0L;
        }
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        OptionalInt methodIndexFor = universe.getMethodIndexFor(resolvedJavaMethod);
        int methodIndex = methodIndexFor.orElseThrow(IllegalArgumentException::new);
        return JDWPBridgeImpl.getIds().getIdOrCreateWeak(universe.getMethodAtIndex(methodIndex));
    }

    @Override
    public ResolvedJavaType toResolvedJavaType(long typeRefId) throws JDWPException {
        ResolvedJavaType resolvedJavaType;
        if (typeRefId == 0L) {
            return null;
        }
        try {
            resolvedJavaType = JDWPBridgeImpl.getIds().toObject(typeRefId, ResolvedJavaType.class);
        }
        catch (ClassCastException e) {
            throw JDWPException.raise(ErrorCode.INVALID_CLASS);
        }
        if (resolvedJavaType == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        OptionalInt typeIndexFor = universe.getTypeIndexFor(resolvedJavaType);
        if (typeIndexFor.isEmpty()) {
            throw JDWPException.raise(ErrorCode.INVALID_CLASS);
        }
        return resolvedJavaType;
    }

    @Override
    public ResolvedJavaField toResolvedJavaField(long fieldRefId) throws JDWPException {
        ResolvedJavaField resolvedJavaField;
        if (fieldRefId == 0L) {
            return null;
        }
        try {
            resolvedJavaField = JDWPBridgeImpl.getIds().toObject(fieldRefId, ResolvedJavaField.class);
        }
        catch (ClassCastException e) {
            throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
        }
        if (resolvedJavaField == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        OptionalInt typeIndexFor = universe.getFieldIndexFor(resolvedJavaField);
        if (typeIndexFor.isEmpty()) {
            throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
        }
        return resolvedJavaField;
    }

    @Override
    public ResolvedJavaMethod toResolvedJavaMethod(long methodRefId) throws JDWPException {
        ResolvedJavaMethod resolvedJavaMethod;
        if (methodRefId == 0L) {
            return null;
        }
        try {
            resolvedJavaMethod = JDWPBridgeImpl.getIds().toObject(methodRefId, ResolvedJavaMethod.class);
        }
        catch (ClassCastException e) {
            throw JDWPException.raise(ErrorCode.INVALID_METHODID);
        }
        if (resolvedJavaMethod == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        OptionalInt methodIndexFor = universe.getMethodIndexFor(resolvedJavaMethod);
        if (methodIndexFor.isEmpty()) {
            throw JDWPException.raise(ErrorCode.INVALID_METHODID);
        }
        return resolvedJavaMethod;
    }
}

