/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.interpreter.InterpreterFeature;
import com.oracle.svm.interpreter.debug.DebuggerEventsFeature;
import com.oracle.svm.jdwp.bridge.JDWPNativeBridgeSupport;
import com.oracle.svm.jdwp.bridge.ResidentJDWPFeatureEnabled;
import com.oracle.svm.jdwp.bridge.jniutils.NativeBridgeSupport;
import com.oracle.svm.jdwp.resident.DebuggingOnDemandHook;
import com.oracle.svm.jdwp.resident.JDWPOptions;
import com.oracle.svm.jdwp.resident.ThreadStartDeathSupport;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.HOSTED_ONLY.class})
@AutomaticallyRegisteredFeature
final class ResidentJDWPFeature
implements InternalFeature {
    ResidentJDWPFeature() {
    }

    public String getDescription() {
        return "Support debugging native images via JDWP, using standard Java tooling";
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(NativeBridgeSupport.class, (Object)new JDWPNativeBridgeSupport());
        ImageSingletons.add(ResidentJDWPFeatureEnabled.class, (Object)new ResidentJDWPFeatureEnabled());
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeSupport.getRuntimeSupport().addStartupHook(new DebuggingOnDemandHook());
        ImageSingletons.add(ThreadStartDeathSupport.class, (Object)new ThreadStartDeathSupport());
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JDWPOptions.JDWP.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(InterpreterFeature.class, DebuggerEventsFeature.class);
    }
}

