/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIEnvironmentPointer;
import com.oracle.svm.core.jni.headers.JNIErrors;
import com.oracle.svm.core.jni.headers.JNIJavaVMInitArgs;
import com.oracle.svm.core.jni.headers.JNIJavaVMOption;
import com.oracle.svm.core.jni.headers.JNIJavaVMPointer;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.jni.headers.JNIVersion;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.debug.DebuggerEvents;
import com.oracle.svm.jdwp.bridge.ArgFilesOption;
import com.oracle.svm.jdwp.bridge.DebugOptions;
import com.oracle.svm.jdwp.bridge.Logger;
import com.oracle.svm.jdwp.bridge.NativeToHSJDWPEventHandlerBridge;
import com.oracle.svm.jdwp.bridge.ResidentJDWPFeatureEnabled;
import com.oracle.svm.jdwp.bridge.jniutils.JNI;
import com.oracle.svm.jdwp.bridge.jniutils.JNIMethodScope;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeObjectHandles;
import com.oracle.svm.jdwp.resident.EnterHSEventHandler;
import com.oracle.svm.jdwp.resident.JDWPBridgeImpl;
import com.oracle.svm.jdwp.resident.JDWPOptions;
import com.oracle.svm.jdwp.resident.ThreadStartDeathSupport;
import com.oracle.svm.jdwp.resident.impl.ResidentJDWP;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Signal;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

public class DebuggingOnDemandHandler
implements Signal.Handler {
    private final DebugOptions.Options options;
    private static volatile Thread suspendThread;
    private static final int MAX_DEBUGGER_VM_OPTIONS = 32;
    boolean first = true;
    private static JNI.JavaVM debuggerServerJavaVM;
    private static final FastThreadLocalWord<JNI.JNIEnv> jniEnvPerThread;

    public DebuggingOnDemandHandler(DebugOptions.Options options) {
        this.options = options;
    }

    public static JNI.JNIEnv currentThreadJniEnv() {
        JNI.JNIEnv currentJniEnv = jniEnvPerThread.get();
        if (currentJniEnv.isNull()) {
            JNI.JNIEnvPointer attachedJniEnvPointer = (JNI.JNIEnvPointer)StackValue.get(JNI.JNIEnvPointer.class);
            debuggerServerJavaVM.getFunctions().getAttachCurrentThreadAsDaemon().call(debuggerServerJavaVM, attachedJniEnvPointer, (JNI.JavaVMAttachArgs)Word.nullPointer());
            currentJniEnv = attachedJniEnvPointer.readJNIEnv();
            jniEnvPerThread.set(currentJniEnv);
        }
        return currentJniEnv;
    }

    @Override
    public void handle(Signal sig) {
        if (!this.first) {
            ResidentJDWP.LOGGER.log("[DebuggingOnDemand] received USR2 signal, but JDWP server already spawned?");
            return;
        }
        this.first = false;
        ResidentJDWP.LOGGER.log("[DebuggingOnDemand] received USR2 signal, spawning JDWP server");
        this.spawnJDWPThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP"}, justification="Intentional.")
    public void spawnJDWPThread() {
        long initialThreadId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(Thread.currentThread());
        Path libraryPath = DebuggingOnDemandHandler.findLibraryPath(this.options);
        assert (Files.isRegularFile(libraryPath, new LinkOption[0]));
        JDWPServerThread jdwpServerThread = new JDWPServerThread(libraryPath, initialThreadId, this.options);
        ThreadStartDeathSupport.get().setDebuggerThreadServer(jdwpServerThread);
        jdwpServerThread.setDaemon(true);
        jdwpServerThread.start();
        if (!this.options.suspend()) return;
        suspendThread = Thread.currentThread();
        Class<DebuggingOnDemandHandler> clazz = DebuggingOnDemandHandler.class;
        synchronized (DebuggingOnDemandHandler.class) {
            try {
                DebuggingOnDemandHandler.class.wait();
            }
            catch (InterruptedException e) {
                ResidentJDWP.LOGGER.log("[DebuggingOnDemand] Interrupted initial suspend.");
            }
            return;
        }
    }

    public static void spawnJDWPServer(Path libraryPath, long initialThreadId, DebugOptions.Options jdwpOptions) {
        assert (libraryPath != null);
        ResidentJDWP.LOGGER = new Logger(jdwpOptions.tracing(), "[ResidentJDWP]", System.err);
        String debuggerArgs = jdwpOptions.vmOptions();
        ArrayList<String> vmOptions = new ArrayList<String>();
        if (debuggerArgs != null && !debuggerArgs.isBlank()) {
            ArgFilesOption parser = new ArgFilesOption();
            for (String arg : debuggerArgs.split("(\\R|\\s)+")) {
                vmOptions.addAll(parser.process(arg));
            }
        } else if ("jvm".equals(jdwpOptions.mode())) {
            throw new IllegalArgumentException("The JDWP 'vm.options' option is not set or empty. It must contain at least the -Djava.class.path for the debugger, note that it also supports @argFiles arguments.");
        }
        if (vmOptions.size() > 32) {
            throw VMError.shouldNotReachHere("'vm.options' contains more than 32 elements (including @argFile expansion)");
        }
        try (CTypeConversion.CCharPointerHolder declaringClass = CTypeConversion.toCString((CharSequence)"com/oracle/svm/jdwp/server/JDWPServer");
             CTypeConversion.CCharPointerHolder hsMethodName = CTypeConversion.toCString((CharSequence)"createInstance");
             CTypeConversion.CCharPointerHolder hsSignature = CTypeConversion.toCString((CharSequence)"()Lcom/oracle/svm/jdwp/bridge/JDWPEventHandlerBridge;");
             CTypeConversion.CCharPointerPointerHolder hsVMOptions = CTypeConversion.toCStrings((CharSequence[])vmOptions.toArray(new String[0]));){
            ResidentJDWP.LOGGER.log("Loading libraryPath=" + String.valueOf(libraryPath));
            ResidentJDWP.LOGGER.log("jdwpOptions=" + jdwpOptions.jdwpOptions());
            ResidentJDWP.LOGGER.log("additionalOptions=" + jdwpOptions.additionalOptions());
            JNIJavaVMInitArgs args = (JNIJavaVMInitArgs)StackValue.get(JNIJavaVMInitArgs.class);
            args.setNOptions(vmOptions.size());
            JNIJavaVMOption options = (JNIJavaVMOption)StackValue.get((int)32, JNIJavaVMOption.class);
            for (int i = 0; i < vmOptions.size(); ++i) {
                CCharPointer option = hsVMOptions.get().read(i);
                options.addressOf(i).setOptionString(option);
            }
            args.setOptions(options);
            args.setIgnoreUnrecognized(false);
            args.setVersion(JNIVersion.JNI_VERSION_10());
            args.setIgnoreUnrecognized(true);
            JNIJavaVMPointer jvmptr = (JNIJavaVMPointer)StackValue.get(JNIJavaVMPointer.class);
            JNIEnvironmentPointer dbgEnv = (JNIEnvironmentPointer)StackValue.get(JNIEnvironmentPointer.class);
            PlatformNativeLibrarySupport.NativeLibrary library = PlatformNativeLibrarySupport.singleton().createLibrary(libraryPath.toString(), false);
            library.load();
            JNICreateJavaVMPointer symCreateJavaVM = (JNICreateJavaVMPointer)library.findSymbol("JNI_CreateJavaVM");
            int result = symCreateJavaVM.call(jvmptr, dbgEnv, args);
            if (result != JNIErrors.JNI_OK()) {
                Log.log().string("CreateJavaVM failed: ").signed(result).newline();
                LibC.exit(99);
            }
            debuggerServerJavaVM = (JNI.JavaVM)((Object)jvmptr.read());
            JNIObjectHandle jhJDWPServerClass = dbgEnv.read().getFunctions().getFindClass().invoke(dbgEnv.read(), declaringClass.get());
            DebuggingOnDemandHandler.abortOnJNIException(dbgEnv);
            JNIMethodId jdwpCreateInstance = dbgEnv.read().getFunctions().getGetStaticMethodID().invoke(dbgEnv.read(), jhJDWPServerClass, hsMethodName.get(), hsSignature.get());
            DebuggingOnDemandHandler.abortOnJNIException(dbgEnv);
            CallStaticObjectMethodFunctionPointer entryPointFunctionPointer = (CallStaticObjectMethodFunctionPointer)dbgEnv.read().getFunctions().getCallStaticObjectMethod();
            JNI.JObject handle = entryPointFunctionPointer.invoke(dbgEnv.read(), jhJDWPServerClass, jdwpCreateInstance);
            DebuggingOnDemandHandler.abortOnJNIException(dbgEnv);
            final NativeToHSJDWPEventHandlerBridge jdwpEventHandler = NativeToHSJDWPEventHandlerBridge.createNativeToHS((JNI.JNIEnv)((Object)dbgEnv.read()), handle);
            DebuggingOnDemandHandler.abortOnJNIException(dbgEnv);
            long isolate = CurrentIsolate.getIsolate().rawValue();
            DebuggerEvents.singleton().setEventHandler(new EnterHSEventHandler(jdwpEventHandler));
            ThreadStartDeathSupport.get().setListener(new ThreadStartDeathSupport.Listener(){

                @Override
                public void threadStarted() {
                    IsolateThread isolateThread = CurrentIsolate.getCurrentThread();
                    Thread thread = ThreadStartDeathSupport.get().filterAppThread(isolateThread);
                    if (thread == null) {
                        return;
                    }
                    long threadId = JDWPBridgeImpl.getIds().toId(thread);
                    ResidentJDWP.LOGGER.log("[StartDeathSupport] threadStarted[" + threadId + "](" + thread.getName() + ")");
                    try (JNIMethodScope ignored = new JNIMethodScope("JDWPServer::onThreadStart", DebuggingOnDemandHandler.currentThreadJniEnv());){
                        jdwpEventHandler.onThreadStart(threadId);
                    }
                }

                @Override
                @Uninterruptible(reason="Used in ThreadListenerSupport.", calleeMustBe=false)
                public void threadDied() {
                    IsolateThread isolateThread = CurrentIsolate.getCurrentThread();
                    this.threadDied(isolateThread);
                }

                private void threadDied(IsolateThread isolateThread) {
                    Thread thread = ThreadStartDeathSupport.get().filterAppThread(isolateThread);
                    if (thread == null) {
                        return;
                    }
                    long threadId = JDWPBridgeImpl.getIds().toId(thread);
                    ResidentJDWP.LOGGER.log("[StartDeathSupport] threadDied[" + threadId + "](" + thread.getName() + ")");
                    try (JNIMethodScope ignored = new JNIMethodScope("JDWPServer::onThreadDeath", DebuggingOnDemandHandler.currentThreadJniEnv());){
                        jdwpEventHandler.onThreadDeath(threadId);
                    }
                }

                @Override
                public void vmDied() {
                    ResidentJDWP.LOGGER.log("[StartDeathSupport] vmDied()");
                    try (JNIMethodScope ignored = new JNIMethodScope("JDWPServer::onVMDeath", DebuggingOnDemandHandler.currentThreadJniEnv());){
                        jdwpEventHandler.onVMDeath();
                    }
                }
            });
            assert (DebuggerEvents.singleton().getEventHandler() != null);
            Path metadataPath = DebuggerSupport.getMetadataFilePath();
            String metadataHashString = DebuggerSupport.getMetadataHashString();
            try (JNIMethodScope ignored = new JNIMethodScope("JDWPServer::spawnServer", DebuggingOnDemandHandler.currentThreadJniEnv());){
                long jdwpBridgeHandle = DebuggingOnDemandHandler.createJDWPBridgeHandle();
                jdwpEventHandler.spawnServer(jdwpOptions.jdwpOptions(), jdwpOptions.additionalOptions(), isolate, initialThreadId, jdwpBridgeHandle, metadataHashString, metadataPath.toString(), jdwpOptions.tracing());
            }
        }
    }

    static Path findJavaHome() {
        String javaHome = System.getenv("JDWP_SERVER_JAVA_HOME");
        if (javaHome == null && (javaHome = System.getenv("GRAALVM_HOME")) == null) {
            javaHome = System.getenv("JAVA_HOME");
        }
        return javaHome != null ? Path.of(javaHome, new String[0]) : null;
    }

    private static Path findLibrary(String libraryName, boolean throwIfNotFound, List<Path> searchPaths) {
        for (Path path : searchPaths) {
            Path libraryPath;
            Path fileName = path.getFileName();
            if (Files.isRegularFile(path, new LinkOption[0]) && fileName != null && libraryName.equals(fileName.toString())) {
                return path;
            }
            if (!Files.isDirectory(path, new LinkOption[0]) || !Files.isRegularFile(libraryPath = path.resolve(libraryName), new LinkOption[0])) continue;
            return libraryPath;
        }
        if (throwIfNotFound) {
            throw new IllegalArgumentException(libraryName + " not found in search path: " + String.valueOf(searchPaths));
        }
        return null;
    }

    private static Path librariesInJavaHome(Path javaHome) {
        if (javaHome == null) {
            return null;
        }
        return javaHome.resolve(OS.WINDOWS.isCurrent() ? "bin" : "lib");
    }

    private static Path jvmLibraryInJavaHome(Path javaHome, String jvmSubDirectory) {
        Path libraries = DebuggingOnDemandHandler.librariesInJavaHome(javaHome);
        if (libraries == null) {
            return null;
        }
        return libraries.resolve(jvmSubDirectory);
    }

    private static Path jvmLibraryInJavaHome(Path javaHome) {
        return DebuggingOnDemandHandler.jvmLibraryInJavaHome(javaHome, "server");
    }

    private static List<Path> filterValidPaths(Path ... paths) {
        ArrayList<Path> validPaths = new ArrayList<Path>();
        for (Path path : paths) {
            if (path == null || !Files.exists(path, new LinkOption[0])) continue;
            validPaths.add(path);
        }
        return validPaths;
    }

    private static Path findLibraryPath(DebugOptions.Options jdwpOptions) {
        List<Path> searchPaths;
        String libraryName;
        Path libraryPath = null;
        if (jdwpOptions.libraryPath() != null) {
            libraryPath = Path.of(jdwpOptions.libraryPath(), new String[0]);
        }
        if ("jvm".equals(jdwpOptions.mode())) {
            libraryName = System.mapLibraryName("jvm");
            searchPaths = DebuggingOnDemandHandler.filterValidPaths(libraryPath, DebuggingOnDemandHandler.jvmLibraryInJavaHome(libraryPath), DebuggingOnDemandHandler.jvmLibraryInJavaHome(DebuggingOnDemandHandler.findJavaHome()));
        } else {
            assert ("native".equals(jdwpOptions.mode()));
            libraryName = System.mapLibraryName("svmjdwp");
            searchPaths = DebuggingOnDemandHandler.filterValidPaths(libraryPath, Path.of(ProcessProperties.getExecutableName(), new String[0]).getParent(), DebuggingOnDemandHandler.librariesInJavaHome(libraryPath), DebuggingOnDemandHandler.librariesInJavaHome(DebuggingOnDemandHandler.findJavaHome()));
        }
        return DebuggingOnDemandHandler.findLibrary(libraryName, true, searchPaths);
    }

    private static long createJDWPBridgeHandle() {
        VMError.guarantee(JDWPOptions.JDWP.getValue());
        VMError.guarantee(InterpreterOptions.DebuggerWithInterpreter.getValue());
        return NativeObjectHandles.create(new JDWPBridgeImpl());
    }

    static long toPrimitiveOrId(JavaKind kind, Object object) {
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case JavaKind.Boolean -> JavaConstant.forBoolean((boolean)((Boolean)object)).getRawValue();
            case JavaKind.Byte -> JavaConstant.forByte((byte)((Byte)object)).getRawValue();
            case JavaKind.Short -> JavaConstant.forShort((short)((Short)object)).getRawValue();
            case JavaKind.Char -> JavaConstant.forChar((char)((Character)object).charValue()).getRawValue();
            case JavaKind.Int -> JavaConstant.forInt((int)((Integer)object)).getRawValue();
            case JavaKind.Float -> JavaConstant.forFloat((float)((Float)object).floatValue()).getRawValue();
            case JavaKind.Long -> JavaConstant.forLong((long)((Long)object)).getRawValue();
            case JavaKind.Double -> JavaConstant.forDouble((double)((Double)object)).getRawValue();
            case JavaKind.Object -> JDWPBridgeImpl.getIds().toId(object);
            case JavaKind.Void -> {
                if (!$assertionsDisabled && object != null) {
                    throw new AssertionError();
                }
                yield 0L;
            }
            case JavaKind.Illegal -> throw VMError.shouldNotReachHere("illegal return kind");
        };
    }

    private static void abortOnJNIException(JNIEnvironmentPointer dbgEnv) {
        if (dbgEnv.read().getFunctions().getExceptionCheck().invoke(dbgEnv.read())) {
            dbgEnv.read().getFunctions().getExceptionDescribe().invoke(dbgEnv.read());
            LibC.exit(99);
        }
    }

    public static boolean suspendDoneOnShellSide() {
        Thread t = suspendThread;
        suspendThread = null;
        if (t != null) {
            t.interrupt();
            return true;
        }
        return false;
    }

    static {
        jniEnvPerThread = FastThreadLocalFactory.createWord("jniEnvPerThread");
    }

    private static class JDWPServerThread
    extends Thread {
        private final Path libraryPath;
        private final long initialThreadId;
        private final DebugOptions.Options options;

        JDWPServerThread(Path libraryPath, long initialThreadId, DebugOptions.Options options) {
            super("jdwp-server");
            this.libraryPath = libraryPath;
            this.initialThreadId = initialThreadId;
            this.options = options;
        }

        @Override
        public void run() {
            DebuggingOnDemandHandler.spawnJDWPServer(this.libraryPath, this.initialThreadId, this.options);
            ThreadStartDeathSupport.get().setDebuggerThreadServer(null);
        }
    }

    public static interface JNICreateJavaVMPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIJavaVMPointer var1, JNIEnvironmentPointer var2, JNIJavaVMInitArgs var3);
    }

    public static interface CallStaticObjectMethodFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JNI.JObject invoke(JNIEnvironment var1, JNIObjectHandle var2, JNIMethodId var3);
    }

    private static final class EntryPointHolder {
        private EntryPointHolder() {
        }

        @Uninterruptible(reason="Dummy symbol to make HotSpot's native method linking to look for symbols in the main executable. Required to run the JDWP server (debugger) on HotSpot")
        @CEntryPoint(name="JNI_OnLoad_DEFAULT_NAMESPACE", include=ResidentJDWPFeatureEnabled.class)
        @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
        public static int onLoadDefaultNamespace(JNI.JavaVM vm, PointerBase reserved) {
            return JNIVersion.JNI_VERSION_10();
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_JDWPJNIConfig_attachCurrentThread", builtin=CEntryPoint.Builtin.ATTACH_THREAD, include=ResidentJDWPFeatureEnabled.class)
        public static native IsolateThread attachCurrentThread(JNI.JNIEnv var0, JNI.JClass var1, Isolate var2);
    }

    public static interface CallStaticVoidMethodFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void invoke(JNIEnvironment var1, JNIObjectHandle var2, JNIMethodId var3);
    }
}

