/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge.nativebridge;

import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;

public final class NativeObjectHandles {
    private NativeObjectHandles() {
    }

    public static long create(Object object) {
        return ObjectHandles.getGlobal().create(object).rawValue();
    }

    public static <T> T resolve(long handle, Class<T> type) {
        try {
            return type.cast(ObjectHandles.getGlobal().get((ObjectHandle)Word.pointer((long)handle)));
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidHandleException(iae);
        }
    }

    public static void remove(long handle) {
        try {
            ObjectHandles.getGlobal().destroy((ObjectHandle)Word.pointer((long)handle));
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidHandleException(iae);
        }
    }

    public static final class InvalidHandleException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        InvalidHandleException(IllegalArgumentException cause) {
            super(cause.getMessage(), cause);
            this.setStackTrace(cause.getStackTrace());
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

