/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import java.io.PrintStream;
import java.util.function.Supplier;

public final class Logger {
    private final boolean enabled;
    private final String prefix;
    private final PrintStream sink;

    public Logger(boolean enabled, String prefix, PrintStream sink) {
        this.enabled = enabled;
        this.prefix = prefix;
        this.sink = sink;
    }

    public void log(Supplier<String> s) {
        if (this.enabled) {
            this.log(s.get());
        }
    }

    public void log(String message) {
        if (this.enabled) {
            this.sink.println(this.prefix + " " + message);
        }
    }

    public void log(Throwable throwable) {
        if (this.enabled) {
            throwable.printStackTrace(new PrintStream(this.sink){

                @Override
                public void println(Object x) {
                    super.println(Logger.this.prefix + " " + String.valueOf(x));
                }
            });
        }
    }

    public void log(Throwable throwable, String message) {
        if (this.enabled) {
            this.log(message);
            this.log(throwable);
        }
    }

    public boolean isLoggable() {
        assert (this.prefix != null);
        return this.enabled;
    }

    public void log(String messageSimpleFormat, Object ... args) {
        if (this.enabled) {
            this.log(Logger.fmt(messageSimpleFormat, args));
        }
    }

    private static String fmt(String simpleFormat, Object ... args) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int argIndex = 0;
        while (index < simpleFormat.length()) {
            char ch;
            if ((ch = simpleFormat.charAt(index++)) == '%') {
                if (index >= simpleFormat.length()) {
                    throw new IllegalArgumentException("An unquoted '%' character cannot terminate a format specification");
                }
                char specifier = simpleFormat.charAt(index++);
                switch (specifier) {
                    case 's': {
                        if (argIndex >= args.length) {
                            throw new IllegalArgumentException("Too many format specifiers or not enough arguments");
                        }
                        sb.append(args[argIndex++]);
                        break;
                    }
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    case 'n': {
                        sb.append(System.lineSeparator());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal format specifier: " + specifier);
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        if (argIndex < args.length) {
            throw new IllegalArgumentException("Not enough format specifiers or too many arguments");
        }
        return sb.toString();
    }
}

